package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.domain.cardfield.Group;
import com.digiwin.athena.knowledgegraph.domain.cardfield.TaskCardFields;
import com.digiwin.athena.knowledgegraph.domain.task.CardColumn;
import com.digiwin.athena.knowledgegraph.domain.task.CardFilterConfigDTO;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupApplication;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupGroup;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupTask;
import com.digiwin.athena.knowledgegraph.domain.task.CardLabel;
import com.digiwin.athena.knowledgegraph.domain.task.CardOrderConfigDTO;
import com.digiwin.athena.knowledgegraph.domain.task.LabelVO;
import com.digiwin.athena.knowledgegraph.domain.task.ReturnFieldVO;
import com.digiwin.athena.knowledgegraph.dto.CardConfigDTO;
import com.digiwin.athena.knowledgegraph.dto.GroupAndLabelDto;
import com.digiwin.athena.knowledgegraph.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.knowledgegraph.service.ATMCService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IAppService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_KNOWLEDGE_GRAPH;

@Lang
@Service
@Slf4j
public class TaskFieldService {


    @Autowired
    private ATMCService atmcService;

    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    TenantService tenantService;
    @Autowired
    DataMapService dataMapService;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    IAppService appService;

    public static final String NON_REAL_TIME = "NON_REAL_TIME";

    public List<CardGroupGroup> sysCardGroups(String tenantId){

        List<CardGroupGroup> sysCardGroups = null;
        try{
            sysCardGroups= atmcService.getGroupDimension(tenantId);
        }catch (Exception e){
            log.error(e.getMessage(), e);
        }
        if(null==sysCardGroups){
            sysCardGroups = new ArrayList<>();
        }
        sysCardGroups.forEach(s->{
            s.setEnabled(true);
            s.setCommonEnable(true);
        });
        return sysCardGroups;
    }


    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH , key = "applicationGroupAndCard", tenant = true, ttlSecs = 86400L, loadEmpty = true,language = true)
    public GroupAndLabelDto applicationGroupAndCard() throws Exception {
        GroupAndLabelDto dto = new GroupAndLabelDto();

        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        //获取租户所有应用的任务
        List<String> authApps = tenantService.getAppCodes();
        List<ApplicationRelation> taskRelations = appService.getApplicationRelationByTypeAndAppCode("activity", authApps);
        List<Application> apps = appService.getApplicationsByCodes(authApps);
        List<String> taskCodes = taskRelations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
        Map<String,ApplicationRelation> taskRelationsMap = new HashMap<>();
        Map<String,Application> applicationMap = new HashMap<>();
        taskRelations.forEach(applicationRelation -> {
            taskRelationsMap.put(applicationRelation.getCode(), applicationRelation);
        });
        apps.forEach(app -> {
            applicationMap.put(app.getCode(), app);
        });

        dto.setTaskRelationsMap(taskRelationsMap);

        Map<String,Object> query = MapUtil.of("code",taskCodes);
        List tasks = dataMapService.postCardConfig(query);
        for(Object task:tasks){
            Map map = (Map) task;
            String taskCode= (String) map.get("code");
            String taskName = (String) map.get("name");
            Object taskCardFields = map.get("fieldConfig");
            //卡面业务数据的来源方式
            String businessMessageSourceMethod = JSON.parseObject(JSON.toJSONString(taskCardFields), JSONObject.class).getString("businessMessageSourceMethod");
            if (NON_REAL_TIME.equals(businessMessageSourceMethod)){
                // 非实时的 需要解析成返回给前端的新格式 cardConfig
                dto.getBusinessMessageSourceMethodMap().put(taskCode, taskCardFieldToCardConfig(taskCardFields));
            }
            Map<String,Map<String,String>> taskLang= null;
            if(null==taskCardFields){continue;}
            try{
                taskLang = JSON.parseObject(JSON.toJSONString(map.get("lang")),Map.class);
            }catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            //标签
            Object labels = JSONPath.eval(taskCardFields,"$.taskCardField.labels");
            if(null!=labels){
                CardLabel cardLabel = new CardLabel();
                cardLabel.setTaskCode(taskCode);
                cardLabel.setLabels(JSON.parseArray(JSON.toJSONString(labels), LabelVO.class));
                dto.getCardLabels().add(cardLabel);
                cardLabel.getLabels().forEach(labelVO -> {
                    if(null==labelVO.getOriginName()){
                        labelVO.setOriginName(labelVO.getName());
                    }
                });
            }
            //分组
            Object groups = JSONPath.eval(taskCardFields,"$.taskCardField.groups");
            if(null!=groups){
                CardGroupApplication cardGroupApplication = taskGroup(taskCode,dto,taskRelationsMap,applicationMap);
                CardGroupTask cardGroupTask = new CardGroupTask();
                cardGroupTask.setTaskId((String) map.get("id"));
                cardGroupTask.setCode(taskCode);
                cardGroupTask.setName(taskName);
                cardGroupTask.setLang(taskLang);
                if (StringUtils.isNotBlank(businessMessageSourceMethod)) {
                    cardGroupTask.setBusinessMessageSourceMethod(BusinessMessageSourceMethod.valueOf(businessMessageSourceMethod));
                }
                List<CardGroupGroup> cardGroupGroups = JSON.parseArray(JSON.toJSONString(groups), CardGroupGroup.class);
                for (CardGroupGroup cardGroupGroup : cardGroupGroups) {
                    cardGroupGroup.setEnabled(cardGroupGroup.isDefaultEffective());
                    cardGroupGroup.setCommonEnable(false);
                    cardGroupGroup.setDefaultGroup(false);
                }
                cardGroupTask.setGroups(cardGroupGroups);
                cardGroupApplication.getTasks().add(cardGroupTask);
            }

            Object columns = JSONPath.eval(taskCardFields, "$.taskCardField.columns");
            if (null != columns) {
                List<CardColumn> cardColumns = JSON.parseArray(JSON.toJSONString(columns), CardColumn.class);
                cardColumns.forEach(e->e.setTaskCode(taskCode));
                dto.getColumns().addAll(cardColumns);
            }
        }

        return dto;
    }

    public List<CardConfigDTO> taskCardFieldToCardConfig(Object taskCardFields){
        try {
            String locale = AthenaUtils.getCurrentLocale();
            Set<String> aliasCode = new LinkedHashSet<>();
            // 标签
            Object labels = JSONPath.eval(taskCardFields,"$.taskCardField.labels");
            Map<String,CardConfigDTO.Config.Label> labelCodeMap = new HashMap<>();
            if (labels!=null){
                List<LabelVO> labelVOS = JSON.parseArray(JSON.toJSONString(labels),LabelVO.class);
                Set<String> labelCodes = labelVOS.stream().map(LabelVO::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(labelCodes);
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(labelVOS)){
                    List<LabelVO> labelVOList = labelVOS.stream().filter(LabelVO::isDefaultEffective).collect(Collectors.toList());
                    for (LabelVO labelVO : labelVOList) {

                        CardConfigDTO.Config.Label label = new CardConfigDTO.Config.Label();
                        label.setDefaultEffective("true");
                        try {
                            LanguageUtil.processLocaleLanguage(labelVO,locale);
                        } catch (IllegalAccessException | NoSuchFieldException e) {
                            log.error("processLocaleLanguage error, " + labelVO);
                        }

                        CardConfigDTO.Config.Label.Style style = new CardConfigDTO.Config.Label.Style();
                        label.setStyle(style);
                        label.setAliasName(labelVO.getName());
                        label.setLang(labelVO.getLang());
                        labelCodeMap.put(labelVO.getCode(),label);

                        List<ReturnFieldVO> returnFields = labelVO.getReturnFields();
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(returnFields)){
                            Optional<CardConfigDTO.Config.Label.Style> styleOptional = returnFields.stream().map(o -> {
                                CardConfigDTO.Config.Label.Style style1 = new CardConfigDTO.Config.Label.Style();
                                if (o.getStyle() != null) {
                                    style1.setColor(o.getStyle().getColor());
                                }
                                return style1;
                            }).findFirst();
                            if (styleOptional.isPresent()){
                                CardConfigDTO.Config.Label.Style style1 = styleOptional.get();
                                style.setColor(style1.getColor());
                            }
                        }
                    }
                }

            }
            //分组
            Object groups = JSONPath.eval(taskCardFields,"$.taskCardField.groups");
            Map<String, CardConfigDTO.Config.Data> groupCodeMap = new HashMap<>();
            if (groups != null) {
                List<CardGroupGroup> cardGroupGroups = JSON.parseArray(JSON.toJSONString(groups), CardGroupGroup.class);
                Set<String> groupCodes = cardGroupGroups.stream().map(CardGroupGroup::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(groupCodes);
                groupCodeMap.putAll( cardGroupGroups.stream().filter(o -> "true".equals(String.valueOf(o.isDefaultEffective())))
                        .collect(Collectors.toMap(o -> o.getCode(), o -> {
                    CardConfigDTO.Config.Data group = new CardConfigDTO.Config.Data();
                    try {
                        LanguageUtil.processLocaleLanguage(o, locale);
                    } catch (IllegalAccessException | NoSuchFieldException e) {
                        log.error("processLocaleLanguage error, " + group);
                    }
                    group.setDefaultEffective("true");
                    group.setAliasName(o.getName());
                    group.setLang( o.getLang());

                    return group;
                },(o1,o2)->o1)));
            }

            // 栏目
            Object columns = JSONPath.eval(taskCardFields, "$.taskCardField.columns");
            Map<String, CardConfigDTO.Config.Column> columnCodeMap = new HashMap<>();
            if (columns!=null){
                List<CardColumn> cardColumns = JSON.parseArray(JSON.toJSONString(columns),CardColumn.class);
                Set<String> columnCodes = cardColumns.stream().map(CardColumn::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(columnCodes);
                columnCodeMap .putAll( cardColumns.stream().collect(Collectors.toMap(CardColumn::getCode, o -> {
                    try {
                        LanguageUtil.processLocaleLanguage(o, locale);
                    } catch (IllegalAccessException | NoSuchFieldException e) {
                        log.error("processLocaleLanguage error, " + o);
                    }
                    CardConfigDTO.Config.Column column = new CardConfigDTO.Config.Column();
                    column.setDefaultEffective("true");
                    column.setValueType(o.getValueType());
                    column.setAliasName(o.getName());
                    column.setLang(o.getLang());

                    return column;
                },(o1,o2)->o1)));
            }

            // 排序
            Object order = JSONPath.eval(taskCardFields, "$.taskCardField.order");
            Map<String, CardConfigDTO.Config.Data> orderCodeMap = new HashMap<>();
            if (order!=null){
                List<CardOrderConfigDTO> cardOrderConfigList = JSON.parseArray(JSON.toJSONString(order),CardOrderConfigDTO.class);
                Set<String> orderCodes = cardOrderConfigList.stream().map(CardOrderConfigDTO::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(orderCodes);
                orderCodeMap.putAll( cardOrderConfigList.stream().filter(o -> "true".equals(o.getDefaultEffective()))
                        .collect(Collectors.toMap(CardOrderConfigDTO::getCode, o -> {
                            try {
                                LanguageUtil.processLocaleLanguage(o, locale);
                            } catch (IllegalAccessException | NoSuchFieldException e) {
                                log.error("processLocaleLanguage error, " + o);
                            }
                            CardConfigDTO.Config.Data orderData = new CardConfigDTO.Config.Data();
                            orderData.setAliasName(o.getName());
                            orderData.setDefaultEffective("true");
                            orderData.setLang(o.getLang());

                            return orderData;
                        },(o1,o2)->o1)));

            }

            // 筛选
            Object filter = JSONPath.eval(taskCardFields, "$.taskCardField.filter");
            Map<String, CardConfigDTO.Config.Data> filterCodeMap = new HashMap<>();
            if (filter!=null){
                List<CardFilterConfigDTO> cardFilterConfigList = JSON.parseArray(JSON.toJSONString(filter),CardFilterConfigDTO.class);
                Set<String> filterCodes = cardFilterConfigList.stream().map(CardFilterConfigDTO::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(filterCodes);

                filterCodeMap.putAll( cardFilterConfigList.stream().filter(o -> "true".equals(o.getDefaultEffective()))
                        .collect(Collectors.toMap(CardFilterConfigDTO::getCode, o -> {
                            try {
                                LanguageUtil.processLocaleLanguage(o, locale);
                            } catch (IllegalAccessException | NoSuchFieldException e) {
                                log.error("processLocaleLanguage error, " + o);
                            }
                            CardConfigDTO.Config.Data filterData = new CardConfigDTO.Config.Data();
                            filterData.setDefaultEffective("true");
                            filterData.setDataType(o.getDataType());
                            filterData.setAliasName(o.getName());
                            filterData.setLang(o.getLang());

                            return filterData;
                        },(o1,o2)->o1)));
            }
            return aliasCode.stream().map(code->{
                CardConfigDTO cardConfigDTO = new CardConfigDTO();
                cardConfigDTO.setAliasField(code);
                CardConfigDTO.Config config = new CardConfigDTO.Config();
                cardConfigDTO.setConfig(config);
                config.setGroup(groupCodeMap.get(code));
                config.setOrder(orderCodeMap.get(code));
                config.setFilter(filterCodeMap.get(code));
                config.setLabel(labelCodeMap.get(code));
                config.setColumn(columnCodeMap.get(code));
                return cardConfigDTO;
            }).collect(Collectors.toList());
        }catch (Exception e){
            log.error("parse taskCardFields error,",e);
            return new ArrayList<>();
        }

    }

    private CardGroupApplication taskGroup(String taskCode,GroupAndLabelDto dto, Map<String,ApplicationRelation> taskRelationsMap,Map<String,Application> applicationMap){
        ApplicationRelation applicationRelation = taskRelationsMap.get(taskCode);
        String appCode = applicationRelation.getAppCode();
        Application app = applicationMap.get(appCode);
        CardGroupApplication groupApplication =null;
        for(CardGroupApplication cgp:dto.getCardGroupApplications()){
            if(cgp.getAppCode().equals(appCode)){
                groupApplication = cgp;
                break;
            }
        }
        if(null==groupApplication){
            groupApplication = new CardGroupApplication();
            groupApplication.setAppCode(appCode);
            groupApplication.setAppName(applicationRelation.getAppName());
            groupApplication.setTasks(new ArrayList<>());
            if(null!=app && null!=app.getLang()){
                groupApplication.setLang(app.getLang());
                groupApplication.getLang().put("appName",app.getLang().get("name"));

            }
            dto.getCardGroupApplications().add(groupApplication);
        }
        return groupApplication;
    }

    public List<CardGroupApplication> generateApplicationGroups(Map<String, List<TaskCardFields>> appTasks) {
        if (CollectionUtils.isEmpty(appTasks)) {
            return Collections.EMPTY_LIST;
        }
        List<CardGroupApplication> cardGroupApplications = new LinkedList<>();
        appTasks.forEach((k, v) -> {
            CardGroupApplication cardGroupApplication = new CardGroupApplication();
            cardGroupApplication.setAppCode(k);
            List<TaskCardFields> appTasksList = v;
            List<CardGroupTask> tasks = new LinkedList<>();
            appTasksList.forEach(appTask -> {
                CardGroupTask cardGroupTask = new CardGroupTask();
                cardGroupTask.setCode(appTask.getCode());
                List<Group> groups = appTask.getTaskCardField().getGroups();
                cardGroupTask.setGroups(JSON.parseArray(JSON.toJSONString(groups), CardGroupGroup.class));
                tasks.add(cardGroupTask);
            });
            cardGroupApplication.setTasks(tasks);
            cardGroupApplications.add(cardGroupApplication);
        });
        return cardGroupApplications;
    }







}
