package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.*;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.log.operation.annotation.DWLogOperation;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.activity.*;
import com.digiwin.athena.kg.domain.TenantSummaryField;
import com.digiwin.athena.kg.domain.TenantSummaryFields;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.kmservice.support.MergePolicyBuilder;
import com.digiwin.athena.domain.definition.ReminderRule;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.cache.CacheService;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.knowledgegraph.component.ComponentInitManager;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.constant.ComponentConstants;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.dao.ActivityDAO;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.domain.*;
import com.digiwin.athena.kg.activity.Language;
import com.digiwin.athena.knowledgegraph.domain.activity.ExportAndImportConfig;
import com.digiwin.athena.knowledgegraph.domain.application.*;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.config.MergeRule;
import com.digiwin.athena.knowledgegraph.domain.qr.DynamicTaskAndActivities;
import com.digiwin.athena.knowledgegraph.domain.task.*;
import com.digiwin.athena.knowledgegraph.domain.valueobject.ActivityDataEntryVO;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.knowledgegraph.dto.*;
import com.digiwin.athena.kg.activity.ExpectedDurationDTO;
import com.digiwin.athena.dto.TenantSummaryFieldsDto;
import com.digiwin.athena.knowledgegraph.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.knowledgegraph.enums.SourceType;
import com.digiwin.athena.knowledgegraph.enums.WSConfigType;
import com.digiwin.athena.knowledgegraph.enums.WSPageCode;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.repo.DecisionRuleRepository;
import com.digiwin.athena.knowledgegraph.repoSystem.ActivityCompositionRepository;
import com.digiwin.athena.knowledgegraph.service.*;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.task.model.*;
import com.digiwin.athena.knowledgegraph.utils.*;
import com.digiwin.athena.knowledgegraph.vo.*;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.ConditionScopeVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WSConditionVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WorkbenchSettingVO;
import com.digiwin.athena.repository.neo4j.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_KNOWLEDGE_GRAPH;
import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_WORKBENCHSETTING_CACHE;

/**
 * 新的重构版本 需要数据结构修改
 **/
@Lang
@Service
@Slf4j
@MyExceptionHandler
@SuppressWarnings("findsecbugs:HARD_CODE_PASSWORD")
public class TaskService implements ITaskService {

    public static final String SUMMARY = "summary";
    public static final String BUSINESS_INFO = "businessInfo";
    public static final String SEARCH_KEY = "searchKey";
    public static final String PROJECT_INFO = "projectInfo";
    @Autowired
    TaskFieldService taskFieldService;
    @Autowired
    TaskRepository taskRepository;
    @Autowired
    Activity2Repository activityRepository;
    @Autowired
    ActivityRepository activityRepo;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    private DecisionRuleRepository decisionRuleRepository;

    @Autowired
    SolvePlanRepository solvePlanRepository;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired
    ActivityCompositionRepository activityCompositionRepository;

    @Autowired
    DynamicTaskRepository dynamicTaskRepository;

    @Autowired
    private CACUtils cacUtils;

    @Autowired
    private AppService applicationService;
    @Autowired
    TenantService tenantService;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private MechanismService mechanismService;

    @Autowired
    private ComponentManager componentManager;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private ESPUtils espUtils;
    @Autowired
    private ComponentInitManager componentInitManager;

    @Autowired
    private MongoEntityBaseDAO mongoEntityBaseDAO;

    @Autowired
    private EocService eocService;

    @Autowired
    private AppService appService;

    @Autowired
    private CacheService cacheService;
    @Autowired
    private ATMCService atmcService;

    @Autowired
    TranslateUtils translateUtils;

    @Autowired
    @Qualifier("baseExecutor")
    ThreadPoolTaskExecutor executor;

    @Autowired
    WorkbenchSettingService workbenchSettingService;

    @Autowired(required = false)
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    DataPickService dataPickService;

    @Autowired
    ReportConditionService reportConditionService;
    @Autowired
    private ActionService actionService;

    @Autowired
    AppMetaCaller appMetaCaller;

    @Autowired
    private ActivityDAO activityDAO;

    @Override
    @Deprecated
    public Object getDefinition(String taskId) throws Exception {

        return getDefinitionWithMultiLanguage(taskId);
    }
    //@Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getDefinitionWithMultiLanguage$0$1", tenant = true,language = true, ttlSecs = 7200)
    @Override
    public Object getDefinitionWithMultiLanguage(String taskId, String pageCode) throws Exception {
        return dataMapService.getDefinitionWithMultiLanguage(taskId,pageCode);
//        Object task = this.getDefinitionWithMultiLanguage(taskId);
//        try {
//            Activity result = JSON.parseObject(JSON.toJSONString(task), Activity.class);
//            try {
//                Map<String, Object> pages = result.getPages();
//                result.setPages((Map<String, Object>) pages.get(pageCode));
//                ApplicationRelation applicationRelation = applicationService.getApplicationByTypeAndCode("task", result.getCode());
//                FunctionCtrl functionCtrl = applicationService.getApplicationFunctionCtrlByAppCode(applicationRelation.getAppCode());
//                boolean cardCustomizeFlag = this.isCardCustom(functionCtrl);
//                if (cardCustomizeFlag) {
//                    processSysSummaryFields(result);
//                    //获取租户级summaryFields
//                    processTenantSummaryFields(result, pageCode);
//                }
//            } catch (Exception e) {
//                log.warn("processSummaryFields error:", e);
//                return result;
//            }
//            return result;
//        } catch (Exception e) {
//            return task;
//        }
    }
   // @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getDefinitionWithMultiLanguage$0", tenant = true,language = true, ttlSecs = 7200)
    @Override
    public Object getDefinitionWithMultiLanguage(String taskId) throws Exception {
        return dataMapService.getDefinitionByTaskId(taskId);

//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        TaskAndTarget tt = taskRepository.findTaskAndTarget(tenantId, taskId, tenantVersion);
//        if (null == tt) {
//            Object dm = dataMapService.getProject(taskId);
//            try {
//                JSONObject dmObject = (JSONObject) dm;
//                JSONArray phases = dmObject.getJSONArray("phases");
//                String application = dmObject.getString("application");
//                String applicationCode = applicationService.getAppCodeByApplication(application);
//                List<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<>();
//                for (Object phase : phases) {
//                    JSONArray taskCodesArray = ((JSONObject) phase).getJSONArray("taskCodes");
//                    for (Object taskCode : taskCodesArray) {
//
//                        ComponentBaseInfoBO componentInfo = new ComponentBaseInfoBO();
//                        componentInfo.setCode(taskCode.toString());
//                        componentInfo.setType(ComponentTypeEnum.Task);
//                        componentBaseInfos.add(componentInfo);
//                    }
//                }
//                List<ComponentBaseInfoBO> filteredBaseInfos = componentManager.FilterByTenantApplicationComponentList(applicationCode, tenantId, componentBaseInfos);
//                for (Object phase : phases) {
//                    JSONArray taskCodesArray = ((JSONObject) phase).getJSONArray("taskCodes");
//                    List<Object> toRemoves = new ArrayList<>();
//                    for (Object taskCode : taskCodesArray) {
//                        boolean found = false;
//                        for (ComponentBaseInfoBO component : filteredBaseInfos) {
//                            if (component.getCode().equals(taskCode.toString())) {
//                                found = true;
//                            }
//                        }
//                        if (!found) {
//                            toRemoves.add(taskCode);
//                        }
//                    }
//                    for (Object toRemove : toRemoves) {
//                        taskCodesArray.remove(toRemove);
//                    }
//                }
//            } catch (Exception e) {
//            }
//            if (null != dm) {
//                return dm;
//            }
//        }
//        if (tt == null) {
//            log.warn("neo4j find task by code:{} and tenantId:{},result={}", taskId, tenantId, tt);
//            return null;
//        }
//        Task task = tt.getTask();
//        task.setChargePerson(tt.getPersonInCharge());
//        //dto兼容
//        task.setTaskId(task.getCode());
//        task.setTaskName(task.getName());
//        if (Constants.TaskType.BUSINESS.equalsIgnoreCase(task.getType())) {
//            task.setCompletedReport(true);
//        }
//        if (null != tt.getTarget()) {
//            task.setTaskTargetId(tt.getTarget().getCode());
//            task.setTaskTargetName(tt.getTarget().getName());
//            if (!tt.getTarget().getLang().isEmpty() && null != tt.getTarget().getLang().get("name")) {
//                task.setTaskTargetName(processLanguage(tt.getTarget().getName(), "name", tt.getTarget().getLang()));
//            }
//        }
//        if (null != task.getLang().get("sourceName")) {
//            task.setSourceName(processLanguage((String) task.getSourceName(), "sourceName", task.getLang()));
//        }
//        if (null != task.getLang().get("dueDateName")) {
//            task.setDueDateName(processLanguage((String) task.getDueDateName(), "dueDateName", task.getLang()));
//        }
//        if (null != task.getLang().get("name")) {
//            task.setTaskName(processLanguage((String) task.getName(), "name", task.getLang()));
//        }
//
//        //加载mongodb中的taskConfigs配置
//        Task taskConfig = this.findTaskConfig(tenantId, taskId, task.getVersion());
//        if (taskConfig != null) {
//            AthenaUtils.mergeObject(taskConfig, task);
//        }
//        // 原来setMapProductInfo循环调用获取产品名称赋值改为批量处理
//        batchSetProductInfo(task.getDataSources(), tenantId);
//        return task;
    }

    @Override
    public Object postDefinitionWithMultiLanguage(String taskId, OperationUnit operationUnit) throws Exception {
        Map<String,Object> query =new HashMap<>();
        query.put("taskId",taskId);
        query.put("operationUnit",operationUnit);
        return dataMapService.postDefinitionByTaskIdAndOperationUnit(query);

//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        TaskAndTarget tt = taskRepository.findTaskAndTarget(tenantId, taskId, tenantVersion);
//        if (null == tt) {
//            Object dm = dataMapService.getProject(taskId, operationUnit);
//            try {
//                JSONObject dmObject = (JSONObject) dm;
//                JSONArray phases = dmObject.getJSONArray("phases");
//                String application = dmObject.getString("application");
//                String applicationCode = applicationService.getAppCodeByApplication(application);
//                List<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<>();
//                for (Object phase : phases) {
//                    JSONArray taskCodesArray = ((JSONObject) phase).getJSONArray("taskCodes");
//                    for (Object taskCode : taskCodesArray) {
//
//                        ComponentBaseInfoBO componentInfo = new ComponentBaseInfoBO();
//                        componentInfo.setCode(taskCode.toString());
//                        componentInfo.setType(ComponentTypeEnum.Task);
//                        componentBaseInfos.add(componentInfo);
//                    }
//                }
//                List<ComponentBaseInfoBO> filteredBaseInfos = componentManager.FilterByTenantApplicationComponentList(applicationCode, tenantId, componentBaseInfos);
//                for (Object phase : phases) {
//                    JSONArray taskCodesArray = ((JSONObject) phase).getJSONArray("taskCodes");
//                    List<Object> toRemoves = new ArrayList<>();
//                    for (Object taskCode : taskCodesArray) {
//                        boolean found = false;
//                        for (ComponentBaseInfoBO component : filteredBaseInfos) {
//                            if (component.getCode().equals(taskCode.toString())) {
//                                found = true;
//                            }
//                        }
//                        if (!found) {
//                            toRemoves.add(taskCode);
//                        }
//                    }
//                    for (Object toRemove : toRemoves) {
//                        taskCodesArray.remove(toRemove);
//                    }
//                }
//            } catch (Exception e) {
//            }
//            if (null != dm) {
//                return dm;
//            }
//        }
//        if (tt == null) {
//            log.warn("neo4j find task by code:{} and tenantId:{},result={}", taskId, tenantId, tt);
//            return null;
//        }
//        Task task = tt.getTask();
//        task.setChargePerson(tt.getPersonInCharge());
//        //dto兼容
//        task.setTaskId(task.getCode());
//        task.setTaskName(task.getName());
//        if (Constants.TaskType.BUSINESS.equalsIgnoreCase(task.getType())) {
//            task.setCompletedReport(true);
//        }
//        if (null != tt.getTarget()) {
//            task.setTaskTargetId(tt.getTarget().getCode());
//            task.setTaskTargetName(tt.getTarget().getName());
//            if (!tt.getTarget().getLang().isEmpty() && null != tt.getTarget().getLang().get("name")) {
//                task.setTaskTargetName(processLanguage(tt.getTarget().getName(), "name", tt.getTarget().getLang()));
//            }
//        }
//        if (null != task.getLang().get("sourceName")) {
//            task.setSourceName(processLanguage((String) task.getSourceName(), "sourceName", task.getLang()));
//        }
//        if (null != task.getLang().get("dueDateName")) {
//            task.setDueDateName(processLanguage((String) task.getDueDateName(), "dueDateName", task.getLang()));
//        }
//        if (null != task.getLang().get("name")) {
//            task.setTaskName(processLanguage((String) task.getName(), "name", task.getLang()));
//        }
//
//        //加载mongodb中的taskConfigs配置
//        Task taskConfig = this.findTaskConfig(tenantId, taskId, task.getVersion());
//        if (taskConfig != null) {
//            AthenaUtils.mergeObject(taskConfig, task);
//
//        }
//        // 原来setMapProductInfo循环调用获取产品名称赋值改为批量处理
//        batchSetProductInfo(task.getDataSources(), tenantId);
//
//        return task;
    }

    @Override
    @Deprecated
    public Object getActivities(String taskId) throws Exception {
        return getActivitiesWithMultiLanguage(taskId);
    }


    @Override
    public Object getActivitiesWithMultiLanguage(String taskId) throws Exception {
        return dataMapService.getTasks(taskId);

//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        TaskAndActivities tt = taskRepository.findTaskAndActivities(tenantId, taskId, tenantVersion);
//
//        if (null == tt) {
//            Object dm = dataMapService.getTasks(taskId);
//            if (null != dm) {
//                return dm;
//            }
//        }
//        if (null == tt) {
//            log.warn("neo4j find task by code:{} and tenantId:{},result={}", taskId, tenantId, tt);
//            return null;
//        }
//        Task task = tt.getTask();
//        task.setActivities(tt.getActivities());
//        //dto兼容
//        task.setTaskId(task.getCode());
//        task.setTaskName(processLanguage(task.getName(), "name", task.getLang()));
//
//        if (null != task.getActivities()) {
//            Collections.sort(task.getActivities());
//            // 定义serviceName->productNanme的map集合
//            Map<String, String> serviceNameMap = new HashMap<>();
//            // 过滤出符合条件的serviceNames
//            List<String> serviceNames = task.getActivities().stream()
//                    .filter(activity -> null != activity.getExpectedDuration()
//                            && null != activity.getExpectedDuration().getDueDateRule()
//                            && null != activity.getExpectedDuration().getDueDateRule().getGetDateAction()
//                            && "ESP".equalsIgnoreCase(activity.getExpectedDuration().getDueDateRule().getGetDateAction().getType())
//                    )
//                    .map(activity -> activity.getExpectedDuration().getDueDateRule().getGetDateAction().getServiceName())
//                    .filter(Objects::nonNull)
//                    .distinct()
//                    .collect(Collectors.toList());
//            try {
//                serviceNameMap = productNameResolver.getProductNameMap(tenantId, serviceNames);
//            } catch (Exception e) {
//                log.error(e.toString());
//            }
//            // serviceNameMap在foreach中使用要不可变
//            final Map<String, String> finalServiceNameMap = serviceNameMap;
//            // 遍历Activities
//            task.getActivities().forEach(a -> {
//                a.setActivityId(a.getCode());
//                if (null != a.getLang().get("name")) {
//                    a.setActivityName(processLanguage(a.getName(), "name", a.getLang()));
//                }
//
//                if (null != a.getExpectedDuration() && null != a.getExpectedDuration().getDueDateRule()
//                        && null != a.getExpectedDuration().getDueDateRule().getGetDateAction()
//                        && "ESP".equalsIgnoreCase(a.getExpectedDuration().getDueDateRule().getGetDateAction().getType())) {
//                    String serviceName = a.getExpectedDuration().getDueDateRule().getGetDateAction().getServiceName();
//                    if (StringUtils.isNotEmpty(serviceName)) {
//                        a.getExpectedDuration().getDueDateRule().getGetDateAction().setProductName(finalServiceNameMap.get(serviceName));
//                    }
//                }
//
//                //todo 加载过期处理规则.为了编辑方便先存mongo
//                Activity activityPageConfig = null;
//                try {
//                    activityPageConfig = findBetterActivity(tenantId, a.getCode(), a.getVersion());
//                } catch (DWBusinessException e) {
//                    throw new RuntimeException(e);
//                }
//                if (null != activityPageConfig) {
//                    a.setOverdueRules(activityPageConfig.getOverdueRules());
//                    if (null != activityPageConfig.getExpectedDuration()) {
//                        a.setExpectedDuration(activityPageConfig.getExpectedDuration());
//                    }
//                }
//
//
//            });
//        }
//
//        return task;
    }

    private static Object processLanguage(String defVal, String propName, Map<String, Map<String, String>> langMap) {
        if (langMap.get(propName) != null) {
            Map propLangMap = langMap.get(propName);
            propLangMap.put("zh_CN", defVal);
            langMap.remove(propName);
            return propLangMap;
        }

        return defVal;
    }

    /**
     * @return [{"name":"","type":"项目或任务","code":"项目或任务code","pattern":"基础资料或报表"}]
     * @Author zhuangli
     * @Description 模糊查询报表, 基础数据录入, 手动创建项目
     * @Date 8 2022/1/7
     * @Param
     **/
    @Override
    public Object getQueryItem(String condition) throws Exception {
        condition = Pattern.quote(condition);
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
//        List<String> appCodes = this.tenantService.getAppCodes(tenantId);
        List<String> appCodes = cacUtils.getAppAuth();
        //优化查询逻辑，先查出应用下含有哪些项目，然后再从中查询手动发起的项目
        List<ApplicationRelation> task = applicationService.getApplicationRelationByTypeAndAppCode("task", appCodes);
        List<String> taskCodes = task.stream().map(e -> e.getCode()).distinct().collect(Collectors.toList());

        Map<String, Object> query = new HashMap<>();
        query.put("manualAble", true);
        query.put("name", condition);
        query.put("code", taskCodes);
        List projectInDataMap = new LinkedList();
        try {
            projectInDataMap = dataMapService.getProjects(query);  //modify by srj 换成和查询手动发起项目一致的datamap接口
            this.filterProject(projectInDataMap, appCodes, tenantId);
        } catch (Exception e) {
            log.error("获取dataMap中的project异常", e);
        }

        List<Activity> dataEntry = dataPickService.excludeWithSameCode(activityDAO.getActivitiesByPatternCondition("DATA_ENTRY", condition, tenantId, tenantVersion));
        filterUc(dataEntry,tenantId);
        List<Activity> commonDataEntry = dataPickService.excludeWithSameCode(activityDAO.getActivitiesByPatternCondition("DATA_ENTRY", condition, tenantId, tenantVersion));
        filterUc(commonDataEntry,tenantId);
        List<Activity> statements = dataPickService.excludeWithSameCode(activityDAO.getActivitiesByPatternCondition("STATEMENT", condition, tenantId, tenantVersion));
        filterUc(statements,tenantId);
        List<Activity> commonStatements = dataPickService.excludeWithSameCode(activityDAO.getActivitiesByPatternCondition("STATEMENT", condition, tenantId, tenantVersion));
        filterUc(commonStatements,tenantId);
        condition = ".*" + condition + ".*";
        List<Task> manualProject = taskRepository.getManualProjectsByName(condition, tenantId, tenantVersion);

        // 公共基础资料根据应用搭售基础资料筛选
        Map<String, Activity> activityMap = commonDataEntry.stream()
                .collect(Collectors.toMap(Activity::getCode, Function.identity(), (a, b) -> b));
        List<String> commonDataEntryCodes = commonDataEntry.stream().map(Activity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> commonDataEntryCodesRelations = appService.getApplicationRelation(appCodes, commonDataEntryCodes, "activity", null);
        Map<String, List<String>> commonDataEntryListCodes =
                commonDataEntryCodesRelations.stream().collect(Collectors.groupingBy(ApplicationRelation::getCode,
                        Collectors.mapping(ApplicationRelation::getAppCode, Collectors.toList())));
        if (!CollectionUtils.isEmpty(commonDataEntryCodes)) {
            Map<String, List<ApplicationRelation>> applicationRelationsMap =
                    applicationService.getApplicationRelationsMapByTypeAndCodesAndLang("activity",
                            commonDataEntryCodes, localeStr, activityMap);
            Set<String> appsIncludedItems = getCommonAppsIncludedItems(applicationRelationsMap);
            commonDataEntry = commonDataEntry.stream().filter(activity -> appsIncludedItems.contains(activity.getCode())).collect(Collectors.toList());
        }

        // 公共报表根据应用搭售基础资料筛选 （仿照公共基础资料写法）
        Map<String, Activity> activityStatementMap = commonStatements.stream()
                .collect(Collectors.toMap(Activity::getCode, Function.identity(), (a, b) -> b));
        List<String> commonStatementsCodes = commonStatements.stream().map(Activity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> commonStatementsCodesRelations = appService.getApplicationRelation(appCodes, commonStatementsCodes, "activity", null);
        Map<String, List<String>> commonStatementsListCodes =
                commonStatementsCodesRelations.stream().collect(Collectors.groupingBy(ApplicationRelation::getCode,
                        Collectors.mapping(ApplicationRelation::getAppCode, Collectors.toList())));
        if (!CollectionUtils.isEmpty(commonStatementsCodes)) {
            Map<String, List<ApplicationRelation>> applicationRelationsMap =
                    applicationService.getApplicationRelationsMapByTypeAndCodesAndLang("activity",
                            commonStatementsCodes, localeStr, activityStatementMap);
            Set<String> appsIncludedItems = getCommonAppsIncludedItems(applicationRelationsMap);
            commonStatements = commonStatements.stream().filter(activity -> appsIncludedItems.contains(activity.getCode())).collect(Collectors.toList());
        }

        //普通基础资料根据应用授权过滤
        List<String> dataEntryCodes = dataEntry.stream().map(Activity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> dataEntryCodesRelations = mongoTemplate.find(Query.query(Criteria.where("code").in(dataEntryCodes).and("appCode").in(appCodes)
                .and("version").is(tenantVersion).and("type").is("activity").and("commonApp").ne(true)), ApplicationRelation.class); //加上commonApp不等于true，过滤掉公共应用的数据
        dataEntryCodesRelations = dataPickService.filterApplicationRelations(dataEntryCodesRelations);
        Map<String, List<String>> dataEntryListCodes =
                dataEntryCodesRelations.stream().collect(Collectors.groupingBy(ApplicationRelation::getCode,
                        Collectors.mapping(ApplicationRelation::getAppCode, Collectors.toList())));
        dataEntry = dataEntry.stream().filter(activity -> dataEntryListCodes.containsKey(activity.getCode())).collect(Collectors.toList());

        List<String> statementsCodes = statements.stream().map(Activity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> statementsCodesRelations = mongoTemplate.find(Query.query(Criteria.where("code").in(statementsCodes).and("appCode").in(appCodes)
                .and("version").is(tenantVersion).and("type").is("activity").and("commonApp").ne(true)), ApplicationRelation.class);//加上commonApp不等于true，过滤掉公共应用的数据
        statementsCodesRelations = dataPickService.filterApplicationRelations(statementsCodesRelations);
        Map<String, List<String>> statementsListCodes =
                statementsCodesRelations.stream().collect(Collectors.groupingBy(ApplicationRelation::getCode,
                        Collectors.mapping(ApplicationRelation::getAppCode, Collectors.toList())));
        statements = statements.stream().filter(activity -> statementsListCodes.containsKey(activity.getCode())).collect(Collectors.toList());

        List<String> manualProjectCodes = dataEntry.stream().map(Activity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> manualProjectCodesRelations = appService.getApplicationRelation(appCodes, manualProjectCodes, "task", null);
        List<String> manualProjectCodesRelationsListCodes = manualProjectCodesRelations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
        manualProject = manualProject.stream().filter(activity -> manualProjectCodesRelationsListCodes.contains(activity.getCode())).collect(Collectors.toList());

        //tdd报表特殊处理  用来定义是否自定义ifCustom
        Map<String, String> tbbCodeApplicationMap = new HashMap<>();
        handleTBBTenantReports("STATEMENT", tenantId, tenantVersion, statements, tbbCodeApplicationMap);
        List<String> tbbIfCustom = statements.stream()
                .map(Activity::getCode).filter(code -> !StringUtils.isEmpty(tbbCodeApplicationMap.get(code)))
                .collect(Collectors.toList());


        List<Map> dataEntryMapList = castActivityToItemMap(dataEntry, localeStr, dataEntryListCodes);
        List<Map> commonDataEntryMapList = castActivityToItemMap(commonDataEntry, localeStr, commonDataEntryListCodes);
        List<Map> statementsMapList = castActivityToItemMap(statements, localeStr, statementsListCodes, tbbIfCustom);
        List<Map> commonStatementsMapList = castActivityToItemMap(commonStatements, localeStr, commonStatementsListCodes);
        List<Map> manualProjectMapList = castTaskToItemMap(manualProject, localeStr);
        List<Map> manualProjectDataMapMapList = castDataMapTaskToItemMap(projectInDataMap, localeStr);
        if (!CollectionUtils.isEmpty(commonDataEntryMapList)) {
            dataEntryMapList.addAll(commonDataEntryMapList);
        }
        if (!CollectionUtils.isEmpty(commonStatementsMapList)) {
            dataEntryMapList.addAll(commonStatementsMapList);
        }
        if (!CollectionUtils.isEmpty(statementsMapList)) {
            dataEntryMapList.addAll(statementsMapList);
        }
        if (!CollectionUtils.isEmpty(manualProjectMapList)) {
            dataEntryMapList.addAll(manualProjectMapList);
        }
        if (!CollectionUtils.isEmpty(manualProjectDataMapMapList)) {
            dataEntryMapList.addAll(manualProjectDataMapMapList);
        }
        return dataEntryMapList;
    }

    private List<Map> castActivityToItemMap(List<Activity> dataEntry, String localeStr, Map<String, List<String>> appCodeMap) {
        if (CollectionUtils.isEmpty(dataEntry)) {
            return new LinkedList<>();
        } else {
            List<Map> dataEntryMapList = new LinkedList<>();
            dataEntry.forEach(item -> {
                List<String> appCodeList = appCodeMap.get(item.getCode());
                if (!CollectionUtils.isEmpty(appCodeList)) {
                    for (String appCode : appCodeList) {
                        Map<String, Object> itemMap = new HashMap<>(16);
                        itemMap.put("name", (CollectionUtils.isEmpty(item.getLang()) || CollectionUtils.isEmpty(item.getLang().get("name")) || null == item.getLang().get("name").get(localeStr)) ? item.getName()
                                : item.getLang().get("name").get(localeStr));
                        itemMap.put("type", "Activity");
                        itemMap.put("code", item.getCode());
                        itemMap.put("pattern", item.getPattern());
                        itemMap.put("subReport", BooleanUtils.toBoolean(item.getSubReport()));
                        //2024/1/25 虚拟common类型移除
                        itemMap.put("ifCommon", "false");
                        itemMap.put("category", item.getCategory());
                        itemMap.put("appCode", appCode);
                        itemMap.put("ifCustom", false);
                        dataEntryMapList.add(itemMap);
                    }
                }
            });
            return dataEntryMapList;
        }
    }

    private List<Map> castActivityToItemMap(List<Activity> dataEntry, String localeStr, Map<String, List<String>> appCodeMap, List<String> tbbIfCustom) {
        if (CollectionUtils.isEmpty(dataEntry)) {
            return new LinkedList<>();
        } else {
            List<Map> dataEntryMapList = new LinkedList<>();
            dataEntry.forEach(item -> {
                List<String> appCodeList = appCodeMap.get(item.getCode());
                for (String appCode : appCodeList) {
                    Map<String, Object> itemMap = new HashMap<>(16);
                    itemMap.put("name", (null == item.getLang() || item.getLang().isEmpty() || null == item.getLang().get("name") || null == item.getLang().get("name").get(localeStr))
                            ? item.getName() : item.getLang().get("name").get(localeStr));
                    itemMap.put("type", "Activity");
                    itemMap.put("code", item.getCode());
                    itemMap.put("pattern", item.getPattern());
                    itemMap.put("subReport", BooleanUtils.toBoolean(item.getSubReport()));
                    //2024/1/25 虚拟common类型移除
                    itemMap.put("ifCommon", "false");
                    itemMap.put("category", item.getCategory());
                    itemMap.put("appCode", appCode);
                    itemMap.put("ifCustom", tbbIfCustom.contains(item.getCode()));
                    dataEntryMapList.add(itemMap);
                }
            });
            return dataEntryMapList;
        }
    }

    private List<Map> castDataMapTaskToItemMap(List manualDataMapProject, String localeStr) {
        if (CollectionUtils.isEmpty(manualDataMapProject)) {
            return Collections.EMPTY_LIST;
        } else {
            List<Map> originalMap = JSON.parseArray(JSON.toJSONString(manualDataMapProject), Map.class);
            List<Map> dataEntryMapList = new LinkedList<>();
            originalMap.forEach(item -> {
                Map<String, String> itemMap = new HashMap<>(8);
                itemMap.put("name", (String) item.get("name"));
                itemMap.put("type", "Task");
                itemMap.put("code", (String) item.get("code"));
                itemMap.put("pattern", null == item.get("pattern") ? null : (String) item.get("pattern"));
                dataEntryMapList.add(itemMap);
            });
            return dataEntryMapList;
        }
    }

    private List<Map> castTaskToItemMap(List<Task> manualProject, String localeStr) {
        if (CollectionUtils.isEmpty(manualProject)) {
            return Collections.emptyList();
        } else {
            List<Map> dataEntryMapList = new LinkedList<>();
            manualProject.forEach(item -> {
                Map<String, String> itemMap = new HashMap<>(8);
                itemMap.put("name", (null == item.getLang() || item.getLang().isEmpty() || null == item.getLang().get("name") || null == item.getLang().get("name").get(localeStr))
                        ? item.getName()
                        : item.getLang().get("name").get(localeStr));
                itemMap.put("type", "Task");
                itemMap.put("code", item.getCode());
                itemMap.put("pattern", item.getPattern());
                dataEntryMapList.add(itemMap);
            });
            return dataEntryMapList;
        }
    }


    @Override
    public Object getActivityNamesByCode(String activityCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        final String loc_zh_CN = "zh_CN";
        final String loc_zh_TW = "zh_TW";
        final String loc_en_US = "en_US";
        final String loc_default = "default";
        final String key = "name";
        //Activity activity = dataPickService.chooseOneWithSameCode(activityRepository.getActivityByCode(tenantId, activityCode, tenantVersion));
        Activity activity = dataPickService.chooseOneWithSameCode(activityDAO.getActivityByCodeAndVersion(activityCode, tenantVersion ,tenantId));
        Map<String, String> lang = new HashMap<>();
        if (null == activity) {
            return lang;
        }
        lang.put(loc_default, activity.getName());
        if (null != activity.getLang() && !activity.getLang().isEmpty()) {
            String en_US = activity.getLang().get(key).get(loc_en_US);
            String zh_TW = activity.getLang().get(key).get(loc_zh_TW);
            String zh_CN = activity.getLang().get(key).get(loc_zh_CN);
            if (!StringUtils.isEmpty(en_US)) {
                lang.put(loc_en_US, en_US);
            }
            if (!StringUtils.isEmpty(zh_TW)) {
                lang.put(loc_zh_TW, zh_TW);
            }
            if (!StringUtils.isEmpty(zh_CN)) {
                lang.put(loc_zh_CN, zh_CN);
            }
        }
        return lang;
    }

    @Override
    public Object postTenantTBBReportsByProductCode(TBBReportReplacer reportReplacer) throws Exception {
//        String tenantVersion = kgInnerService.getTenantVersion(reportReplacer.getTenantId());
//        //step1:根据productCode先将对应应用下所有PCC报表删除,包括activity,applicationRelation,activityConfigs
//        clearTenantTBBReportsByProductCode(reportReplacer.getProductCode(), reportReplacer.getTenantId(), tenantVersion);
//        //step2:将报表分别写入neo4j的activity,mongo的applicationRelation和activityConfigs
//        reportReplacer.setVersion(tenantVersion);
//        writeNewReportToDB(reportReplacer);
//        return null;
        Map<String,Object> map = AppMetaCaller.of("reportReplacer",reportReplacer);
        RespObject resp = appMetaCaller.call("/record/tenantTBBReportsByProductCode","post",map,RespObject.class);
        return resp.getResponse();
    }

    /**
     * 根据productCode先将对应应用下所有PCC报表删除,包括activity,applicationRelation,activityConfigs
     * @param productCode 产品code
     * @param tenantId 租户id
     * @param tenantVersion 租户版本号
     * @throws DWBusinessException
     */
    private void clearTenantTBBReportsByProductCode(String productCode, String tenantId, String tenantVersion) throws DWBusinessException {
        //查找当前应用下所有activity
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId).and("version").is(tenantVersion).and("productCode").is(productCode);
        queryUser.addCriteria(criteriaUser);
        mongoTemplateUser.remove(queryUser, "tbbReports");
    }

    /**
     * 写入报表数据
     * @param reportReplaceDO 报表数据
     */
    private void writeNewReportToDB(TBBReportReplacer reportReplaceDO) {
        mongoTemplateUser.insert(reportReplaceDO, "tbbReports");
    }

    /**
     * @return java.lang.Object
     * @Author zhuangli
     * @Description 根据mode类型和productCode获取报表, mode:pc or mobile
     * @Date 14:39 2022/6/7
     * @Param [mode]
     **/
    @Override
    public Object getTBBReports(String mode, String productCode) throws Exception {
//        List<ActivityDataEntryVO> activityDataEntryVOS;
//        switch (mode) {
//            case "pc":
//                activityDataEntryVOS = (List<ActivityDataEntryVO>) getActivitiesByPattern("STATEMENT");
//                break;
//            case "mobile":
//                activityDataEntryVOS = (List<ActivityDataEntryVO>) getActivitiesByPattern("MOBI-STATEMENT");
//                break;
//            default:
//                activityDataEntryVOS = (List<ActivityDataEntryVO>) getActivitiesByPattern("STATEMENT");
//                break;
//        }
//        if (CollectionUtils.isEmpty(activityDataEntryVOS)) {
//            return Collections.EMPTY_LIST;
//        }
//        activityDataEntryVOS = activityDataEntryVOS.stream().filter(activity -> activity.getAppCode() != null && activity.getAppCode().equals(productCode)).collect(Collectors.toList());
//        return activityDataEntryVOS;
        Map<String,Object> map = AppMetaCaller.of("mode",mode);
        map.put("productCode", productCode);
        RespObject resp = appMetaCaller.call("/record/tBBReports","get",map,RespObject.class);
        return resp.getResponse();
    }

    @Autowired
    IamService iamService;

    @Override
    public Object getBaseDataApplication() throws Exception {
//        List<Activity> activities = activityRepository.getCommonBaseData(AthenaUtils.getTenantId());
//        List<String> activityCodes = activities.stream().map(Activity::getCode).collect(Collectors.toList());
//        List<ApplicationRelation> applicationRelations = applicationService.getApplicationRelation(activityCodes, "2.0");
//        new ExcelExporter().exportToExcel(applicationRelations);
//        return applicationRelations;
        RespObject resp = appMetaCaller.call("/record/baseDataApplication","get",null,RespObject.class);
        return resp.getResponse();
    }


    @Override
    public Object getActivitiesInfoByPattern() throws Exception {
//        List<ActivityDataEntryVO> activityDataEntryVOS = new LinkedList<>();
//        List<String> appCodes = cacUtils.getAppAuth();
//
//
//        DWServiceContext context = DWServiceContext.getContext();
//        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
//        CompletableFuture<List<ActivityDataEntryVO>> service1Future = CompletableFuture.supplyAsync(() -> {
//
//            // 基础资料
//            try{
//                DWServiceContext.setContext(context);
//                RequestContextHolder.setRequestAttributes(requestAttributes);
//                List<ActivityDataEntryVO> baseList = (List<ActivityDataEntryVO>) this.getActivitiesByPattern("DATA_ENTRY");
//                baseList.forEach(data -> {
//                    data.setType("baseDataEntry");
//                });
//                return baseList;
//            }catch (Exception e){
//                log.error("getActivitiesInfoByPattern error:{}", e);
//            }
//            return new ArrayList<>();
//        });
//
//        CompletableFuture<List<ActivityDataEntryVO>> service2Future = CompletableFuture.supplyAsync(() -> {
//            // 报表
//            try{
//
//                DWServiceContext.setContext(context);
//                RequestContextHolder.setRequestAttributes(requestAttributes);
//                List<ActivityDataEntryVO>  reportList = (List<ActivityDataEntryVO>) this.getActivitiesByPattern("STATEMENT");
//                reportList.forEach(data -> {
//                    data.setType("statement");
//                });
//                return reportList;
//            }catch (Exception e){
//                log.error("getActivitiesInfoByPattern error:{}", e);
//            }
//            return new ArrayList<>();
//        });
//
//        CompletableFuture<List<JSONObject>> service3Future = CompletableFuture.supplyAsync(() -> {
//            try {
//
//                DWServiceContext.setContext(context);
//                RequestContextHolder.setRequestAttributes(requestAttributes);
//                // 发起项目
//                List<JSONObject> jsonObjectList = (List<JSONObject>) this.getManualListBasic();
//                return jsonObjectList;
//            }catch (DWBusinessException e){
//                log.error("getActivitiesInfoByPattern error:{}", e);
//            }
//           return new ArrayList<>();
//        });
//
//        CompletableFuture<Void> allOf = CompletableFuture.allOf(service1Future, service2Future, service3Future);
//        List<ActivityDataEntryInfoVO> resultList = new LinkedList<>();
//        allOf.thenRun(() -> {
//            try{
//                RequestContextHolder.setRequestAttributes(requestAttributes);
//                // 三个服务请求完毕后的后续处理
//                List<ActivityDataEntryVO> baseList = service1Future.join();
//
//                List<ActivityDataEntryVO> reportList = service2Future.join();
//
//                List<JSONObject> jsonObjectList = service3Future.join();
//
//                // 进行后续处理
//                List<ApplicationRelation> applicationRelationList = applicationService.getApplicationRelationByTypeAndAppCode("task", appCodes);
//                Map<String, List<ApplicationRelation>> map = applicationRelationList.stream().collect(Collectors.groupingBy(ApplicationRelation::getCode));
//                for (JSONObject jsonObject : jsonObjectList) {
//                    List<ApplicationRelation> applicationRelations = map.get(jsonObject.getString("code"));
//
//                    if (!CollectionUtils.isEmpty(applicationRelations)) {
//                        List<ApplicationRelation> handlerList = applicationRelations.stream()
//                                .collect(Collectors.collectingAndThen(
//                                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(
//                                                ApplicationRelation::getCode))), ArrayList::new
//                                        )
//                                );
//
//                        handlerList.forEach(applicationRelation -> {
//                            ActivityDataEntryVO activityDataEntryVO = new ActivityDataEntryVO();
//                            activityDataEntryVO.setAppCode(null == applicationRelation ? null : applicationRelation.getAppCode());
//                            activityDataEntryVO.setAppName(null == applicationRelation ? "缺少应用关系配置" : applicationRelation.getAppName());
//
//                            activityDataEntryVO.setName(jsonObject.getString("name"));
//                            activityDataEntryVO.setCode(jsonObject.getString("code"));
//                            activityDataEntryVO.setType("manualStartProject");
//                            activityDataEntryVO.setCategory(null);
//                            activityDataEntryVO.setIfCustom(null);
//
//                            activityDataEntryVOS.add(activityDataEntryVO);
//                        });
//                    }
//                }
//
//                activityDataEntryVOS.addAll(baseList);
//                activityDataEntryVOS.addAll(reportList);
//
//                Map<String, List<ActivityDataEntryVO>> maps = activityDataEntryVOS.stream()
//                        .filter(item -> !StringUtils.isEmpty(item.getAppCode()))
//                        .collect(Collectors.groupingBy(ActivityDataEntryVO::getAppCode));
//
//                maps.forEach((key, value) -> {
//
//                    List<ActivityDataEntryInfoVO.ActivityDataEntryInnerVO> activityDataEntryInnerVO = new LinkedList<>();
//
//                    ActivityDataEntryInfoVO activityDataEntryVO = new ActivityDataEntryInfoVO();
//                    activityDataEntryVO.setAppCode(value.get(0).getAppCode());
//                    activityDataEntryVO.setAppName(value.get(0).getAppName());
//
//                    value.forEach(data -> {
//                        ActivityDataEntryInfoVO.ActivityDataEntryInnerVO activityDataEntryInner = new ActivityDataEntryInfoVO.ActivityDataEntryInnerVO();
//                        activityDataEntryInner.setName(data.getName());
//                        activityDataEntryInner.setCode(data.getCode());
//                        activityDataEntryInner.setType(data.getType());
//                        activityDataEntryInner.setIfCustom(data.getIfCustom());
//                        activityDataEntryInner.setCategory(data.getCategory());
//                        activityDataEntryInnerVO.add(activityDataEntryInner);
//                    });
//
//                    activityDataEntryVO.setData(activityDataEntryInnerVO);
//
//                    resultList.add(activityDataEntryVO);
//
//                });
//
//
//            }catch(Exception e){
//                log.error("getActivitiesInfoByPattern error:{}", e);
//            }
//        }).join();
//        return resultList;

        RespObject resp = appMetaCaller.call("/record/activitiesInfoByPattern","get",null,RespObject.class);
        return resp.getResponse();

//        // 基础资料
//        List<ActivityDataEntryVO> baseList = (List<ActivityDataEntryVO>) this.getActivitiesByPattern("DATA_ENTRY");
//        baseList.forEach(data -> {
//            data.setType("baseDataEntry");
//        });
//        // 报表
//        List<ActivityDataEntryVO> reportList = (List<ActivityDataEntryVO>) this.getActivitiesByPattern("STATEMENT");
//        reportList.forEach(data -> {
//            data.setType("statement");
//        });
//        // 发起项目
//        List<ApplicationRelation> applicationRelationList = applicationService.getApplicationRelationByTypeAndAppCode("task", appCodes);
//        Map<String, List<ApplicationRelation>> map = applicationRelationList.stream().collect(Collectors.groupingBy(ApplicationRelation::getCode));
//        List<JSONObject> jsonObjectList = (List<JSONObject>) this.getManualList();
//        for (JSONObject jsonObject : jsonObjectList) {
//            List<ApplicationRelation> applicationRelations = map.get(jsonObject.getString("code"));
//
//            if (!CollectionUtils.isEmpty(applicationRelations)) {
//                List<ApplicationRelation> handlerList = applicationRelations.stream()
//                        .collect(Collectors.collectingAndThen(
//                                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(
//                                                ApplicationRelation::getCode))), ArrayList::new
//                                )
//                        );
//
//                handlerList.forEach(applicationRelation -> {
//                    ActivityDataEntryVO activityDataEntryVO = new ActivityDataEntryVO();
//                    activityDataEntryVO.setAppCode(null == applicationRelation ? null : applicationRelation.getAppCode());
//                    activityDataEntryVO.setAppName(null == applicationRelation ? "缺少应用关系配置" : applicationRelation.getAppName());
//
//                    activityDataEntryVO.setName(jsonObject.getString("name"));
//                    activityDataEntryVO.setCode(jsonObject.getString("code"));
//                    activityDataEntryVO.setType("manualStartProject");
//                    activityDataEntryVO.setCategory(null);
//                    activityDataEntryVO.setIfCustom(null);
//
//                    activityDataEntryVOS.add(activityDataEntryVO);
//                });
//            }
//        }
//
//        activityDataEntryVOS.addAll(baseList);
//        activityDataEntryVOS.addAll(reportList);
//
//        Map<String, List<ActivityDataEntryVO>> maps = activityDataEntryVOS.stream()
//                .filter(item -> !StringUtils.isEmpty(item.getAppCode()))
//                .collect(Collectors.groupingBy(ActivityDataEntryVO::getAppCode));
//        List<ActivityDataEntryInfoVO> resultList = new LinkedList<>();
//        maps.forEach((key, value) -> {
//
//            List<ActivityDataEntryInfoVO.ActivityDataEntryInnerVO> activityDataEntryInnerVO = new LinkedList<>();
//
//            ActivityDataEntryInfoVO activityDataEntryVO = new ActivityDataEntryInfoVO();
//            activityDataEntryVO.setAppCode(value.get(0).getAppCode());
//            activityDataEntryVO.setAppName(value.get(0).getAppName());
//
//            value.forEach(data -> {
//                ActivityDataEntryInfoVO.ActivityDataEntryInnerVO activityDataEntryInner = new ActivityDataEntryInfoVO.ActivityDataEntryInnerVO();
//                activityDataEntryInner.setName(data.getName());
//                activityDataEntryInner.setCode(data.getCode());
//                activityDataEntryInner.setType(data.getType());
//                activityDataEntryInner.setIfCustom(data.getIfCustom());
//                activityDataEntryInner.setCategory(data.getCategory());
//                activityDataEntryInnerVO.add(activityDataEntryInner);
//            });
//
//            activityDataEntryVO.setData(activityDataEntryInnerVO);
//
//            resultList.add(activityDataEntryVO);
//        });
//        return resultList;

    }
    //个案过滤
    private void filterUc(List<Activity> activities,String tenantId){

        Iterator<Activity> activityIterator = activities.iterator();
        List<String> ucCodes = new ArrayList<>();
        while (activityIterator.hasNext()){
            Activity activity  = activityIterator.next();
            if(null!=activity.getInclusionTenant()){
                if(!activity.getInclusionTenant().contains(tenantId)){
                    activityIterator.remove();
                }else{
                    if(activity.getCode().startsWith("UC_")){
                        ucCodes.add(activity.getCode().replace("UC_",""));
                    }
                }
            }
        }
//        Iterator<Activity> activityIterator2 = activities.iterator();
//        while (activityIterator2.hasNext()){
//            Activity activity  = activityIterator2.next();
//            if(ucCodes.contains(activity.getCode())){
//                activityIterator2.remove();
//            }
//        }
    }


   // @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getActivitiesByPattern$0", tenant = true,language = true, ttlSecs = 7200)
    //@SneakyThrows
    @Override
    public Object getActivitiesByPattern(String pattern) throws Exception {
//        long start = System.currentTimeMillis();
//        log.info("enter getActivitiesByPattern at :{}", start);
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        Locale locale = DWResourceBundleUtils.getCurrentLocale();
//        String localeStr = locale.toString();
//        //add start
//        String hasGroundEnd = null;
//        Object hasGroundEndObj = null;
//        try {
//            hasGroundEndObj = this.mechanismService.getVariable("hasGroundEnd", tenantId);
//            if (hasGroundEndObj != null) {
//                Map<String, Object> hasGroundEndMap = (Map<String, Object>) hasGroundEndObj;
//                hasGroundEnd = String.valueOf(hasGroundEndMap.get("hasGroundEnd"));
//            }
//        } catch (Exception e) {
//
//        }
//        List<String> appCodes = cacUtils.getAppAuth();
//        List<String> activityCodes = dataPickService.tenantProductCodes("activity",appCodes);
//        //add end
//        List<Activity> activities = dataPickService.excludeWithSameCode(activityRepository.getActivitiesByPattern(tenantId, pattern, tenantVersion,activityCodes));
//        filterUc(activities,tenantId);
//
//        //TBB报表租户版特殊处理(租户级配置替换标准配置)
//        //<activityCode,applicationCode>
//        Map<String, String> tbbCodeApplicationMap = new HashMap<>();
//        if (pattern.equals("STATEMENT") || pattern.equals("MOBI-STATEMENT")) {
//            //查询租户级TBB报表配置并合并
//            handleTBBTenantReports(pattern, tenantId, tenantVersion, activities, tbbCodeApplicationMap);
//        }
//
//        Map<String, Boolean> activityHasGroundEndMap = this.getActivityHasGroundEnd(activities);
//
//        final String hasGroundEndTemp = hasGroundEnd;
//        List<ActivityDataEntryVO> activityDataEntryVOS = new LinkedList<>();
//
//        if (CollectionUtils.isEmpty(activities)) {
//            return activityDataEntryVOS;
//        }
//        Map<String, Activity> activityMap = activities.stream()
//                .collect(Collectors.toMap(Activity::getCode, Function.identity(), (a, b) -> b));
//        //区分两种activity
//        //normal Activity(非tbb报表)
//        List<String> normalActivityCodes = activities.stream()
//                .filter(item -> StringUtils.isEmpty(tbbCodeApplicationMap.get(item.getCode()))).map(Activity::getCode)
//                .collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(normalActivityCodes)) {
//            Map<String, List<ApplicationRelation>> applicationRelationsMap =
//                    applicationService.getApplicationRelationsMapByTypeAndCodesAndLang("activity",
//                            normalActivityCodes, localeStr, activityMap);
//            //通过iam查询应用搭售基础资料
//            Set<String> finalCommonAppsIncludedItems = getCommonAppsIncludedItems(applicationRelationsMap);
//            normalActivityCodes.forEach(item -> {
//                if (!(StringUtils.equals(hasGroundEndTemp, "N") && activityHasGroundEndMap.get(item) != null && activityHasGroundEndMap.get(item))) {
//                    //p3s1新增逻辑,公共基础资料,一笔资料可能对应多个应用
//                    ActivityDataEntryVO activityDataEntryVO = new ActivityDataEntryVO();
//                    List<ApplicationRelation> applicationRelations = applicationRelationsMap.get(item);
//                    if (!CollectionUtils.isEmpty(applicationRelations)) {
//                        applicationRelations.forEach(applicationRelation -> {
//                            //add by srj 20220802 当有应用关系，但租户已经没有这个应用权限的时候，对应的数据不返回
//                            if (appCodes.contains(applicationRelation.getAppCode())) {
//                                Activity activityItem = activityMap.get(item);
//                                ActivityDataEntryVO dataEntryVO = new ActivityDataEntryVO();
//                                BeanUtils.copyProperties(activityDataEntryVO, dataEntryVO);
//                                dataEntryVO.setName(activityItem.getLang().isEmpty() || null == activityItem.getLang().get("name").get(localeStr) ? activityItem.getName()
//                                        : activityItem.getLang().get("name").get(localeStr));
//                                dataEntryVO.setCode(activityItem.getCode());
//                                //是否公共基础资料 2024/1/25 虚拟公共应用移除
//                                dataEntryVO.setIfCommon(false);
//                                dataEntryVO.setCommonApp(null == applicationRelation.getCommonApp() ? false : applicationRelation.getCommonApp());
//                                dataEntryVO.setResCode(activityItem.getResCode());
//                                dataEntryVO.setCategory(activityItem.getCategory());
//                                dataEntryVO.setCategoryAbi(activityItem.getCategoryAbi());
//                                dataEntryVO.setAppCode(null == applicationRelation ? null : applicationRelation.getAppCode());
//                                dataEntryVO.setAppName(null == applicationRelation ? "缺少应用关系配置" : applicationRelation.getAppName());
//                                dataEntryVO.setGroupCode(StringUtils.isEmpty(activityItem.getGroupCode()) ? null : activityItem.getGroupCode());
//                                dataEntryVO.setSort(null == activityItem.getSequence() ? null : String.valueOf(activityItem.getSequence()));
//                                dataEntryVO.setSubReport(activityItem.getSubReport());
//                                if (applicationRelation.getCommonApp()) {
//                                    if (finalCommonAppsIncludedItems.contains(dataEntryVO.getCode())) {
//                                        activityDataEntryVOS.add(dataEntryVO);
//                                    }
//                                } else {
//                                    activityDataEntryVOS.add(dataEntryVO);
//                                }
//                            }
//                        });
//                    }
//                }
//            });
//        }
//        //tbb Activity
//        List<String> tbbActivityCodes = activities.stream()
//                .filter(item -> !StringUtils.isEmpty(tbbCodeApplicationMap.get(item.getCode()))).map(Activity::getCode)
//                .collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(tbbActivityCodes)) {
//            Map<String, ApplicationRelation> applicationRelationMap =
//                    applicationService.getApplicationRelationsMapByApplicationAndLang(tbbCodeApplicationMap.values(), localeStr);
//            tbbActivityCodes.forEach(item -> {
//                if (!(StringUtils.equals(hasGroundEndTemp, "N") && activityHasGroundEndMap.get(item) != null && activityHasGroundEndMap.get(item))) {
//                    //租户自定义报表:tbb报表application处理,直接根据appcode查app
//                    ApplicationRelation applicationRelation = applicationRelationMap.get(item);
//                    if (appCodes.contains(applicationRelation.getAppCode())) {
//                        //applicationRelations.add(applicationRelation);
//                        ActivityDataEntryVO activityDataEntryVO = new ActivityDataEntryVO();
//                        Activity activityItem = activityMap.get(item);
//                        activityDataEntryVO.setName(activityItem.getLang().isEmpty() || null == activityItem.getLang().get("name").get(localeStr) ? activityItem.getName()
//                                : activityItem.getLang().get("name").get(localeStr));
//                        //是否公共基础资料
//                        activityDataEntryVO.setIfCommon("common".equalsIgnoreCase(activityItem.getNameSpace()) ?
//                                Boolean.TRUE : Boolean.FALSE);
//                        activityDataEntryVO.setCode(activityItem.getCode());
//                        activityDataEntryVO.setResCode(activityItem.getResCode());
//                        activityDataEntryVO.setCategory(activityItem.getCategory());
//                        activityDataEntryVO.setCategoryAbi(activityItem.getCategoryAbi());
//                        activityDataEntryVO.setAppCode(null == applicationRelation ? null : applicationRelation.getAppCode());
//                        activityDataEntryVO.setAppName(null == applicationRelation ? "缺少应用关系配置" : applicationRelation.getAppName());
//                        activityDataEntryVO.setGroupCode(StringUtils.isEmpty(activityItem.getGroupCode()) ? null : activityItem.getGroupCode());
//                        activityDataEntryVO.setSort(null == activityItem.getSequence() ? null : String.valueOf(activityItem.getSequence()));
//                        activityDataEntryVO.setIfCustom(true);
//                        activityDataEntryVO.setSubReport(activityItem.getSubReport());
//                        activityDataEntryVOS.add(activityDataEntryVO);
//                    }
//                }
//            });
//        }
//        log.info("return getActivitiesByPattern run for {}ms", System.currentTimeMillis() - start);
//        return activityDataEntryVOS;
        Map<String,Object> map = AppMetaCaller.of("pattern",pattern);
        RespObject resp = appMetaCaller.call("/record/activitiesByPattern","get",map,RespObject.class);
        return resp.getResponse();
    }

    @Override
    public List<ExportAndImportConfig> getExportAndImportConfig() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        String hasGroundEnd = null;
        Object hasGroundEndObj;
        try {
            hasGroundEndObj = this.mechanismService.getVariable("hasGroundEnd", tenantId);
            if (hasGroundEndObj != null) {
                Map<String, Object> hasGroundEndMap = (Map<String, Object>) hasGroundEndObj;
                hasGroundEnd = String.valueOf(hasGroundEndMap.get("hasGroundEnd"));
            }
        } catch (Exception e) {
            log.error("Route==>TaskService method=getExportAndImportConfig get hasGroundEnd error:", e);
        }
        List<String> appCodes = cacUtils.getAppAuth();
        List<String> activityCodes = dataPickService.tenantProductCodes("activity",appCodes);
        //add end
        List<Activity> activities = activityDAO.getActivitiesByPattern(tenantId, "DATA_ENTRY", tenantVersion,activityCodes);
        filterUc(activities,tenantId);


        Map<String, Boolean> activityHasGroundEndMap = this.getActivityHasGroundEnd(activities);

        final String hasGroundEndTemp = hasGroundEnd;

        if (CollectionUtils.isEmpty(activities)) {
            return new ArrayList<>();
        }
        Map<String, Activity> activityMap = activities.stream()
                .collect(Collectors.toMap(Activity::getCode, Function.identity(), (a, b) -> b));

        List<String> codeList=new ArrayList<>();
        //normal Activity
        List<String> normalActivityCodes = activities.stream().map(Activity::getCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(normalActivityCodes)) {
            Map<String, List<ApplicationRelation>> applicationRelationsMap =
                    applicationService.getApplicationRelationsMapByTypeAndCodesAndLang("activity",
                            normalActivityCodes, localeStr, activityMap);
            //通过iam查询应用搭售基础资料
            Set<String> finalCommonAppsIncludedItems = getCommonAppsIncludedItems(applicationRelationsMap);

            normalActivityCodes.forEach(item -> {
                if (!(StringUtils.equals(hasGroundEndTemp, "N") && activityHasGroundEndMap.get(item) != null && activityHasGroundEndMap.get(item))) {

                    List<ApplicationRelation> applicationRelations = applicationRelationsMap.get(item);
                    if (!CollectionUtils.isEmpty(applicationRelations)) {
                        applicationRelations.forEach(applicationRelation -> {
                            //add by srj 20220802 当有应用关系，但租户已经没有这个应用权限的时候，对应的数据不返回
                            if (appCodes.contains(applicationRelation.getAppCode())) {
                                Activity activityItem = activityMap.get(item);
                                if (applicationRelation.getCommonApp()) {
                                    if (finalCommonAppsIncludedItems.contains(activityItem.getCode())) {
                                        codeList.add(activityItem.getCode());
                                    }
                                } else {
                                    codeList.add(activityItem.getCode());
                                }
                            }
                        });
                    }
                }
            });
        }

        //查询导入导出数据
        List<ExportAndImportConfig> exportAndImportConfigs = mongoTemplate.find(Query.query(Criteria.where("code").in(codeList)
                .and("version").is(tenantVersion)), ExportAndImportConfig.class);

        //国际化
        if (!CollectionUtils.isEmpty(exportAndImportConfigs)) {
            exportAndImportConfigs.forEach(exportAndImportConfig -> {
                exportAndImportConfig.setName(exportAndImportConfig.getLang().isEmpty() || null == exportAndImportConfig.getLang().get("name").get(localeStr) ? exportAndImportConfig.getName()
                        : exportAndImportConfig.getLang().get("name").get(localeStr));
            });
        }

        return exportAndImportConfigs;
    }

    private Set<String> getCommonAppsIncludedItems(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        Set<String> appIdSet = getCommonAppIds(applicationRelationsMap);
        Set<String> commonAppsIncludedItems = Collections.emptySet();
        if (!CollectionUtils.isEmpty(appIdSet)) {
            commonAppsIncludedItems = new HashSet<>(iamService.appItems(new ArrayList<>(appIdSet)));
        }
        Set<String> finalCommonAppsIncludedItems = commonAppsIncludedItems;
        return finalCommonAppsIncludedItems;
    }

    private Set<String> getCommonAppIds(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        Set<String> commonAppIds = new HashSet<>();
        applicationRelationsMap.forEach((k, v) -> {
            ApplicationRelation applicationRelation = v.get(0);
            if (applicationRelation.getCommonApp()) {
                commonAppIds.add(applicationRelation.getAppCode());

            }
        });
        return commonAppIds;
    }

    @Override
    public Object getActivitiesByPatternAndAppCode(String pattern, String appCode) throws Exception {
//        List<ActivityDataEntryVO> activitiesByPattern = (List<ActivityDataEntryVO>) this.getActivitiesByPattern(pattern);
//        if (!CollectionUtils.isEmpty(activitiesByPattern)) {
//            Iterator<ActivityDataEntryVO> iterator = activitiesByPattern.iterator();
//            while (iterator.hasNext()) {
//                ActivityDataEntryVO next = iterator.next();
//                if (!StringUtils.equals(next.getAppCode(), appCode)) {
//                    iterator.remove();
//                }
//            }
//        }
//        return activitiesByPattern;
        Map<String,Object> map = AppMetaCaller.of("pattern",pattern);
        map.put("appCode", appCode);
        RespObject resp = appMetaCaller.call("/record/activitiesByPatternAndAppCode","get",map,RespObject.class);
        return resp.getResponse();
    }


    private void handleTBBTenantReports(String pattern, String tenantId, String tenantVersion, List<Activity> activities, Map<String, String> tbbCodeApplicationMap) {
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId).and("version").is(tenantVersion);
        queryUser.addCriteria(criteriaUser);
        List<TBBReportReplacer> tbbReportReplacers = mongoTemplateUser.find(queryUser, TBBReportReplacer.class, "tbbReports");
        List<Activity> tbbActivities = new LinkedList<>();
        Set<String> replaceIdSet = new HashSet<>();
        if (!CollectionUtils.isEmpty(tbbReportReplacers)) {
            tbbReportReplacers.forEach(item -> {
                item.getReports().forEach(itemj -> {
                    if ((pattern.equals("STATEMENT") && itemj.getMode().equals("pc")) ||
                            (pattern.equals("MOBI-STATEMENT") && itemj.getMode().equals("mobile"))) {
                        Activity activity = new Activity();
                        //设置为租户覆盖的id
                        activity.setCode(itemj.getId());
                        Map<String, Map<String, String>> langMap = new HashMap<>();
                        langMap.put("name", itemj.getName());
                        activity.setLang(langMap);
                        tbbCodeApplicationMap.put(itemj.getId(), item.getProductCode());
                        if (!StringUtils.isEmpty(itemj.getReplaceId())) {
                            replaceIdSet.add(itemj.getReplaceId());
                        }
                        tbbActivities.add(activity);
                    }
                });
            });
        }
        //过滤掉被替换旧数据数据
        if (!CollectionUtils.isEmpty(activities)) {
            activities = activities.stream().filter(activity -> !replaceIdSet.contains(activity.getCode())).collect(Collectors.toList());
        } else {
            activities = new LinkedList<>();
        }
        if (!CollectionUtils.isEmpty(tbbActivities)) {
            tbbActivities.forEach(tbbActivity -> tbbActivity.setCategory("STATEMENT"));
            activities.addAll(tbbActivities);
        }
    }


  //  @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getActivitiesAndSortByPattern$0", tenant = true,language = true, ttlSecs = 7200)
    @Override
    public Object getActivitiesAndSortByPattern(String pattern) throws Exception {
//        List<ActivityDataEntryVO> activitiesByPattern = (List<ActivityDataEntryVO>) getActivitiesByPattern(pattern);
//        postActivitiesGroup(activitiesByPattern);
//        filterComponentByCode(activitiesByPattern, pattern);
//        return activitiesByPattern;
        Map<String,Object> map = AppMetaCaller.of("pattern",pattern);
        RespObject resp = appMetaCaller.call("/record/activitiesAndSortByPattern","get",map,RespObject.class);
        return resp.getResponse();
    }

    /**
     *
     * @param activitiesByPattern
     * @param pattern
     * @throws DWBusinessException
     */
    private void filterComponentByCode(List<ActivityDataEntryVO> activitiesByPattern, String pattern) throws DWBusinessException {
        if (CollectionUtils.isEmpty(activitiesByPattern)) {
            return;
        }
        List<String> appCodeList =
                activitiesByPattern.stream().map(ActivityDataEntryVO::getAppCode).distinct().collect(Collectors.toList());
        Query query = new Query();
        query.addCriteria(Criteria.where(ComponentManager.APP_CODE).in(appCodeList)
                .and(ComponentManager.TENANT_ID).is(AthenaUtils.getTenantId()));
        List<TenantAppComponentListBO> tenantAppComponentListBOS = mongoTemplateUser.find(query,
                TenantAppComponentListBO.class);
        if (!CollectionUtils.isEmpty(tenantAppComponentListBOS)) {
            //生成key为应用code value为此租户下允许的codeList的map  过滤条件为type和非禁用
            Map<String, List<String>> map =
                    tenantAppComponentListBOS.stream().collect(Collectors.toMap(TenantAppComponentListBO::getAppCode,
                            vo -> {
                                if (CollectionUtils.isEmpty(vo.getComponents())) {
                                    return new ArrayList<>();
                                } else {
                                    return vo.getComponents().stream().filter(v -> v.getType().equals(transformPattern(pattern)) && !v.isDisabled()).map(ComponentBO::getCode).distinct().collect(Collectors.toList());
                                }
                            }, (a, b) -> a));

            Iterator<ActivityDataEntryVO> iterator = activitiesByPattern.iterator();
            while (iterator.hasNext()) {
                ActivityDataEntryVO next = iterator.next();
                if (map.containsKey(next.getAppCode())) {
                    //权限允许的codeList
                    List<String> codeList = map.get(next.getAppCode());
                    if (!CollectionUtils.isEmpty(codeList)) {
                        if (codeList.contains(next.getCode())) {
                            continue;
                        }
                        iterator.remove();
                    }
                }
            }
        }
    }

    private ComponentTypeEnum transformPattern(String pattern) {
        if ("DATA_ENTRY".equals(pattern)) {
            return ComponentTypeEnum.BaseDataEntry;
        } else if ("STATEMENT".equals(pattern) || "MOBI-STATEMENT".equals(pattern)) {
            return ComponentTypeEnum.Report;
        }
        log.error("not found pattern:{}", pattern);
        return null;
    }

    /**
     * 报表/基础资料/手动创建项目设置排序
     * @param requestList 报表/基础资料/手动创建项目
     * @return
     * @throws Exception
     */
    public List<ActivityDataEntryVO> postActivitiesGroup(List<ActivityDataEntryVO> requestList) throws Exception {
        log.info("start postActivitiesGroup:{}", System.currentTimeMillis());
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String lang = locale.toString();
        for (ActivityDataEntryVO vo : requestList) {
            ApplicationGroup applicationGroup;
            if (!StringUtils.isEmpty(vo.getGroupCode())) {
                Criteria criteria = new Criteria();
                criteria.and("appCode").exists(false).and("groupCode").is(vo.getGroupCode()).and("version").is(tenantVersion);
                applicationGroup = mongoTemplate.findOne(new Query(criteria), ApplicationGroup.class);
            } else {
                //公共基础资料的activity groupCode不在本节点定义
                Criteria criteria = new Criteria();
                criteria.and("appCode").is(vo.getAppCode()).and("activityCode").is(vo.getCode()).and("version").is(tenantVersion);
                applicationGroup = mongoTemplate.findOne(new Query(criteria), ApplicationGroup.class);
                if (null != applicationGroup) {
                    vo.setGroupCode(applicationGroup.getGroupCode());
                }
            }
            if (null != applicationGroup && null != applicationGroup.getLang()) {
                vo.setGroupSort(StringUtils.isEmpty(applicationGroup.getGroupSort()) ? null :
                        applicationGroup.getGroupSort());
                //vo.setSort(StringUtils.isEmpty(applicationGroup.getSort()) ? null : applicationGroup.getSort());
                Map nameLangMap = applicationGroup.getLang().get("groupName");
                if (null == nameLangMap) {
                    nameLangMap = applicationGroup.getLang().get("name") == null ? new HashMap<>() :
                            applicationGroup.getLang().get("name");
                }
                String language = (null == nameLangMap.get(lang)) ? applicationGroup.getGroupName() : (String) nameLangMap.get(lang);
                vo.setGroupName(null == language ? applicationGroup.getGroupName() : language);
            }
        }
        log.info("end postActivitiesGroup:{}", System.currentTimeMillis());
        return requestList;
    }

    private Map<String, Boolean> getActivityHasGroundEnd(List<Activity> activities) {
        if (CollectionUtils.isEmpty(activities)) {
            return new HashMap<>();
        }
        List<Activity> allActivityList = new ArrayList<>();
        Map<String, List<Activity>> groupByVersionActivityMap = activities.stream().collect(Collectors.groupingBy(e -> e.getVersion() == null ? "" : e.getVersion()));
        Set<Map.Entry<String, List<Activity>>> entries = groupByVersionActivityMap.entrySet();
        for (Map.Entry<String, List<Activity>> entry : entries) {
            List<Activity> value = entry.getValue();
            List<String> activityCodeList = value.stream().map(Activity::getCode).collect(Collectors.toList());
            Query query = Query.query(Criteria.where("code").in(activityCodeList)
                    .and("version").is(entry.getKey()));
            query.fields().include("code").include("dependOnGroundEnd");
            List<Activity> activityConfig = mongoTemplate.find(query, Activity.class, "activityConfigs");
            if (!CollectionUtils.isEmpty(activityConfig)) {
                allActivityList.addAll(activityConfig);
            }
        }
        Map<String, Boolean> resultMap = allActivityList.stream().collect(Collectors.toMap(Activity::getCode, e -> BooleanUtils.toBoolean(e.getDependOnGroundEnd()), (a, b) -> a));
        return resultMap;
    }

    /**
     * 是否自定义卡面
     *
     * @param functionCtrl
     * @return
     */
    private boolean isCardCustom(FunctionCtrl functionCtrl) {
        return functionCtrl != null
                && (functionCtrl.isProjectCardCustomizeFlag() || functionCtrl.isTaskCardCustomizeFlag());
    }

    /**
     * 这个接口呗同时用到查任务合基础资料报表
     * @param activityId 任务code
     * @param pageCode 页面设计code
     * @return
     * @throws Exception
     */
    @Override
//    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "activityDefinition2$0$1", language = true,
//            tenant = true, ttlSecs = 86400L)
    public Object getActivityDefinition(String activityId, String pageCode) throws Exception {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        Activity activity = dataPickService.chooseOneWithSameCode(activityRepository.getActivityByCode(tenantId, activityId, tenantVersion));
//        //校验关联的应用是否过期
//        if (null == activity || !activity.getNameSpace().equalsIgnoreCase("common")) {
//            this.applicationService.checkRelatedAppHasExpired("activity", activityId);
//        }
//        if (null == activity) {
//            Object dm =dataMapService.getActivityDefinition(activityId,pageCode);
//            if (null != dm) {
//                return dm;
//            }
//        }
//        if(null==activity){
//            return null;
//        }
//        String activityVersion = activity.getVersion();
//
//        Activity activityPageConfig = findBetterActivity(tenantId, activityId, activityVersion);
//
//        if (null != activityPageConfig) {
//            if (null != activityPageConfig.getPages()) {
//                activityPageConfig.setPages((Map<String, Object>) activityPageConfig.getPages().get(pageCode));
//            }
//            //处理API信息
//            // 原来setMapProductInfo循环调用获取产品名称赋值改为批量处理
//            batchSetProductInfo(activityPageConfig.getDataSources(), tenantId);
//            batchSetProductInfo(activityPageConfig.getPages(), tenantId);
//            //基础资料维护没有审核相关
//
//            AthenaUtils.mergeObject(activityPageConfig, activity);
//
//        }
//
//        //查询是否有设置abi报表查询字段，有就去处理报表查询字段的排序
//        try {
//            ReportConditionSetting setting = reportConditionService.findQueryConditionSetting(tenantId,activityId,tenantVersion);
//            if (null != setting && org.apache.commons.collections.CollectionUtils.isNotEmpty(setting.getSortData())){
//                dealReportSort(activity,setting.getSortData());
//            }
//        } catch (Exception e) {
//            log.warn("activity dealReportSort error:", e);
//        }
//        //同时返回app信息
//        processApplication(activityId, activity);
//        try {
//            ApplicationRelation applicationRelation = applicationService.getApplicationByTypeAndCode("activity", activity.getCode());
//            FunctionCtrl functionCtrl = applicationService.getApplicationFunctionCtrlByAppCode(applicationRelation.getAppCode());
//            boolean cardCustomizeFlag = this.isCardCustom(functionCtrl);
//            ;
//            if (cardCustomizeFlag) {
//                processSysSummaryFields(activity);
//                //获取租户级summaryFields
//                processTenantSummaryFields(activity, pageCode);
//            }
//        } catch (Exception e) {
//            log.warn("parse activity error:", e);
//            return activity;
//        }
//
//        return activity;
        Map<String,Object> map = AppMetaCaller.of("activityId",activityId);
        map.put("pageCode",pageCode);
        RespObject resp = appMetaCaller.call("/record/activityDefinition","get",map,RespObject.class);
        return resp.getResponse();
    }

    private void dealReportSort(Activity activity,List<Map<String, Object>> sortData) {
        if(activity != null){
            Map<String, Object> pages = activity.getPages();
            if (null != pages){
                if (!CollectionUtils.isEmpty((List) pages.get("layout"))) {
                    List<Map<String, Object>> layoutList = (List<Map<String, Object>>) pages.get("layout");
                            // 遍历layout集合
                    for (Map<String, Object> layout : layoutList) {
                        if ("FORM_LIST".equals(layout.get("type"))) {
                            // 递归处理group字段
                            processGroup(layout, sortData);
                        }
                    }
                }

            }
        }
    }
    private static void processGroup(Map<String, Object> layout, List<Map<String, Object>> sortData) {
        List<Map<String, Object>> group = (List<Map<String, Object>>) layout.get("group");
        if (group != null) {
            // 找到匹配的sortData对象
            Optional<Map<String, Object>> sortItemOpt = sortData.stream()
                    .filter(item -> ((String) layout.get("id")).equals(item.get("id")))
                    .findFirst();
            if (sortItemOpt.isPresent()) {
                // 如果匹配到sortData对象，根据sortField排序group字段
                Map<String, Integer> sortIndexMap = createSortIndexMap(sortItemOpt.get());
                group.sort(Comparator.comparingInt(item -> {
                    String pathSchema = (String) item.get("path") + ";" + item.get("schema");
                    return sortIndexMap.getOrDefault(pathSchema, 99999); // 不在sortField中的放后面,给与足够大的数值99999，排序时放后面
                }));
            }
            // 递归处理嵌套的FORM_LIST对象
            group.forEach(subItem -> {
                if ("FORM_LIST".equals(subItem.get("type"))) {
                    processGroup(subItem, sortData); // 递归调用
                }
            });
        }
    }
    public static Map<String, Integer> createSortIndexMap(Map<String, Object> sortItem) {
        List<String> sortFields = (List<String>) sortItem.get("sortField");
        if (sortFields == null){
            return new HashMap<>();
        }
        //使用 toMap 的重载版本,如果出现键值冲突，合并函数将选择保留现有的值(即)
        return sortFields.stream()
                .collect(Collectors.toMap(
                        field -> field,
                        field -> sortFields.indexOf(field),
                        (existingValue, newValue) -> existingValue // 合并函数，这里简单地选择保留现有值
                ));
    }

    private void processSysSummaryFields(Activity activity) {
        if (null != activity) {
            Map<String, Object> pages = activity.getPages();
            if (!CollectionUtils.isEmpty(pages)) {
                List<Map<String, Object>> dataStates = (List<Map<String, Object>>) pages.get("dataStates");

                if (!CollectionUtils.isEmpty(dataStates)) {

                    //新结构处理
                    dataStates.forEach(dataState -> {
                        if(SUMMARY.equals(dataState.get("type"))){
                            activity.setSummary(dataState);
                            activity.setSummaryFields((List<Map<String, Object>>) dataState.get("fieldMappings"));
                        }
                        if(BUSINESS_INFO.equals(dataState.get("type"))){
                            activity.setBusinessInfo(dataState);
                        }
                        if(SEARCH_KEY.equals(dataState.get("type"))){
                            activity.setSearchKey(dataState);
                        }
                        if(PROJECT_INFO.equals(dataState.get("type"))){
                            activity.setProjectInfo(dataState);
                        }
                    });

                    //不存在新结构，按原逻辑处理
                    if(!checkNewSummary(activity)){
                        List<Map<String, Object>> summaryFields = (List<Map<String, Object>>) dataStates.get(0).get("summaryFields");
                        activity.setSummaryFields(summaryFields);
                    }

                } else{
                    List<Map<String, Object>> summaryFieldsCandidate = (List<Map<String, Object>>) pages.get("summaryFields");
                    if (!CollectionUtils.isEmpty(summaryFieldsCandidate)) {
                        activity.setSummaryFields(summaryFieldsCandidate);
                    }
                }
            }
        }
    }

    /**
     * 判断是否是新的summary结构
     */
    private boolean checkNewSummary(Activity activity) {
        return !(CollectionUtils.isEmpty(activity.getSummary()) && CollectionUtils.isEmpty(activity.getBusinessInfo()) && CollectionUtils.isEmpty(activity.getSearchKey()) && CollectionUtils.isEmpty(activity.getProjectInfo()));
    }

    private void processApplication(String activityId, Activity activity) throws DWBusinessException {
        if (null != activity) {
            ApplicationRelation applicationRelation = applicationService.getApplicationByTypeAndCode("activity", activityId, AthenaUtils.getCurrentLocale());
            if (null != applicationRelation) {
                activity.setApplication(applicationRelation.getAppCode());
                activity.setAppName(applicationRelation.getAppName());
            }
            //dto
            activity.setActivityId(activityId);
            activity.setActivityName(activity.getName());
            activity.getLang().put("activityName", activity.getLang().get("name"));
        }
    }

    private void processTenantSummaryFields(Activity activity, String pageCode) throws DWBusinessException {
        if (null != activity) {
            String application = activity.getApplication();
            String code = activity.getCode();
            String type;
            switch (pageCode) {
                case "project-card":
                    type = "project";
                    break;
                case "task-card":
                    type = "task";
                    break;
                default:
                    type = null;
            }
            if(checkNewSummary(activity)){
                //新结构
                newProcessTenantSummaryFields(activity, pageCode);
            }else {
                // 开发平台增加了标识，不是所有字段都能作为摘要字段
                activity.setCanSelectedSummaryFields(ObjectUtil.cloneByStream(activity.getSummaryFields()));
                if (type != null && null != application) {
                    TenantSummaryFields tenantSummaryFields = queryTenantSummaryFields(application, type, code);
                    if (null != tenantSummaryFields) {
                        boolean ifUseTenantSummaryFields = judgeIfUseTenantSummaryFields(tenantSummaryFields, activity.getSummaryFields());
                        boolean ifUseTenantTitle = judgeIfUseTenantTitle(tenantSummaryFields);
                        if (ifUseTenantSummaryFields) {
                            if (!CollectionUtils.isEmpty(tenantSummaryFields.getSummaryFields())) {
                                List<Map<String, Object>> transformedTenantSummaryFields = transformTenantFieldsToSys(tenantSummaryFields, activity.getSummaryFields());
                                List<Map<String, Object>> mergedSummaryFields = mergeSummaryFields(activity.getSummaryFields(), transformedTenantSummaryFields);
                                Map<String, Object> pages = activity.getPages();
                                if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((List) pages.get("dataStates"))) {
                                    List<Map<String, Object>> dataStates = (List<Map<String, Object>>) pages.get("dataStates");
                                    Map<String, Object> dataState = dataStates.get(0);
                                    dataState.put("summaryFields", mergedSummaryFields);
                                } else {
                                    pages.put("summaryFields", mergedSummaryFields);
                                }
                                activity.setSummaryFields(mergedSummaryFields);
                            }
                            activity.setUsedTenantSummaryFields(true);
                        } else {
                            activity.setUsedTenantSummaryFields(false);
                        }
                        //判断是否使用租户自定义标题
                        if (ifUseTenantTitle && activity.getUsedTenantSummaryFields()) {
                            TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                            tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                            tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                            activity.setTenantCardTitleDefinition(tenantCardTitleDefinition);
                            //activity.setUsedTenantSummaryFields(true);
                        }
                        activity.setTenantSummaryFields(transformToTenantSummaryFieldsDTO(tenantSummaryFields));
                    } else {
                        activity.setUsedTenantSummaryFields(false);
                    }
                } else {
                    activity.setUsedTenantSummaryFields(false);
                }
                filterSummaryFields(activity);
            }
        }
    }

    private void newProcessTenantSummaryFields(Activity activity, String pageCode) throws DWBusinessException {
        if (null != activity) {
            String application = activity.getApplication();
            String code = activity.getCode();
            String type;
            switch (pageCode) {
                case "project-card":
                    type = "project";
                    break;
                case "task-card":
                    type = "task";
                    break;
                default:
                    type = null;
            }
            List<Map<String, Object>> newSummaryFieldes = (List<Map<String, Object>>) activity.getSummary().get("fieldMappings");
            // 开发平台增加了标识，不是所有字段都能作为摘要字段
            activity.setCanSelectedSummaryFields(ObjectUtil.cloneByStream(newSummaryFieldes));
            if (type != null && null != application) {
                TenantSummaryFields tenantSummaryFields = queryTenantSummaryFields(application, type, code);
                if (null != tenantSummaryFields) {
                    boolean ifUseTenantSummaryFields = judgeIfUseTenantSummaryFields(tenantSummaryFields, newSummaryFieldes);
                    boolean ifUseTenantTitle = judgeIfUseTenantTitle(tenantSummaryFields);
                    if (ifUseTenantSummaryFields) {
                        if (!CollectionUtils.isEmpty(tenantSummaryFields.getSummaryFields())) {
                            List<Map<String, Object>> transformedTenantSummaryFields = transformTenantFieldsToSys(tenantSummaryFields, newSummaryFieldes);
                            List<Map<String, Object>> mergedSummaryFields = transformedTenantSummaryFields;
                            Map<String, Object> pages = activity.getPages();
                            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((List) pages.get("dataStates"))) {
                                for (Map<String,Object> dataState : (List<Map<String,Object>>) pages.get("dataStates")) {
                                    if (SUMMARY.equals(dataState.get("type"))) {
                                        dataState.put("fieldMappings", mergedSummaryFields);
                                    }
                                }
                            }
                            activity.setSummaryFields(mergedSummaryFields);
                        }
                        activity.setUsedTenantSummaryFields(true);
                    } else {
                        activity.setUsedTenantSummaryFields(false);
                    }
                    //判断是否使用租户自定义标题
                    if (ifUseTenantTitle && activity.getUsedTenantSummaryFields()) {
                        TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                        tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                        tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                        activity.setTenantCardTitleDefinition(tenantCardTitleDefinition);
                    }
                    activity.setTenantSummaryFields(transformToTenantSummaryFieldsDTO(tenantSummaryFields));
                } else {
                    activity.setUsedTenantSummaryFields(false);
                }
            } else {
                activity.setUsedTenantSummaryFields(false);
            }
            newFilterSummaryFields(activity);
        }
    }

    /**
     * 合并摘要
     * @param summaryFields 系统级摘要字段
     * @param transformedTenantSummaryFields 租户级摘要字段
     * @return 合并后的摘要字段
     */
    private List<Map<String, Object>> mergeSummaryFields(List<Map<String, Object>> summaryFields, List<Map<String, Object>> transformedTenantSummaryFields) {
        if (CollectionUtils.isEmpty(summaryFields)) {
            return transformedTenantSummaryFields;
        } else {
            List<Map<String, Object>> mergedSummaryFields = new ArrayList<>();
            mergedSummaryFields.addAll(transformedTenantSummaryFields);
            // 非摘要字段，历史资讯或者其他字段
            mergedSummaryFields.addAll(summaryFields.stream().filter(map -> !MapUtils.getBoolean(map, "summary", true)).collect(Collectors.toList()));
            return mergedSummaryFields;
        }
    }

    /**
     * 过滤摘要字段
     * @param activity 任务定义
     */
    private void filterSummaryFields(Activity activity) throws DWBusinessException {
        if (!CollectionUtils.isEmpty(activity.getSummaryFields()) && !activity.getUsedTenantSummaryFields()) {
            // 只有应用级摘要字段需要按照“默认展示”标识过滤
            // 历史数据默认为true
            activity.getSummaryFields().removeIf(map -> !MapUtils.getBoolean(map, "defaultEffective", true) && MapUtils.getBoolean(map, "summary", true));
            Map<String, Object> pages = activity.getPages();
            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((List) pages.get("dataStates"))) {
                List<Map<String, Object>> dataStates = (List<Map<String, Object>>) pages.get("dataStates");
                Map<String, Object> dataState = dataStates.get(0);
                dataState.put("summaryFields", activity.getSummaryFields());
            } else {
                pages.put("summaryFields", activity.getSummaryFields());
            }
        }
        if (!CollectionUtils.isEmpty(activity.getCanSelectedSummaryFields())) {
            // 过滤掉不是摘要字段的，历史数据默认为true
            activity.getCanSelectedSummaryFields().removeIf(map -> !MapUtils.getBoolean(map, "summary", true));
        }
        // 如果之前设置过的租户级摘要字段不在本次可选择的字段中，为了兼容历史数据，需要将租户级字段添加到可选择的字段中
        if (!CollectionUtils.isEmpty(activity.getCanSelectedSummaryFields())) {
            List<Map<String, Object>> canSelectedSummaryFields = activity.getCanSelectedSummaryFields();
            List<Map<String, Object>> tenantSummaryFieldList = activity.getSummaryFields();
            String locale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString(activity.getCanSelectedSummaryFields().get(0), "actionId");
            List<ApiDataFieldLocaleMetadataDTO> fields = null;
            if (StringUtils.isNotEmpty(actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO) actionService.getMetadata(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                } catch (Exception e) {
                    throw new DWBusinessException("查询元数据定义出错，actionId：{}", actionId);
                }
            }
            activity.getCanSelectedSummaryFields().forEach(field -> {
                if (StringUtils.isEmpty(MapUtils.getString(field, "description"))) {
                    Object title = JSONPath.eval(field, "$.tags[0].title");
                    Object localeTitle = JSONPath.eval(field, "$.tags[0].lang.title." + locale);
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty(MapUtils.getString(field, "data_name"))) {
                    String value = MapUtils.getString(field, "value", "");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty(MapUtils.getString(field, "data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map<String, Object> tenantSummaryField : tenantSummaryFieldList) {
                //租户级数据不在可选范围中，则将租户级数据加入到可选摘要字段中，主要是为了兼容历史数据
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString(map, "value", "").equals(MapUtils.getString(tenantSummaryField, "value", "")));
                if (b && MapUtils.getBoolean(tenantSummaryField, "summary", true)) {
                    if (null != fields && !fields.isEmpty()) {
                        Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString(tenantSummaryField, "data_name", ""))).findFirst();
                        //如果
                        dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                    }
                    canSelectedSummaryFields.add(tenantSummaryField);
                }
            }
        }
    }

    /**
     * 新的过滤摘要字段
     */
    private void newFilterSummaryFields(Activity activity) throws DWBusinessException {
        if (!CollectionUtils.isEmpty(activity.getSummaryFields()) && !activity.getUsedTenantSummaryFields()) {
            // 只有应用级摘要字段需要按照“默认展示”标识过滤
            // 历史数据默认为true
            activity.getSummaryFields().removeIf(map -> !MapUtils.getBoolean(map, "defaultEffective", true));
            Map<String, Object> pages = activity.getPages();
            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((List) pages.get("dataStates"))) {
                for (Map<String,Object> dataState : (List<Map<String,Object>>) pages.get("dataStates")) {
                    if (SUMMARY.equals(dataState.get("type"))) {
                        dataState.put("fieldMappings", activity.getSummaryFields());
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(activity.getCanSelectedSummaryFields())) {
            // 过滤掉不是摘要字段的，历史数据默认为true
            activity.getCanSelectedSummaryFields().removeIf(map -> !MapUtils.getBoolean(map, "summary", true));
        }
        // 如果之前设置过的租户级摘要字段不在本次可选择的字段中，为了兼容历史数据，需要将租户级字段添加到可选择的字段中
        if (!CollectionUtils.isEmpty(activity.getCanSelectedSummaryFields())) {
            List<Map<String, Object>> canSelectedSummaryFields = activity.getCanSelectedSummaryFields();
            List<Map<String, Object>> tenantSummaryFieldList = activity.getSummaryFields();
            String locale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString(activity.getCanSelectedSummaryFields().get(0), "actionId");
            List<ApiDataFieldLocaleMetadataDTO> fields = null;
            if (StringUtils.isNotEmpty(actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO) actionService.getMetadata(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                } catch (Exception e) {
                    throw new DWBusinessException("查询元数据定义出错，actionId：{}", actionId);
                }
            }
            activity.getCanSelectedSummaryFields().forEach(field -> {
                if (StringUtils.isEmpty(MapUtils.getString(field, "description"))) {
                    Object title = JSONPath.eval(field, "$.tags[0].title");
                    Object localeTitle = JSONPath.eval(field, "$.tags[0].lang.title." + locale);
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty(MapUtils.getString(field, "data_name"))) {
                    String value = MapUtils.getString(field, "value", "");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty(MapUtils.getString(field, "data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map<String, Object> tenantSummaryField : tenantSummaryFieldList) {
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString(map, "value", "").equals(MapUtils.getString(tenantSummaryField, "value", "")));
                if (b && MapUtils.getBoolean(tenantSummaryField, "summary", true)) {
                    if (fields!=null && fields.size()>0) {
                        Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString(tenantSummaryField, "data_name", ""))).findFirst();
                        dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                    }
                    canSelectedSummaryFields.add(tenantSummaryField);
                }
            }
        }
    }

    private List<Map<String, Object>> transformTenantFieldsToSys(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        List<TenantSummaryField> tenantSummaryFieldList = tenantSummaryFields.getSummaryFields();
        if (!CollectionUtils.isEmpty(tenantSummaryFieldList)) {
            List<Map<String, Object>> sysSummaryFields = new ArrayList<>(6);
            for (int i = 0; i < tenantSummaryFieldList.size(); i++) {
                List<String> values = tenantSummaryFieldList.get(i).getValue();
                for (int j = 0; j < values.size(); j++) {
                    // 通过字段匹配应用级摘要配置；租户级配置覆盖应用级配置
                    String fieldPath = values.get(j);
                    Optional<Map<String, Object>> first = summaryFields.stream()
                            .filter(map -> fieldPath.equals(MapUtil.getStr(map, "value"))).findFirst();
                    Map<String, Object> sysSummaryField = Maps.newHashMap();
                    if (first.isPresent()) {
                        sysSummaryField = first.get();
                    }
                    Map<String, Object> sysSummaryFieldCopy = ObjectUtil.cloneByStream(sysSummaryField);
                    sysSummaryFieldCopy.put("summary", true);
                    sysSummaryFieldCopy.put("actionId", tenantSummaryFields.getActionId());
                    sysSummaryFieldCopy.put("value", fieldPath);
                    List<Map<String, Object>> tagList = new ArrayList<>(1);
                    Map<String, Object> tag = new HashMap<>();
                    tag.put("code", "group_" + i);
                    tag.put("title", tenantSummaryFieldList.get(i).getTitle());
                    tag.put("customTitle", true);
                    if (StringUtils.isEmpty(MapUtils.getString(sysSummaryFieldCopy, "description"))) {
                        sysSummaryFieldCopy.put("description", tenantSummaryFieldList.get(i).getTitle());
                        sysSummaryFieldCopy.put("data_type", "string");
                        sysSummaryFieldCopy.put("data_name", fieldPath.contains(".") ? fieldPath.split("\\.")[1] : fieldPath);

                    }
                    if (!tag.containsKey("lang")) {
                        JSONObject lang = new JSONObject();
                        JSONObject titleLang = new JSONObject();
                        titleLang.fluentPut("zh_CN", tenantSummaryFieldList.get(i).getTitle())
                                .fluentPut("zh_TW", tenantSummaryFieldList.get(i).getTitle())
                                .fluentPut("en_US", tenantSummaryFieldList.get(i).getTitle());
                        lang.put("title", titleLang);
                        tag.put("lang", lang);
                    }
                    tagList.add(tag);
                    sysSummaryFieldCopy.put("tags", tagList);
                    sysSummaryFields.add(sysSummaryFieldCopy);
                }
            }
            return sysSummaryFields;
        }
        return summaryFields;
    }

    private TenantSummaryFieldsDto transformToTenantSummaryFieldsDTO(TenantSummaryFields tenantSummaryFields) {
        return JSON.parseObject(JSON.toJSONString(tenantSummaryFields), TenantSummaryFieldsDto.class);
    }

    private boolean judgeIfUseTenantSummaryFields(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        } else if (CollectionUtils.isEmpty(summaryFields)) {
            return false;
        } else if (!summaryFields.get(0).get("actionId").equals(tenantSummaryFields.getActionId())) {
            return false;
        }
        return true;
    }

    private boolean judgeIfUseTenantTitle(TenantSummaryFields tenantSummaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        } else {
            String titlePrefix = tenantSummaryFields.getTitlePrefix();
            List<String> title = tenantSummaryFields.getTitle();
            return !(CollectionUtils.isEmpty(title) && StringUtils.isEmpty(titlePrefix));
        }
    }

    @Override
    @DWLogOperation(desc = "获取任务")
//    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "activityDefinition3$0$1$2", language = true,
//            tenant = true, ttlSecs = 86400L)
    public Object getActivityDefinition(String taskId, String activityId, String pageCode) throws Exception {

        return  dataMapService.getActivityDefinitionWithMergeRule(taskId, activityId,pageCode);
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        //处理动态任务id 使用-前的模板任务id查询任务定义
//        String activityCode = activityId;
//        if (activityId.contains("-")) {
//            activityCode = activityId.substring(0, activityId.indexOf("-"));
//            DynamicActivity da = dynamicTaskRepository.getDynamicActivityByCode(taskId, activityCode, tenantVersion);
//            if (da == null) {//检查动态任务模板是否存在 未找到动态模板数据则抛出异常
//                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.dynamicActivityNotFound", taskId,
//                        activityCode));
//            }
//        }
//
//        //同时返回app信息
//        ApplicationRelation applicationRelation = applicationService.getApplicationByTypeAndCode("activity", activityId, AthenaUtils.getCurrentLocale());
//        Application application = null;
//        if (null != applicationRelation) {
//            application = appService.getApplicationByCode(applicationRelation.getAppCode());
//        }
//        TaskAndActivity tt = taskRepository.findTaskAndActivity(tenantId, taskId, activityCode, tenantVersion);
//        if (null == tt) {
//            Object dm = getTaskInfoFromDataMap(taskId, activityId, pageCode, tenantId);
//
//            try {
//                Activity result = JSON.parseObject(JSON.toJSONString(dm), Activity.class);
//                processApplication(activityId, result);
//                try {
//                    FunctionCtrl functionCtrl = applicationService.getApplicationFunctionCtrlByAppCode(applicationRelation.getAppCode());
//                    boolean cardCustomizeFlag = this.isCardCustom(functionCtrl);
//                    ;
//                    if (cardCustomizeFlag) {
//                        processSysSummaryFields(result);
//                        //获取租户级summaryFields
//                        processTenantSummaryFields(result, pageCode);
//                    }
//                } catch (Exception e) {
//                    log.warn("parse activity error:", e);
//                }
//                if (null != application) {
//                    processMergeRule(result, taskId, activityId, application.getFunctionCtrl());
//                }
//                handleReminderRule(result);
//                return result;
//            } catch (Exception e) {
//                log.warn("parse activity error:", e);
//                return dm;
//            }
//        }
//        if (null == tt || null == tt.getActivity()) {
//            log.warn("neo4j find task by taskId:{} and tenantId:{} and activityId:{},result={}", taskId, tenantId,
//                    activityId, tt);
//            return null;
//        }
//
//        Activity activity = tt.getActivity();
//        String activityVersion = activity.getVersion();
//
//        Activity activityPageConfig = findBetterActivity(tenantId, activityCode, activityVersion);
//
//        if (null != activityPageConfig) {
//            if (null != activityPageConfig.getPages()) {
//                activityPageConfig.setPages((Map<String, Object>) activityPageConfig.getPages().get(pageCode));
//            }
//            //处理API信息
//            // 原来setMapProductInfo循环调用获取产品名称赋值改为批量处理
//            batchSetProductInfo(activityPageConfig.getDataSources(), tenantId);
//            batchSetProductInfo(activityPageConfig.getPages(), tenantId);
//            if (null != activityPageConfig.getApprove()) {
//                String approveType = activityPageConfig.getApprove().getType();
//                if (ApproveInfo.SEQ.equals(approveType)) {
//                    doApproveItemProductInfo(activityPageConfig.getApprove().getSequence(), tenantId);
//                } else if (ApproveInfo.DEC.equals(approveType)) {
////                    if(null!=activityPageConfig.getApprove().getDecision()){
////                        doApproveItemProductInfo(activityPageConfig.getApprove().getDecision().getDecisionRules(),
////                        tenantId);
////                    }
//                } else {
//                    //数据配置错误 忽略
//                }
//            }
//            //todo  toberemove1
//            if (null != activityPageConfig.getApproves()) {
//                // 第一步将activityPageConfig.getApproves()中的submits铺平
//                List<Action> actions1 = activityPageConfig.getApproves().stream()
//                        .filter(approve -> null != approve.getSubmits())
//                        .flatMap(approve -> approve.getSubmits().stream())
//                        .filter(Objects::nonNull)
//                        .collect(Collectors.toList());
//                // 第二步将activityPageConfig.getApproves()中submits中的attachActions铺平
//                List<Action> actions2 = activityPageConfig.getApproves().stream()
//                        .filter(approve -> null != approve.getSubmits())
//                        .flatMap(approve -> approve.getSubmits().stream())
//                        .filter(Objects::nonNull)
//                        .filter(action -> null != action.getAttachActions())
//                        .flatMap(action -> action.getAttachActions().stream())
//                        .filter(Objects::nonNull)
//                        .collect(Collectors.toList());
//                // 第三步将actions2合入actions1
//                actions1.addAll(actions2);
//                // 批量设置产品名称
//                try {
//                    batchSetDataActionProductInfo2(actions1, tenantId);
//                } catch (Exception e) {
//                    // 原逻辑设置产品名称失败后会吃掉异常
//                    log.error("获取productName失败", e);
//                }
//            }
//
//
//            AthenaUtils.mergeObject(activityPageConfig, activity);
//
//        }
//
//        if (null != activity.getExpectedDuration() && null != activity.getExpectedDuration().getDueDateRule()
//                && null != activity.getExpectedDuration().getDueDateRule().getGetDateAction()
//                && "ESP".equalsIgnoreCase(activity.getExpectedDuration().getDueDateRule().getGetDateAction().getType())) {
//            setDataActionProductInfo2(activity.getExpectedDuration().getDueDateRule().getGetDateAction(), tenantId);
//        }
//        if (null != applicationRelation) {
//            activity.setApplication(applicationRelation.getAppCode());
//            activity.setAppName(applicationRelation.getAppName());
//        }
//        //dto
//        activity.setActivityId(activityId);
//        activity.setActivityName(activity.getName());
//        activity.getLang().put("activityName", activity.getLang().get("name"));
//
//        processApplication(activityId, activity);
//        try {
//            if (null != applicationRelation) {
//                FunctionCtrl functionCtrl = applicationService.getApplicationFunctionCtrlByAppCode(applicationRelation.getAppCode());
//                boolean cardCustomizeFlag = this.isCardCustom(functionCtrl);
//                ;
//                if (cardCustomizeFlag) {
//                    processSysSummaryFields(activity);
//                    //获取租户级summaryFields
//                    processTenantSummaryFields(activity, pageCode);
//                }
//            }
//        } catch (Exception e) {
//            log.warn("parse activity error:", e);
//            return activity;
//        }
//        handleReminderRule(activity);
//        return activity;
    }

    /**
     * 处理催办规则
     * @param activity 活动
     */
    private void handleReminderRule(Activity activity) {
        ReminderRule reminderRule = activity.getReminderRule();
        // #17520需求，本次需求之前旧数据没有rules，需要兼容一下
        if (reminderRule != null && CollectionUtils.isEmpty(reminderRule.getRules())) {
            String currentLocale = AthenaUtils.getCurrentLocale();
            String titlePrefix = "规则";
            if ("zh_TW".equals(currentLocale)) {
                titlePrefix = "規則";
            } else if ("en_US".equals(currentLocale)) {
                titlePrefix = "rule";
            }
            Map<String, Object> rule = new HashMap<>();
            rule.put("aheadTime", reminderRule.getAheadTime());
            rule.put("notices", reminderRule.getNotices());
            rule.put("rule", reminderRule.getRule());
            rule.put("title", titlePrefix + "1");
            rule.put("identities", Collections.emptyList());
            reminderRule.setRules(Collections.singletonList(rule));
            reminderRule.setRule(null);
            reminderRule.setNotices(null);
            reminderRule.setAheadTime(null);
        }
        if (reminderRule != null && !CollectionUtils.isEmpty(reminderRule.getRules())) {
            for (Map<String, Object> ruleItem : reminderRule.getRules()) {
                Map map = MapUtils.getMap(ruleItem, "rule", Collections.emptyMap());
                String ruleType = MapUtils.getString(map, "rule");
                if ("count".equals(ruleType)) {
                    map.put("interval", null);
                } else {
                    map.put("count", null);
                }
            }
        }
    }

    private void processMergeRule(Activity activity, String taskId, String activityId, FunctionCtrl functionCtrl) throws Exception {
        boolean enableCustomize = null == functionCtrl ? false : functionCtrl.isTaskCardMergeCustomizeFlag();
        if (!enableCustomize) {
            return;
        }
        Map<String, Object> activityConfig = (Map<String, Object>) getActivityConfig(taskId, activityId);
        MergeRule mergeRule = (MergeRule) getTenantMergeConfig("task", activityId);
        if (null == mergeRule || mergeRule.getDelete()) {
            return;
        } else {
            activity.setMerge(mergeRule.getMerge());
            //将租户级mergeRule转为应用级结构
            Map<String, Object> mergeConfig = MergeRule.convertToMergeConfig(mergeRule.getMergeRules(), activityConfig);
            activity.getConfig().put("mergeConfig", mergeConfig);
        }
    }

    private boolean judgeUseMergeAbility(Map<String, Object> config, Boolean merge) {
        boolean mergeB = merge;
        Map<String, Object> mergeConfig = (Map<String, Object>) config.get("mergeConfig");
        if (!CollectionUtils.isEmpty(mergeConfig)) {
            List<Object> fieldMeta = (List<Object>) mergeConfig.get("fieldMeta");
            if (mergeB && !CollectionUtils.isEmpty(fieldMeta)) {
                return true;
            }
        }
        return false;
    }


    @Override
    public Object getActivityConfig(String taskId, String activityId) throws Exception {

        return dataMapService.getActivityConfig(taskId,activityId);

//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        //处理动态任务id 使用-前的模板任务id查询任务定义
//        String activityCode = activityId;
//        if (activityId.contains("-")) {
//            activityCode = activityId.substring(0, activityId.indexOf("-"));
//            DynamicActivity da = dynamicTaskRepository.getDynamicActivityByCode(taskId, activityCode, tenantVersion);
//            if (da == null) {//检查动态任务模板是否存在 未找到动态模板数据则抛出异常
//                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.dynamicActivityNotFound", taskId,
//                        activityCode));
//            }
//        }
//
//
//        TaskAndActivity tt = taskRepository.findTaskAndActivity(tenantId, taskId, activityCode, tenantVersion);
//        if (null == tt) {
//            Object dm = getTaskInfoFromDataMap(taskId, activityId, null, tenantId);
//            Activity result = JSON.parseObject(JSON.toJSONString(dm), Activity.class);
//            try {
//                //Activity result = JSON.parseObject(JSON.toJSONString(dm), Activity.class);
//                processApplication(activityId, result);
//                result.getConfig().put("merge", result.getMerge());
//                return result.getConfig();
//            } catch (DWBusinessException e) {
//                log.warn("parse activity error:", e);
//                Map<String, Object> config = new HashMap<>();
//                config.put("merge", result.getMerge());
//                return config;
//            }
//        }
//        //旧流程引擎数据暂不做处理
//        return null;
    }

    @Override
    public Object getTenantMergeConfig(String type, String code) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria
                .where("type").is(type)
                .and("code").is(code)
                .and("tenantId").is(tenantId)
                .and("version").is(tenantVersion);
        queryUser.addCriteria(criteria);
        MergeRule mergeRule = mongoTemplateUser.findOne(queryUser, MergeRule.class);
        return mergeRule;
    }

    @Override
    public Object postTenantMergeRule(MergeRule mergeRule) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria
                .where("type").is(mergeRule.getType())
                .and("code").is(mergeRule.getCode())
                .and("tenantId").is(tenantId)
                .and("version").is(tenantVersion);
        queryUser.addCriteria(criteria);
        Update update = new Update();
        update.set("merge", mergeRule.getMerge());
        update.set("delete", mergeRule.getDelete());
        update.set("mergeRules", mergeRule.getMergeRules());
        UpdateResult updateResult = mongoTemplateUser.upsert(queryUser, update, MergeRule.class);
        long count = updateResult.getModifiedCount();
        //TODO 刷新缓存
        if (count > 0) {
            String cacheKey = REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + ":*";
            try {
                cacheService.deleteWithPattern(cacheKey);
            } catch (Exception e) {
                log.error("delete redis fail:", e);
            }
        }
        return count;
    }

    @Override
    public Object postDeleteTenantMergeRule(String type, String code, String application) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria
                .where("type").is(type)
                .and("code").is(code)
                .and("tenantId").is(tenantId)
                .and("version").is(tenantVersion);
        queryUser.addCriteria(criteria);
        Update update = new Update();
        update.set("delete", true);
        UpdateResult updateResult = mongoTemplateUser.updateFirst(queryUser, update, MergeRule.class);
        long count = updateResult.getModifiedCount();
        //TODO 刷新缓存
        if (count > 0) {
            String cacheKey = REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + ":*";
            try {
                cacheService.deleteWithPattern(cacheKey);
            } catch (Exception e) {
                log.error("delete redis fail:", e);
            }
        }
        return count;
    }

    @Override
    @DWLogOperation(desc = "获取任务")
//    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "activityDefinition4$0$1$2$3", language = true,
//            tenant = true, ttlSecs = 86400L)
    public Object postActivityDefinition(String taskId, String activityId, String pageCode, OperationUnit operationUnit) throws Exception {

        Map<String,Object> query = new HashMap<>();
        query.put("taskId",taskId);
        query.put("activityId",activityId);
        query.put("pageCode",pageCode);
        query.put("operationUnit",operationUnit);
        return dataMapService.postActivityDefinition(query);


//        log.info("postActivityDefinition task no cache :{}",activityId);
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        //处理动态任务id 使用-前的模板任务id查询任务定义
//        String activityCode = activityId;
//        if (activityId.contains("-")) {
//            activityCode = activityId.substring(0, activityId.indexOf("-"));
//            DynamicActivity da = dynamicTaskRepository.getDynamicActivityByCode(taskId, activityCode, tenantVersion);
//            if (da == null) {//检查动态任务模板是否存在 未找到动态模板数据则抛出异常
//                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.dynamicActivityNotFound", taskId,
//                        activityCode));
//            }
//        }
//
//        TaskAndActivity tt = taskRepository.findTaskAndActivity(tenantId, taskId, activityCode, tenantVersion);
//        if (null == tt) {
//            Object dm = getTaskInfoFromDataMap(taskId, activityId, pageCode, tenantId, operationUnit);
//            if (null != dm) {
//                return dm;
//            }
//        }
//        if (null == tt || null == tt.getActivity()) {
//            log.warn("neo4j find task by taskId:{} and tenantId:{} and activityId:{},result={}", taskId, tenantId,
//                    activityId, tt);
//            return null;
//        }
//
//        Activity activity = tt.getActivity();
//        String activityVersion = activity.getVersion();
//
//        Activity activityPageConfig = findBetterActivity(tenantId, activityCode, activityVersion);
//
//        if (null != activityPageConfig) {
//            if (null != activityPageConfig.getPages()) {
//                activityPageConfig.setPages((Map<String, Object>) activityPageConfig.getPages().get(pageCode));
//            }
//            //处理API信息
//            // 原来setMapProductInfo循环调用获取产品名称赋值改为批量处理
//            batchSetProductInfo(activityPageConfig.getDataSources(), tenantId);
//            batchSetProductInfo(activityPageConfig.getPages(), tenantId);
//            if (null != activityPageConfig.getApprove()) {
//                String approveType = activityPageConfig.getApprove().getType();
//                if (ApproveInfo.SEQ.equals(approveType)) {
//                    doApproveItemProductInfo(activityPageConfig.getApprove().getSequence(), tenantId);
//                } else if (ApproveInfo.DEC.equals(approveType)) {
////                    if(null!=activityPageConfig.getApprove().getDecision()){
////                        doApproveItemProductInfo(activityPageConfig.getApprove().getDecision().getDecisionRules(),
////                        tenantId);
////                    }
//                } else {
//                    //数据配置错误 忽略
//                }
//            }
//            //todo  toberemove
//            if (null != activityPageConfig.getApproves()) {
//                // 第一步将activityPageConfig.getApproves()中的submits铺平
//                List<Action> actions1 = activityPageConfig.getApproves().stream()
//                        .filter(approve -> null != approve.getSubmits())
//                        .flatMap(approve -> approve.getSubmits().stream())
//                        .filter(Objects::nonNull)
//                        .collect(Collectors.toList());
//                // 第二步将activityPageConfig.getApproves()中submits中的attachActions铺平
//                List<Action> actions2 = activityPageConfig.getApproves().stream()
//                        .filter(approve -> null != approve.getSubmits())
//                        .flatMap(approve -> approve.getSubmits().stream())
//                        .filter(Objects::nonNull)
//                        .filter(action -> null != action.getAttachActions())
//                        .flatMap(action -> action.getAttachActions().stream())
//                        .filter(Objects::nonNull)
//                        .collect(Collectors.toList());
//                // 第三步将actions2合入actions1
//                actions1.addAll(actions2);
//                // 批量设置产品名称
//                try {
//                    batchSetDataActionProductInfo2(actions1, tenantId);
//                } catch (Exception e) {
//                    // 原逻辑设置产品名称失败后会吃掉异常
//                    log.error("获取productName失败", e);
//                }
//            }
//
//
//            AthenaUtils.mergeObject(activityPageConfig, activity);
//
//        }
//
//        if (null != activity.getExpectedDuration() && null != activity.getExpectedDuration().getDueDateRule()
//                && null != activity.getExpectedDuration().getDueDateRule().getGetDateAction()
//                && "ESP".equalsIgnoreCase(activity.getExpectedDuration().getDueDateRule().getGetDateAction().getType())) {
//            setDataActionProductInfo2(activity.getExpectedDuration().getDueDateRule().getGetDateAction(), tenantId);
//        }
//
//        //dto
//        activity.setActivityId(activityId);
//        activity.setActivityName(activity.getName());
//        activity.getLang().put("activityName", activity.getLang().get("name"));
//
//        return activity;
    }

    @Override
    //@Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "activityStartTargetCode$0$1$2", tenant = true, ttlSecs = 86400L, loadEmpty = true)
    public Object getActivityStartTargetCode(String taskId, String activityId, String pageCode) throws Exception {

        Map<String, Object> param = new HashMap<>();
        param.put("projectCode", taskId);
        param.put("taskCode", activityId);
        Object obj = dataMapService.postActivityStartTargetCode(param);
        return obj;


//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        Activity activity = new Activity();
//        //发起签核得任务也想知道它发起的是哪个签核任务
//        List<String> activityCodes = activityRepo.getActivityCodes(tenantId, taskId, tenantVersion);
//        if (null != activityCodes && activityCodes.size() > 0) {
//            Query query = Query.query(Criteria.where("code").in(activityCodes)
//                    .and("startApproveActivity").in(activityId)
//                    .and("version").is(tenantVersion));
//            query.fields().include("code");
//            Activity activityApprove = mongoTemplate.findOne(query, Activity.class, "activityConfigs");
//            if (null != activityApprove) {
//                activity.setTargetApproveActivity(activityApprove.getCode());
//            }
//        } else {
//            Map<String, Object> param = new HashMap<>();
//            param.put("projectCode", taskId);
//            param.put("taskCode", activityId);
//            Object obj = dataMapService.postActivityStartTargetCode(param);
//            if (null != obj) {
//                return obj;
//            }
//        }
//        return activity;
    }

    @Override
    public Object getTaskInfoFromDataMap(String activityId) {
        return getTaskInfoFromDataMap(null, activityId, null, null);
    }

    /**
     * 根据条件查询任务
     * @param taskId 任务code
     * @param activityId 活动code
     * @param pageCode 页面类型code
     * @param tenantId 租户id
     * @return
     */
    public Object getTaskInfoFromDataMap(String taskId, String activityId, String pageCode, String tenantId) {
        return getTaskInfoFromDataMap(taskId, activityId, pageCode, tenantId, null);
    }

    /**
     * 根据条件查询任务
     * @param taskId 任务code
     * @param activityId 活动code
     * @param pageCode 页面类型code
     * @param tenantId 租户id
     * @param operationUnit 运营单元
     * @return
     */
    private Object getTaskInfoFromDataMap(String taskId, String activityId, String pageCode, String tenantId, OperationUnit operationUnit) {

        Object dm = dataMapService.getTask(taskId, activityId, pageCode, operationUnit);
        if (null != dm) {
            try {
                //todo 因为获取projectName的方法移动不过去，暂时放这里
                Map<String, Object> json = (Map<String, Object>) dm;
                Map<String, Object> dataSources = (Map<String, Object>) json.get("dataSources");
                Map<String, Object> pages = (Map<String, Object>) json.get("pages");
                // 原来setMapProductInfo循环调用获取产品名称赋值改为批量处理
                batchSetProductInfo(dataSources, tenantId);
                batchSetProductInfo(pages, tenantId);
                Map<String, Object> expectedDuration = (Map<String, Object>) json.get("expectedDuration");
                if (null != expectedDuration) {
                    Map<String, Object> dueDateRule = (Map<String, Object>) expectedDuration.get("dueDateRule");
                    if (null != dueDateRule) {
                        Map<String, Object> getDateAction = (Map<String, Object>) dueDateRule.get("getDateAction");
                        batchSetProductInfo(getDateAction, tenantId);
                    }
                }
            } catch (Exception ee) {
            }
        }
        return dm;
    }

    private Object getPageUIElementFromDataMap(String taskId, String activityId, String pageCode, String tenantId) {
        List<Object> dm = (List) dataMapService.getPageUIElement(taskId, activityId, pageCode);
//        if (null != dm) {
//            try {
//                // 定义Map类型的dm平铺接收容器
//                List<Map<String, Object>> actionMap = new ArrayList<>();
//                // 递归List的Map嵌套类型并平铺为actionMap
//                batchListSetActionMap(dm, tenantId, actionMap);
//                // 批量设置Action产品名称
//                batchSetDataActionProductInfo(actionMap, tenantId);
//            } catch (Exception ee) {
//                log.error("getPageUIElementFromDataMap error:{}", ee.toString());
//            }
//        }
        return dm;
    }

    private Object getSystemHooksFromDataMap(List<String> activityIds, List<String> pageCodes) {
        List<Object> dm = (List) dataMapService.getSystemHooks(activityIds,pageCodes);
        return dm;
    }

    private void doApproveItemProductInfo(List<? extends ApproveItem> items, String tenantId) {
        if (null == items) {
            return;
        }
        // 第一步将items中的submits铺平
        List<Action> actions1 = items.stream()
                .filter(approve -> null != approve.getSubmits())
                .flatMap(approve -> approve.getSubmits().stream())
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
        // 第二步将items中submits中的attachActions铺平
        List<Action> actions2 = items.stream()
                .filter(approve -> null != approve.getSubmits())
                .flatMap(approve -> approve.getSubmits().stream())
                .filter(Objects::nonNull)
                .filter(action -> null != action.getAttachActions())
                .flatMap(action -> action.getAttachActions().stream())
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
        // 第三步将actions2合入actions1
        actions1.addAll(actions2);
        // 批量设置产品名称
        try {
            batchSetDataActionProductInfo2(actions1, tenantId);
        } catch (Exception e) {
            // 原逻辑设置产品名称失败后会吃掉异常
            log.error("获取productName失败", e);
        }
    }

    @Override
    public Object getActivityDefinitionWithMultiLanguage(String taskId, String activityId, String tenantId) throws Exception {
        return null;
    }

   // @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getManualList", tenant = true,language = true, ttlSecs = 7200)
    @Override
    public Object getManualList() throws DWBusinessException {
        System.out.println(Thread.currentThread().getName()+" kg getManualList...");
        return  dataMapService.getManualListMobile();
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<String> appCodes = cacUtils.getAppAuth();
//        List<Map<String,Object>> result = new ArrayList<>();
//        Map<String,Object> query1 = new HashMap<>();
//        query1.put("code",appCodes);
//        query1.put("commonApp",true);
//        List<Application> commonApps = dataPickService.findSystem(query1,Application.class);
//        List<String> commonAppCodes = commonApps.stream().map(Application::getCode).collect(Collectors.toList());
//        List<String> commonTaskCodes = iamService.appItems(commonAppCodes);
//
//        List<Task> datas = taskRepository.findByManualAble(tenantId, true, tenantVersion);
//        try {
//            //优化查询逻辑，先查出应用下含有哪些项目，然后再从中查询手动发起的项目
//            List<ApplicationRelation> task = applicationService.getApplicationRelationByTypeAndAppCode("task", appCodes);
//            List<String> taskCodes = task.stream().map(e -> e.getCode()).distinct().collect(Collectors.toList());
//
//            Map<String, Object> query = new HashMap<>();
//            query.put("manualAble", true);
//            query.put("code", taskCodes);
//            List projectInDataMap = dataMapService.getProjects(query);
//
//            this.filterProject(projectInDataMap, appCodes, tenantId);
//
//
//            if (!CollectionUtils.isEmpty(datas)) {
//                List<JSONObject> jsonData = JSON.parseArray(JSON.toJSONString(datas), JSONObject.class);
//                result.addAll(jsonData);
//            }
//
//            if (!CollectionUtils.isEmpty(projectInDataMap)) {
//                result.addAll(projectInDataMap);
//            }
//            //add by srj 20220824 根据维护的项目应用的关系及用户的实际有效的应用过滤数据
//            if (!CollectionUtils.isEmpty(result)) {
//                List<String> collect = result.stream().map(e -> getTaskCode(e)).distinct().collect(Collectors.toList());
//                List<ApplicationRelation> applicationRelationList = applicationService.getApplicationByTypeAndCode("task", collect);
//
//                if (!CollectionUtils.isEmpty(applicationRelationList)) {
//                    Map<String, String> collect1 = applicationRelationList.stream().collect(Collectors.toMap(ApplicationRelation::getCode, ApplicationRelation::getAppCode, (a, b) -> a));
//                    Iterator<Map<String,Object>> iterator = result.iterator();
//                    while (iterator.hasNext()) {
//                        Map<String,Object> next = iterator.next();
//                        String taskCode = (String) next.get("code");
//                        String appCode = collect1.get(taskCode);
//                        if (collect1.containsKey(taskCode) && !appCodes.contains(appCode)) {
//                            iterator.remove();
//                            continue;
//                        }
//                        //判断是否搭售
//                        if(commonAppCodes.contains(appCode)){
//                            if(commonTaskCodes.contains(taskCode)){
//                                next.put("commonApp",true);
//                            }else {
//                                iterator.remove();
//                            }
//                        }
//
//                    }
//                }
//
//            }
//
//        } catch (Exception e) {
//            log.error(e.toString());
//        }
//
//
//        return result;
    }

    /**
     * 从datamap获取手动发起项目的接口改为dataMapService.getProjectsBasic;只需要基本信息
     * @return
     * @throws DWBusinessException
     */
    public Object getManualListBasic() throws DWBusinessException {
        return dataMapService.getManualList();
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<String> appCodes = cacUtils.getAppAuth();
//        List<Map<String,Object>> result = new ArrayList<>();
//        Map<String,Object> query1 = new HashMap<>();
//        query1.put("code",appCodes);
//        query1.put("commonApp",true);
//        List<Application> commonApps = dataPickService.findSystem(query1,Application.class);
//        List<String> commonAppCodes = commonApps.stream().map(Application::getCode).collect(Collectors.toList());
//        List<String> commonTaskCodes = iamService.appItems(commonAppCodes);
//
//        List<Task> datas = taskRepository.findByManualAble(tenantId, true, tenantVersion);
//        try {
//            //优化查询逻辑，先查出应用下含有哪些项目，然后再从中查询手动发起的项目
//            List<ApplicationRelation> task = applicationService.getApplicationRelationByTypeAndAppCode("task", appCodes);
//            List<String> taskCodes = task.stream().map(e -> e.getCode()).distinct().collect(Collectors.toList());
//
//            Map<String, Object> query = new HashMap<>();
//            query.put("manualAble", true);
//            query.put("code", taskCodes);
//            List projectInDataMap = dataMapService.getProjectsBasic(query);
//
//            this.filterProject(projectInDataMap, appCodes, tenantId);
//
//
//            if (!CollectionUtils.isEmpty(datas)) {
//                List<JSONObject> jsonData = JSON.parseArray(JSON.toJSONString(datas), JSONObject.class);
//                result.addAll(jsonData);
//            }
//
//            if (!CollectionUtils.isEmpty(projectInDataMap)) {
//                result.addAll(projectInDataMap);
//            }
//            //add by srj 20220824 根据维护的项目应用的关系及用户的实际有效的应用过滤数据
//            if (!CollectionUtils.isEmpty(result)) {
//                List<String> collect = result.stream().map(e -> getTaskCode(e)).distinct().collect(Collectors.toList());
//                List<ApplicationRelation> applicationRelationList = applicationService.getApplicationByTypeAndCode("task", collect);
//
//                if (!CollectionUtils.isEmpty(applicationRelationList)) {
//                    Map<String, String> collect1 = applicationRelationList.stream().collect(Collectors.toMap(ApplicationRelation::getCode, ApplicationRelation::getAppCode, (a, b) -> a));
//                    Iterator<Map<String,Object>> iterator = result.iterator();
//                    while (iterator.hasNext()) {
//                        Map<String,Object> next = iterator.next();
//                        String taskCode = (String) next.get("code");
//                        String appCode = collect1.get(taskCode);
//                        if (collect1.containsKey(taskCode) && !appCodes.contains(appCode)) {
//                            iterator.remove();
//                            continue;
//                        }
//                        //判断是否搭售
//                        if(commonAppCodes.contains(appCode)){
//                            if(commonTaskCodes.contains(taskCode)){
//                                next.put("commonApp",true);
//                            }else {
//                                iterator.remove();
//                            }
//                        }
//
//                    }
//                }
//
//            }
//
//        } catch (Exception e) {
//            log.error(e.toString());
//        }
//        return result;
    }

    /**
     * 从任务对象中获取任务code
     * @param object 任务
     * @return 任务code
     */
    private String getTaskCode(Object object) {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(object));
        String code = jsonObject.getString("code");
        return code;
    }

    /**
     * 过滤出有授权的应用数据
     * @param projectInDataMap 项目数据，包含pageView视图数据，项目任务目标，里程碑
     * @param appCodes 应用code集合
     * @param tenantId 租户
     * @throws DWBusinessException
     */
    private void filterProject(List projectInDataMap, List<String> appCodes, String tenantId) throws DWBusinessException {
        if (null != projectInDataMap) {
            try {
                if (appCodes == null) {
                    appCodes = cacUtils.getAppAuth();
                }
                Map<String, List<ComponentBaseInfoBO>> componentListByAppCode = new HashMap<>();
                List<String> taskCodeList = new ArrayList<>();
                projectInDataMap.forEach(e -> {
                    String taskCode = getTaskCode(e);
                    taskCodeList.add(taskCode);
                });
                List<ApplicationRelation> applicationRelationList = applicationService.getApplicationByTypeAndCode("task", taskCodeList);
                Map<String, String> collect1 = applicationRelationList.stream().collect(Collectors.toMap(ApplicationRelation::getCode, ApplicationRelation::getAppCode, (a, b) -> a));

                List<String> remainProjectCodes = new ArrayList<>();
                List<String> checkedProjectCodes = new ArrayList<>();
                for (Object projectObj : projectInDataMap) {
                    JSONObject project = (JSONObject) projectObj;
                    String projectCode = project.getString("code");
                    String appCode = collect1.get(projectCode);
                    if (!componentListByAppCode.containsKey(appCode)) {
                        componentListByAppCode.put(appCode, new ArrayList<ComponentBaseInfoBO>());
                    }
                    ComponentBaseInfoBO componentInfo = new ComponentBaseInfoBO();
                    componentInfo.setCode(projectCode);
                    componentInfo.setType(ComponentTypeEnum.Project);
                    componentListByAppCode.get(appCode).add(componentInfo);
                }
                componentListByAppCode.forEach((appCode, componentList) -> {
                    try {
                        List<ComponentBaseInfoBO> filteredBaseInfos = componentManager.FilterByTenantApplicationComponentList(appCode, tenantId, componentList);
                        componentList.forEach((component) -> {
                            checkedProjectCodes.add(component.getCode());
                        });
                        filteredBaseInfos.forEach((component) -> {
                            remainProjectCodes.add(component.getCode());
                        });
                    } catch (Exception e) {
                        log.error("process app componentList exception:", e);
                        log.error("process app componentList error:appCode[{}],componentList[{}]", appCode, componentList);
                    }
                });
                Iterator<Object> iterator = projectInDataMap.iterator();
                while (iterator.hasNext()) {
                    Object projectObj = iterator.next();
                    JSONObject project = (JSONObject) projectObj;
                    String projectCode = project.getString("code");
                    if (checkedProjectCodes.contains(projectCode) && !remainProjectCodes.contains(projectCode)) {
                        iterator.remove();
                    } else {
                        //add by srj 20220824 根据维护的项目应用的关系及用户的实际有效的应用过滤数据
                        if (collect1.containsKey(projectCode) && !appCodes.contains(collect1.get(projectCode))) {
                            iterator.remove();
                        }
                    }
                }
            } catch (Exception ex) {
            }
        }
    }

    @Override
    public Object getDetail(String taskId) throws DWBusinessException {
        return dataMapService.getDetail(taskId);
//        Session session = sessionFactory.openSession();
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        TaskAndTarget tat = taskRepository.findTaskDetail(tenantId, taskId, tenantVersion);
//        try {
//            if (null == tat) {
//                Object pro = dataMapService.getProject(taskId);
//                if (null != pro) {
//                    return pro;
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.toString());
//        }
//        if (tat == null) {
//            throw new DWBusinessException("P.KG.500.0008", I18nUtils.getValue("knowledgegraph.taskNotFound", taskId, tenantId));
//        }
//        Task task = tat.getTask();
//        task.setChargePerson(tat.getPersonInCharge());
//        task.setTarget(tat.getTarget());
//        task.setActivities(tat.getActivities());
//        task.setPresetActivities(tat.getPresetActivities());
//
//        if (null != task && null != task.getPresetActivities()) {
//            task.getPresetActivities().forEach(a -> {
//
//                Activity pageActivity = null;
//                try {
//                    pageActivity = findBetterActivity(tenantId, a.getCode(), a.getVersion());
//                } catch (DWBusinessException e) {
//                    throw new RuntimeException(e);
//                }
//                if (null != pageActivity) {
//                    AthenaUtils.mergeObject(pageActivity, a);
//                }
//                if (null != a.getFields()) {
//                    Collections.sort(a.getFields());
//                }
//            });
//        }
//        if (null != task.getActivities()) {
//            Collections.sort(task.getActivities());
//        }
//
//        return task;

    }


    @Override
    public Object getInputData(String taskId) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        Optional<TaskInputData> inputData = taskRepository.getTaskInputData(tenantId, taskId, tenantVersion);//tenantId,
//        if (inputData.isPresent()) {
//            TaskInputData data = inputData.get();
//            data.getInputData().setField(new ArrayList<>(data.getFields()));
//            Map<String, Object> result = new HashMap();
//            result.put("taskId", taskId);
//            result.put("inputData", DataEntityMetadataDTO.ConvertFromDataEntity(data.getInputData()));
//            return result;
//        } else {
            Object obj2 = dataMapService.projectInputData(taskId);
            return obj2;
        }



    @Override
    public Object getSolvePlan(String taskId, String activityId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<SolvePlan> plans = solvePlanRepository.getByActivity(tenantId, taskId, activityId, tenantVersion);
        return plans;
    }

    @Override
    public Object getSolvePlan(String activityId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<SolvePlan> plans = solvePlanRepository.getByActivity(tenantId, activityId, tenantVersion);
        return plans;
    }


    @Override
    public Object getSolvePlanByData(String dataName) throws DWBusinessException {

        String tenantId = AthenaUtils.getTenantId();
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<SolvePlanData> plans = solvePlanRepository.getByData(dataName, locale.toString(), tenantVersion);
        try {
            plans.sort(Comparator.comparing(e -> e.getSolvePlan().getPlanId()));
        } catch (Exception e) {
            log.error("SolvePlanList sort error:{}", e.getMessage());
        }
        List<Map<String, Object>> res = new ArrayList<>(plans.size());
        for (SolvePlanData p : plans) {
            Language lang = p.getLanguage();
            Map<String, Object> map = new HashMap<>();
            map.put("planId", p.getSolvePlan().getPlanId());
            if (lang == null || lang.getName() == null) {
                map.put("name", p.getSolvePlan().getName());
            } else {
                map.put("name", lang.getName());
            }
            map.put("enableApprove", this.enableApprove(p.getActivitySet()));

            if (null != p.getSolvePlan().getLang()) {
                map.put("lang", p.getSolvePlan().getLang());
            }

            res.add(map);
        }
        return res;

    }


    //enableApprove
    //而这个是否需要签核的信息通过以下逻辑得到：通过solvePlan看与activity之间是否有关系，
    // 如果没有，就是不用签核，如果找到activity，就看下是否是自定义签核，不是的话也是需要签核，
    // 是的话看下自定义签核里的是否签核属性
    private boolean enableApprove(ActivitySet activitySet) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        if (activitySet == null) {
            return false;
        }
        String activities = activitySet.getActivities();
        if (StringUtils.isEmpty(activities)) {
            return false;
        }
        JSONArray ja = JSON.parseArray(activities);
        List<String> activityIdList = new ArrayList<>();
        for (int i = 0; i < ja.size(); i++) {
            activityIdList.add(ja.getJSONObject(i).getString("activityId"));
        }
        List<ActivityBaseInfoVO> activityList = this.activityDAO.getApproveActivityListByActivityIds(activityIdList, tenantId, tenantVersion);
        if (CollectionUtils.isEmpty(activityList)) { //查看任务引擎的任务
            Map<String, Object> query = new HashMap<>();
            query.put("category", "APPROVAL");
            query.put("code", activityIdList);
            List taskList = this.dataMapService.getTaskList(query);
            if (CollectionUtils.isEmpty(taskList)) {
                return false;
            } else {
                Object o = taskList.get(0);
                Activity activity = JSON.parseObject(JSON.toJSONString(o), Activity.class);
                Object task = this.dataMapService.getTask("", activity.getCode(), null);
                if (task != null) {
                    Map<String, Object> json = (Map<String, Object>) task;
                    Object approveObj = json.get("approve");
                    if (approveObj == null) {
                        return true;
                    } else {
                        Map<String, Object> approve = (Map<String, Object>) approveObj;
                        if (approve == null || "Y".equals(String.valueOf(approve.get("enableApprove")))) {
                            return true;
                        }
                    }
                }
//                if (activity.getApprove() == null || StringUtils.equals("Y", activity.getApprove().getEnableApprove())) {
////                    return true;
////                }
            }
            return false;
        } else {  //流程引擎的任务
            //约定只能关联出一个approve类型的签核
            ActivityBaseInfoVO activityBaseInfoVO = activityList.get(0);
            Activity betterActivity = this.findBetterActivity(AthenaUtils.getTenantId(), activityBaseInfoVO.getActivityId(), activityBaseInfoVO.getActivityVersion());
            if (betterActivity == null) {
                return false;
            }
            if (betterActivity.getApprove() == null || StringUtils.equals("Y", betterActivity.getApprove().getEnableApprove())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getActivitiesWithMultiLanguage(String taskId, String compositionId) throws Exception {
        //compositionId为空
        if (compositionId == null || compositionId.isEmpty()) {
            return this.getActivitiesWithMultiLanguage(taskId);
        }

        Object re = null;
        try {
            //根据compositionId获取动态任务列表
            ActivityComposition composition = activityCompositionRepository.findOneByCompositionId(compositionId);
            if (composition != null && composition.getCompositionCodes() != null && !composition.getCompositionCodes().isEmpty()) {
                //查询到组合数据
                String tenantId = AthenaUtils.getTenantId();
                String tenantVersion = kgInnerService.getTenantVersion(tenantId);
                DynamicTaskAndActivities tt = dynamicTaskRepository.findTaskAndActivities(tenantId, taskId, composition.getCompositionCodes(), tenantVersion);
                Assert.notNull(tt, "can not find task by code:" + taskId + " and tenantId:" + tenantId);
                if (log.isInfoEnabled()) {
                    log.info("neo4j find task by code:{} and tenantId:{},result={}", taskId, tenantId, tt);
                }
                Task task = tt.getTask();
                task.setActivities(tt.getActivities());

                //dto兼容
                task.setTaskId(task.getCode());
                task.setTaskName(task.getName());

                if (null != task.getLang().get("name")) {
                    task.setTaskName(task.getLang().get("name"));
                    task.getLang().remove("name");
                }
                if (null != task.getActivities()) {
                    Collections.sort(task.getActivities());
                    task.getActivities().forEach(a -> {
                        a.setActivityId(a.getCode());
                        if (null != a.getLang().get("name")) {
                            a.setActivityName(a.getLang().get("name"));
                        }
                    });
                }

                TaskActivitiesDTO activitiesDTO = new TaskActivitiesDTO();

                activitiesDTO.setTaskId(task.getCode());
                activitiesDTO.setTaskName(task.getTaskName());
                activitiesDTO.setEmergency(task.getEmergency());

                Map<String, ActivityInfoDTO> dynamicActivities = new HashMap<>();
                for (Activity activity : task.getActivities()) {
                    ActivityInfoDTO activityInfoDTO = new ActivityInfoDTO();
                    activityInfoDTO.setActivityId(activity.getActivityId());
                    activityInfoDTO.setActivityName(activity.getActivityName());
                    activityInfoDTO.setExecuteType(ActivityExecuteTypeEnum.valueOf(activity.getExecuteType()));
                    activityInfoDTO.setSequence(activity.getSequence());
                    activityInfoDTO.setEmergency(activity.getEmergency());
                    activityInfoDTO.setMilestone(activity.getMilestone());
                    activityInfoDTO.setShowFlow(activity.getShowFlow());
                    activityInfoDTO.setCategory(activity.getCategory());
                    activityInfoDTO.setPattern(activity.getPattern());
                    activityInfoDTO.setMerge(activity.getMerge());

                    dynamicActivities.put(activity.getActivityId(), activityInfoDTO);
                }
                //根据dynamicActivityCode获取界面定义
                List<ActivityInfoDTO> activities = new ArrayList<>();
                for (ActivityCompositionItem item : composition.getActivities()) {
                    String dynCode = item.getDynamicActivityCode();
                    ActivityInfoDTO define = dynamicActivities.get(dynCode);
                    ActivityInfoDTO activity = (ActivityInfoDTO) define.clone();
                    activity.setActivityId(item.getActivityId());
                    activity.setSequence(item.getSequence());
                    activity.setActivityName(item.getName());
                    ExpectedDurationDTO expDurDate = new ExpectedDurationDTO();
                    expDurDate.setDueDateType(2);//动态任务的预完成日为常量型
                    expDurDate.setConstantValue(item.getDueDate());
                    activity.setExpectedDuration(expDurDate);
                    activities.add(activity);
                }

                activitiesDTO.setActivities(activities);
                re = activitiesDTO;
            }
        } catch (Exception ex) {
        }
        if (re == null) {//如果通过 compositionId查不到动态流程 再尝试查静态定义的流程
            re = this.getActivitiesWithMultiLanguage(taskId);//todo lingxiang 尝试屏蔽数据异常导致的问题 下个迭代移除该逻辑
        }
        return re;
    }

    @Override
    public Object getAllTasks() throws DWBusinessException {

        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        //List<Task> tasks = taskRepository.allTask(tenantId, tenantVersion);

        List<String> codes = dataPickService.tenantApplicationRelationCodes("task");
        List<Task> tasks = taskRepository.allTask(tenantId, tenantVersion,codes);
        return tasks;
    }

    @Override
    public Object getAppSubscription(String taskId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();

        //   AppSubscription appSubscription = mongoTemplateUser.findOne(Query.query(Criteria.where("tenantId").is(tenantId).and("taskId").is(taskId)),AppSubscription.class);

        List<ApplicationRelation> relations = applicationService.getAppCodeByTaskCode(taskId);
        AppSubscription appSubscription = new AppSubscription();
        if (relations.size() > 0) {
            ApplicationRelation first = relations.get(0);
            appSubscription.setAppId(first.getAppCode());
            appSubscription.setName(first.getAppName());
            appSubscription.setTenantId(tenantId);
            appSubscription.setTaskId(taskId);
        }


        return appSubscription;
    }

    /*private void setMapProductInfo(Map<String, Object> data, String tenantId) throws Exception {
        if (data != null && !data.isEmpty()) {
            setDataActionProductInfo(data, tenantId);
            for (Map.Entry<String, Object> item : data.entrySet()) {
                Object value = item.getValue();
                if (value instanceof Map) {
                    setMapProductInfo((Map) value, tenantId);
                } else if (value instanceof List) {
                    setListProductInfo((List) value, tenantId);
                }
            }
        }
    }

    private void setListProductInfo(List data, String tenantId) throws Exception {
        if (data != null && !data.isEmpty()) {
            for (Object item : data) {
                if (item instanceof Map) {
                    setMapProductInfo((Map) item, tenantId);
                } else if (item instanceof List) {
                    setListProductInfo((List) item, tenantId);
                }
            }
        }
    }

    private void setDataActionProductInfo(Map action, String tenantId) throws Exception {
        if (action == null || action.isEmpty() || (!ObjectUtils.isEmpty(action.get("productName")))) {
            return;
        }

        String url = String.valueOf(action.get("url"));
        String type = String.valueOf(action.get("type"));
        String serviceName = String.valueOf(action.get("serviceName"));

        if (null == serviceName || !"ESP".equalsIgnoreCase(type)) {
            return;
        }

//        if ((url == null || url.isEmpty()) &&
//                (serviceName == null || serviceName.isEmpty())) {
//            return;
//        }

//        if (url != null && url.contains("CROSS")) {
//            ProductTenantConfigDO productTenantConfigDO = new ProductTenantConfigManager().readTenantConfig(tenantId, ProductTypeEnum.PRODUCTION);
//            action.put("productUid", productTenantConfigDO.getProductUid());
//            action.put("productName", productTenantConfigDO.getProductName());
//        } else {
//            //敏态api从MDC获取租户的ProductName
//            action.put("productName", new ProductNameResolver().getCloudProductName(serviceName, tenantId));
//        }
        action.put("productName", this.productNameResolver.getProductName(serviceName, tenantId));
    }*/

    /**
     * 批量设置Map结构的Action产品名称
     * @param data      map结构的action
     * @param tenantId  租户ID
     * @throws Exception
     */
    private void batchSetProductInfo(Map<String, Object> data, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        // 定义Map类型的data平铺接收容器
        List<Map<String, Object>> actionMap = new ArrayList<>();
        // 递归Map嵌套类型并平铺为actionMap
        batchMapSetActionMap(data, tenantId, actionMap);
        // 批量设置Action产品名称
        batchSetDataActionProductInfo(actionMap, tenantId);
    }

    /**
     * 递归Map嵌套类型并平铺为actionMap
     * @param data      Map数据源
     * @param tenantId  租户ID
     * @param actionMap 目标action集合
     * @throws Exception
     */
    private void batchMapSetActionMap(Map<String, Object> data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        // map结构的数据加入actionMap
        actionMap.add(data);
        for (Map.Entry<String, Object> item : data.entrySet()) {
            Object value = item.getValue();
            if (value instanceof Map) {
                batchMapSetActionMap((Map) value, tenantId, actionMap);
            } else if (value instanceof List) {
                batchListSetActionMap((List) value, tenantId, actionMap);
            }
        }
    }

    /**
     * 递归List的Map嵌套类型并平铺为actionMap
     * @param data      List数据源
     * @param tenantId  租户ID
     * @param actionMap 目标action集合
     * @throws Exception
     */
    private void batchListSetActionMap(List data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        for (Object item : data) {
            if (item instanceof Map) {
                batchMapSetActionMap((Map) item, tenantId, actionMap);
            } else if (item instanceof List) {
                batchListSetActionMap((List) item, tenantId, actionMap);
            }
        }
    }

    /**
     * 批量设置Action产品名称
     * @param actions   actions
     * @param tenantId  租户ID
     * @throws Exception
     */
    private void batchSetDataActionProductInfo(List<Map<String, Object>> actions, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        // 过滤出产品名称为空且是ESP类型的并且serviceName不为空
        actions = actions.stream()
                .filter(action -> (ObjectUtils.isEmpty(action.get("productName")))
                        && "ESP".equalsIgnoreCase(String.valueOf(action.get("type")))
                        && StringUtils.isNotEmpty(String.valueOf(action.get("serviceName")))
                ).collect(Collectors.toList());
        // 再次判空处理
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        // 获取serviceName集合
        List<String> serviceNames = actions.stream().map(action -> String.valueOf(action.get("serviceName"))).distinct().collect(Collectors.toList());
        Map<String, String> serviceNameMap = productNameResolver.getProductNameMap(tenantId, serviceNames);
        // 设置产品名称
        for (Map<String, Object> action : actions) {
            action.put("productName", serviceNameMap.get(String.valueOf(action.get("serviceName"))));
        }
    }


    private void setDataActionProductInfo2(Action action, String tenantId) throws Exception {
        if (action == null || (!ObjectUtils.isEmpty(action.getProductName())) || !"ESP".equalsIgnoreCase(action.getType())) {
            return;
        }

        String url = action.getUrl();
        String serviceName = action.getServiceName();

        if ((url == null || url.isEmpty()) && (serviceName == null || serviceName.isEmpty())) {
            return;
        }
        action.setProductName(this.productNameResolver.getProductName(serviceName, tenantId));
    }

    /**
     * 批量设置Action产品名称
     * @param actions   actions
     * @param tenantId  租户ID
     * @throws Exception
     */
    private void batchSetDataActionProductInfo2(List<Action> actions, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        // 过滤出产品名称为空且是ESP类型的并且（serviceName不为空 ）->原逻辑有改动，入参serviceName集合批量查询产品名称时不能有空值
        actions = actions.stream()
                .filter(action -> ObjectUtils.isEmpty(action.getProductName())
                        && "ESP".equalsIgnoreCase(action.getType())
                        && StringUtils.isNotEmpty(action.getServiceName())
                ).collect(Collectors.toList());
        // 再次判空处理
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        // 获取serviceName集合
        List<String> serviceNames = actions.stream().map(Action::getServiceName).distinct().collect(Collectors.toList());
        Map<String, String> serviceNameMap = productNameResolver.getProductNameMap(tenantId, serviceNames);
        // 设置产品名称
        for (Action action : actions) {
            action.setProductName(serviceNameMap.get(action.getServiceName()));
        }
    }

    public Activity findBetterActivity(String tenantId, String activityCode, String activityVersion) throws DWBusinessException {

        Map<String, Object> keyConditions = new HashMap<>();
        keyConditions.put("code", activityCode);

        Query query2 = Query.query(Criteria.where("code").is(activityCode).and("version").is(activityVersion).and("tenantId").is(tenantId));
        Activity defaultActivity = mongoEntityBaseDAO.findOne(keyConditions, activityVersion, Activity.class, "activityConfigs");
        Activity tenantActivity = mongoTemplateUser.findOne(query2, Activity.class, "activityConfigs");
        if (null != tenantActivity) {
            AthenaUtils.mergeObject(tenantActivity, defaultActivity, MergePolicyBuilder.getPolicy(Activity.class.getName()));
        }

//        List<Activity> activityPageConfigs = ;
//        if(null!=activityPageConfigs){
//            for(Activity a: activityPageConfigs){
//                if(a.getTenantId()==null){defaultActivity =a;}
//                if(tenantId.equals(a.getTenantId())){
//                    return a;
//                }
//
//            }
//        }

        return defaultActivity;
    }

    private Task findTaskConfig(String tenantId, String taskCode, String taskVersion) {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query(Criteria.where("code").is(taskCode).and("version").is(taskVersion));
        Task defTask = mongoTemplate.findOne(query, Task.class, "taskConfigs");
        Query query1 = Query.query(Criteria.where("code").is(taskCode).and("version").is(taskVersion)
                .and("tenantId").is(tenantId));
        Task tenantTask = mongoTemplateUser.findOne(query1, Task.class, "taskConfigs");

        if (defTask != null) {
            if (tenantTask != null) {
                AthenaUtils.mergeObject(tenantTask, defTask);
            }
            return defTask;
        } else {
            return tenantTask;
        }
    }

    @Deprecated
    @Override
    public Object postUpdateTaskConfig(Task data) throws DWBusinessException {
        String col = "taskConfigs";
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        String id = data.getId();
//        if (id == null) {
//            data.setTenantId(tenantId);
//            mongoTemplateUser.save(data, col);
//            return "success";
//        }
        Task task = this.taskRepository.findTask(tenantId, data.getCode(), tenantVersion);
        if (task == null) { //任务引擎
            dataMapService.updateProject(data);
        } else {
            Query query = Query.query(Criteria.where("code").is(data.getCode()).and("version").is(data.getVersion()).and("tenantId").is(tenantId));
            Task indb2 = mongoTemplateUser.findOne(query, Task.class, col);
            if (null != indb2) {
                data.setId(null); //id不替换，用原来indb2里的id去更新数据
                AthenaUtils.mergeObject(data, indb2);
                mongoTemplateUser.save(indb2, col);
            } else {
                data.setTenantId(tenantId);
                data.setId(null); //找不到时重新设置id
                mongoTemplateUser.save(data, col);
            }
        }
//        Task indb = mongoTemplateUser.findById(data.getId(), Task.class, col);
//        if (indb == null) {
//            //todo 因为系统级和租户级不是同一条记录,需要判断用户点击提交修改后没有刷新页面再次修改的情况,这时候id仍然是系统级的但是已经产生了一条租户级记录了.暂时不做
//            Query query = Query.query(Criteria.where("code").is(data.getCode()).and("version").is(data.getVersion()).and("tenantId").is(tenantId));
//            Task indb2 = mongoTemplateUser.findOne(query, Task.class, col);
//            if (null != indb2) {
//                AthenaUtils.mergeObject(data, indb2);
//                mongoTemplateUser.save(indb2, col);
//            } else {
//                data.setTenantId(tenantId);
//                data.setId(null); //找不到时重新设置id
//                mongoTemplateUser.save(data, col);
//                //因为数据可能是从neo4j中来不好查,所有可以都往datamap走,datamap有对应的记录会不做处理
//                dataMapService.updateProject(data);
//            }
//        } else {
//            AthenaUtils.mergeObject(data, indb);
//            mongoTemplateUser.save(indb, col);
//        }

        return "success";
    }

    @Override
    public Object postUpdateTaskConfig(Task data, OperationUnit operationUnit) throws DWBusinessException {
        String col = "taskConfigs";
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);

        Task task = this.taskRepository.findTask(tenantId, data.getCode(), tenantVersion);
        if (task == null) { //任务引擎
            dataMapService.updateProject(data, operationUnit);
        } else {
            Query query = Query.query(Criteria.where("code").is(data.getCode()).and("version").is(data.getVersion()).and("tenantId").is(tenantId));
            Task indb2 = mongoTemplateUser.findOne(query, Task.class, col);
            if (null != indb2) {
                data.setId(null); //id不替换，用原来indb2里的id去更新数据
                AthenaUtils.mergeObject(data, indb2);
                mongoTemplateUser.save(indb2, col);
            } else {
                data.setTenantId(tenantId);
                data.setId(null); //找不到时重新设置id
                mongoTemplateUser.save(data, col);
            }
        }


        return "success";
    }

    @Override
    public Object postQueryRelatedTask(String tenantId, String activityId) throws Exception {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.tenantIdEmpty"));
        }
        if (activityId == null || activityId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.activityIdEmpty"));
        }
        Map<String, Object> keyConditions = new HashMap<>();
        keyConditions.put("code", activityId);
        ActivityConfig config = dataPickService.findByCode(activityId, ActivityConfig.class, "activityConfigs");
        if (config.getRelatedTasks() != null && config.getRelatedTasks().size() > 0) {//有定义关联项目 并且有数据
            //目前一个任务只可能定义一个应用 取第一笔app记录
            Map<String, Object> app = config.getRelatedTasks().get(0);
            String appId = (String) app.get("appId");
            if (StringUtils.isNotEmpty(appId)) {
                if (cacUtils.getAppAuth(tenantId, appId)) {
                    return app.get("taskCode");
                }
            }
        }

        return null;
    }


    @Override
    public Object getTaskByApp(String applicationCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<Object> result = new ArrayList<>();
        List<String> taskIdList = applicationService.getTaskCode(applicationCode);
        //根据租户的组件清单过滤项目
        taskIdList = this.filterProjectByComponent(applicationCode, tenantId, taskIdList);

        for (String taskId : taskIdList) {
            TaskDTO taskDTO = new TaskDTO();
            Object definitionWithMultiLanguage = this.getDefinitionWithMultiLanguage(taskId);
            if (null == definitionWithMultiLanguage || definitionWithMultiLanguage instanceof String) {
                continue;
            }
            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(definitionWithMultiLanguage));
            if (jsonObject != null && jsonObject.getBooleanValue("hideDeliverySetting")) {
                //当设置需要隐藏显示的时候，不放入结果集中
                continue;
            }

            //任务引擎往config中加
            if (jsonObject != null && jsonObject.getJSONObject("config") != null && jsonObject.getJSONObject("config").getBooleanValue("hideDeliverySetting")) {
                continue;
            }

            taskDTO.setTask(definitionWithMultiLanguage);
//            if(definitionWithMultiLanguage  instanceof Task){
//                taskDTO.setTask((Task)this.getDefinitionWithMultiLanguage(taskId));
//            }else{
//                continue;
//            }
            List<Action> taskDataGroupAction = dataPickService.excludeWithSameCode(actionRepository.getTaskDataGroupAction(taskId));
            if (!CollectionUtils.isEmpty(taskDataGroupAction)) {
                taskDTO.setHasDataGroupAction(true);
            }
            Query query = new Query();
            Criteria criteria = Criteria.where("taskCode").is(taskId).and("version").is(tenantVersion);
            query.addCriteria(criteria);
            List<TaskMonitorRule> taskMechanism = this.mongoTemplate.find(query, TaskMonitorRule.class, "taskMonitorRule");
            if (!CollectionUtils.isEmpty(taskMechanism)) {
                List<String> collect = taskMechanism.stream().map(TaskMonitorRule::getMonitorRuleCode).collect(Collectors.toList());
                taskDTO.setRelatedMonitorRules(collect);
            }

            result.add(taskDTO);
        }
        return result;
    }

    @Override
    public Object postTaskByApp(String applicationCode, OperationUnit operationUnit) throws Exception {
        Map<String,Object> query = new HashMap<>();
        query.put("applicationCode",applicationCode);
        query.put("operationUnit",operationUnit);
        return dataMapService.postTaskByApp(query);

//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<Object> result = new CopyOnWriteArrayList<>();
//        List<String> taskIdList = applicationService.getTaskCode(applicationCode);
//        //根据租户的组件清单过滤项目
//        taskIdList = this.filterProjectByComponent(applicationCode, tenantId, taskIdList);
//
//        DWServiceContext context = DWServiceContext.getContext();
//        if (CollectionUtils.isEmpty(taskIdList)) {
//            return result;
//        }
//        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
//        CompletableFuture
//                .allOf(
//                        taskIdList.stream().map(taskId ->
//                                        CompletableFuture.completedFuture(taskId).runAsync(() -> {
//                                            DWServiceContext.setContext(context);
//                                            RequestContextHolder.setRequestAttributes(requestAttributes);
//                                            try {
//                                                TaskDTO taskDTO = new TaskDTO();
//                                                Object definitionWithMultiLanguage = this.postDefinitionWithMultiLanguage(taskId, operationUnit);
//                                                if (null == definitionWithMultiLanguage || definitionWithMultiLanguage instanceof String) {
//                                                    return;
//                                                }
//                                                JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(definitionWithMultiLanguage));
//                                                if (jsonObject != null && jsonObject.getBooleanValue("hideDeliverySetting")) {
//                                                    //当设置需要隐藏显示的时候，不放入结果集中
//                                                    return;
//                                                }
//
//                                                //任务引擎往config中加
//                                                if (jsonObject != null && jsonObject.getJSONObject("config") != null && jsonObject.getJSONObject("config").getBooleanValue("hideDeliverySetting")) {
//                                                    return;
//                                                }
//
//                                                taskDTO.setTask(definitionWithMultiLanguage);
//
//                                                List<Action> taskDataGroupAction = this.actionRepository.getTaskDataGroupAction(taskId);
//                                                if (!CollectionUtils.isEmpty(taskDataGroupAction)) {
//                                                    taskDTO.setHasDataGroupAction(true);
//                                                }
//                                                Query query = new Query();
//                                                Criteria criteria = Criteria.where("taskCode").is(taskId).and("version").is(tenantVersion);
//                                                query.addCriteria(criteria);
//                                                List<TaskMonitorRule> taskMechanism = this.mongoTemplate.find(query, TaskMonitorRule.class, "taskMonitorRule");
//                                                if (!CollectionUtils.isEmpty(taskMechanism)) {
//                                                    List<String> collect = taskMechanism.stream().map(TaskMonitorRule::getMonitorRuleCode).collect(Collectors.toList());
//                                                    taskDTO.setRelatedMonitorRules(collect);
//                                                }
//
//                                                result.add(taskDTO);
//
//                                            } catch (Exception e) {
//                                                log.error("postTaskByApp error:{}", e);
//                                            } finally {
//
//                                            }
//                                        }, Constants.APP_EXECUTE_POOL))
//                                .toArray(CompletableFuture[]::new))
//                .join();
//        return result;
    }

    @Override
    public Object postFixTask(String taskId, OperationUnit operationUnit) throws Exception {
        log.info("fix Project:{}", taskId);
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        TaskDTO taskDTO = new TaskDTO();
//        Object definitionWithMultiLanguage = this.postDefinitionWithMultiLanguage(taskId, operationUnit);
//        if (null == definitionWithMultiLanguage || definitionWithMultiLanguage instanceof String) {
//            return null;
//        }
//        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(definitionWithMultiLanguage));
//        if (jsonObject != null && jsonObject.getBooleanValue("hideDeliverySetting")) {
//            //当设置需要隐藏显示的时候，不放入结果集中
//            return null;
//        }
//
//        //任务引擎往config中加
//        if (jsonObject != null && jsonObject.getJSONObject("config") != null && jsonObject.getJSONObject("config").getBooleanValue("hideDeliverySetting")) {
//            return null;
//        }
//
//        taskDTO.setTask(definitionWithMultiLanguage);
//
//        List<Action> taskDataGroupAction = this.actionRepository.getTaskDataGroupAction(taskId);
//        if (!CollectionUtils.isEmpty(taskDataGroupAction)) {
//            taskDTO.setHasDataGroupAction(true);
//        } else {
            dataMapService.postFixProject(taskId);
//        }
        return null;
    }

    /**
     * 根据应用code过滤出用户授权下的项目
     * @param appCode 应用code
     * @param tenantId 租户id
     * @param taskIdList 任务code
     * @return
     */
    private List<String> filterProjectByComponent(String appCode, String tenantId, List<String> taskIdList) {
        if (CollectionUtils.isEmpty(taskIdList)) {
            return null;
        }
        List<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<>();
        for (String taskId : taskIdList) {
            ComponentBaseInfoBO componentInfo = new ComponentBaseInfoBO();
            componentInfo.setCode(taskId);
            componentInfo.setType(ComponentTypeEnum.Project);
            componentBaseInfos.add(componentInfo);
        }

        try {
            List<ComponentBaseInfoBO> filteredBaseInfos = componentManager.FilterByTenantApplicationComponentList(appCode, tenantId, componentBaseInfos);
            if (!CollectionUtils.isEmpty(filteredBaseInfos)
                    && filteredBaseInfos.size() != componentBaseInfos.size()) {
                //有过滤
                List<String> collect = filteredBaseInfos.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
                return collect;
            }
        } catch (DWBusinessException e) {
            log.error(e.getMessage(), e);
        }

        return taskIdList;
    }

    @Override
    public Object getReportsByBizCodeNType(String bizCode, Integer type) throws Exception {
        return getReportsByBizCodeNType(bizCode, type, null);
    }

    @Override
    public Object getReportsByBizCodeNType(String bizCode, Integer type, String userId) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        //从mongo中查询出项目或任务关联的报表记录
        if (null == type || type == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeInvalid"));
            //query = Query.query(Criteria.where("bizCode").is(bizCode));
        }
        List<BizRelatedReport> relatedReports = dataPickService.find(Criteria.where("bizCode").is(bizCode).and("type").is(type), BizRelatedReport.class, "bizRelatedReports");
        //根据visibleCondition中的条件对数据进行过滤
        try {
            this.filterBizReportByVisibleCondition(relatedReports, tenantId);
        } catch (Exception e) {
            log.error("filterBizReportByVisibleCondition error:{}", e.getMessage());
        }
        if (CollectionUtils.isEmpty(relatedReports)) {
            return Collections.EMPTY_LIST;
        }
        Map<String, BizRelatedReport> relatedReportMap = relatedReports.stream().collect(Collectors.toMap(BizRelatedReport::getReportCode, a -> a));
        List<String> reportCodes = relatedReports.stream().map(BizRelatedReport::getReportCode).collect(Collectors.toList());

        // 根据应用授权筛选
        List<String> appCodes = new ArrayList<>();
        if (StringUtils.isNotEmpty(userId)) {
            appCodes = cacUtils.getAppAuth(userId);
        } else {
            appCodes = cacUtils.getAppAuth();
        }
        List<ApplicationRelation> relations = appService.getApplicationRelation(appCodes, reportCodes, "activity", null);
        reportCodes = relations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
        //根据type查询项目或者任务
        //查询neo4j中的租户对应报表
        List<Activity> reportList = dataPickService.excludeWithSameCode(activityDAO.getReportActivitiesByCode(reportCodes, tenantId, tenantVersion));
        if (CollectionUtils.isEmpty(reportList)) {
            return Collections.EMPTY_LIST;
        }
        filterUc(reportList,tenantId);
        //根据neo4j中查到的数据进行过滤以及多语言处理
        List<BizRelatedReport> relatedReportResultList = new LinkedList<>();
        reportList.forEach(item -> {
            BizRelatedReport bizRelatedReportItem = relatedReportMap.get(item.getCode());
            bizRelatedReportItem.setParamsMapping(null);
            bizRelatedReportItem.setReportName(item.getLang().isEmpty() || null == item.getLang().get("name").get(localeStr) ? item.getName()
                    : item.getLang().get("name").get(localeStr));
            relatedReportResultList.add(bizRelatedReportItem);
        });
        return relatedReportResultList;
    }



    @Override
    @Deprecated
    public Object getDataEntryByBizCodeNType(String code, Integer type) throws Exception {
        if (null == type || type == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeInvalid"));
        }
        String application;
        switch (type) {
            case Constants.DataEntrySourceType.PROJECT:
                Task task = taskRepository.findTaskNoTenantId(code);
                if (null == task) {
                    return Collections.EMPTY_LIST;
                }
                application = task.getNameSpace();
                break;
            case Constants.DataEntrySourceType.TASK:
                Activity activity = activityDAO.findActivityNoTenantId(code);
                if (null == activity) {
                    return Collections.EMPTY_LIST;
                }
                application = activity.getNameSpace();
                break;
            default:
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeNotSupport2"));
        }
        List<Activity> reportList = activityDAO.getDataEntryByNameSpace(application);
        if (CollectionUtils.isEmpty(reportList)) {
            return Collections.EMPTY_LIST;
        }
        return reportList;
    }

    private boolean filterActivityByHasGroundEnd(String code, String tenantId) {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query(Criteria.where("code").is(code)
                .and("version").is(tenantVersion));
        Activity activityConfig = mongoTemplate.findOne(query, Activity.class, "activityConfigs");
        if (BooleanUtils.isTrue(activityConfig.getDependOnGroundEnd())) {  //如果依赖地端
            Object hasGroundEndObj = null;
            String hasGroundEnd = null;
            try {
                hasGroundEndObj = this.mechanismService.getVariable("hasGroundEnd", tenantId);
                if (hasGroundEndObj != null) {
                    Map<String, Object> hasGroundEndMap = (Map<String, Object>) hasGroundEndObj;
                    hasGroundEnd = String.valueOf(hasGroundEndMap.get("hasGroundEnd"));
                }
            } catch (Exception e) {

            }

            if (StringUtils.equals(hasGroundEnd, "N")) { //但么有地端信息
                return true;
            }
        }
        return false;
    }

    protected void filterBizReportByVisibleCondition(List<BizRelatedReport> relatedReports, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(relatedReports)) {
            return;
        }
        Map<String, Map<String, Object>> apiResponseMap = new HashMap<>(); // 记录调用esp api的结果返回，如果存在就直接使用map中的值，避免多次调用
        Map<String, Object> queryedVariableMap = new HashMap<>();  // 记录调用mechanismVariable的结果返回，如果存在就直接使用map中的值，避免多次调用
        Iterator<BizRelatedReport> iterator = relatedReports.iterator();
        while (iterator.hasNext()) {
            BizRelatedReport next = iterator.next();
            //检查对应的报表是否依赖地端
            if (filterActivityByHasGroundEnd(next.getReportCode(), tenantId)) {
                iterator.remove();
                continue;
            }

            if (next.getVisibleCondition() == null) {
                continue;
            }
            // 把应用 code 放到上下文中，在调用 esp 的地方，透传过去
            LoginInfo loginInfo = KgFilter.getLoginInfo();
            if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty(next.getApplication())) {
                loginInfo.setApplication(next.getApplication());
            }
            Map<String, Object> visibleCondition = next.getVisibleCondition();
            String from = String.valueOf(visibleCondition.get("from"));
            String key = String.valueOf(visibleCondition.get("key"));
            String visibleValue = String.valueOf(visibleCondition.get("visibleValue"));
            String api = String.valueOf(visibleCondition.get("api"));
            if (StringUtils.equalsIgnoreCase(from, "variable")) { //从机制变量获取
                Object mechanismVariableValue = queryedVariableMap.get(key);
                if (mechanismVariableValue == null) {
                    Object variable = this.mechanismService.getVariable(key, tenantId);
                    Map variableMap = (Map) variable;
                    mechanismVariableValue = variableMap.get(key);
                    queryedVariableMap.put(key, mechanismVariableValue);
                }
                if (!StringUtils.equals(visibleValue, String.valueOf(mechanismVariableValue))) {
                    iterator.remove();
                    continue;
                }
            } else if (StringUtils.equalsIgnoreCase(from, "esp")) { //调用esp的api获取值
                Map<String, Object> queryResult = apiResponseMap.get(api); //先看下之前有没有调用过这个api
                if (queryResult == null) {
                    queryResult = this.espUtils.query(DWServiceContext.getContext().getToken(), tenantId, api);
                    apiResponseMap.put(api, queryResult);
                }
                if (queryResult != null) {
                    Object apiQueryField = queryResult.get(key);
                    if (!StringUtils.equals(visibleValue, String.valueOf(apiQueryField))) {
                        iterator.remove();
                        continue;
                    }
                }
            }
        }
    }

    @Override
    public Object getReportByBizCodeNTypeNReportCode(String bizCode, Integer type, String reportCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        //从mongo中查询出项目或任务关联的报表记录
        if (null == type || type == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeInvalid"));
        }
        Criteria criteria = Criteria.where("bizCode").is(bizCode).and("type").is(type).and("reportCode").is(reportCode);
        BizRelatedReport relatedReport = dataPickService.findOneByCondition(criteria, BizRelatedReport.class, "bizRelatedReports");
        if (null == relatedReport) {
            throw new DWBusinessException("P.KG.500.0036", I18nUtils.getValue("knowledgegraph.relationStatementNotFound"));
        }
        //查找neo4j中的定义用于多语言处理
        switch (type) {
            case 1:
//                Task task = taskRepository.findTask(tenantId, bizCode, tenantVersion);
//                if (null == task) {
                Task task=null;
                    Map<String, Object> dmp = new HashMap<>();
                    dmp.put("code", bizCode);
                    List datamapProjects = dataMapService.getProjectsBasic(dmp);
                    if (null != datamapProjects && datamapProjects.size() > 0) {
                        List<Task> tasks2 = JSON.parseArray(JSON.toJSONString(datamapProjects), Task.class);
                        task = tasks2.get(0);
                    }
                    if (null == task) {
                        throw new DWBusinessException("P.KG.500.0037", I18nUtils.getValue("knowledgegraph.tenantNotFoundProject"));
                    }
             //   }
                relatedReport.setBizName(task.getLang().isEmpty() || null == task.getLang().get("name").get(localeStr) ? task.getName()
                        : task.getLang().get("name").get(localeStr));
                break;
            case 2:
                Activity activity=null;
//                Activity activity = activityRepository.findActivity(tenantId, bizCode, tenantVersion);
//                if (null == activity) {
                    Map<String, Object> dmp2 = new HashMap<>();
                    dmp2.put("code", bizCode);
                    List datamapTasks = dataMapService.getTaskList(dmp2);
                    if (null != datamapTasks && datamapTasks.size() > 0) {
                        List<Activity> activities2 = JSON.parseArray(JSON.toJSONString(datamapTasks), Activity.class);
                        activity = activities2.get(0);
                    }
                    if (null == activity) {
                        throw new DWBusinessException("P.KG.500.0037", I18nUtils.getValue("knowledgegraph.tenantNotFoundProject"));
                    }
               // }
                relatedReport.setBizName(activity.getLang().isEmpty() || null == activity.getLang().get("name").get(localeStr) ? activity.getName()
                        : activity.getLang().get("name").get(localeStr));
                break;
            default:
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeNotSupport2"));
        }
        Activity report = dataPickService.chooseOneWithSameCode(activityDAO.getReportActivitiesByCode(Collections.singletonList(reportCode), tenantId, tenantVersion));
        if (null == report) {
            throw new DWBusinessException("P.KG.500.0038", I18nUtils.getValue("knowledgegraph.tenantNotFoundStatement"));
        }
        relatedReport.setReportName(report.getLang().isEmpty() || null == report.getLang().get("name").get(localeStr) ? report.getName()
                : report.getLang().get("name").get(localeStr));
        return relatedReport;
    }

    @Override
    public Object getBizsByReportCodeNType(String reportCode, Integer type) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        //从mongo中查询出报表关联的项目或任务记录
        if (null == type || type == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeInvalid"));
            //query = Query.query(Criteria.where("reportCode").is(reportCode));
        }
        List<BizRelatedReport> relatedReports = dataPickService.find(Criteria.where("reportCode").is(reportCode).and("type").is(type), BizRelatedReport.class, "bizRelatedReports");;
        Map<String, BizRelatedReport> relatedReportMap = relatedReports.stream().collect(Collectors.toMap(BizRelatedReport::getBizCode, a -> a));
        List<String> bizCodes = relatedReports.stream().map(BizRelatedReport::getBizCode).collect(Collectors.toList());
        //查询neo4j中对应的报表
//        Activity report = activityRepository.getReportActivitiesByCode(reportCode, tenantId);
//        if (null == report) {
//            throw new DWBusinessException("租户未找到报表定义");
//        }
        //查找neo4j中的定义用于多语言处理
        List<BizRelatedReport> resultList = new LinkedList<>();
        switch (type) {
            case 1:
                List<Task> tasks = new ArrayList<>();
//                List<Task> tasks = taskRepository.getTasksByCode(tenantId, bizCodes, tenantVersion);
                Map<String, Object> dmp = new HashMap<>();
                dmp.put("code", bizCodes);
                List datamapProjects = dataMapService.getProjectsBasic(dmp);
                if (null != datamapProjects && datamapProjects.size() > 0) {
                    List<Task> tasks2 = JSON.parseArray(JSON.toJSONString(datamapProjects), Task.class);
                    tasks.addAll(tasks2);
                }

                if (CollectionUtils.isEmpty(tasks)) {
                    //throw new DWBusinessException("租户未找到项目定义");
                    return Collections.EMPTY_LIST;
                }
                tasks.forEach(item -> {
                    BizRelatedReport bizRelatedReportItem = relatedReportMap.get(item.getCode());
                    if (null != bizRelatedReportItem) {
                        if (null != item.getLang() && null != item.getLang().get("name")) {
                            bizRelatedReportItem.setBizName(item.getLang().isEmpty() || null == item.getLang().get("name").get(localeStr) ? item.getName()
                                    : item.getLang().get("name").get(localeStr));
                        }
                        bizRelatedReportItem.setParamsMapping(null);
                        resultList.add(bizRelatedReportItem);
                    }

                });
                return resultList;
            case 2:
                List<Activity> activities = new ArrayList<>();
//                List<Activity> activities = activityRepository.getActivitiesByCode(tenantId, bizCodes, tenantVersion);
                Map<String, Object> dmp2 = new HashMap<>();
                dmp2.put("code", bizCodes);
                List datamapTasks = dataMapService.getTaskList(dmp2);
                if (null != datamapTasks && datamapTasks.size() > 0) {
                    List<Activity> activities2 = JSON.parseArray(JSON.toJSONString(datamapTasks), Activity.class);
                    activities.addAll(activities2);
                }
                if (CollectionUtils.isEmpty(activities)) {
                    return Collections.EMPTY_LIST;
                }
                activities.forEach(item -> {
                    BizRelatedReport bizRelatedReportItem = relatedReportMap.get(item.getCode());
                    if (null != bizRelatedReportItem) {
                        if (null != item.getLang() && null != item.getLang().get("name")) {
                            bizRelatedReportItem.setBizName(item.getLang().isEmpty() || null == item.getLang().get("name").get(localeStr) ? item.getName()
                                    : item.getLang().get("name").get(localeStr));
                        }
                        bizRelatedReportItem.setParamsMapping(null);
                        resultList.add(bizRelatedReportItem);
                    }
                });
                return resultList;
            default:
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeNotSupport2"));
        }
    }

    @Override
    public Object postAuthorityConfigs(List<String> taskIdList) throws Exception {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        Query query = Query.query(Criteria.where("code").in(taskIdList));
//        query.fields().include("code").include("authorityPrefix");
//        List<AuthorityConfigVO> defaultActivity = mongoTemplate.find(query.addCriteria(Criteria
//                .where("version").is(tenantVersion)), AuthorityConfigVO.class, "taskConfigs");
//
//        try {
            Map<String, Object> query1 = new HashMap<>();
            query1.put("code", taskIdList);
            List datamapTasks = dataMapService.getProjectsBasic(query1);
            return datamapTasks;
//            if (!CollectionUtils.isEmpty(datamapTasks)) {
//                defaultActivity.addAll(JSON.parseArray(JSON.toJSONString(datamapTasks), AuthorityConfigVO.class));
//            }
//        } catch (Exception e0) {
//        }
//
//        return defaultActivity;
    }

  //  @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "postActivityDefinitionList1$0$1$2", tenant = true,language = true, ttlSecs = 7200)
    @Override
    public Object postActivityDefinitionList(String taskId, Set<String> activityIds, String pageCode) throws Exception {
        return this.postActivityDefinitionList(taskId, activityIds, pageCode, null);
    }

  //  @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "postActivityDefinitionList2$0$1$2$3", tenant = true,language = true, ttlSecs = 7200)
    @Override
    public Object postActivityDefinitionList(String taskId, Set<String> activityIds, String pageCode, OperationUnit operationUnit) throws Exception {
        if (CollectionUtils.isEmpty(activityIds)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.activityIdEmpty"));
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        DWServiceContext context = DWServiceContext.getContext();
        Map<String, Object> re = new ConcurrentHashMap<>();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        CompletableFuture
                .allOf(
                        activityIds.stream().map(activityId ->
                                        CompletableFuture.completedFuture(activityId).runAsync(() -> {
                                            DWServiceContext.setContext(context);
                                            try {
                                                RequestContextHolder.setRequestAttributes(requestAttributes);
                                                Object o = SpringUtil.getBean(TaskService.class).postActivityDefinition(taskId, activityId, pageCode, operationUnit);
                                                if (!ObjectUtils.isEmpty(o)) {
                                                    re.put(activityId, o);
                                                }
                                            } catch (Exception e) {
                                                log.error("getActivityDefinition error:{}", e.getMessage());
                                            } finally {
                                                RequestContextHolder.resetRequestAttributes();
                                            }
                                        }, Constants.APP_EXECUTE_POOL))
                                .toArray(CompletableFuture[]::new))
                .join();
        stopWatch.stop();


      //  Object re = dataMapService.batchTaskDetails(activityIds,pageCode,operationUnit);

        return re;
    }

    @Override
    public Object postQueryTaskAndActivityInfo() throws Exception {
        List<Object> result = new ArrayList<>();
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<Application> applications = appService.postAllApplications();
        Map<String, Application> appEntityMap = applications.stream().collect(Collectors.toMap(Application::getCode, t -> t, (v1, v2) -> v2));

        List<Map> allTask = this.taskRepository.getAllTask();
        for (Map map : allTask) {
            String nameSpace = String.valueOf(map.get("nameSpace"));
            Application appEntity = appEntityMap.get(nameSpace);
            map.put("type", "task");
            if (appEntity != null) {
                map.put("appCode", appEntity.getCode());
                map.put("appName", appEntity.getName());
            }
        }

        List<Map> allActivity = this.activityDAO.getAllActivity();
        for (Map map : allActivity) {
            String nameSpace = String.valueOf(map.get("nameSpace"));
            Application appEntity = appEntityMap.get(nameSpace);
            map.put("type", "activity");
            if (appEntity != null) {
                map.put("appCode", appEntity.getCode());
                map.put("appName", appEntity.getName());
            }
        }
        result.addAll(allTask);
        result.addAll(allActivity);
        return result;
    }

    @Override
    public Object postQueryAllProjectAndTaskInfo() {
        List<Object> result = new CopyOnWriteArrayList<>();
        Map<String, String> appOldNameSpaceMap = new HashMap<>();
        appOldNameSpaceMap.put("PWD", "purchaseWithDiagram"); //NOSONAR 只是恰好叫 PWD
        appOldNameSpaceMap.put("DCP", "designChangeProject");
        appOldNameSpaceMap.put("PCM", "projectCostManagement");

        List<ApplicationPreNamespace> all1 = this.mongoTemplate.findAll(ApplicationPreNamespace.class);
        if (!CollectionUtils.isEmpty(all1)) {
            Map<String, String> collect = all1.stream().collect(Collectors
                    .toMap(ApplicationPreNamespace::getCode, ApplicationPreNamespace::getPreNamespace, (a, b) -> a));
            appOldNameSpaceMap.putAll(collect);
        }

        List<Application> applications = appService.postAllApplications();
        if (CollectionUtils.isEmpty(applications)) {
            return result;
        }

        Set<String> taskSet = new CopyOnWriteArraySet<>();
        Set<String> projectSet = new CopyOnWriteArraySet<>();
        Set<String> reportSet = new CopyOnWriteArraySet<>();
        Set<String> baseDataSet = new CopyOnWriteArraySet<>();

        //从application获取应用名称
        List<Application> all = this.mongoTemplate.findAll(Application.class);
        Map<String, Application> collect = all.stream().collect(Collectors.toMap(Application::getCode, Function.identity(), (a, b) -> a));
        DWServiceContext context = DWServiceContext.getContext();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        CompletableFuture
                .allOf(
                        applications.stream().map(appEntity ->
                                        CompletableFuture.completedFuture(appEntity).runAsync(() -> {
                                            try {
                                                DWServiceContext.setContext(context);
                                                RequestContextHolder.setRequestAttributes(requestAttributes);
//        for(AppEntity appEntity : appEntities){
                                                Application application = collect.get(appEntity.getCode());

                                                List<ComponentBO> projectComponent = this.componentInitManager.getProjectComponent(appEntity.getCode(),
                                                        appEntity.getCode(), appEntity.getVersion(), null);
                                                if (appOldNameSpaceMap.containsKey(appEntity.getCode())) {
                                                    List<ComponentBO> projectComponent1 = this.componentInitManager.getProjectComponent(appOldNameSpaceMap.get(appEntity.getCode()),
                                                            appEntity.getCode(), appEntity.getVersion(), null);
                                                    if (!CollectionUtils.isEmpty(projectComponent1)) {
                                                        projectComponent.addAll(projectComponent1);
                                                    }
                                                }
                                                for (ComponentBO componentBO : projectComponent) {
                                                    if (projectSet.contains(componentBO.getCode())) {
                                                        continue;
                                                    }
                                                    projectSet.add(componentBO.getCode());
                                                    Map map = new HashMap();
                                                    map.put("code", componentBO.getCode());
                                                    map.put("name", componentBO.getName());
                                                    map.put("type", componentBO.getType());
                                                    map.put("appCode", appEntity.getCode());
                                                    map.put("appName", application != null ? application.getName() : appEntity.getName());

                                                    Map<String, Map<String, String>> lang = componentBO.getLang();
                                                    Map<String, String> appNameLang = null;
                                                    if (application != null && application.getLang() != null) {
                                                        appNameLang = application.getLang().get("name");
                                                    }
                                                    if (lang == null) {
                                                        lang = new HashMap<>();
                                                    }
                                                    lang.put("appName", appNameLang);
                                                    map.put("lang", lang);

                                                    result.add(map);
                                                }
                                                List<ComponentBO> taskComponent = this.componentInitManager.getTaskComponent(appEntity.getCode(),
                                                        appEntity.getCode(), appEntity.getVersion(), null);
                                                if (appOldNameSpaceMap.containsKey(appEntity.getCode())) {
                                                    List<ComponentBO> taskComponent1 = this.componentInitManager.getTaskComponent(appOldNameSpaceMap.get(appEntity.getCode()),
                                                            appEntity.getCode(), appEntity.getVersion(), null);
                                                    if (!CollectionUtils.isEmpty(taskComponent1)) {
                                                        taskComponent.addAll(taskComponent1);
                                                    }
                                                }
                                                for (ComponentBO componentBO : taskComponent) {
                                                    if (taskSet.contains(componentBO.getCode())) {
                                                        continue;
                                                    }
                                                    taskSet.add(componentBO.getCode());
                                                    Map map = new HashMap();
                                                    map.put("code", componentBO.getCode());
                                                    map.put("name", componentBO.getName());
                                                    map.put("type", componentBO.getType());
                                                    map.put("appCode", appEntity.getCode());
                                                    map.put("appName", application != null ? application.getName() : appEntity.getName());

                                                    Map<String, Map<String, String>> lang = componentBO.getLang();
                                                    Map<String, String> appNameLang = null;
                                                    if (application != null && application.getLang() != null) {
                                                        appNameLang = application.getLang().get("name");
                                                    }
                                                    if (lang == null) {
                                                        lang = new HashMap<>();
                                                    }
                                                    lang.put("appName", appNameLang);
                                                    map.put("lang", lang);

                                                    result.add(map);
                                                }
                                                List<ComponentBO> reportComponent = this.componentInitManager.getReportComponent(appEntity.getCode(),
                                                        appEntity.getCode(), appEntity.getVersion(), null);
                                                if (appOldNameSpaceMap.containsKey(appEntity.getCode())) {
                                                    List<ComponentBO> reportComponent1 = this.componentInitManager.getReportComponent(appOldNameSpaceMap.get(appEntity.getCode()),
                                                            appEntity.getCode(), appEntity.getVersion(), null);
                                                    if (!CollectionUtils.isEmpty(reportComponent1)) {
                                                        reportComponent.addAll(reportComponent1);
                                                    }
                                                }
                                                for (ComponentBO componentBO : reportComponent) {
                                                    if (reportSet.contains(componentBO.getCode() + "#" + appEntity.getCode())) {
                                                        continue;
                                                    }
                                                    reportSet.add(componentBO.getCode() + "#" + appEntity.getCode());
                                                    Map map = new HashMap();
                                                    map.put("code", componentBO.getCode());
                                                    map.put("name", componentBO.getName());
                                                    map.put("type", componentBO.getType());
                                                    map.put("appCode", appEntity.getCode());
                                                    map.put("appName", application != null ? application.getName() : appEntity.getName());

                                                    Map<String, Map<String, String>> lang = componentBO.getLang();
                                                    Map<String, String> appNameLang = null;
                                                    if (application != null && application.getLang() != null) {
                                                        appNameLang = application.getLang().get("name");
                                                    }
                                                    if (lang == null) {
                                                        lang = new HashMap<>();
                                                    }
                                                    lang.put("appName", appNameLang);
                                                    map.put("lang", lang);

                                                    result.add(map);
                                                }
                                                List<ComponentBO> baseDataEntryComponent = this.componentInitManager.getBaseDataEntryComponent(appEntity.getCode(),
                                                        appEntity.getCode(), appEntity.getVersion(), null);
                                                if (appOldNameSpaceMap.containsKey(appEntity.getCode())) {
                                                    List<ComponentBO> baseDataEntryComponent1 = this.componentInitManager.getBaseDataEntryComponent(appOldNameSpaceMap.get(appEntity.getCode()),
                                                            appEntity.getCode(), appEntity.getVersion(), null);
                                                    if (!CollectionUtils.isEmpty(baseDataEntryComponent1)) {
                                                        baseDataEntryComponent.addAll(baseDataEntryComponent1);
                                                    }
                                                }
                                                for (ComponentBO componentBO : baseDataEntryComponent) {
                                                    if (baseDataSet.contains(componentBO.getCode() + "#" + appEntity.getCode())) {
                                                        continue;
                                                    }
                                                    baseDataSet.add(componentBO.getCode() + "#" + appEntity.getCode());
                                                    Map map = new HashMap();
                                                    map.put("code", componentBO.getCode());
                                                    map.put("name", componentBO.getName());
                                                    map.put("type", componentBO.getType());
                                                    map.put("appCode", appEntity.getCode());
                                                    map.put("appName", application != null ? application.getName() : appEntity.getName());

                                                    Map<String, Map<String, String>> lang = componentBO.getLang();
                                                    Map<String, String> appNameLang = null;
                                                    if (application != null && application.getLang() != null) {
                                                        appNameLang = application.getLang().get("name");
                                                    }
                                                    if (lang == null) {
                                                        lang = new HashMap<>();
                                                    }
                                                    lang.put("appName", appNameLang);
                                                    map.put("lang", lang);

                                                    result.add(map);
                                                }
//        }

                                            } catch (Exception e) {
                                                log.error("postQueryAllProjectAndTaskInfo error:{}", e.getMessage());
                                            } finally {
                                                DWServiceContext.setContext(null);
                                            }
                                        }, Constants.APP_EXECUTE_POOL))
                                .toArray(CompletableFuture[]::new))
                .join();
        return result;
    }

    @Override
    public Object postTenantSummaryFields(TenantSummaryFieldsDto tenantSummaryFields) throws Exception {
        log.info("postTenantSummaryFields start");
        String tenantId = AthenaUtils.getTenantId();
        deleteTenantSummaryFields(tenantSummaryFields);
        TenantSummaryFields tenantSummaryFieldsPO = transformToTenantSummaryFieldsPO(tenantSummaryFields);
        tenantSummaryFieldsPO.setTenantId(tenantId);
        mongoTemplateUser.insert(tenantSummaryFieldsPO);
        cacheService.deleteWithPattern(REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + "*");
        return null;
    }

    private TenantSummaryFields transformToTenantSummaryFieldsPO(TenantSummaryFieldsDto tenantSummaryFields) {
        return JSON.parseObject(JSON.toJSONString(tenantSummaryFields), TenantSummaryFields.class);
    }

    @Override
    public Object deleteTenantSummaryFields(TenantSummaryFieldsDto tenantSummaryFields) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId)
                .and("type").is(tenantSummaryFields.getType())
                .and("code").is(tenantSummaryFields.getCode())
                .and("application").is(tenantSummaryFields.getApplication());
        queryUser.addCriteria(criteriaUser);
        DeleteResult deleteResult = mongoTemplateUser.remove(queryUser, TenantSummaryFields.class);
        cacheService.deleteWithPattern(REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + "*");
        return deleteResult.getDeletedCount();
    }

    private TenantSummaryFields queryTenantSummaryFields(String application, String type, String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId)
                .and("type").is(type)
                .and("code").is(code)
                .and("application").is(application);
        queryUser.addCriteria(criteriaUser);
        TenantSummaryFields result = mongoTemplateUser.findOne(queryUser, TenantSummaryFields.class);
        return result;
    }

    @Override
    public Object postApplicationRelation(String type, Set<String> codes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Map<String, String> convertType = new HashMap<>();
        convertType.put("project", "task");
        convertType.put("task", "activity");
        Map<String, List<ApplicationRelation>> relationsMap = this.getApplicationRelationsMapByTypeAndCodesAndLang(convertType.get(type), codes, AthenaUtils.getCurrentLocale());

        List<ApplicationRelation> relations = relationsMap.entrySet().stream()
                .map(Map.Entry::getValue)
                .filter(list -> !CollectionUtils.isEmpty(list))
                .filter(Objects::nonNull)
                .flatMap(List::stream)
                .filter(relation -> tenantVersion.equals(relation.getVersion()))
                .collect(Collectors.toList());

        if (!CollectionUtils.isEmpty(relations) && relations.get(0) != null) {
            return relations;
        } else {
            return Collections.emptyList();
        }

    }

    /**
     * 根据组件code，组件类型查询应用组件关系
     * @param type 组件类型
     * @param codes 组件code集合
     * @param lang 多语言
     * @return {组件code, 应用组件关系集合}
     * @throws DWBusinessException
     */
    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type, Collection<String> codes, String lang) throws DWBusinessException {
        //   log.info("getApplicationByTypeAndCodeAndLang");
        Map<String, List<ApplicationRelation>> applicationRelationsMap = this.getApplicationsMapByTypeAndCodes(type, codes);
        Set<String> applicationsCodes = new HashSet<>();
        applicationRelationsMap.values().forEach(item -> {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        List<Application> applications = appService.getApplicationsByCodes(applicationsCodes);
        Map<String, Application> applicationMap = applications.stream().collect(Collectors.toMap(Application::getCode, Function.identity(), (v1, v2) -> v1));
        applicationRelationsMap.forEach((k, v) -> {
            v.forEach(applicationRelation -> {
                Application application = applicationMap.get(applicationRelation.getAppCode());
                if (application != null && application.getLang() != null) {
                    Map nameLangMap = application.getLang().get("name");
                    String language = null == nameLangMap.get(lang) ? application.getName() : (String) nameLangMap.get(lang);
                    applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
                }
            });
        });
        return applicationRelationsMap;
    }

    /**
     * 根据组件类型，组件code获取组件应用关系
     * @param type 组件类型
     * @param codes  组件code集合
     * @return {组件code, 应用组件关系集合}
     * @throws DWBusinessException
     */
    public Map<String, List<ApplicationRelation>> getApplicationsMapByTypeAndCodes(String type, Collection<String> codes) throws DWBusinessException {
        Map<String, List<ApplicationRelation>> applicationRelationsMap = new HashMap<>();
        for (String code : codes) {
            Query queryUser = new Query();
            Criteria criteriaUser = Criteria.where("type").is(type).and("code").is(code);
            queryUser.addCriteria(criteriaUser);

            List<ApplicationRelation> applicationRelations = dataPickService.find(Criteria.where("type").is(type).and("code").is(code), ApplicationRelation.class, "applicationRelation");
            applicationRelationsMap.put(code, applicationRelations);
        }
        return applicationRelationsMap;
    }

    // 根据viewCode获取视图数据  + 多语言翻译
    public Object postDataViewList(List<String> viewCodes) throws NoSuchFieldException, IllegalAccessException, DWBusinessException {
        Map<String, Object> dataMap = new HashMap<>();
        String tenantVersion = kgInnerService.currentTenantVersion();
        List<Object> dataViews = mongoTemplate.find(Query.query(Criteria.where("code").in(viewCodes).and("version").is(tenantVersion)), Object.class, "dataView");
        if (!CollectionUtils.isEmpty(dataViews)) {
            Locale locale = DWResourceBundleUtils.getCurrentLocale();
            String localeStr = locale.toString();
            String dataViewsStr = translateUtils.translateContent(dataViews);
            dataViews = JSON.parseArray(dataViewsStr, Object.class);
            LanguageUtil.processLocaleLanguage(dataViews, localeStr);
        }
        dataMap.put("dataViews", dataViews);
        return dataMap;
    }

    /**
     * 构造根据pageCode过滤,有or操作符需要重写生成
     * @param pageCode
     * @param criteria
     */
    private void addPageCodeCriteria(String pageCode,Criteria criteria){
        if("project-card".equals(pageCode)){
            criteria.and("pageCode").is(pageCode);
        }else {
            // pageCode不存在为任务卡
            criteria.orOperator(Criteria.where("pageCode").is(pageCode),Criteria.where("pageCode").exists(false));
        }
    }

    @Override
    public Object getCardLabel(String code,String pageCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Criteria criteria = Criteria.where("tenantId").is(tenantId).and("taskCode").is(code);
        Query query = new Query();
        addPageCodeCriteria(pageCode,criteria);
        query.addCriteria(criteria);
        CardLabel cardLabel = mongoTemplateUser.findOne(query, CardLabel.class);
        if (null == cardLabel) {
            cardLabel = new CardLabel();
            cardLabel.setTaskCode(code);
            Map<String, Object> query1 = MapUtil.of("code", code);
            List tasks = dataMapService.postCardConfig(query1,pageCode);
            if (null != tasks && tasks.size() > 0) {
                Object task = tasks.get(0);
                Object labels = JSONPath.eval(task, "$.fieldConfig.taskCardField.labels");
                cardLabel.setLabels(JSON.parseArray(JSON.toJSONString(labels), LabelVO.class));
            }
        }
        if (null != cardLabel.getLabels()) {
            cardLabel.getLabels().forEach(labelVO -> {
                if (null == labelVO.getOriginName()) {
                    labelVO.setOriginName(labelVO.getName());
                }
                if (null != labelVO.getLang() && null == labelVO.getLang().get("originName")) {
                    labelVO.getLang().put("originName", labelVO.getLang().get("name"));
                }
            });
        }
        return cardLabel;
    }

    @Override
    public Object getCardLabel(String code) throws DWBusinessException {
        return getCardLabel(code,"task-card");
    }

    @Override
    public Object postSaveCardLabel(CardLabel cardLabel) throws Exception {
        String pageCode = cardLabel.getPageCode();
        if(StringUtils.isBlank(pageCode)){
            cardLabel.setPageCode("task-card");
        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        String locale = AthenaUtils.getCurrentLocale();
        cardLabel.setTenantId(tenantId);
        cardLabel.setVersion(tenantId);
        //处理修改名字后自动化翻译再次覆盖名字问题
        if (null != cardLabel.getLabels() && null != locale) {
            cardLabel.getLabels().forEach(labelVO -> {
                if (null != labelVO.getLang()) {
                    //fix 99664 不需要多语言，用户输入内容在任意语言下都正常展示，不需展示为多语言，展示用户输入内容原文即可
                    labelVO.getLang().remove("name");
//                    Map<String, String> nameLang = labelVO.getLang().get("name");
//                    if (null != nameLang) {
//                        nameLang.put(locale, labelVO.getName());
//                    }
                }
            });
        }
        Query queryUser = new Query();
        Criteria criteria = Criteria.where("taskCode").is(cardLabel.getTaskCode()).and("tenantId").is(tenantId);
        addPageCodeCriteria(cardLabel.getPageCode(),criteria);
        queryUser.addCriteria(criteria);
        Update update = new Update();
        update.set("labels", cardLabel.getLabels());
        update.set("delete", cardLabel.isDelete());
        update.set("ifTenant", true);
        UpdateResult updateResult = mongoTemplateUser.upsert(queryUser, update, CardLabel.class);
        long count = updateResult.getModifiedCount();
        //   if (count > 0) {
        String cacheKey = REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + ":*";
        try {
            cacheService.deleteWithPattern(cacheKey);
        } catch (Exception e) {
            log.error("delete redis fail:", e);
        }
        // }


        return count;
    }

    @Override
    public Object getDeleteCardLabel(String code,String pageCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteria = Criteria.where("taskCode").is(code).and("tenantId").is(tenantId);
        addPageCodeCriteria(pageCode,criteria);
        queryUser.addCriteria(criteria);
        Update update = new Update();
        update.set("delete", true);
        DeleteResult updateResult = mongoTemplateUser.remove(queryUser, CardLabel.class);
        long count = updateResult.getDeletedCount();
        //TODO 刷新缓存
        //   if (count > 0) {
        String cacheKey = REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + ":*";
        try {
            cacheService.deleteWithPattern(cacheKey);
            ;
        } catch (Exception e) {
            log.error("delete redis fail:", e);
        }
        //    }

        return getCardLabel(code,pageCode);
    }

    @Override
    public Object getDeleteCardLabel(String code) throws Exception {
        return getDeleteCardLabel(code,"task-card");
    }

    @Override
    public Object getCardGroup() throws Exception {
        String tenantId = AthenaUtils.getTenantId();

        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        Query query = new Query();
        query.addCriteria(criteria);
        CardGroup cardLabel = mongoTemplateUser.findOne(query, CardGroup.class);
        Boolean enable = null;
        if (null != cardLabel && null != cardLabel.getEnabled()) {
            enable = cardLabel.getEnabled();
        }

        if (null == cardLabel || null == cardLabel.getSystem()) {
            cardLabel = new CardGroup();
            List<CardGroupGroup> sysCardGroups = taskFieldService.sysCardGroups(tenantId);
            GroupAndLabelDto groupAndLabelDto = taskFieldService.applicationGroupAndCard();
            cardLabel.setSystem(new SystemGroup());
            cardLabel.getSystem().setGroups(sysCardGroups);
            cardLabel.setApplications(groupAndLabelDto.getCardGroupApplications());
            cardLabel.setTenantId(tenantId);
            if (null != enable) {
                cardLabel.setEnabled(enable);
            }
        }

        //确定只有一个被设定为默认选中
        boolean hasDefault = false;
        if (null != cardLabel.getSystem() && null != cardLabel.getSystem().getGroups()) {
            for (CardGroupGroup cardGroup : cardLabel.getSystem().getGroups()) {
                if (hasDefault) {
                    cardGroup.setDefaultEffective(false);
                }
                if (cardGroup.isDefaultEffective()) {
                    hasDefault = true;
                }
            }
        }
        if (!hasDefault && null != cardLabel.getApplications()) {
            for (CardGroupApplication application : cardLabel.getApplications()) {
                if (null != application.getTasks()) {
                    for (CardGroupTask task : application.getTasks()) {
                        if (hasDefault) {
                            task.setDefaultEffective(false);
                        }
                        if (task.isDefaultEffective()) {
                            hasDefault = true;
                        }
                    }
                }
            }
        }

        return cardLabel;
    }


//    public Object getSystemCardGroup() throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.currentTenantVersion();
//        //step1 请求小ai接口查询系统级分组规则
//        List<CardGroupGroup> sysCardGroups = atmcService.getGroupDimension(tenantId);
//        if (CollectionUtils.isEmpty(sysCardGroups)) {
//            throw new DWBusinessException("未能获取到系统级分组规则");
//        }
//        //step2 查询租户授权的应用
//        List<String> authApps = tenantService.getAppCodes();
//        //step3 查询各应用各任务的分组规则(消耗较大)
//        Map<String, List<TaskCardFields>> appTasks = new HashMap<>();
//        authApps.forEach(item -> {
//            try {
//                //resp为list
//                List<TaskCardFields> resp = (List) dataMapService.getAppCardFields(item);
//                if (CollectionUtils.isEmpty(resp)) {
//                    appTasks.put(item, resp);
//                }
//            } catch (Exception e) {
//                log.error("query app tasks error for app:{}", item);
//            }
//        });
//        //step4 将结果合并组装为分组规则定义
//        CardGroup cardGroup = new CardGroup();
//        //sysGroup
//        SystemGroup systemGroup = new SystemGroup();
//        systemGroup.setGroups(sysCardGroups);
//        cardGroup.setSystem(systemGroup);
//        //applicationGroup
//        List<CardGroupApplication> applications = taskFieldService.generateApplicationGroups(appTasks);
//        cardGroup.setApplications(applications);
//        return cardGroup;
//    }

    @Override
    public Object postSaveCardGroup(CardGroup cardGroup) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();

        cardGroup.setTenantId(tenantId);
        cardGroup.setVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        queryUser.addCriteria(criteria);
        Update update = new Update();
        if (CollectionUtil.isNotEmpty(cardGroup.getApplications())) {
            for (CardGroupApplication application : cardGroup.getApplications()) {
                for (CardGroupTask task : application.getTasks()) {
                    task.setEnabled(task.getGroups().stream().anyMatch(v->Boolean.TRUE.equals(v.isEnabled())));
                    task.setDefaultEffective(task.getGroups().stream().anyMatch(v->Boolean.TRUE.equals(v.getDefaultGroup())));
                    for (CardGroupGroup group : task.getGroups()) {
                        group.setDefaultEffective(group.isEnabled());
                    }
                }
            }
            update.set("applications", cardGroup.getApplications());
        }
        if (null != cardGroup.getSystem()) {
            update.set("system", cardGroup.getSystem());
        }
        update.set("enabled", true);//2024S4之后，页面上的开关已去掉，所以默认都是启用
        UpdateResult updateResult = mongoTemplateUser.upsert(queryUser, update, CardGroup.class);
        long count = updateResult.getModifiedCount();
        //  if (count > 0) {
        String cacheKey = REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + ":*";
        try {
            cacheService.deleteWithPattern(cacheKey);
        } catch (Exception e) {
            log.error("delete redis fail:", e);
        }
        //  }
        return count;
    }

    @Override
    public Object getCardGroupStatus() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Criteria orderCriteria = Criteria.where("tenantId").is(tenantId);
        Query orderQry = new Query();
        orderQry.addCriteria(orderCriteria);
        CardGroup cardGroup = mongoTemplateUser.findOne(orderQry, CardGroup.class);
        if (null == cardGroup) {
            return false;
        }
        return cardGroup.getEnabled();
    }

    @Override
    public Object getDeleteCardGroup() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        queryUser.addCriteria(criteria);

        DeleteResult deleteResult = mongoTemplateUser.remove(queryUser, CardGroup.class);
        long count = deleteResult.getDeletedCount();
        //TODO 刷新缓存
        //  if (count > 0) {
        String cacheKey = REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + ":*";
        try {
            cacheService.deleteWithPattern(cacheKey);
        } catch (Exception e) {
            log.error("delete redis fail:", e);
        }
        //}
        CardGroup cardGroup = (CardGroup) getCardGroup();
        cardGroup.setEnabled(true);
        postSaveCardGroup(cardGroup);
        return cardGroup;
    }


    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getCardConfig", tenant = true, ttlSecs = 86400L, loadEmpty = true, language = true)
    @Override
    public Object getCardConfig() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Map<String, Object> result = new HashMap<>();
        Map<String, Object> groupRule = new HashMap<>();
        List<CardGroupGroup> sysCardGroups = new ArrayList<>();
        Map<String, Object> groupType = new HashMap<>();
        List<Map<String, String>> businessKey = new ArrayList<>();

        // 所有应用任务的配置
        GroupAndLabelDto groupAndLabelDto = taskFieldService.applicationGroupAndCard();

        //分组
        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        Query query = new Query();
        query.addCriteria(criteria);
        CardGroup cardGroup = mongoTemplateUser.findOne(query, CardGroup.class);

        if (null != cardGroup && cardGroup.getEnabled()) {
            if (!CollectionUtils.isEmpty(cardGroup.getApplications())) {
                List<String> authApps = cardGroup.getApplications()
                        .stream().map(CardGroupApplication::getAppCode).collect(Collectors.toList());
                List<Application> apps = dataPickService.find(Criteria.where("code").in(authApps), Application.class, "application");
                LanguageUtil.processLocaleLanguage(apps, AthenaUtils.getCurrentLocale());

                Map<String, String> appsNameMap = apps.stream().collect(Collectors.toMap(
                        Application::getCode,
                        Application::getName,
                        (existing, replacement) -> existing));

                for (CardGroupApplication groupApplication : cardGroup.getApplications()) {
                    if (null == groupApplication.getTasks()) {
                        continue;
                    }
                    for (CardGroupTask task : groupApplication.getTasks()) {
                        log.info("cardGroupTask:{}", JSON.toJSONString(task));
                        log.info("groupAndLabelDto:{}", JSON.toJSONString(groupAndLabelDto));
                        if (task.getGroups() != null && task.isEnabled()) {
                            ApplicationRelation applicationRelation = groupAndLabelDto.getTaskRelationsMap().get(task.getCode());
                            if(null==applicationRelation){
                                log.warn("getCardConfig CardGroupTask has no application  task code="+task.getCode()+",tenantId="+tenantId);
                                continue;
                            }
                            String appCode = applicationRelation.getAppCode();
                            for (CardGroupGroup cardGroupGroup : task.getGroups()) {
                                //这个isDefaultEffective代表被选中的字段，一个字段同时作为选择与默认值确实造成了一些困扰
                                if (cardGroupGroup.isDefaultEffective()) {
                                    Map<String, String> item = new HashMap<>();
                                    item.put("taskCode", task.getCode());
                                    item.put("name", cardGroupGroup.getName());
                                    item.put("bkCode", cardGroupGroup.getCode());
                                    item.put("appName", appsNameMap.get(groupApplication.getAppCode()));
                                    businessKey.add(item);
                                    cardGroupGroup.setType("businessKey");
                                    cardGroupGroup.setCode(appCode + "-" + cardGroupGroup.getCode());
                                    cardGroupGroup.setEnabled(true);
                                    cardGroupGroup.setAppName(appsNameMap.get(groupApplication.getAppCode()));
                                    //这个isDefaultEffective代表当前任务是否被选为默认
                                    cardGroupGroup.setDefaultEffective(task.isDefaultEffective());
                                    sysCardGroups.add(cardGroupGroup);
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if (null != cardGroup.getSystem()) {
                sysCardGroups.addAll(cardGroup.getSystem().getGroups());
            }
        } else {
            sysCardGroups = taskFieldService.sysCardGroups(tenantId);
        }
        Set<String> codesisDefaultEffective = new HashSet<>();
        sysCardGroups.forEach(group -> {
            if (group.isDefaultEffective()) {
                codesisDefaultEffective.add(group.getCode());
            }
        });
        Set<String> codes = new HashSet<>();
        Iterator<CardGroupGroup> groups = sysCardGroups.iterator();
        boolean hasDefault = false;
        while (groups.hasNext()) {
            CardGroupGroup group = groups.next();
            if (!group.isEnabled() || codes.contains(group.getCode()) || (codesisDefaultEffective.contains(group.getCode()) && !group.isDefaultEffective())) {
                groups.remove();
                continue;
            }
            if (hasDefault) {
                group.setDefaultEffective(false);
            }
            if (group.isDefaultEffective()) {
                hasDefault = true;
            }
            codes.add(group.getCode());
        }
        Criteria labelCriteria = Criteria.where("tenantId").is(tenantId);
        addPageCodeCriteria("task-card",labelCriteria);
        //标签
        List<CardLabel> labels = mongoTemplateUser.find(Query.query(labelCriteria), CardLabel.class);
        List<String> tenantLabelCodes = labels.stream().map(CardLabel::getTaskCode).collect(Collectors.toList());
        for (CardLabel label : groupAndLabelDto.getCardLabels()) {
            // 根据TaskCode识别，有租户级别取租户，没有取应用
            if (!tenantLabelCodes.contains(label.getTaskCode())) {
                labels.add(label);
            }
        }

        //排序
        Criteria orderCriteria = Criteria.where("tenantId").is(tenantId);
        Query orderQry = new Query();
        orderQry.addCriteria(orderCriteria);
        CardOrder cardOrder = mongoTemplateUser.findOne(orderQry, CardOrder.class);
        List<TaskTypeOrder> taskTypeOrders = new ArrayList<>();
        if (null != cardOrder && !CollectionUtil.isEmpty(cardOrder.getTaskTypeOrders())) {
            taskTypeOrders = cardOrder.getTaskTypeOrders();
        }
        //  对于非实时生成业务数据的卡，取租户级别配置
        handleCardConfigByBusinessMessageSourceMethod(cardGroup,cardOrder, labels,groupAndLabelDto);

        groupType.put("businessKey", businessKey);
        groupRule.put("groupType", groupType);
        groupRule.put("showGroup", sysCardGroups);
        result.put("groupRule", groupRule);
        result.put("labelRule", labels);
        result.put("orderRule", taskTypeOrders);
        result.put("columnRule", groupAndLabelDto.getColumns());
        result.put("businessMessageSourceMethodMap", groupAndLabelDto.getBusinessMessageSourceMethodMap());
        return result;
    }

    private void handleCardConfigByBusinessMessageSourceMethod(CardGroup cardGroup, CardOrder cardOrder, List<CardLabel> labels,GroupAndLabelDto groupAndLabelDto) throws DWBusinessException {
        Map<String, Object> businessMessageSourceMethodMap = groupAndLabelDto.getBusinessMessageSourceMethodMap();
        Set<String> taskCodes = businessMessageSourceMethodMap.keySet();
        Object o = postCardConfigByType(new CardConfigQueryDTO()
                .setCodes(new ArrayList<>(taskCodes))
                .setPageCode("task-card")
                .setCardOrder(cardOrder)
                .setNeedQueryCardOrder(false));
        JSONObject config = (JSONObject) o;
        taskCodes.forEach(c->{
            businessMessageSourceMethodMap.put(c, config.getJSONObject(c).get("config"));
        });
    }

    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getTenantTask", tenant = true, ttlSecs = 86400L, loadEmpty = true, language = true)
    @Override
    public Object getTenantTask() throws Exception {

        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        // 查询当前租户授权的应用
        List<String> authApps = tenantService.getAppCodes();
        if (CollectionUtil.isEmpty(authApps)) {
            return null;
        }
        // 查询应用信息
        List<Application> apps = dataPickService.find(Criteria.where("code").in(authApps), Application.class, "application");
        Map<String, Application> applicationMap = new HashMap<>();
        apps.forEach(app -> {
            applicationMap.put(app.getCode(), app);
        });
        // 查询应用任务关系
        List<ApplicationRelation> taskRelations = appService.getApplicationRelationByTypeAndAppCode("activity", authApps);
        if (CollectionUtil.isEmpty(taskRelations)) {
            return null;
        }
        Map<String, ApplicationRelation> taskRelationsMap = new HashMap<>();
        taskRelations.forEach(applicationRelation -> {
            taskRelationsMap.put(applicationRelation.getCode(), applicationRelation);
        });
        // 获取所有任务
        List<String> taskCodes = taskRelations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
        Map<String, Object> query = MapUtil.of("code", taskCodes);
        List<Map<String, Object>> tasks = dataMapService.postCardConfig4Order(query);

        //处理应用和任务信息

        // 任务添加应用信息
        for (Map<String, Object> task : tasks) {
            task.put("appCode", taskRelationsMap.get(task.get("code").toString()).getAppCode());
        }
        // 任务依据应用进行分组
        Map<String, List<Map<String, Object>>> appTaskRelMap = tasks.stream().collect(Collectors.groupingBy(i -> i.get("appCode").toString()));
        List<AppTaskRel> appTaskRelList = new ArrayList<>();
        for (String appCode : appTaskRelMap.keySet()) {
            AppTaskRel appTaskRel = new AppTaskRel();
            appTaskRel.setCode(appCode);
            appTaskRel.setName(applicationMap.get(appCode).getName());
            appTaskRel.setLang(applicationMap.get(appCode).getLang());
            List<TaskVO> taskList = new ArrayList<>();
            appTaskRel.setTaskList(taskList);
            List<Map<String, Object>> taskMapList = appTaskRelMap.get(appCode);
            for (Map<String, Object> task : taskMapList) {
                TaskVO taskVO = new TaskVO();
                taskVO.setCode(task.get("code").toString());
                taskVO.setName(task.get("name").toString());
                taskVO.setLang((Map) task.get("lang"));
                taskList.add(taskVO);
            }
            appTaskRelList.add(appTaskRel);
        }

        LanguageUtil.processLocaleLanguage(appTaskRelList, AthenaUtils.getCurrentLocale());

        // 获取多语言处理之后的名称
        Map<String, String> codeNameRelMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(appTaskRelList)) {
            List<TaskVO> taskList = new ArrayList<>();
            for (AppTaskRel appTaskRel : appTaskRelList) {
                taskList.addAll(appTaskRel.getTaskList());
            }
            codeNameRelMap = taskList.stream().collect(Collectors.toMap(TaskVO::getCode, TaskVO::getName));
        }

        // 查询任务排序信息
        Query queryUser = new Query();
        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        queryUser.addCriteria(criteria);
        CardOrder cardOrder = mongoTemplateUser.findOne(queryUser, CardOrder.class);

        LanguageUtil.processLocaleLanguage(cardOrder, AthenaUtils.getCurrentLocale());
        if (null != cardOrder) {
            List<TaskTypeOrder> taskTypeOrders = cardOrder.getTaskTypeOrders();
            if (CollectionUtil.isNotEmpty(taskTypeOrders)) {
                // 处理失效的任务信息
                for (TaskTypeOrder taskTypeOrder : taskTypeOrders) {
                    taskTypeOrder.setEffective(true);
                    // 如果任务已经不存在
                    if (!taskCodes.contains(taskTypeOrder.getTaskCode())) {
                        taskTypeOrder.setEffective(false);
                    }
                    // 如果任务的名称发生了变更
                    if (!taskTypeOrder.getTaskName().equals(codeNameRelMap.get(taskTypeOrder.getTaskCode()))) {
                        taskTypeOrder.setEffective(false);
                    }
                }
            }
        }

        Map<String, Object> result = new HashMap<>();
        result.put("appTaskRelList", appTaskRelList);
        result.put("cardOrder", cardOrder);
        return result;
    }

    @Override
    public Object postSaveTaskOrder(CardOrder cardOrder) throws DWBusinessException {

        if (null == cardOrder.getEnabled() && CollectionUtil.isEmpty(cardOrder.getTaskTypeOrders())) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        queryUser.addCriteria(criteria);
        Update update = new Update();
        if (null != cardOrder.getEnabled()) {
            update.set("enabled", cardOrder.getEnabled());
        }
        if (CollectionUtil.isNotEmpty(cardOrder.getTaskTypeOrders())) {
            update.set("taskTypeOrders", cardOrder.getTaskTypeOrders());
        }

        UpdateResult updateResult = mongoTemplateUser.upsert(queryUser, update, CardOrder.class);
        String cacheKey = REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + ":*";
        try {
            cacheService.deleteWithPattern(cacheKey);
        } catch (Exception e) {
            log.error("delete redis fail:", e);
        }
        return updateResult.getModifiedCount();
    }

    @Override
    public Object getDeleteTaskOrder() throws DWBusinessException {

        Query queryUser = new Query();
        Criteria criteria = Criteria.where("tenantId").is(AthenaUtils.getTenantId());
        queryUser.addCriteria(criteria);
        Update update = new Update();
        update.set("taskTypeOrders", new ArrayList<>());
        UpdateResult updateResult = mongoTemplateUser.upsert(queryUser, update, CardOrder.class);
        String cacheKey = REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + AthenaUtils.getTenantId() + ":*";
        try {
            cacheService.deleteWithPattern(cacheKey);
        } catch (Exception e) {
            log.error("delete redis fail:", e);
        }
        return updateResult.getModifiedCount();
    }


    @Override
    public Object getTaskOrderStatus() throws DWBusinessException {

        Query queryUser = new Query();
        Criteria criteria = Criteria.where("tenantId").is(AthenaUtils.getTenantId());
        queryUser.addCriteria(criteria);
        CardOrder cardOrder = mongoTemplateUser.findOne(queryUser, CardOrder.class);
        if (null == cardOrder) {
            return false;
        }
        return cardOrder.getEnabled();
    }

    @Override
    public Object getTaskOrder() throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteria = Criteria.where("tenantId").is(AthenaUtils.getTenantId());
        queryUser.addCriteria(criteria);
        CardOrder cardOrder = mongoTemplateUser.findOne(queryUser, CardOrder.class);
        if (null == cardOrder || CollectionUtil.isEmpty(cardOrder.getTaskTypeOrders())) {
            return null;
        }
        return cardOrder.getTaskTypeOrders();
    }

    @Override
    public Object getTenantApplications() throws Exception {
        //step1 根据租户id查询到所有的appcode
        //从应用mongo中查询
        AppRelationVO appRelationVO = new AppRelationVO();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        // 查询当前租户授权的应用
        List<String> authApps = tenantService.getAppCodes();
        if (CollectionUtil.isNotEmpty(authApps)) {
            // 查询应用信息
            List<Application> apps = dataPickService.find(Criteria.where("code").in(authApps), Application.class, "application");
            List<AppTaskRel> appTaskRelList = new ArrayList<>();
            apps.forEach(e -> {
                AppTaskRel appTaskRel = new AppTaskRel();
                appTaskRel.setCode(e.getCode());
                appTaskRel.setName(e.getName());
                appTaskRel.setLang(e.getLang());
                appTaskRelList.add(appTaskRel);
            });
            LanguageUtil.processLocaleLanguage(appTaskRelList, AthenaUtils.getCurrentLocale());
            appRelationVO.setAppTaskRelList(appTaskRelList);
        }


        // 先找出租户维护的数据
        Query queryUser = new Query();
        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        queryUser.addCriteria(criteria);
        CardOrder cardOrder = mongoTemplateUser.findOne(queryUser, CardOrder.class);

        if (cardOrder != null && CollectionUtil.isNotEmpty(cardOrder.getTaskTypeOrders())) {
            List<String> customTaskCodes = cardOrder.getTaskTypeOrders().stream().map(e -> e.getTaskCode()).collect(Collectors.toList());
            LanguageUtil.processLocaleLanguage(cardOrder, AthenaUtils.getCurrentLocale());
            List<ApplicationRelation> taskRelations = appService.getApplicationByTypeAndCode("task", customTaskCodes);
            List<String> relationTaskCodes = taskRelations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());

            cardOrder.getTaskTypeOrders().forEach(e -> {
                e.setEffective(true);
                if (!relationTaskCodes.contains(e.getTaskCode())) {
                    e.setEffective(false);
                }
            });
        }
        appRelationVO.setCardOrder(cardOrder);
        return appRelationVO;
    }

    @Override
    public Object getTenantTasksByAppCode(String code) throws Exception {

        //step1 根据租户id查询到所有的appcode
        //从应用mongo中查询
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        // 查询当前租户授权的应用
        List<String> authApps = tenantService.getAppCodes();
        if (CollectionUtil.isEmpty(authApps)) {
            return null;
        }
        if (authApps.contains(code)) {
            Application app = new Application();
            List<Application> apps = mongoTemplate.find(Query.query(Criteria.where("code").in(code).and("version").is(tenantVersion)), Application.class);
            if (apps.isEmpty()) {
                return null;
            } else {
                app = apps.get(0);
            }

            List<ApplicationRelation> taskRelations = appService.getApplicationRelationByTypeAndAppCode(tenantId,"activity", code);
            if (CollectionUtil.isEmpty(taskRelations)) {
                return null;
            }
            List<String> taskCodes = taskRelations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
            Map<String, Object> query = MapUtil.of("code", taskCodes);
            List<Map<String, Object>> tasks = dataMapService.postCardConfig4Order(query);

            Map<String, ApplicationRelation> taskRelationsMap = new HashMap<>();
            taskRelations.forEach(applicationRelation -> {
                taskRelationsMap.put(applicationRelation.getCode(), applicationRelation);
            });

            if (!tasks.isEmpty()) {
                // 任务添加应用信息
                AppTaskRel appTaskRel = new AppTaskRel();
                appTaskRel.setCode(app.getCode());
                appTaskRel.setName(app.getName());
                appTaskRel.setLang(app.getLang());
                List<TaskVO> taskList = new ArrayList<>();
                appTaskRel.setTaskList(taskList);
                for (Map<String, Object> task : tasks) {
                    TaskVO taskVO = new TaskVO();
                    taskVO.setCode(task.get("code").toString());
                    taskVO.setName(task.get("name").toString());
                    taskVO.setLang((Map) task.get("lang"));
                    taskList.add(taskVO);
                }
                LanguageUtil.processLocaleLanguage(appTaskRel, AthenaUtils.getCurrentLocale());
                return appTaskRel;
            }
        }

        return null;
    }

    @Override
    public Object postCardConfigByType(CardConfigQueryDTO cardConfigQueryDTO) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<String> codes = cardConfigQueryDTO.getCodes();
        WSPageCode wsPageCode = getWsPageCode(cardConfigQueryDTO.getPageCode());
        if (wsPageCode == null) {
            return null;
        }

        // step0: 查询应用级信息，由于columns
        JSONArray jsonArray = callAppCardConfig(wsPageCode, codes);
        // step1: 租户级别配置 分组/排序/筛选
        List<WorkbenchSettingVO> tenantSetting = getTenantIdSetting(wsPageCode);
        // 一个分组下，一个代理code 只会有一条
        Map<WSConfigType, List<WorkbenchSettingVO>> configTypeListMap =
                tenantSetting.stream().collect(Collectors.groupingBy(WorkbenchSettingVO::getConfigType));
        // 租户级别配置没有则走应用级配置
        List<WSConfigType> needAppConfig = new LinkedList<>();
        // 租户级别配置
        //List<CardConfigDTO> cardConfigByTenant = new ArrayList<>();
        Map<String,CardConfigDTO> orderTenantMap = doHandleTenantConfig(configTypeListMap, needAppConfig, WSConfigType.order);
        Map<String,CardConfigDTO> groupTenantMap = doHandleTenantConfig(configTypeListMap, needAppConfig, WSConfigType.groups);
        Map<String,CardConfigDTO> filterTenantMap =doHandleTenantConfig(configTypeListMap, needAppConfig, WSConfigType.filter);

        // step2: 处理标签 task-code-> 代理code-> 标签配置 先取租户级
        Map<String, Map<String, CardConfigDTO.Config.Label>> cardLabelInfo = labelInfo(cardConfigQueryDTO.getPageCode(),tenantId, tenantVersion);
        // 项目卡/任务卡ID  ---->   代理配置(多个代理code)
        Map<String, List<CardConfigDTO>> summaryFieldsMap = new LinkedHashMap<>();
        Map<String, String> businessMessageSourceMethodMap = new HashMap<>();
        jsonArray.forEach(o -> {
            PageView pageView = JSON.parseObject(JSON.toJSONString(o), PageView.class);
            // 这里处理需要应用级别的数据，不包括标签
            List<CardConfigDTO> cardConfig = new ArrayList<>();
            parseTaskOrProject(orderTenantMap,groupTenantMap,filterTenantMap,
                    cardConfigQueryDTO.getPageCode(), needAppConfig, cardConfig,
                    businessMessageSourceMethodMap,
                    pageView, cardLabelInfo, wsPageCode);
            List<CardConfigDTO> configByCode = summaryFieldsMap.get(pageView.getCode());
            if (configByCode == null) {
                summaryFieldsMap.put(pageView.getCode(), new ArrayList<>());
                configByCode = summaryFieldsMap.get(pageView.getCode());
            }

            configByCode.addAll(cardConfig);
        });

        JSONObject result = new JSONObject();
        for (String code : codes) {
            JSONObject summaryFieldsAndColumns = new JSONObject();
            summaryFieldsAndColumns.put("config", summaryFieldsMap.get(code));
            // summaryFieldsAndColumns.put("columns", columnsMap.get(code));
            result.put(code, summaryFieldsAndColumns);
        }
        //排序
        CardOrder cardOrder = cardConfigQueryDTO.getCardOrder();
        if (cardConfigQueryDTO.isNeedQueryCardOrder()){
            Criteria orderCriteria = Criteria.where("tenantId").is(tenantId);
            Query orderQry = new Query();
            orderQry.addCriteria(orderCriteria);
            cardOrder = mongoTemplateUser.findOne(orderQry, CardOrder.class);
        }
        List<TaskTypeOrder> taskTypeOrders = new ArrayList<>();
        if (null != cardOrder && !CollectionUtil.isEmpty(cardOrder.getTaskTypeOrders())) {
            taskTypeOrders = cardOrder.getTaskTypeOrders();
        }
        result.put("orderRule", taskTypeOrders);
        result.put("businessMessageSourceMethodMap", businessMessageSourceMethodMap);
        return result;
    }

    private void parseTaskOrProject(Map<String,CardConfigDTO> orderTenantMap ,
                                    Map<String,CardConfigDTO> groupTenantMap,
                                    Map<String,CardConfigDTO> filterTenantMap,
                                    String pageCode,
                                    List<WSConfigType> configTypes,
                                    List<CardConfigDTO> cardConfigDTOS,
                                    Map<String, String> businessMessageSourceMethodMap,
                                    PageView pageView,
                                    Map<String, Map<String, CardConfigDTO.Config.Label>> labelInfo,
                                    WSPageCode wsPageCode) {

        if(null!=pageView.getPages() && null!=pageView.getPages().get(pageCode)){
            Map<String,Object> taskcard = (Map<String, Object>) pageView.getPages().get(pageCode);
            List<Map> dataStates = (List<Map>) taskcard.get("dataStates");

            if(null!=dataStates){
                CardConfigDTO empty = new CardConfigDTO();
                empty.setConfig(new CardConfigDTO.Config());
                for(Map map : dataStates){
                    if("all".equals(map.get("type"))){
                        Object taskCardFields = map.get("taskCardFields");
                        String code = pageView.getCode();
                        //卡面业务数据的来源方式
                        String businessMessageSourceMethod = JSON.parseObject(JSON.toJSONString(taskCardFields), JSONObject.class).getString("businessMessageSourceMethod");
                        if ("NON_REAL_TIME".equals(businessMessageSourceMethod)){
                            // 非实时的
                            businessMessageSourceMethodMap.put(code, businessMessageSourceMethod);
                        }
                        List<CardConfigDTO> parse = taskFieldService.taskCardFieldToCardConfig(taskCardFields);
                        // 拿到租户级别代理code
                        Set<String> tenantCode = new HashSet<>();
                        filterTenantMap.forEach((k,v)->{
                            if (v.getConfig().getFilter().getScope().contains(code)){
                                tenantCode.add(k);
                            }
                        });
                        groupTenantMap.forEach((k,v)->{
                            if (v.getConfig().getGroup().getScope().contains(code)){
                                tenantCode.add(k);
                            }
                        });
                        orderTenantMap.forEach((k,v)->{
                            if (v.getConfig().getOrder().getScope().contains(code)){
                                tenantCode.add(k);
                            }
                        });
                        parse.forEach(o->{
                            CardConfigDTO.Config config = o.getConfig();
                            if (config==null){
                                config = new CardConfigDTO.Config();
                            }
                            boolean contains = tenantCode.remove(o.getAliasField());
                            if (!configTypes.contains(WSConfigType.filter)){
                                CardConfigDTO.Config.Data filter = null;
                                if (contains){
                                    CardConfigDTO.Config.Data tenantFilter = filterTenantMap.getOrDefault(o.getAliasField(), empty).getConfig().getFilter();
                                    if (tenantFilter!=null) {
                                        if (tenantFilter.getScope().contains(code)) {
                                            filter = tenantFilter;
                                        }
                                    }
                                }
                                config.setFilter(filter);
                            }
                            if (!configTypes.contains(WSConfigType.order)){
                                CardConfigDTO.Config.Data order = null;
                                if (contains){
                                    CardConfigDTO.Config.Data tenantOrder = orderTenantMap.getOrDefault(o.getAliasField(), empty).getConfig().getOrder();
                                    if (tenantOrder!=null) {
                                        if (tenantOrder.getScope().contains(code)) {
                                            order = tenantOrder;
                                        }
                                    }
                                }
                                config.setOrder(order);
                            }
                            if (!configTypes.contains(WSConfigType.groups)){
                                CardConfigDTO.Config.Data group = null;
                                if (contains){
                                    CardConfigDTO.Config.Data tenantGroup = groupTenantMap.getOrDefault(o.getAliasField(), empty).getConfig().getGroup();
                                    if (tenantGroup!=null) {
                                        if (tenantGroup.getScope().contains(code)) {
                                            group =  tenantGroup;
                                        }
                                    }
                                }
                                config.setGroup(group);
                            }
                            CardConfigDTO.Config.Label label = labelInfo.getOrDefault(pageView.getCode(), new HashMap<>()).get(o.getAliasField());
                            if (label!=null){
                                config.setLabel(label);
                            }
                            if (config.getOrder()!=null || config.getFilter()!=null || config.getColumn()!=null || config.getGroup()!=null || config.getLabel()!=null){
                                cardConfigDTOS.add(o);
                            }
                        });
                        // 说明开发平台关闭，但是租户级还开启
                        if (!tenantCode.isEmpty()){
                            tenantCode.forEach(o->{
                                CardConfigDTO cardConfigDTO = new CardConfigDTO();

                                String aliasField = "";
                                if (orderTenantMap.containsKey(o)){
                                    aliasField = orderTenantMap.get(o).getAliasField();
                                }
                                if (StringUtils.isBlank(aliasField) && groupTenantMap.containsKey(o)){
                                    aliasField = groupTenantMap.get(o).getAliasField();
                                }
                                if (StringUtils.isBlank(aliasField) && filterTenantMap.containsKey(o)){
                                    aliasField = filterTenantMap.get(o).getAliasField();
                                }
                                cardConfigDTO.setAliasField(aliasField);
                                CardConfigDTO.Config  config = new CardConfigDTO.Config();
                                cardConfigDTO.setConfig(config);
                                if (orderTenantMap.containsKey(o)){
                                    if (orderTenantMap.get(o).getConfig()!=null){
                                        config.setOrder(orderTenantMap.get(o).getConfig().getOrder());
                                    }
                                }
                                if (groupTenantMap.containsKey(o)){
                                    if (groupTenantMap.get(o).getConfig()!=null){
                                        config.setGroup(groupTenantMap.get(o).getConfig().getGroup());
                                    }
                                }
                                if (filterTenantMap.containsKey(o)){
                                    if (filterTenantMap.get(o).getConfig()!=null){
                                        config.setFilter(filterTenantMap.get(o).getConfig().getFilter());
                                    }
                                }
                                cardConfigDTOS.add(cardConfigDTO);
                            });
                        }
                        break;
                    }
                }
            }
        }
    }

    /**
     * task-code-> 代理code-> 标签配置
     */
    private Map<String, Map<String, CardConfigDTO.Config.Label>> labelInfo(String pageCode,String tenantId, String tenantVersion) {
        String locale = AthenaUtils.getCurrentLocale();
        Criteria mainCriteria = new Criteria()
                .orOperator(
                        Criteria.where("tenantId").is(com.digiwin.athena.domain.common.Constants.defaultTenantId)
                                .and("version").is(tenantVersion),
                        Criteria.where("tenantId").is(tenantId)
                );
        // 多个or会报错，需重新生成一个
        Criteria criteria = new Criteria();
        addPageCodeCriteria(pageCode,criteria);
        Criteria param = new Criteria();
        param.andOperator(mainCriteria,criteria);
        Query query = Query.query(param);
        List<CardLabel> cardLabels = mongoTemplateUser.find(query, CardLabel.class);
        Map<String, Map<String, CardConfigDTO.Config.Label>> result = new HashMap<>();
        for (CardLabel cardLabel : cardLabels) {
            Map<String, CardConfigDTO.Config.Label> labelMap = result.get(cardLabel.getTaskCode());
            if (labelMap == null) {
                labelMap = new HashMap<>();
                result.put(cardLabel.getTaskCode(), labelMap);
            }
            List<LabelVO> labels = cardLabel.getLabels();
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(labels)) {
                for (LabelVO label : labels) {
                    String code = label.getCode();
                    List<ReturnFieldVO> returnFields = label.getReturnFields();
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(returnFields)){
                        Optional<CardConfigDTO.Config.Label.Style> styleOptional = returnFields.stream().map(o -> {
                            CardConfigDTO.Config.Label.Style style1 = new CardConfigDTO.Config.Label.Style();
                            if (o.getStyle() != null) {
                                style1.setColor(o.getStyle().getColor());
                            }
                            return style1;
                        }).findFirst();
                        if (styleOptional.isPresent()){
                            CardConfigDTO.Config.Label.Style style1 = styleOptional.get();
                            try {
                                LanguageUtil.processLocaleLanguage(label,locale);
                            } catch (IllegalAccessException | NoSuchFieldException e) {
                                log.error("processLocaleLanguage error, " + label);
                            }
                            CardConfigDTO.Config.Label label1 = new CardConfigDTO.Config.Label();
                            label1.setDefaultEffective(label.isDefaultEffective()?"true":"false");
                            CardConfigDTO.Config.Label.Style style = new CardConfigDTO.Config.Label.Style();
                            label1.setStyle(style);
                            label1.setAliasName(label.getName());
                            label1.setLang(label.getLang());

                            style.setColor(style1.getColor());
                            labelMap.put(code, label1);
                        }
                    }
                }
            }
        }
        return result;
    }

    /**
     * 租户级别数据转换，如果没有租户级别数据，则标记要进行app级别查询
     */
    private Map<String,CardConfigDTO> doHandleTenantConfig(Map<WSConfigType,
            List<WorkbenchSettingVO>> configTypeListMap,
                                                           List<WSConfigType> needAppConfig,
                                                           WSConfigType wsConfigType) {
        List<WorkbenchSettingVO> tenantSetting = configTypeListMap.remove(wsConfigType);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(tenantSetting)) {
            // convert(orderTenantSetting);
            List<CardConfigDTO> cardConfigList = new ArrayList<>();
            // Map<String, List<CardConfigDTO>> aliasFieldMap = cardConfigDTOS.stream().collect(Collectors.groupingBy(CardConfigDTO::getAliasField));
            tenantSetting.forEach(o -> {
                List<WSConditionVO> condition = o.getCondition();
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(condition)){
                    for (WSConditionVO wsCondition : condition) {
                        convertWsCondition(cardConfigList, wsConfigType, wsCondition);
                    }
                }
            });
            return cardConfigList.stream().collect(Collectors.toMap(CardConfigDTO::getAliasField, o->o ,(o1,o2) -> o1));
        } else {
            // 查询应用级别配置
            needAppConfig.add(wsConfigType);
            return new HashMap<>();
        }
    }

    private void convertWsCondition(List<CardConfigDTO> cardConfigDTOS,
                                    WSConfigType wsConfigType,
                                    WSConditionVO wsCondition) {
        if (Boolean.TRUE.equals(wsCondition.getEnable()) && SourceType.customer.equals(wsCondition.getSourceType())) {
            String locale = AthenaUtils.getCurrentLocale();
            //List<CardConfigDTO> exists = aliasFieldMap.get(wsCondition.getAliasCode());
            CardConfigDTO cardConfigDTO = new CardConfigDTO();
            // if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(exists)) {
            //     cardConfigDTO = exists.get(0);
            // }
            String aliasCode = wsCondition.getAliasCode();
            // if (aliasCode.contains("-") && wsConfigType == WSConfigType.groups){
            //     String[] split = aliasCode.split("-");
            //     aliasCode = split[split.length-1];
            // }
            cardConfigDTO.setAliasField(aliasCode);
            //cardConfigDTO.setAliasName(wsCondition.getAliasName());
            CardConfigDTO.Config config = new CardConfigDTO.Config();
            cardConfigDTO.setConfig(config);
            List<ConditionScopeVO> conditionScope = wsCondition.getConditionScope();
            List<String> scopes = new ArrayList<>();
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(conditionScope)){
                scopes.addAll(conditionScope.stream().map(ConditionScopeVO::getCode).collect(Collectors.toList()));
            }
            try {
                LanguageUtil.processLocaleLanguage(wsCondition, locale);
            } catch (IllegalAccessException | NoSuchFieldException e) {
                log.error("processLocaleLanguage error, " + wsCondition);
            }
            if (WSConfigType.filter.equals(wsConfigType)) {
                CardConfigDTO.Config.Data filter = new CardConfigDTO.Config.Data();
                config.setFilter(filter);

                filter.setDefaultEffective("true");
                filter.setDataType(wsCondition.getDataType());
                filter.setAliasName(wsCondition.getAliasName());
                filter.setScope(scopes);
                filter.setLang(wsCondition.getLang());

            } else if (WSConfigType.groups.equals(wsConfigType)) {
                CardConfigDTO.Config.Data group = new CardConfigDTO.Config.Data();
                config.setGroup(group);
                group.setDefaultEffective("true");
                group.setAliasName(wsCondition.getAliasName());
                group.setScope(scopes);
                group.setLang(wsCondition.getLang());

            } else if (WSConfigType.order.equals(wsConfigType)) {
                CardConfigDTO.Config.Data order = new CardConfigDTO.Config.Data();
                config.setOrder(order);
                order.setDefaultEffective("true");
                order.setAliasName(wsCondition.getAliasName());
                order.setScope(scopes);
                order.setLang(wsCondition.getLang());
            }
            cardConfigDTOS.add(cardConfigDTO);
        }
    }

    private WSPageCode getWsPageCode(String pageCode) {
        WSPageCode wsPageCode = null;

        switch (pageCode) {
            case "project-card":
                wsPageCode = WSPageCode.project;
                break;
            case "task-card":
                wsPageCode = WSPageCode.task;
                break;
        }

        return wsPageCode;
    }

    private List<WorkbenchSettingVO> getTenantIdSetting( WSPageCode wsPageCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String cacheKey = REDIS_KNOWLEDGE_GRAPH + ":" + tenantId + ":" + REDIS_WORKBENCHSETTING_CACHE+":"+ wsPageCode  ;
        if (stringRedisTemplate != null){
            String o = stringRedisTemplate.opsForValue().get(cacheKey);
            if (o != null){
                List<WorkbenchSettingVO> workbenchSettings = JSONObject.parseObject(o, new TypeReference<List<WorkbenchSettingVO>>() {
                });
                try {
                    String currentLocale = AthenaUtils.getCurrentLocale();
                    for (WorkbenchSettingVO workbenchSetting : workbenchSettings) {
                        LanguageUtil.processLocaleLanguage(workbenchSetting.getCondition(),currentLocale);
                        LanguageUtil.processLocaleLanguage(workbenchSetting.getDefaultCondition(),currentLocale);
                    }
                } catch (IllegalAccessException | NoSuchFieldException e) {
                    log.error("processLocaleLanguage error,", e);
                }
                return workbenchSettings;
            }
        }
        List<WSConfigType> configTypes = new LinkedList<>();
        configTypes.add(WSConfigType.order);
        configTypes.add(WSConfigType.groups);
        configTypes.add(WSConfigType.filter);
        List<WorkbenchSetting> workbenchTenantSetting = workbenchSettingService.getWorkbenchTenantSetting(wsPageCode, configTypes);
        List<WorkbenchSettingVO> settingVOS = new ArrayList<>();
        settingVOS.addAll(workbenchTenantSetting.stream().map(o -> JSON.parseObject(JSON.toJSONString(o), WorkbenchSettingVO.class)).collect(Collectors.toList()));
        if (WSPageCode.task == wsPageCode) {
            Criteria criteria = Criteria.where("tenantId").is(tenantId);
            Query query = new Query();
            query.addCriteria(criteria);
            CardGroup cardGroup = mongoTemplateUser.findOne(query, CardGroup.class);
            if (cardGroup != null) {
                settingVOS.add(workbenchSettingService.cardGroupToWSConditionVO(cardGroup));
            }
        }
        if (stringRedisTemplate != null){
            stringRedisTemplate.opsForValue().set(cacheKey,JSON.toJSONString(settingVOS, SerializerFeature.DisableCircularReferenceDetect),86400L, TimeUnit.SECONDS);
        }
        return settingVOS;
    }


    private JSONArray callAppCardConfig(WSPageCode pageCode, List<String> codes) {

        HashMap<String, Object> params = new HashMap<>();
        params.put("code", codes);
        params.put("pageCode", pageCode);
        DapResponse dapResponse = dataMapService.requestDataMap("/view/workbenchSetting/configTypes", "post", params);
        JSONArray response = (JSONArray) dapResponse.getResponse();
        if (response==null){
            return new JSONArray();
        }
        return response;
    }



    @Override
    public Object postQueryCondition(CardConditionQueryDTO cardConditionQueryDTO) {
        WSPageCode wsPageCode = getWsPageCode(cardConditionQueryDTO.getPageCode());
        WSConfigType configType = cardConditionQueryDTO.getConfigType();
        WorkbenchSettingVO workbenchSettingVO = workbenchSettingService.getWorkbenchSetting(wsPageCode, configType, false);
        // List<WSConditionVO> defaultCondition = workbenchSettingVO.getDefaultCondition();
        // if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(defaultCondition)) {
        //     workbenchSettingVO.setDefaultCondition(defaultCondition.stream().filter(o -> Boolean.TRUE.equals(o.getEnable())).collect(Collectors.toList()));
        // }
        if (workbenchSettingVO != null){
            if (wsPageCode == WSPageCode.task && configType == WSConfigType.groups){
                List<WSConditionVO> condition = workbenchSettingVO.getCondition();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(condition)){
                    for (WSConditionVO wsConditionVO : condition) {
                        String aliasCode = wsConditionVO.getAliasCode();
                        if(StringUtils.isNotBlank(aliasCode)){
                            aliasCode = aliasCode.replaceAll("\\.","#");
                            wsConditionVO.setAliasCode(aliasCode);
                        }
                        if (BusinessMessageSourceMethod.NON_REAL_TIME != wsConditionVO.getBusinessMessageSourceMethod()) {
                            if (StringUtils.isNotBlank(wsConditionVO.getAppCode())){
                                wsConditionVO.setAliasCode(wsConditionVO.getAppCode()+"-"+aliasCode);
                            }
                        }
                    }
                }
                List<WSConditionVO> defaultCondition = workbenchSettingVO.getDefaultCondition();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(defaultCondition)){
                    for (WSConditionVO wsConditionVO : defaultCondition) {
                        String aliasCode = wsConditionVO.getAliasCode();
                        if(StringUtils.isNotBlank(aliasCode)){
                            aliasCode = aliasCode.replaceAll("\\.","#");
                            wsConditionVO.setAliasCode(aliasCode);
                        }
                        if (BusinessMessageSourceMethod.NON_REAL_TIME != wsConditionVO.getBusinessMessageSourceMethod()) {
                            if (StringUtils.isNotBlank(wsConditionVO.getAppCode())) {
                                wsConditionVO.setAliasCode(wsConditionVO.getAppCode() + "-" + aliasCode);
                            }
                        }
                    }
                }
            }
        }
        return workbenchSettingVO;
    }

    @Override
    @DWLogOperation(desc = "获取页面UI元素")
    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "pageUIElement$0$1$2", language = true,
            tenant = true, ttlSecs = 86400L)
    public Object getPageUIElement(String code, String activityId, String pageCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        return getPageUIElementFromDataMap(code, activityId, pageCode, tenantId);
    }

    @Override
    @DWLogOperation(desc = "根据tenantId获取SystemHooks元素")
    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "systemHooksByTenantId$0$1", language = true,
            tenant = true, ttlSecs = 86400L)
    public Object postSystemHooksByTenantId(String tenantId, List<String> pageCodes) throws Exception {
        List<String> activityIds = appService.getActivityCode(tenantId);
        return getSystemHooksFromDataMap(activityIds, pageCodes);
    }

    @Override
    @DWLogOperation(desc = "获取SystemHooks元素")
    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "systemHooks$0$2", language = true,
            tenant = true, ttlSecs = 86400L)
    public Object postSystemHooks(String md5,List<String> activityIds, List<String> pageCodes) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        return getSystemHooksFromDataMap(activityIds, pageCodes);
    }

    @Override
    public List<TaskCardFieldVO> postViewTaskCardField(TaskCardFieldRequest taskCardFieldRequest){
        return dataMapService.postViewTaskCardField(taskCardFieldRequest);
    }

    @Override
    @DWLogOperation(desc = "获取任务项目的编码和名称")
    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "codeOptions$0",
            tenant = true, ttlSecs = 86400L)
    public List<SemcDictOption> getCodeOptions(String type) throws Exception {
        // 查询当前租户授权的应用
        List<String> authApps = tenantService.getAppCodes();
        List<SemcDictOption> dictOptionList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(authApps)) {
            return dictOptionList;
        }
        String tenantId = AthenaUtils.getTenantId();
        // 获取租户版本
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<ApplicationRelation> taskRelations = null;
        boolean isTask = false;
        if("groupByTaskType".equals(type)){
             isTask = true;
             // 查询任务需要顺便查询项目卡的code用来查询neo4j的任务卡
            taskRelations = appService.getApplicationRelationByTypeAndAppCode("task", authApps);
            taskRelations.addAll(appService.getApplicationRelationByTypeAndAppCode("activity", authApps));
             // 查询流程引擎的任务定义
        }else if("groupByProjectType".equals(type)){
            taskRelations = appService.getApplicationRelationByTypeAndAppCode("task", authApps);
        }
        if(null == taskRelations || taskRelations.isEmpty()){
            return dictOptionList;
        }
        Set<String> set = new HashSet<>();
        if(isTask){
            // 根据类型分组
            Map<String, List<ApplicationRelation>> typeToRelationsMap = taskRelations.stream().collect(Collectors.groupingBy(ApplicationRelation::getType));
            // 查询流程引擎的活动定义，由于流程引擎的的任务在ApplicationRelation不存在，需要通过项目的code查找
            List<ApplicationRelation> task = typeToRelationsMap.get("task");
            if(!CollectionUtils.isEmpty(task)){
                List<Map<String, Object>> taskList = getTaskAndActivityData(isTask,task,tenantId,tenantVersion);
                addDictOptionList(taskList,dictOptionList,set);
            }
            taskRelations = typeToRelationsMap.get("activity");
        }else {
            List<Map<String, Object>> taskList = getTaskAndActivityData(isTask,taskRelations,tenantId,tenantVersion);
            addDictOptionList(taskList,dictOptionList,set);
            // 过滤掉查询流程的项目
            taskRelations = taskRelations.stream().filter(e->!set.contains(e.getCode())).collect(Collectors.toList());
        }
        if(taskRelations==null || CollectionUtils.isEmpty(taskRelations)){
            return dictOptionList;
        }
        // 获取任务或项目名称和编码
        List<Map<String, Object>> codeNameList = dataMapService.getCodeNames(taskRelations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList()), isTask);
        if(!CollectionUtils.isEmpty(codeNameList)){
            addDictOptionList(codeNameList,dictOptionList,set);
        }
        return dictOptionList;
    }

    /**
     * 获取任务和项目的neo4j的定义名称
     * @param isTask
     * @param applicationRelationList
     * @param tenantId
     * @param tenantVersion
     * @return
     */
    private  List<Map<String, Object>> getTaskAndActivityData(boolean isTask,List<ApplicationRelation> applicationRelationList,String tenantId,String tenantVersion){
        if(null == applicationRelationList || applicationRelationList.isEmpty()){
            return Collections.emptyList();
        }
        List<String> codes = applicationRelationList.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
        List<List<String>> lists = Utils.spliceArrays(codes, 500);
        List<Map<String, Object>> taskList = com.google.common.collect.Lists.newArrayListWithExpectedSize(codes.size());
        for (List<String> list : lists) {
            List<Map<String, Object>> splitTaskData = isTask?taskRepository.getTaskByProjectCodes(tenantId, tenantVersion,list):taskRepository.getProjectByProjectCodes(tenantId, tenantVersion,list);
            if(!CollectionUtils.isEmpty(splitTaskData)){
                taskList.addAll(splitTaskData);
            }
        }
        return taskList;
    }


    /**
     * 数据转换并添加到返回对象中
     * @param dataList
     * @param dictOptionList
     * @param codes
     */
    private void addDictOptionList(List<Map<String, Object>> dataList, List<SemcDictOption> dictOptionList, Set<String> codes){
        dataList.forEach(e->{
            SemcDictOption option = new SemcDictOption();
            String code = MapUtils.getString(e, "code");
            if(codes.add(code)){
                // 只取name的国际化
                Map<String, Map<String, String>> lang = (Map<String, Map<String, String>>) e.get("lang");
                if(lang != null){
                    Map<String, String> nameMap = lang.get("name");
                    if(MapUtils.isNotEmpty(nameMap)){
                        Map<String, Map<String, String>> nameLang = new HashMap<>();
                        nameLang.put("name",nameMap);
                        option.setLang(nameLang);
                    }
                }
                option.setName(MapUtils.getString(e,"name"));
                option.setCode(MapUtils.getString(e,"code"));
                dictOptionList.add(option);
            }
        });
    }

    /**
     * 获取租户级分组配置
     * @return
     * @throws DWBusinessException
     */
    @Override
    public List<SemcDictOption> getTenantGroupConfigCode() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        Query query = new Query();
        query.addCriteria(criteria);
        CardGroup cardLabel = mongoTemplateUser.findOne(query, CardGroup.class);
        if(cardLabel == null){
           return null;
        }
        if(BooleanUtils.isTrue(cardLabel.getEnabled())){
            SystemGroup system = cardLabel.getSystem();
            List<SemcDictOption> codes = com.google.common.collect.Lists.newArrayList();
            if(system != null){
                List<CardGroupGroup> groups = system.getGroups();
                if(!CollectionUtils.isEmpty(groups)){
                    groups.forEach(e->{
                        boolean isAdd;
                        Boolean commonEnable = e.getCommonEnable();
                        if(commonEnable != null){
                            isAdd = commonEnable && e.isEnabled();
                        }else {
                            isAdd = e.isEnabled();
                        }
                        if(isAdd){
                            SemcDictOption semcDictOption = new SemcDictOption();
                            semcDictOption.setName(e.getName());
                            Map<String, Map<String, String>> lang = e.getLang();
                            // 目前定义都是aliasName，为了通用修改成name
                            if(lang != null){
                                lang.put("name",lang.get("aliasName"));
                            }
                            semcDictOption.setType("system");
                            semcDictOption.setLang(lang);
                            semcDictOption.setCode(e.getCode());
                            semcDictOption.setName(e.getName());
                            codes.add(semcDictOption);
                        }
                    });
                }
            }
            return codes;
        }
        return null;
    }

    @Override
    public Object postDataEntryAndReportByAppCode(String appCode, String pattern) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<String> activityCodes = dataPickService.tenantProductCodes("activity", Lists.newArrayList(appCode));
        List<Activity> activities = activityDAO.getActivitiesByPattern(tenantId, pattern, tenantVersion, activityCodes);
        activities = dataPickService.excludeWithSameCode(activities);
        // 如果是业务数据录入的，查询该作业是否是客制的页面
        if("DATA_ENTRY".equals(pattern) && org.apache.commons.collections.CollectionUtils.isNotEmpty(activities)){
            for (Activity activity : activities) {
                Object activityDefinition = this.getActivityDefinition(activity.getCode(), "basic-data");
                if (activityDefinition == null) {
                    log.error("postDataEntryAndReportByAppCode not found Definition appCode:" + appCode + " ,code:" + activity.getCode());
                    continue;
                }
                JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(activityDefinition));
                JSONObject pages = jsonObject.getJSONObject("pages");
                Boolean isCustomize = Objects.nonNull(pages) ? pages.getBoolean("isCustomize") : null;
                if (Objects.isNull(isCustomize) && "CUSTOM".equals(jsonObject.getString("pattern"))) {
                    isCustomize = true;
                }
                activity.setIsCustomize(isCustomize);
            }
        }
        return activities;
    }

    @Override
    public Object postTaskList(Map<String, Object> query) throws Exception {
        List taskList = dataMapService.getTaskList(query);
        // 查询该任务是否是客制的页面
//        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(taskList)){
//            List<Activity> activities = JSON.parseArray(JSON.toJSONString(taskList), Activity.class);
//            for (Activity activity : activities) {
//                Object activityDefinition = this.getActivityDefinition(activity.getCode(), "task-detail");
//                if (activityDefinition == null) {
//                    log.error("postTaskList not found Definition appCode:" + activity.getApplication() + " ,code:" + activity.getCode());
//                    continue;
//                }
//                JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(activityDefinition));
//                JSONObject pages = jsonObject.getJSONObject("pages");
//                Boolean isCustomize = Objects.nonNull(pages) ? pages.getBoolean("isCustomize") : null;
//                if (Objects.isNull(isCustomize) && "CUSTOM".equals(jsonObject.getString("pattern"))) {
//                    isCustomize = true;
//                }
//                activity.setIsCustomize(isCustomize);
//            }
//            return activities;
//        }
        return taskList;
    }

    @Override
    public Object postProjectExcludeMainlineByAppCode(String appCode) {
        return dataMapService.projectExcludeMainlineByAppCode(appCode);
    }

    @Override
    public Object postProjectListBasic(Map<String, Object> query) {
        return dataMapService.getProjectsBasic(query);
    }

    @Override
    public Object postProjectList(Map<String, Object> query) {
        return dataMapService.getProjects(query);
    }

    @Override
    public Object postFindTaskFromUser(FindTaskFromUserRequest request) throws Exception {
        log.info("TaskService.postFindTaskFromUser request param={}", JSONObject.toJSONString(request));
        if (Objects.isNull(request) || StringUtils.isEmpty(request.getUserId())) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.httpRequestError"));
        }
        // 调用cac查询用户在当前租户下拥有的应用列表
        List<String> appCodes = cacUtils.getAppAuth(request.getUserId());
        if (CollectionUtils.isEmpty(appCodes)) {
            // 应用列表为空
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appCodesEmpty"));
        }
        // 应用列表不为空，结合请求参数findTaskFromUser，调用dataMap按条件分页查询人工任务类型列表
        Map<String, Object> query = new HashMap<>();
        query.put("tenantId", request.getTenantId());
        query.put("taskDefName", request.getTaskDefName());
        query.put("applicationList", appCodes);
        query.put("executeType", "manual");
        query.put("pageNum", request.getPageNum());
        query.put("pageSize", request.getPageSize());
        // 处理category 传参
        handleRequestCategory(query, request.getCategory());
        Object taskFromUser = dataMapService.findTaskFromUser(query);
        // 组装返回数据
        String currentLocale = AthenaUtils.getCurrentLocale();
        return handleFindTaskRespParam(taskFromUser, request, currentLocale);

    }

    /**
     * 处理请求参数的includeCategoryList和excludeCategoryList字段
     * @param query
     * @param category
     */
    private void handleRequestCategory(Map<String, Object> query, List<String> category) {
        if (CollectionUtils.isEmpty(category)) {
            // 全都不选，不做处理
            return;
        }
        // OTHER:表示其他任务,APPROVAL:签核任务,SOLVE:异常排除任务,REPLY:回复任务,PROCESS:通用人工任务,DATA_ENTRY:表单任务
        // 兼容驱动2.0 ManualApprove表示签核任务、ManualExecution表示通用人工任务
        List<String> categoryList = Stream.of("APPROVAL", "SOLVE", "REPLY", "PROCESS", "DATA_ENTRY").collect(Collectors.toList());
        List<String> drivenCategory = new ArrayList<>();
        if (category.contains("OTHER")) {
            categoryList.removeAll(category);
            query.put("excludeCategoryList", categoryList);
            // 处理驱动2.0的category
            handleDrivenCategory(drivenCategory, categoryList);
        } else {
            query.put("includeCategoryList", category);
            // 处理驱动2.0的category
            handleDrivenCategory(drivenCategory, category);
        }
        query.put("drivenCategory", drivenCategory);
    }

    private FindTaskFromUserResp handleFindTaskRespParam(Object taskFromUser, FindTaskFromUserRequest request, String currentLocale) {
        if (Objects.isNull(taskFromUser)) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), 0L);
        }
        DataMapFindTaskResp dataMapFindTaskResp = JSONObject.parseObject(JSONObject.toJSONString(taskFromUser), DataMapFindTaskResp.class);
        if (Objects.isNull(dataMapFindTaskResp)) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), 0L);
        }
        if (CollectionUtils.isEmpty(dataMapFindTaskResp.getData())) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), dataMapFindTaskResp.getTotal());
        }
        List<FindTaskFromUserVO> data = new ArrayList<>();
        for (DataMapTaskVO dataMapTaskVO : dataMapFindTaskResp.getData()) {
            FindTaskFromUserVO vo = new FindTaskFromUserVO();
            vo.setTaskDefName(dataMapTaskVO, currentLocale);
            vo.setTaskDefCode(dataMapTaskVO.getCode());
            vo.setApplication(dataMapTaskVO.getApplication());
            // 如果category的值为DATA_ENTRY_DRIVEN使用drivenCategory作为业务模型，否则使用category作为业务模型
            vo.setCategory(Objects.equals("DATA_ENTRY_DRIVEN", dataMapTaskVO.getCategory()) ? dataMapTaskVO.getDrivenCategory() : dataMapTaskVO.getCategory());
            data.add(vo);
        }
        // 根据语言选择任务类型名称
        return new FindTaskFromUserResp(data, request.getPageNum(), request.getPageSize(), dataMapFindTaskResp.getTotal());
    }

    /**
     * 处理驱动2.0的category
     * @param drivenCategory
     * @param category
     */
    private void handleDrivenCategory(List<String> drivenCategory,List<String> category) {
        if (category.contains("APPROVAL")) {
            drivenCategory.add("ManualApprove");
        }
        if (category.contains("PROCESS")) {
            drivenCategory.add("ManualExecution");
        }
    }
}
