package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.targets.TenantIndicatorForest;
import com.digiwin.athena.knowledgegraph.service.ITenantTargetService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import javax.validation.Valid;
import java.util.List;

@Lang
@Service
@Slf4j
public class TenantTargetService implements ITenantTargetService {

    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Override
    public Object deleteIndicatorForest() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId).and("version").is(tenantVersion);
        queryUser.addCriteria(criteriaUser);
        mongoTemplateUser.findAndRemove(queryUser, TenantIndicatorForest.class, "indicatorForest");
        return null;
    }

    @Override
    public Object getIndicatorForest() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId).and("version").is(tenantVersion);
        queryUser.addCriteria(criteriaUser);
        TenantIndicatorForest tenantIndicatorForest = mongoTemplateUser.findOne(queryUser, TenantIndicatorForest.class, "indicatorForest");
        return tenantIndicatorForest;
    }

    @Override
    public Object getIndicatorForests() throws DWBusinessException {
        //String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = "2.0";
        Query query = new Query();
        Criteria criteria = Criteria.where("version").is(tenantVersion);
        query.addCriteria(criteria);
        List<TenantIndicatorForest> tenantIndicatorForests = mongoTemplateUser.find(query, TenantIndicatorForest.class, "indicatorForest");
        return tenantIndicatorForests;
    }

    @Override
    public Object postIndicatorForest(@Valid TenantIndicatorForest tenantIndicatorForest) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId).and("version").is(tenantVersion);
        queryUser.addCriteria(criteriaUser);
        mongoTemplateUser.findAndRemove(queryUser, TenantIndicatorForest.class, "indicatorForest");
        tenantIndicatorForest.setTenantId(tenantId);
        tenantIndicatorForest.setVersion(tenantVersion);
        mongoTemplateUser.insert(tenantIndicatorForest, "indicatorForest");
        return null;
    }

}
