package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.constant.SystemWSConditionVO;
import com.digiwin.athena.knowledgegraph.domain.CardPresentConfig;
import com.digiwin.athena.knowledgegraph.domain.WorkbenchSetting;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.domain.task.*;
import com.digiwin.athena.knowledgegraph.enums.SourceType;
import com.digiwin.athena.knowledgegraph.enums.WSConfigType;
import com.digiwin.athena.knowledgegraph.enums.WSPageCode;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.service.ATMCService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IWorkbenchSettingService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.ConditionScopeVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WSConditionVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WorkbenchSettingVO;
import com.digiwin.athena.knowledgegraph.workbenchSetting.CardPresentConfigReq;
import com.digiwin.athena.knowledgegraph.workbenchSetting.WorkbenchSettingSaveRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_KNOWLEDGE_GRAPH;
import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_WORKBENCHSETTING_CACHE;

/**
 * 交付设计器，待办工作台配置
 */
@Lang
@Service
@Slf4j
@MyExceptionHandler
public class WorkbenchSettingService implements IWorkbenchSettingService {

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplate;

    @Autowired
    private KgInnerService kgInnerService;

    @Autowired
    TenantService tenantService;

    @Autowired
    private DataMapService dataMapService;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    private TaskFieldService taskFieldService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private ATMCService atmcService;

    @Override
    public WorkbenchSettingVO getWorkbenchSetting(WSPageCode pageCode, WSConfigType configType,Boolean appCondition) {
        WorkbenchSettingVO workbenchSettingVO;
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        if (pageCode == WSPageCode.task && configType == WSConfigType.groups) {
            workbenchSettingVO = new WorkbenchSettingVO();
            workbenchSettingVO.setTenantId(tenantId);
            workbenchSettingVO.setPageCode(pageCode);
            workbenchSettingVO.setConfigType(configType);
            ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<>();
            List<WSConditionVO> defaultCondition ;
            Criteria criteria = Criteria.where("tenantId").is(tenantId);
            Query query = new Query();
            query.addCriteria(criteria);
            CardGroup cardGroup = mongoTemplateUser.findOne(query, CardGroup.class);
            if (null == cardGroup ) {
                List<CardGroupGroup> cardGroupGroups = taskFieldService.sysCardGroups(tenantId);
                if (CollectionUtil.isNotEmpty(cardGroupGroups)) {
                    List<WSConditionVO> sysConditions = systemCardGroupGroupToCondition(cardGroupGroups);
                    wsConditionVOS.addAll(sysConditions);
                }
                if (Boolean.TRUE.equals(appCondition)) {

                    String tenantVersion = kgInnerService.getTenantVersion(tenantId);
                    //获取租户所有应用的任务
                    List<String> authApps;
                    try {
                        authApps = tenantService.getAppCodes();
                    } catch (DWBusinessException e) {
                        throw new RuntimeException(e);
                    }
                    List<ApplicationRelation> taskRelations = mongoTemplate.find(Query.query(Criteria.where("appCode").in(authApps).and("type").is("activity").and("version").is(tenantVersion)),ApplicationRelation.class);
                    List<String> taskCodes = taskRelations.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
                    Map<String,ApplicationRelation> taskRelationsMap = new HashMap<>();
                    taskRelations.forEach(applicationRelation -> {
                        taskRelationsMap.put(applicationRelation.getCode(), applicationRelation);
                    });

                    Map<String,Object> params = new HashMap<>();
                    params.put("query",query);
                    DapResponse<List> resp = dataMapService.requestDataMap("/view/newCardConfig","post",MapUtil.of("query",MapUtil.of("code",taskCodes)));
                    List<WSConditionVO> appConditions = JSON.parseArray(JSON.toJSONString(resp.getResponse()), WSConditionVO.class);
                    if (CollectionUtil.isNotEmpty(appConditions)) {
                        Map<String, List<WSConditionVO>> conditionMap = appConditions.stream().collect(Collectors.groupingBy(v -> v.getAliasCode()));
                        String currentLocale = AthenaUtils.getCurrentLocale();
                        for (Map.Entry<String, List<WSConditionVO>> entry : conditionMap.entrySet()) {
                            List<WSConditionVO> conditionVOS = entry.getValue();
                            WSConditionVO wsConditionVO = conditionVOS.stream().sorted(Comparator.comparing(WSConditionVO::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).findFirst().get();
                            wsConditionVO.setAppCode(taskRelationsMap.get(wsConditionVO.getTaskCode()).getAppCode());
                            List<ConditionScopeVO> scopeVOList = conditionVOS.stream()
                                    .flatMap(v -> v.getConditionScope().stream())
                                    .distinct()
                                    .sorted(Comparator.comparing(ConditionScopeVO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeVO::getId, Comparator.nullsLast(Comparator.naturalOrder())))
                                    .collect(Collectors.toList());
                            for (ConditionScopeVO conditionScopeVO : scopeVOList) {
                                ApplicationRelation applicationRelation = taskRelationsMap.get(conditionScopeVO.getCode());
                                if (applicationRelation!=null) {
                                    conditionScopeVO.setAppName(applicationRelation.getAppName());
                                    conditionScopeVO.setAppCode(applicationRelation.getAppCode());
                                }
                            }
                            try {
                                LanguageUtil.processLocaleLanguage(scopeVOList,currentLocale);
                            } catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            } catch (NoSuchFieldException e) {
                                throw new RuntimeException(e);
                            }
                            wsConditionVO.setConditionScope(scopeVOList);
                            wsConditionVOS.add(wsConditionVO);
                        }
                    }
                }
                defaultCondition = wsConditionVOS.stream()
                        .filter(v -> Boolean.TRUE.equals(v.getEnable()))
                        .map(v->{
                            WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(v), WSConditionVO.class);
                            if (wsConditionVO.getSourceType() == SourceType.customer) {
                                wsConditionVO.setEnable(false);
                            }
                            return wsConditionVO;
                        })
                        .collect(Collectors.toList());
                workbenchSettingVO.setCondition(wsConditionVOS);
                workbenchSettingVO.setDefaultCondition(defaultCondition);
            }else {
                workbenchSettingVO = cardGroupToWSConditionVO(cardGroup);
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getCondition()) {
                Map<String, Map<String, String>> lang = wsConditionVO.getLang();
                if (lang!=null) {
                    Map<String, String> aliasName = lang.get("aliasName");
                    if (aliasName==null) {
                        wsConditionVO.setLang( MapUtil.of("aliasName",wsConditionVO.getLang().get("name")));
                    }
                }
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getDefaultCondition()) {
                Map<String, Map<String, String>> lang = wsConditionVO.getLang();
                if (lang!=null) {
                    Map<String, String> aliasName = lang.get("aliasName");
                    if (aliasName==null) {
                        wsConditionVO.setLang( MapUtil.of("aliasName",wsConditionVO.getLang().get("name")));
                    }
                }
            }
            String currentLocale = AthenaUtils.getCurrentLocale();
            try {
                LanguageUtil.processLocaleLanguage(workbenchSettingVO.getCondition(),currentLocale);
                LanguageUtil.processLocaleLanguage(workbenchSettingVO.getDefaultCondition(),currentLocale);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            } catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }else {
            Criteria criteria = Criteria.where("tenantId").is(tenantId)
                    .and("pageCode").is(pageCode)
                    .and("configType").is(configType);
            WorkbenchSetting workbenchSetting = mongoTemplateUser.findOne(new Query(criteria), WorkbenchSetting.class);
            if (workbenchSetting == null) {
                workbenchSettingVO = getCardSetting(pageCode, configType,appCondition);
            }else{
                workbenchSettingVO = JSON.parseObject(JSON.toJSONString(workbenchSetting),WorkbenchSettingVO.class);
                //设置新增的创建时间选项（主要是对于库里已有数据）
                addNewCondition(workbenchSettingVO.getCondition());
                addNewCondition(workbenchSettingVO.getDefaultCondition());
            }
            String currentLocale = AthenaUtils.getCurrentLocale();
            try {
                LanguageUtil.processLocaleLanguage(workbenchSettingVO.getCondition(),currentLocale);
                LanguageUtil.processLocaleLanguage(workbenchSettingVO.getDefaultCondition(),currentLocale);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            } catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getCondition()) {
                try {
                    LanguageUtil.processLocaleLanguage(wsConditionVO.getConditionScope(),currentLocale);
                } catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                } catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }

            }
        }
        return workbenchSettingVO;
    }

    /**
     * 设置新增的创建时间选项
     * @param condition
     */
    private void addNewCondition(List<WSConditionVO> condition) {
        if (CollectionUtils.isNotEmpty(condition)){
            List<String> aliasCodes= condition.stream().map(WSConditionVO::getAliasCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(aliasCodes) && !aliasCodes.contains("CREATE_TIME")){
                //库里数据
                WSConditionVO conditionVO = WSConditionVO.builder().sourceType(SourceType.system).aliasName("创建时间").aliasCode("CREATE_TIME").dataType("datetime").enable(true)
                        .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "創建時間").put("en_US", "create time").put("zh_CN", "创建时间").build()).build()).build();
                condition.add(conditionVO);
            }
        }
    }


    public WorkbenchSettingVO cardGroupToWSConditionVO(CardGroup cardGroup){
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        String currentLocale = AthenaUtils.getCurrentLocale();
        WorkbenchSettingVO workbenchSettingVO = new WorkbenchSettingVO();
        workbenchSettingVO.setTenantId(tenantId);
        workbenchSettingVO.setPageCode(WSPageCode.task);
        workbenchSettingVO.setConfigType(WSConfigType.groups);
        ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<>();
        if (!Boolean.FALSE.equals(cardGroup.getEnabled())) {
            SystemGroup system = cardGroup.getSystem();
            if (system!=null) {
                List<CardGroupGroup> groups = system.getGroups();
                if (CollectionUtil.isNotEmpty(groups)) {
                    List<WSConditionVO> sysConditions = systemCardGroupGroupToCondition(groups);
                    wsConditionVOS.addAll(sysConditions);
                }
            }
            List<CardGroupApplication> applications = cardGroup.getApplications();
            if (CollectionUtils.isNotEmpty(applications)) {
                ArrayList<WSConditionVO> appConditionVOS = new ArrayList<>();
                for (CardGroupApplication application : applications) {
                    List<CardGroupTask> tasks = application.getTasks();
                    if (CollectionUtils.isNotEmpty(tasks)) {
                        for (CardGroupTask task : tasks) {
                            try {
                                LanguageUtil.processLocaleLanguage(task,currentLocale);
                            } catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            } catch (NoSuchFieldException e) {
                                throw new RuntimeException(e);
                            }
                            List<CardGroupGroup> groups1 = task.getGroups();
                            if (CollectionUtils.isNotEmpty(groups1)) {
                                for (CardGroupGroup group : groups1) {
                                    WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(group), WSConditionVO.class);
                                    wsConditionVO.setAppCode(application.getAppCode());
                                    wsConditionVO.setTaskCode(task.getCode());
                                    wsConditionVO.setBusinessMessageSourceMethod(task.getBusinessMessageSourceMethod());
                                    wsConditionVO.setTaskName(task.getName());
                                    wsConditionVO.setTaskLang(task.getLang());
                                    wsConditionVO.setAliasCode(group.getCode());
                                    wsConditionVO.setAliasName(group.getName());
                                    wsConditionVO.setSourceType(SourceType.customer);
                                    wsConditionVO.setDefaultEffective(group.isDefaultEffective());
                                    Boolean defaultGroup = group.getDefaultGroup();
                                    if (defaultGroup == null) {
                                        defaultGroup = group.isDefaultEffective();
                                    }
                                    wsConditionVO.setDefaultGroup(defaultGroup);
                                    wsConditionVO.setEnable(group.isEnabled());
                                    wsConditionVO.setCommonEnable(group.getCommonEnable()!=null?group.getCommonEnable():true);
                                    ConditionScopeVO conditionScopeVO = new ConditionScopeVO();
                                    conditionScopeVO.setAppCode(application.getAppCode());
                                    conditionScopeVO.setName(task.getName());
                                    conditionScopeVO.setAppName(application.getAppName());
                                    conditionScopeVO.setCode(task.getCode());
                                    conditionScopeVO.setCardGroupTask(JSON.parseObject(JSON.toJSONString(task),ConditionScopeVO.CardGroupTask.class));
                                    conditionScopeVO.setId(task.getTaskId());
                                    conditionScopeVO.setBusinessMessageSourceMethod(task.getBusinessMessageSourceMethod());
                                    wsConditionVO.setConditionScope(Collections.singletonList(conditionScopeVO));
                                    appConditionVOS.add(wsConditionVO);
                                }
                            }
                        }
                    }
                }
                Map<String, List<WSConditionVO>> conditionMap = appConditionVOS.stream().collect(Collectors.groupingBy(WSConditionVO::getAliasCode,LinkedHashMap::new,Collectors.toCollection(ArrayList::new)));
                for (Map.Entry<String, List<WSConditionVO>> entry : conditionMap.entrySet()) {
                    List<WSConditionVO> conditionVOS = entry.getValue();
                    WSConditionVO wsConditionDTO = conditionVOS.get(0);
                    wsConditionDTO.setConditionScope(conditionVOS.stream()
                            .flatMap(v -> v.getConditionScope().stream())
                            .distinct()
                            .sorted(Comparator.comparing(ConditionScopeVO::getAppName,Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeVO::getId,Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList())
                    );
                    wsConditionVOS.add(wsConditionDTO);
                }
            }
        }else {
            List<CardGroupGroup> cardGroupGroups = taskFieldService.sysCardGroups(tenantId);
            if (CollectionUtil.isNotEmpty(cardGroupGroups)) {
                List<WSConditionVO> sysConditions = systemCardGroupGroupToCondition(cardGroupGroups);
                wsConditionVOS.addAll(sysConditions);
            }
        }
        List<WSConditionVO> defaultCondition = wsConditionVOS.stream()
                .filter(v -> Boolean.TRUE.equals(v.getEnable()))
                .map(v -> {
                    WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(v), WSConditionVO.class);
                    wsConditionVO.setEnable(v.getCommonEnable());
                    return wsConditionVO;
                })
                .collect(Collectors.toList());
        if (defaultCondition.stream().anyMatch(v->v.getSort()!=null)) {
            defaultCondition = defaultCondition.stream().sorted(Comparator.comparing(v->v.getSort(),Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        }
        workbenchSettingVO.setCondition(wsConditionVOS);
        workbenchSettingVO.setDefaultCondition(defaultCondition);
        return workbenchSettingVO;
    }

    private List<WSConditionVO> systemCardGroupGroupToCondition(List<CardGroupGroup> cardGroupGroups){
        List<WSConditionVO> wsConditionVOS = cardGroupGroups.stream().map(v -> {
            WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(v), WSConditionVO.class);
            wsConditionVO.setAliasName(v.getName());
            wsConditionVO.setAliasCode(v.getCode());
            wsConditionVO.setSourceType(SourceType.system);
            wsConditionVO.setDefaultEffective(v.isDefaultEffective());
            Boolean defaultGroup = v.getDefaultGroup();
            if (defaultGroup == null) {
                defaultGroup = v.isDefaultEffective();
            }
            wsConditionVO.setDefaultGroup(defaultGroup);
            wsConditionVO.setEnable(v.isEnabled());
            wsConditionVO.setCommonEnable(v.getCommonEnable() != null ? v.getCommonEnable() : true);
            return wsConditionVO;
        }).collect(Collectors.toList());
        List<WSConditionVO> taskGroupWSConditionVO = SystemWSConditionVO.taskGroupWSConditionVO;
        WSConditionVO groupByMember = taskGroupWSConditionVO.get(0);
        WSConditionVO groupByDepartment = taskGroupWSConditionVO.get(1);
        if (wsConditionVOS.stream().filter(v->v.getAliasCode().equals(groupByMember.getAliasCode())).count()<=0) {
            wsConditionVOS.add(groupByMember);
        }
        if (wsConditionVOS.stream().filter(v->v.getAliasCode().equals(groupByDepartment.getAliasCode())).count()<=0) {
            wsConditionVOS.add(groupByDepartment);
        }
        return wsConditionVOS;
    }

    /**
     * 调用dataMap查询开发平台配置的条件
     * @param pageCode
     * @param configType
     * @param appCondition 是否查应用级别配置
     * @return
     */
    public WorkbenchSettingVO getCardSetting(WSPageCode pageCode, WSConfigType configType,Boolean appCondition) {
        String tenantId;
        List<String> authApps;
        try {
            tenantId = AthenaUtils.getTenantId();
            authApps = tenantService.getAppCodes();
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        WorkbenchSettingVO workbenchSettingVO = new WorkbenchSettingVO();
        workbenchSettingVO.setTenantId(tenantId);
        workbenchSettingVO.setConfigType(configType);
        workbenchSettingVO.setPageCode(pageCode);
        ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<>();
            String tenantVersion = kgInnerService.getTenantVersion(tenantId);
            String type = null;
            if (WSPageCode.task== pageCode){
                type = "activity";
            }else if (WSPageCode.project== pageCode){
                type = "task";
            }
        Query query = Query.query(Criteria.where("appCode").in(authApps)
                .and("type").is(type)
                .and("version").is(tenantVersion));
            query.fields().include("code").include("appName");
//            查询系统级的条件配置
        if (WSPageCode.task== pageCode) {
            if (WSConfigType.filter == configType){
                wsConditionVOS.addAll(SystemWSConditionVO.taskFilterWSConditionVO);
            }else if (WSConfigType.order == configType){
                wsConditionVOS.addAll(SystemWSConditionVO.taskOrderWSConditionVO);
            }
        }else if (WSPageCode.project== pageCode){
            if (WSConfigType.groups == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectGroupWSConditionVO);
            }else if (WSConfigType.filter == configType){
                wsConditionVOS.addAll(SystemWSConditionVO.projectFilterWSConditionVO);
            }else if (WSConfigType.order == configType){
                wsConditionVOS.addAll(SystemWSConditionVO.projectOrderWSConditionVO);
            }
        }
        if (Boolean.TRUE.equals(appCondition)) {
            List<ApplicationRelation> taskRelations = mongoTemplate.find(query,ApplicationRelation.class);
            if (CollectionUtil.isNotEmpty(taskRelations)) {
                Map<String,ApplicationRelation> applicationNameMap = new HashMap<>();
                taskRelations.forEach(applicationRelation -> {
                    applicationNameMap.put(applicationRelation.getCode(), applicationRelation);
                });
                List<String> codeList = taskRelations.stream().map(v -> v.getCode()).distinct().collect(Collectors.toList());
                HashMap<String, Object> params = new HashMap<>();
                params.put("code",codeList);
                params.put("configType", configType);
                params.put("pageCode", pageCode);
                DapResponse dapResponse = dataMapService.requestDataMap("/view/workbenchSetting","post",params);
                JSONArray jsonArray = (JSONArray) dapResponse.getResponse();
                if (!jsonArray.isEmpty()) {
                List<WSConditionVO> customerConditionVOS = jsonArray.toJavaList(WSConditionVO.class);
                    Map<String, List<WSConditionVO>> conditionMap = customerConditionVOS.stream().collect(Collectors.groupingBy(v -> v.getAliasCode()));
                    for (Map.Entry<String, List<WSConditionVO>> entry : conditionMap.entrySet()) {
                        WSConditionVO wsConditionVO;
                        List<WSConditionVO> wsConditionDTOS = entry.getValue();
                        if (wsConditionDTOS.size()>1) {
                            wsConditionVO = wsConditionDTOS.stream().sorted(Comparator.comparing(WSConditionVO::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).findFirst().get();
                            wsConditionVO.setConditionScope(wsConditionDTOS.stream()
                                    .flatMap(v -> v.getConditionScope().stream())
                                    .distinct()
                                    .sorted(Comparator.comparing(ConditionScopeVO::getAppName,Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeVO::getId,Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList())
                            );
                            String dataType = null;
                            for (String s : Arrays.asList("boolean", "date", "select", "string", "number")) {
                                if (wsConditionDTOS.stream().anyMatch(v -> s.equals(v.getDataType()))) {
                                    dataType = s;
                                    break;
                                }
                            }
                            if (dataType!=null) {
                                wsConditionVO.setDataType(dataType);
                            }
                        }else {
                            wsConditionVO = wsConditionDTOS.get(0);
                        }
                        wsConditionVOS.add(wsConditionVO);
                        for (ConditionScopeVO conditionScopeVO : wsConditionVO.getConditionScope()) {
                            ApplicationRelation applicationRelation = applicationNameMap.get(conditionScopeVO.getCode());
                            if (applicationRelation!=null) {
                                conditionScopeVO.setAppCode(applicationRelation.getAppCode());
                                conditionScopeVO.setAppName(applicationRelation.getAppName());
                            }
                        }
                    }

                }
            }
        }
        List<WSConditionVO> defaultCondition = wsConditionVOS.stream()
                .filter(v -> Boolean.TRUE.equals(v.getEnable()))
                .map(v->{
                    WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(v), WSConditionVO.class);
                    if (wsConditionVO.getSourceType() == SourceType.customer) {
                        wsConditionVO.setEnable(false);
                    }
                    return wsConditionVO;
                })
                .collect(Collectors.toList());
        workbenchSettingVO.setDefaultCondition(defaultCondition);
        workbenchSettingVO.setCondition(wsConditionVOS);
        return workbenchSettingVO;
    }

    @Override
    public WorkbenchSettingVO deleteWorkbenchSetting(WSPageCode wsPageCode, WSConfigType wsConfigType) throws Exception {
        WorkbenchSettingVO result;
        if (wsConfigType == WSConfigType.groups && wsPageCode == WSPageCode.task) {
            taskService.getDeleteCardGroup();
            result = getWorkbenchSetting(wsPageCode,wsConfigType,true);
        }else {
            String tenantId;
            try {
                tenantId = AthenaUtils.getTenantId();
            } catch (DWBusinessException e) {
                throw new RuntimeException(e);
            }
            Criteria criteria = Criteria.where("tenantId").is(tenantId)
                    .and("pageCode").is(wsPageCode)
                    .and("configType").is(wsConfigType);
            mongoTemplateUser.remove(new Query(criteria), WorkbenchSetting.class);
            WorkbenchSettingVO workbenchSettingVO = getCardSetting(wsPageCode, wsConfigType,true);
            WorkbenchSetting workbenchSetting = JSON.parseObject(JSON.toJSONString(workbenchSettingVO), WorkbenchSetting.class);
            workbenchSetting.setTenantId(tenantId);
            workbenchSetting.setConfigType(wsConfigType);
            workbenchSetting.setPageCode(wsPageCode);
            result = JSON.parseObject(JSON.toJSONString(saveWorkbenchSetting(workbenchSetting)), WorkbenchSettingVO.class);
            String currentLocale = AthenaUtils.getCurrentLocale();
            try {
                LanguageUtil.processLocaleLanguage(result.getCondition(),currentLocale);
                LanguageUtil.processLocaleLanguage(result.getDefaultCondition(),currentLocale);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            } catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            for (WSConditionVO wsConditionVO : result.getCondition()) {
                try {
                    LanguageUtil.processLocaleLanguage(wsConditionVO.getConditionScope(),currentLocale);
                } catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                } catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    @Override
    public void saveWorkbenchSetting(WorkbenchSettingSaveRequest workbenchSettingSaveRequest) throws DWBusinessException {
        WorkbenchSetting workbenchSetting = JSON.parseObject(JSON.toJSONString(workbenchSettingSaveRequest), WorkbenchSetting.class);
        saveWorkbenchSetting(workbenchSetting);
    }

    private WorkbenchSetting saveWorkbenchSetting(WorkbenchSetting workbenchSetting) throws DWBusinessException {
        WSPageCode pageCode = workbenchSetting.getPageCode();
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        workbenchSetting.setTenantId(tenantId);
        Update update = new Update();
        for (Field field : WorkbenchSetting.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (field.getName().equals("id")) {
                    continue;
                }
                Object value = field.get(workbenchSetting);
                if (value==null) {
                    continue;
                }
                if (value instanceof String) {
                    if (value.equals("")) {
                        continue;
                    }
                }
                update.set(field.getName(),field.get(workbenchSetting));
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        mongoTemplateUser.upsert(new Query(Criteria.where("tenantId").is(tenantId)
                .and("pageCode").is(workbenchSetting.getPageCode())
                .and("configType").is(workbenchSetting.getConfigType())),update,WorkbenchSetting.class);
        stringRedisTemplate.delete(REDIS_KNOWLEDGE_GRAPH + ":" + tenantId  + ":"+ REDIS_WORKBENCHSETTING_CACHE + ":" + pageCode  );
         return workbenchSetting;
    }

    @Override
    public List<WorkbenchSetting> getWorkbenchTenantSetting(WSPageCode pageCode, List<WSConfigType> configTypes) {
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        Criteria criteria = Criteria.where("tenantId").is(tenantId)
                .and("pageCode").is(pageCode)
                .and("configType").in(configTypes);
        // 租户级别
        List<WorkbenchSetting> workbenchSettings = mongoTemplateUser.find(new Query(criteria), WorkbenchSetting.class);
        String currentLocale = AthenaUtils.getCurrentLocale();
        try {
            for (WorkbenchSetting workbenchSetting : workbenchSettings) {
                LanguageUtil.processLocaleLanguage(workbenchSetting.getCondition(),currentLocale);
                LanguageUtil.processLocaleLanguage(workbenchSetting.getDefaultCondition(),currentLocale);
            }

        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return workbenchSettings;

    }

    @Override
    public List<CardPresentConfig> getCardPresentConfig(String pageCode){
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        Criteria criteria = Criteria.where("tenantId").is(tenantId)
                .and("pageCode").is(pageCode);
        // 租户级别
        List<CardPresentConfig> cardPresentConfigs = mongoTemplateUser.find(new Query(criteria), CardPresentConfig.class);

        return cardPresentConfigs;
    }

    @Override
    public void postSaveCardPresentConfig(CardPresentConfigReq cardPresentConfigReq) {
        CardPresentConfig cardPresentConfig = JSON.parseObject(JSON.toJSONString(cardPresentConfigReq),
                CardPresentConfig.class);
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        cardPresentConfig.setTenantId(tenantId);
        Update update = new Update();
        for (Field field : CardPresentConfig.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (field.getName().equals("id")) {
                    continue;
                }
                Object value = field.get(cardPresentConfig);
                if (value==null) {
                    continue;
                }
                if (value instanceof String) {
                    if (value.equals("")) {
                        continue;
                    }
                }
                update.set(field.getName(),field.get(cardPresentConfig));
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        mongoTemplateUser.upsert(new Query(Criteria.where("tenantId").is(tenantId)
                .and("pageCode").is(cardPresentConfigReq.getPageCode())),update,CardPresentConfig.class);

        /**
         * 清理atmc缓存
         */
        String redisKey = "getCardPresentConfigs:" + tenantId + ":" + cardPresentConfigReq.getPageCode();
        atmcService.cacheReset(tenantId,redisKey);
    }



}
