package com.digiwin.athena.knowledgegraph.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class KggDataPickService extends com.digiwin.athena.kmservice.service.DataPickService{

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private CACUtils cacUtils;

    @Autowired
    TenantService tenantService;

    @Autowired
    KgInnerService kgInnerService;

    @Override
    public MongoTemplate systemTemplate() {
        return mongoTemplate;
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return mongoTemplateUser;
    }

    @Override
    public String tenantVersion(String tenantId) {
        return kgInnerService.getTenantVersion(tenantId);
    }

    @Override
    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        List<String> codes = new ArrayList<>();
        try {
            List<ApplicationRelation> relations = relations(app, type);
            if (null != relations) {
                codes = relations.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
            }
        } catch (DWBusinessException e) {
            log.error(e.getMessage(), e);
        }
        return codes;
    }

    public List<ApplicationRelation> relations(String app, String type) throws DWBusinessException {
        String version = tenantVersion();
        Query query = Query.query(Criteria.where("appCode").is(app).and("type").is(type).and("version").is(version));
        return mongoTemplate.find(query, ApplicationRelation.class);
    }

    @Override
    public boolean isTenantCol(Class c) {
        return false;
    }

    @Override
    public boolean isSystemCol(Class c) {
        return false;
    }
}
