package com.digiwin.athena.knowledgegraph.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentStructuredListType;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-01-10 15:45
 **/

@Slf4j
@Service
public class MechanismGraphService {

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired(required=false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactory1;

    @Autowired(required=false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactory2;


    @Autowired
    ObjectMapper objectMapper;

    @Autowired
    private DataPickService dataPickService;

    public String buildMechanismGraph(String code) throws DWBusinessException {

        String nodeId = code;
        String traceId = nodeId;
        Mechanism mechanism = dataPickService.findOneByCondition(Criteria.where("code").is(code), Mechanism.class, "mechanism");
        if(null==mechanism){return null;}
        StringBuilder nodeSb = new StringBuilder();
        StringBuilder linkSb = new StringBuilder();
        List<String>  mc = new ArrayList<>();
        Set<String> nodeIds = new HashSet<>();
        nodeSb.append("create (").append(nodeId).append(":Mechanism:MechanismPart:DTD {")
                .append("nodeId:'").append(nodeId).append("',")
                .append("code:'").append(mechanism.getCode()).append("',")
                .append("name:'").append(mechanism.getName()).append("',")
                .append("composite:'").append(mechanism.getComposite()).append("',")
                .append("paradigmCode:'").append(mechanism.getParadigmCode()).append("',")
                .append("traceId:'").append(traceId).append("'")
                .append("})\r\n");

        Criteria criteria = Criteria.where(ComponentManager.MECHANISM_CODE).is(code).and(ComponentManager.TYPE).is(ComponentStructuredListType.Mechanism);
        ComponentStructuredList components = dataPickService.findOneByCondition(criteria, ComponentStructuredList.class, "componentStructuredList");

        if(null!=components && CollectionUtils.isNotEmpty(components.getComponents())){
            for(StructuredComponentBO principle: components.getComponents()){
                 componentBo(principle,nodeId,traceId,nodeSb,linkSb,mc,nodeIds);
            }
        }

        String cypher = nodeSb.toString()+linkSb.toString();
        System.out.println(cypher);

        try{
            executeCypher(cypher,mc);
        }catch (Exception e){
            String deleteCyhper = "match(ms:MechanismPart{traceId:')"+traceId+"'}) detach delete ms";
            executeCypher(deleteCyhper,null);
            log.error("机制生成图谱失败 回滚:"+traceId);
            throw e;
        }


        return nodeId;
    }


    public boolean existMechanismPart(String nodeId,Set<String> nodeIds){
        if(nodeIds.contains(nodeId)){
            return true;
        }
        String cypher = "match (m:MechanismPart:DTD{nodeId:'"+nodeId+"'}) return m.nodeId";
        Session session = sessionFactory.openSession();
        Result result = session.query(cypher,new HashMap<>());
        return result.iterator().hasNext();
    }

    public String matchCyhper(String parentCode,String code,String name){
        StringBuilder sbtmp1 = new StringBuilder();
        sbtmp1.append("match (").append(parentCode).append(":MechanismPart:DTD{nodeId:'").append(parentCode).append("'})")
                .append(" match (").append(code).append(":MechanismPart:DTD{nodeId:'").append(code).append("'})")
                .append(" create (").append(parentCode).append(")-[:Link{name:'"+name+"'}]->(").append(code).append(")");
        return sbtmp1.toString();
    }

    private String componentBo(StructuredComponentBO bo,String parentId,String traceId, StringBuilder nodeSb, StringBuilder linkSb,List<String>  mc,Set<String> nodeIds ) throws DWBusinessException {
        String nodeId ="MechanismComponent_"+bo.getCode();

        if(existMechanismPart(nodeId,nodeIds)){
            mc.add(matchCyhper(parentId,nodeId,"包含"));
            return nodeId;
        }

        nodeSb.append("create (").append(nodeId).append(":MechanismComponent:MechanismPart:DTD {")
                .append("nodeId:'").append(nodeId).append("',")
                .append("code:'").append(bo.getCode()).append("',")
                .append("name:'").append(bo.getName()==null?bo.getCode():"").append("',")
                .append("type:'").append(bo.getType()).append("',")
                .append("disabled:").append(bo.isDisabled()).append(",")
                .append("traceId:'").append(traceId).append("'")
                .append("})\r\n");
        linkSb.append("create (").append(parentId).append(")-[:Link{name:'包含'}]->(").append(nodeId).append(")\r\n");

        nodeIds.add(nodeId);

        if(ComponentTypeEnum.MechanismDrive == bo.getType()
                || ComponentTypeEnum.MechanismDecision == bo.getType()
                || ComponentTypeEnum.MechanismControl == bo.getType()
                || ComponentTypeEnum.MechanismLimit == bo.getType()
                || ComponentTypeEnum.MechanismAssign == bo.getType()
                || ComponentTypeEnum.MechanismDefault == bo.getType()
        ){
            String logicId = buildMechanismLogic(bo.getCode(),traceId,nodeIds);
            if(null!=logicId){
                mc.add(matchCyhper(nodeId,logicId,"映射"));
            }
        }

        if (CollectionUtils.isNotEmpty(bo.getSubComponents())){
            for(StructuredComponentBO boSub:bo.getSubComponents()){
                componentBo(boSub,nodeId,traceId,nodeSb,linkSb,mc,nodeIds);
            }
        }
        return nodeId;
    }


    public String buildMechanismLogic(String logicCode,String traceId,Set<String> nodeIds) throws DWBusinessException {
        String nodeId="MechanismLogic_"+logicCode;
        if(existMechanismPart(nodeId,nodeIds)){
            return nodeId;
        }
        Criteria criteria = Criteria.where("code").is(logicCode);
        Query query = Query.query(criteria);
        List<MechanismLogic> mechanismLogics = dataPickService.excludeWithSameCode(mongoTemplateSystem.find(query,MechanismLogic.class), MechanismLogic::getCode, MechanismLogic::getSourceLevel);
        MechanismLogic logic = CollectionUtils.isNotEmpty(mechanismLogics) ? mechanismLogics.get(0) : null;
        if(null==logic || logic.getLogic()==null){
            return null;
        }
        if(ComponentTypeEnum.MechanismControl.name().equalsIgnoreCase(logic.getType())){
            ControlAbilityBO bo = convert(logic.getLogic(),ControlAbilityBO.class);
            buildControl(bo,logic,traceId,nodeId);
        }




        return nodeId;
    }

    private String buildControl(ControlAbilityBO bo,MechanismLogic logic,String traceId,String nodeId){

        StringBuilder nodeSb = new StringBuilder();
        StringBuilder linkSb = new StringBuilder();
        List<String>  mc = new ArrayList<>();
        nodeSb.append("create (").append(nodeId).append(":MechanismLogic:MechanismPart:DTD {")
                .append("nodeId:'").append(nodeId).append("',")
                .append("pluginId:'").append(nodeId).append("',")
                .append("code:'").append(logic.getCode()).append("',")
                .append("name:'").append(logic.getName()).append("',")
                .append("application:'").append(logic.getApplication()).append("',")
                .append("type:'").append(logic.getType()).append("',")
                .append("id:'").append(logic.getId()).append("',")
                .append("traceId:'").append(traceId).append("'")
                .append("})\r\n");
        String problemId = uid();
        nodeSb.append("create (").append(problemId).append(":MechanismProblem:MechanismPart:DTD {")
                .append("nodeId:'").append(problemId).append("',")
                .append("pluginId:'").append(nodeId).append("',")
                .append("name:'").append("异常").append("',")
                .append("traceId:'").append(traceId).append("'")
                .append("})\r\n");

        linkSb.append("create (").append(nodeId).append(")-[:Link{name:'处理'}]->(").append(problemId).append(")\r\n");


        String checkNodeId = uid();
        String checkNodeId2 = uid();
        String planNodeId=uid();
        String targetNodeId=uid();
        String activitiesNodeId=uid();
        if(null!=bo.getChoose()){
            SingleStrategyWidget chooseWidget = bo.getChoose();
            CheckWidget checkWidget = chooseWidget.getCondition();
            PlanWidget planWidget = chooseWidget.getPositiveTarget();
            if(null!=checkWidget){
                nodeSb.append("create (").append(checkNodeId).append(":MechanismCheck:MechanismPart:DTD {")
                        .append("nodeId:'").append(checkNodeId).append("',")
                        .append("pluginId:'").append(nodeId).append("',")
                        .append("name:'").append("对比").append("',")
                        .append("traceId:'").append(traceId).append("'")
                        .append("})\r\n");
                nodeSb.append("create (").append(checkNodeId2).append(":MechanismCondition:MechanismPart:DTD {")
                        .append("nodeId:'").append(checkNodeId2).append("',")
                        .append("pluginId:'").append(nodeId).append("',")
                        .append("name:'").append("公式").append("',")
                        .append("type:'").append(checkWidget.getType()).append("',")
                        .append("expression:'").append(checkWidget.getExpression()).append("',")
                        .append("traceId:'").append(traceId).append("'")
                        .append("})\r\n");
                linkSb.append("create (").append(checkNodeId).append(")-[:Link{name:'使用'}]->(").append(checkNodeId2).append(")\r\n");
                linkSb.append("create (").append(checkNodeId).append(")-[:Link{name:'检出'}]->(").append(problemId).append(")\r\n");
            }
            if(null!=planWidget){
                nodeSb.append("create (").append(planNodeId).append(":MechanismActivity:MechanismPart:DTD {")
                        .append("nodeId:'").append(planNodeId).append("',")
                        .append("pluginId:'").append(nodeId).append("',")
                        .append("name:'").append("解决方案").append("',")
                        .append("type:'").append(planWidget.getType()).append("',")
                        .append("traceId:'").append(traceId).append("'")
                        .append("})\r\n");
                linkSb.append("create (").append(planNodeId).append(")-[:Link{name:'解决'}]->(").append(problemId).append(")\r\n");
            }

        }

        nodeSb.append("create (").append(activitiesNodeId).append(":MechanismCheck:MechanismPart:DTD {")
                .append("nodeId:'").append(activitiesNodeId).append("',")
                .append("pluginId:'").append(nodeId).append("',")
                .append("name:'").append("数据").append("',")
                .append("traceId:'").append(traceId).append("'")
                .append("})\r\n");

        linkSb.append("create (").append(checkNodeId).append(")-[:Link{name:'检入'}]->(").append(activitiesNodeId).append(")\r\n");

        if(null!=bo.getCheckSource()){
            SourceWidget sourceWidget = bo.getCheckSource();
            nodeSb.append("create (").append(targetNodeId).append(":MechanismCheck:MechanismPart:DTD {")
                    .append("nodeId:'").append(targetNodeId).append("',")
                    .append("pluginId:'").append(nodeId).append("',")
                    .append("name:'").append("目标").append("',")
                    .append("type:'").append(sourceWidget.getType()).append("',")
                    .append("target:'").append(sourceWidget.getTarget()).append("',")
                    .append("traceId:'").append(traceId).append("'")
                    .append("})\r\n");
            linkSb.append("create (").append(activitiesNodeId).append(")-[:Link{name:'来源'}]->(").append(targetNodeId).append(")\r\n");
            switch (sourceWidget.getType()){
                case "taskSource":
                    String taskId = uid();
                    StringBuilder sbtmp1 = new StringBuilder();
                    sbtmp1.append("match (").append(taskId).append(":Task:DTD{code:'").append(sourceWidget.getTarget()).append("'})")
                            .append(" match (").append(targetNodeId).append(":MechanismCheck:DTD{nodeId:'").append(targetNodeId).append("'})")
                            .append(" create (").append(targetNodeId).append(")-[:Link{name:'映射'}]->(").append(taskId).append(")");
                    mc.add(sbtmp1.toString());

                    break;
                case "project":
                    break;
            }

        }

        if(CollectionUtils.isNotEmpty(bo.getPreActivities())){
            for(int i=0;i<bo.getPreActivities().size();i++){
                ActivityWidget activityWidget = bo.getPreActivities().get(i);
                String aid=uid();
                nodeSb.append("create (").append(aid).append(":MechanismActivity:MechanismPart:DTD {")
                        .append("nodeId:'").append(aid).append("',")
                        .append("pluginId:'").append(nodeId).append("',")
                        .append("type:'").append(activityWidget.getType()).append("',")
                        .append("name:'").append(activityWidget.getName()==null?"部件":activityWidget.getName()).append("',")
                        .append("traceId:'").append(traceId).append("'")
                        .append("})\r\n");
                linkSb.append("create (").append(activitiesNodeId).append(")-[:Link{name:'依赖',seq:").append(i).append("}]->(").append(aid).append(")\r\n");
                if(null!=activityWidget.getTemplateCode()){
                    String tmid=uid();
                    StringBuilder sbtmp1 = new StringBuilder();
                    sbtmp1.append("match (").append(tmid).append(":MechanismActivity{code:'").append(activityWidget.getTemplateCode()).append("'})")
                            .append(" match (").append(aid).append(":MechanismActivity:DTD{nodeId:'").append(aid).append("'})")
                            .append(" create (").append(aid).append(")-[:Link{name:'映射'}]->(").append(tmid).append(")");
                    mc.add(sbtmp1.toString());
                }
            }

        }




        String cypher = nodeSb.toString()+linkSb.toString();
        System.out.println(cypher);

        executeCypher(cypher,mc);

        return nodeId;
    }



    private void executeCypher(String cypher,List<String> mc){
        Session session1 = null;
        Session session2 = null;
        if(null!=sessionFactory1){
            session1= sessionFactory1.openSession();
            session1.query(cypher,new HashMap<>());
            if(null!=mc){
                for(String str : mc){
                    session1.query(str,new HashMap<>());
                }
            }
        }
        if(null!=sessionFactory2){
            session2= sessionFactory2.openSession();
            session2.query(cypher,new HashMap<>());
            if(null!=mc){
                for(String str : mc){
                    session2.query(str,new HashMap<>());
                }
            }
        }
    }


    public <T> T convert(Object obj,Class<T> c){
        T t = objectMapper.convertValue(obj,c);
        return t;
    }

    public static String uid(){
        return "node"+UUID.randomUUID().toString().replaceAll("-","");
    }

}
