package com.digiwin.athena.knowledgegraph.service.model;

import com.digiwin.athena.domain.common.HierarchicalEntity;
import lombok.Data;

import java.util.Map;

@Data
public class ActivityTemplate extends HierarchicalEntity {
    /**
     * 唯一键
     */
    private String uniqueId;

    /**
     * 模板关系类型   SYSTEM/TENANT_COPY/SYSTEM_EDIT
     */
    private String type;

    private String originId;

    private String sourceId;
    /**
     * 应用ID
     */
    private String application;
    /**
     * 活动ID
     */
    private String activityId;

    /**
     * 任务 BUSINESS_PERFORM  项目 BUSINESS_CHARGE   基础资料  DATA_ENTRY_PERFORM
     */
    private String pattern;
    /**
     * 模板code
     */
    private String code;

    /**
     * 客户端类型  APP  WEB
     */
    private String client;
    /**
     * 模板ID
     */
    private String templateId;
    /**
     * 租户版本
     */
    private String version;
    /**
     * adp数据源类型
     */
    private String adpDataSourceType;
    /**
     * adp数据源ID
     */
    private String adpDataSourceId;
    /**
     * 雅典娜空间名
     */
    private String athena_namespace;
    /**
     * 是否为公共应用
     */
    private Boolean commonApp;
    /**
     * 编译版本
     */
    private String compileVersion;

    /**
     * 模板启用状态 0 未启用  1 启用
     */
    private Integer status;
    /**
     * 本地语言
     */
    private String locale;
    /**
     * 模板名称
     */
    private String name;
    /**
     * 创建时间
     */
    private String createDate;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 修改时间
     */
    private String editDate;
    /**
     * 修改人
     */
    private String editBy;

    public String entityBizCode() {
        return uniqueId;
    }

}
