package com.digiwin.athena.knowledgegraph.service.model;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @Author QinQiang
 * @Description
 * @Date 2024/3/6
 **/
@Data
public class EmailTemplateReq {
    /**
     * 邮件id
     */
    private Long emailId;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 归属哪个应用
     */
    private String appCode;
    /**
     * 模板适配的任务list
     */
    private List<Map<String, String>> activityList;
    /**
     * 邮件名称
     */
    private JSONObject emailName;
    /**
     * 邮件描述
     */
    private JSONObject description;
    /**
     * 邮件类型 1：任务开始，2：任务结束，3：项目卡创建，4：项目卡结案
     */
    private int type;
    /**
     * 邮件状态；2-已失效，1-使用中；0-已停用
     */
    private int state;
    /**
     * 邮件模板更新人
     */
    private String updateBy;
    /**
     * 邮件模板更新时间
     */
    private String updateTime;
    /**
     * 邮件模板预览id，对应的是中间件api---/api/emc/v1/notices/settings的入参 事件id
     */
    private String previewId;
    /**
     * 接收人
     */
    private List<String> receiveStaff;
    /**
     * 邮件模板语言别
     */
    private String langName;
}
