package com.digiwin.athena.knowledgegraph.set;

import com.digiwin.athena.set.part.EmailNoticeTimingEnum;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import lombok.Getter;

/**
 * @Author QinQiang
 * @localeription
 * @Date 2024/3/7
 **/
@Getter
public enum EmailEventIdEnum {

    /**
     * 业务过程随心控任务发起事件通知，各语系
     */
    TASK_BEGIN_NOTICE_ZH_CN(EmailNoticeTimingEnum.TASK_BEGIN.getCode(), "zh_CN","ATHENA_HEART_CONTROL_TASK_BEGIN_NOTI_ZH_CN"),
    TASK_BEGIN_NOTICE_ZH_TW(EmailNoticeTimingEnum.TASK_BEGIN.getCode(),"zh_TW","ATHENA_HEART_CONTROL_TASK_BEGIN_NOTI_ZH_TW"),
    TASK_BEGIN_NOTICE_EN_US(EmailNoticeTimingEnum.TASK_BEGIN.getCode(),"en_US","ATHENA_HEART_CONTROL_TASK_BEGIN_NOTI_EN_US"),

    /**
     * 业务过程随心控任务完成事件通知，各语系
     */
    TASK_END_NOTICE_ZH_CN(EmailNoticeTimingEnum.TASK_END.getCode(),"zh_CN","ATHENA_HEART_CONTROL_TASK_END_NOTI_ZH_CN"),
    TASK_END_NOTICE_ZH_TW(EmailNoticeTimingEnum.TASK_END.getCode(),"zh_TW","ATHENA_HEART_CONTROL_TASK_END_NOTI_ZH_TW"),
    TASK_END_NOTICE_EN_US(EmailNoticeTimingEnum.TASK_END.getCode(),"en_US","ATHENA_HEART_CONTROL_TASK_END_NOTI_EN_US"),

    /**
     * 业务过程随心控项目完结事件通知，各语系
     */
    PROJECT_END_NOTICE_ZH_CN(EmailNoticeTimingEnum.PROJECT_END.getCode(),"zh_CN","ATHENA_HEART_CONTROL_PROJECT_END_NOTI_ZH_CN"),
    PROJECT_END_NOTICE_ZH_TW(EmailNoticeTimingEnum.PROJECT_END.getCode(),"zh_TW","ATHENA_HEART_CONTROL_PROJECT_END_NOTI_ZH_TW"),
    PROJECT_END_NOTICE_EN_US(EmailNoticeTimingEnum.PROJECT_END.getCode(),"en_US","ATHENA_HEART_CONTROL_PROJECT_END_NOTI_EN_US");

    private final String timing;
    private final String locale;
    private final String emailEventId;


    private static final Table<String, String, String> table = HashBasedTable.create();

    static {
        for (EmailEventIdEnum e : EmailEventIdEnum.values()) {
            table.put(e.getTiming(), e.getLocale(), e.getEmailEventId());
        }
    }

    EmailEventIdEnum(String timing, String locale, String emailEventId) {
        this.timing = timing;
        this.locale = locale;
        this.emailEventId = emailEventId;
    }

    public static String getEmailEventId(String timing, String locale) {
        return table.get(timing, locale);
    }
}
