package com.digiwin.athena.knowledgegraph.set;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.set.partParsers.monitorRule.IMonitorRulePartParser;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.part.Part;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class PartParserService {

    @Autowired
    private List<IPartParser> partParsers;

    @Autowired
    private List<IMonitorRulePartParser> monitorRulePartParsers;

    @Autowired
    private List<IOperateParser> operateParsers;


    public void parsePart(SetParseContext context, Part part) throws DWBusinessException {

        for(IPartParser parser: partParsers){
            if(parser.accept(part)){
                parser.parse(context, part);
                return;
            }
        }
        throw new DWBusinessException("没有找到对应的PartParser:" + part);
    }

    public void parseMonitorRulePart(MonitorRule monitorRule, Sets sets) throws DWBusinessException {

        for(IMonitorRulePartParser parser: monitorRulePartParsers){
            if(parser.accept(sets.getS().getPart())){
                parser.parse(monitorRule, sets);
                return;
            }
        }
        throw new DWBusinessException("没有找到对应的MonitorRulePartParser:" + sets.getS().getPart());
    }

    public void parseOperatePart(SetParseContext context, Part part) throws DWBusinessException {

        for(IOperateParser parser: operateParsers){
            if(parser.accept(context)){
                parser.parse(context, part);
                return;
            }
        }
        throw new DWBusinessException("没有找到对应的OperateParser:" + part);
    }
}
