package com.digiwin.athena.knowledgegraph.set.partParsers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.constant.SmartAdjustConstants;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.KgService;
import com.digiwin.athena.knowledgegraph.set.*;
import com.digiwin.athena.knowledgegraph.set.partParsers.enums.DetectType;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.Step;
import com.digiwin.athena.set.part.*;
import com.digiwin.athena.set.serviceComposer.InputParameters;
import com.digiwin.athena.set.serviceComposer.ServiceComposer;
import com.digiwin.athena.set.serviceComposer.ServiceComposerLink;
import com.digiwin.athena.set.serviceComposer.ServiceComposerTask;
import io.seata.common.util.CollectionUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @title: DataUnderstandingPartParser

 * @author: linc
 * @date 2023/10/14 15:58
 * @version: 1.0
 */
@Service
@Slf4j
public class DataUnderstandingPartParser implements IPartParser {

    private static final String TASK = "Task_";
    private static final String LINK = "Link_";
    private static final String URI =  "$(taskEngineUrl)/restful/standard/taskengine/api/project/create";
    private static final String EOC_URI =  "$(eocUrl)/api/eoc/v2/emp/user/id";

    private static final String EMAIL_URI =  "$(atmcUrl)/api/atmc/v1/email/template";
    private static final String PUBLISH_URL = "/restful/standard/scdispatcher/template/publish";

    @Autowired
    @Qualifier("dataFootprintTemplate")
    RestTemplate restTemplate;
    @Value("${scdispatcherUrl}")
    private String scdispatcherUrl;

    @Autowired
    KgService kgService;

    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    CacService cacService;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase("DataUnderstanding", part.getType())
                || StringUtils.equalsIgnoreCase("ThresholdEvaluate", part.getType());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        // Sets
        Sets sets = context.getCurrentSet();

        if (Objects.equals(sets.getOperate(),"delete")) {
            return;
        }
        String version = sets.getVersion();
        List<Step> steps = new ArrayList<>();
        ServiceComposer serviceComposer = new ServiceComposer();
        // 开始任务id
        String startId = UUID.randomUUID().toString().replaceAll("-","_");
        // 数据筛选任务id
        String filterId = UUID.randomUUID().toString().replaceAll("-","_");
        // 判断任务id
        String decisionId = UUID.randomUUID().toString().replaceAll("-","_");
        // 数据存储任务id
        String dataSaveTaskId = UUID.randomUUID().toString().replaceAll("-","_");
        // 数据存储应用api任务id
        String applicationDataSaveTaskId = UUID.randomUUID().toString().replaceAll("-","_");
        // http任务id
        String httpTaskId = UUID.randomUUID().toString().replaceAll("-","_");
        // 结束任务id
        String endTaskId = UUID.randomUUID().toString().replaceAll("-","_");
        // 循环开始和结束的节点
        String startBatchId = UUID.randomUUID().toString().replaceAll("-","_");
        String endBatchId = UUID.randomUUID().toString().replaceAll("-","_");
        // U part
        DataUnderstandingPart dataUnderstandingPart = sets.getU().getPart();
        // P part
        ThresholdEvaluatePart thresholdEvaluatePart = sets.getP().getPart();
        // A part
        SmartAdjustProjectPart smartAdjustProjectPart = JSON.parseObject(JSON.toJSONString(sets.getA().getPart()),
                SmartAdjustProjectPart.class);

        // 上下文返回U的returnFields
        if (CollectionUtils.isNotEmpty(dataUnderstandingPart.getSteps())) {
            List<ReturnField> returnFields = context.getReturnFieldAll();
            for (Step step : dataUnderstandingPart.getSteps()) {
                returnFields.addAll(step.getReturnFields());
            }
            context.setReturnFieldAll(returnFields);
        }

        // 添加开始节点获取侦测数据
        steps.add(buildStartStep(sets,startId));

        // 判断是否为空，非空则加数据筛选
        if (StringUtils.isNotEmpty(thresholdEvaluatePart.getThresholdCondition().getType())) {
            String javascriptExpressions = thresholdEvaluatePart.toJavaScriptExpression();
            steps.add(buildFilterStep(filterId,javascriptExpressions)); // 加数据筛选节点
        }

        // 当责者取字段类型并且需要转换，过滤掉字段为空的数据
        if ("field".equalsIgnoreCase(smartAdjustProjectPart.getPersonIncharge().getType()) && smartAdjustProjectPart.getPersonIncharge().isConvert()) {
            String personInChargeValue = smartAdjustProjectPart.getPersonIncharge().getValue();
            steps.add(buildDefaultPersonInChargeStep(UUID.randomUUID().toString().replaceAll("-","_"), personInChargeValue));
        }

        // 42976 数据存储到应用api
        log.info("数据存储到应用api V:{}",JSON.toJSONString(sets.getV()));
        if (Objects.nonNull(sets.getV()) && Objects.nonNull(sets.getV().getPart())) {
            ApplicationDataSavePart dataSavePart = sets.getV().getPart();
            if (StringUtils.isNotEmpty(dataSavePart.getServiceName()) && StringUtils.isNotEmpty(dataSavePart.getActionId())) {
                steps.add(buildApplicationDataSaveApiStep(applicationDataSaveTaskId, dataSavePart, context.getReturnFieldAll(), version));
            }
        }
        // 数据存到common-driven服务中中
        steps.add(buildDataSaveApiStep(dataSaveTaskId, sets.getCode()));
        List<Step> emailSteps = buildEmailNoticeSteps(sets, smartAdjustProjectPart);
        if (CollectionUtils.isNotEmpty(emailSteps)) {
            steps.addAll(emailSteps);
        }
        steps.add(buildDecisionStep(decisionId)); // 加判断节点


        //判断是否加数据分组节点,分组发送项目
        String personInChargeType = smartAdjustProjectPart.getPersonIncharge().getType();
        if ("field".equalsIgnoreCase(personInChargeType)) {
            String personInChargeValue = smartAdjustProjectPart.getPersonIncharge().getValue();

            // 加EOC员工转换
            boolean personInchargeConvert = smartAdjustProjectPart.getPersonIncharge().isConvert();
            if (personInchargeConvert) {
                String startEocBatchId = UUID.randomUUID().toString().replaceAll("-","_");
                String endEocBatchId = UUID.randomUUID().toString().replaceAll("-","_");
                String httpEocTaskId = "eoc_" + UUID.randomUUID().toString().replaceAll("-","_");
                //循环开始
                steps.add(buildBatchStep(startEocBatchId));
                steps.add(buildHttpEocStep(sets.getCode(),httpEocTaskId,personInChargeValue)); // 加Http节点,调用EOC接口
                //循环结束
                steps.add(buildBatchEndStep(endEocBatchId));
            }else {
                // 不转换时直接设置charge_id
                String dataSetId = UUID.randomUUID().toString().replaceAll("-","_");
                steps.add(buildDataSetStep(dataSetId,personInChargeValue));
            }

            // 数据分组 id
            String dataGroupId = UUID.randomUUID().toString().replaceAll("-","_");
            steps.add(buildDataGroupStep(dataGroupId,personInChargeValue));
            // 加循环开始节点
            steps.add(buildBatchStep(startBatchId));
            steps.add(buildHttpStep(sets.getCode(),httpTaskId,"1", smartAdjustProjectPart.getPersonIncharge())); // 加Http节点发起项目
            // 加循环结束节点
            steps.add(buildBatchEndStep(endBatchId));
        }else {
            steps.add(buildHttpStep(sets.getCode(),httpTaskId,"0", smartAdjustProjectPart.getPersonIncharge())); // 加Http节点发起项目
        }


        steps.add(buildEndStep(endTaskId)); // 加end节点

        List<ServiceComposerTask> tasks = executePart(dataUnderstandingPart,steps,version);
        List<ServiceComposerLink> links = convertConnectionsToLinks(tasks);
        serviceComposer.setId(SetConstants.SERVICECOMPOSER_PREFIX + sets.getCode());
        serviceComposer.setName("参数调整套件的服务编排");
        serviceComposer.setLinks(links);
        serviceComposer.setTasks(tasks);
        publishTemplate(JSON.toJSONString(serviceComposer));
        log.info("sets dsl : {}",JSON.toJSONString(serviceComposer));
    }

    // 服务编排任务编译
    public List<ServiceComposerTask> executePart(DataUnderstandingPart part,List<Step> steps,String version) throws DWBusinessException {
        List<ServiceComposerTask> resultMap = new ArrayList<>();
        List<Step> executionOrder = getExecutionOrder(part,steps);
        for (Step step : executionOrder) {

            executeStep(step, resultMap,version);
        }
        return resultMap;
    }

    // 计算step的执行顺序
    private List<Step> getExecutionOrder(DataUnderstandingPart part,List<Step> steps) {
       /* Set<String> visitedSteps = new HashSet<>();

        // Traverse connections in order
        for (Connection conn : part.getConns()) {
            String from = conn.getFrom();
            String to = conn.getTo();
            if (StringUtils.isEmpty(from)) {
                visitedSteps.add(to);
            } else if (StringUtils.isEmpty(to)) {
                visitedSteps.add(from);
            } else {
                visitedSteps.add(to);
            }
        }
        // Add the remaining, unvisited steps to the sorted list
        List<Step> unvisitedSteps = part.getSteps().stream()
                .filter(step -> visitedSteps.contains(step.getId())).collect(Collectors.toList());*/

        List<Step> partStep = part.getSteps();
        List<Connection> conns = part.getConns();
        List<Step> orderedSteps = new ArrayList<>();
        Set<String> visited = new HashSet<>(); // 记录已访问过的步骤
        String to = ""; // 当前步骤的 to

        if (CollectionUtils.isNotEmpty(steps)) {
            orderedSteps.add(steps.get(0)); //添加开始节点并移除
            steps.remove(0);  // 移除第一条步骤数据
        }

        Map<String, Step> stepMap = new HashMap<>();
        // 将 steps 数组中的每个步骤以其 id 为键存入映射表中
        for (Step step : partStep) {
            String id = step.getId();
            stepMap.put(id, step);
        }

        // 找到从空节点开始的步骤
        for (Connection conn : conns) {
            String from = conn.getFrom();
            if (from.isEmpty()) {
                to = conn.getTo();
                break;
            }
        }

        // 递归遍历连接关系
        //如果页面不存在steps或者conns的时候不需要递归处理拼接页面上提交的数据处理步骤
        if(StringUtils.isNotBlank(to)){
            traverseSteps(stepMap, to, visited, orderedSteps,conns);
        }
        //添加节点
        orderedSteps.addAll(steps);
        return orderedSteps;

    }

    private static void traverseSteps(Map<String, Step> stepMap, String currentStepId, Set<String> visited, List<Step> orderedSteps,List<Connection> conns) {
        visited.add(currentStepId);
        Step currentStep = stepMap.get(currentStepId);
        orderedSteps.add(currentStep);
        String from = currentStepId;
        while (!from.isEmpty()) {
            for (Connection conn : conns) {
                if (conn.getFrom().equals(from)) {
                    String to = conn.getTo();
                    Step step = stepMap.get(to);
                    if (step != null) {
                        orderedSteps.add(step);
                    }
                    from = to;
                    break;
                }
            }
        }
    }


    // Step数据编译
    private void executeStep(Step step, List<ServiceComposerTask> resultMap,String version) throws DWBusinessException {
        if (Objects.equals(SetsStepTypeEnum.API.toString(),step.getType()) || Objects.equals(SetsStepTypeEnum.DataSaveApi.toString(),step.getType())) {
            executeAPI(step, resultMap,version, step.getType());
        } else if (Objects.equals(SetsStepTypeEnum.Script.toString(),step.getType()) || Objects.equals(SetsStepTypeEnum.Constant.toString(),step.getType())
                || Objects.equals(SetsStepTypeEnum.Filter.toString(),step.getType()) || Objects.equals(SetsStepTypeEnum.End.toString(),step.getType())
                || Objects.equals(SetsStepTypeEnum.Start.toString(),step.getType())  || Objects.equals(SetsStepTypeEnum.Group.toString(),step.getType())) {
            executeScript(step, resultMap);
        }else if (Objects.equals(SetsStepTypeEnum.Http.toString(),step.getType())) {
            executeHttp(step, resultMap);
        }else if (Objects.equals(SetsStepTypeEnum.Decision.toString(),step.getType()) || Objects.equals(SetsStepTypeEnum.Batch_End.toString(),step.getType())) {
            executeDecisionAndBatchEnd(step, resultMap);
        }else if (Objects.equals(SetsStepTypeEnum.Batch.toString(),step.getType())) {
            executeBatch(step, resultMap);
        } else{
            throw new DWBusinessException("没有找到对应的type:" + step.getType());
        }
    }

    // Invoke API and process the data
    private void executeAPI (Step step, List<ServiceComposerTask> resultMap, String version, String type) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        ServiceComposerTask task = new ServiceComposerTask();
        InputParameters inputParameters = new InputParameters();
        task.setId(TASK + step.getId().replaceAll("-","_"));
        task.setType(ServiceComposerTaskTypeEnum.ESP.toString());
        task.setName(step.getDescription());
        task.setTaskTimeoutSeconds(86400);
        task.setInputParameters(inputParameters);
        String requestScript;
        String responseScript;
        if (Objects.equals(SetsStepTypeEnum.API.toString(),step.getType())){
            //如果是API的，step页面上行才会有对应的actionI的，DataSaveApi类型的不存在actionId
            List<ApiDataFieldMetadataDTO> actionParameters = kgService.getActionParameters(step.getActionId(),tenantId,version);
            requestScript = buildBeforeRequestScript(step,actionParameters);
            inputParameters.setProductName("");  //调用不用传产品名称
            responseScript = buildAfterResponseScript(step);
        } else {
            // 侦测数据存到common-driven服务中去
            requestScript = step.getScript();
            inputParameters.setProductName(step.getProductName());
            responseScript = step.getResponseScript();
        }
        inputParameters.setBeforeRequestScript(requestScript);
        inputParameters.setAfterResponseScript(responseScript);
        inputParameters.setServiceName(step.getServiceName());
        resultMap.add(task);
    }

    // Invoke Script and process the data
    private void executeScript(Step step, List<ServiceComposerTask> resultMap) {
        ServiceComposerTask task = new ServiceComposerTask();
        InputParameters inputParameters = new InputParameters();
        task.setId(TASK + step.getId().replaceAll("-","_"));
        task.setType(ServiceComposerTaskTypeEnum.JS.toString());
        task.setName(step.getDescription());
        task.setInputParameters(inputParameters);
        if (Objects.equals(SetsStepTypeEnum.Script.toString(),step.getType())) {
            inputParameters.setScript(buildExecuteScript(step));
        }else if (Objects.equals(SetsStepTypeEnum.Constant.toString(),step.getType())) {
            inputParameters.setScript(buildExecuteConstant(step));
        }else {
            inputParameters.setScript(step.getScript());
        }
        resultMap.add(task);
    }

    // Invoke Http and process the data
    private void executeHttp (Step step, List<ServiceComposerTask> resultMap) {
        ServiceComposerTask task = new ServiceComposerTask();
        InputParameters inputParameters = new InputParameters();
        task.setId(step.getId());
        task.setType(step.getType());
        task.setName(step.getDescription());
        task.setTaskTimeoutSeconds(86400);
        task.setInputParameters(inputParameters);
        inputParameters.setBeforeRequestScript(step.getScript());

        inputParameters.setMethod(HttpMethod.POST.toString());
        if (step.getId().contains("eoc")) {
            inputParameters.setAfterResponseScript(step.getResponseScript());
            inputParameters.setUri(EOC_URI);
        } else if (step.getId().contains("email")) {
            inputParameters.setAfterResponseScript("var response = $(response);\n return {\n    'response': response \n};");
            inputParameters.setUri(EMAIL_URI);
        } else {
            inputParameters.setAfterResponseScript("var response = $(response);\n return {\n    'response': response \n};");
            inputParameters.setUri(URI);
        }

        resultMap.add(task);
    }

    // Invoke Decision and process the data   and  循环结束
    private void executeDecisionAndBatchEnd(Step step, List<ServiceComposerTask> resultMap) {
        ServiceComposerTask task = new ServiceComposerTask();
        task.setId(step.getId());
        task.setName(step.getDescription());
        task.setType(step.getType());
        resultMap.add(task);
    }

    // 循环开始
    private void executeBatch(Step step, List<ServiceComposerTask> resultMap) {
        ServiceComposerTask task = new ServiceComposerTask();
        InputParameters inputParameters = new InputParameters();
        inputParameters.setLoopList("$(detectedData)");
        inputParameters.setLoopVarName("data");
        inputParameters.setResultVarName("result");
        task.setId(step.getId());
        task.setName(step.getDescription());
        task.setType(step.getType());
        task.setInputParameters(inputParameters);
        resultMap.add(task);
    }

    // ESP任务类型BeforeRequestScript脚本构造
    private String buildBeforeRequestScript (Step step,List<ApiDataFieldMetadataDTO> actionParameters) {
        boolean isArray = true;
        String dataName = "credit_info";
        if (CollectionUtils.isNotEmpty(actionParameters)) {
            ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = actionParameters.get(0);
            if (apiDataFieldMetadataDTO != null) {
                dataName = apiDataFieldMetadataDTO.getData_name();
                isArray = apiDataFieldMetadataDTO.getIs_array();
            }
        }

        // Execute API for each row
        StringBuilder codeBuilder = new StringBuilder();
        List<Processor> paramsArray = step.getParams();
        JSONArray jsonArray = new JSONArray();
        for (Processor param : paramsArray) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", param.getName());
            jsonObject.put("value", param.getValue());
            jsonObject.put("type", param.getType());
            jsonArray.add(jsonObject);
        }
        codeBuilder.append("var jsonArray = [];\n")
                .append("var paramsArray = ").append(jsonArray.toJSONString()).append(";\n")
                .append("var jsonParam = {};\n")
                .append("var detectedData = $(detectedData);\n");
        if (!isArray) {
            codeBuilder.append("var jsonObject = {};\n");
        }

        if (paramsArray.stream().anyMatch(param -> "Field".equals(param.getType()))) {
            codeBuilder.append("detectedData.forEach(function(item) {\n");
        }
        // Execute API only once
        if (isArray) {
            codeBuilder.append("var jsonObject = {};\n");
        }

        codeBuilder.append("if (paramsArray != null) {").append("\n")
                .append("paramsArray.forEach(function(paramObject) {").append("\n")
                .append("var paramName = paramObject[\"name\"];").append("\n")
                .append("var paramValue = paramObject[\"value\"];").append("\n")
                .append("var paramType = paramObject[\"type\"];").append("\n");
        if (paramsArray.stream().anyMatch(param -> "Field".equals(param.getType()))) {
            codeBuilder.append("if (paramType === \"Field\") {").append("\n")
                    .append("var detectedValue = item[paramValue]; ").append("\n")
                    .append("jsonObject[paramName] = detectedValue;").append("\n")
                    .append("} else {").append("\n");
        }
        codeBuilder.append("jsonObject[paramName] = paramValue;").append("\n");
        if (paramsArray.stream().anyMatch(param -> "Field".equals(param.getType()))) {
            codeBuilder.append("}").append("\n");
        }
        codeBuilder.append("});").append("\n")
                .append("}").append("\n");
        codeBuilder.append("jsonArray.push(jsonObject);\n");
//                .append("var data = JSON.stringify(jsonArray);\n");
        if (paramsArray.stream().anyMatch(param -> "Field".equals(param.getType()))) {
            codeBuilder.append("});\n");
        }

        if (isArray) {
            codeBuilder.append("if (jsonArray[0] && Object.keys(jsonArray[0]).length !== 0) { jsonParam.").append(dataName).append("= jsonArray; }\n");
        }else {
            codeBuilder.append("if (jsonArray[0] && Object.keys(jsonArray[0]).length !== 0) { jsonParam.").append(dataName).append("= jsonObject; }\n");
        }

        codeBuilder.append("var request = {").append("\n")
                .append("\"std_data\": {").append("\n")
                .append(" \"parameter\": jsonParam").append("\n")
                .append("}};").append("\n")
                .append("return request;").append("\n");

        return codeBuilder.toString();
    }

    // ESP任务类型AfterResponseScript脚本构造
//    private String buildAfterResponseScript (Step step) {
//        StringBuilder codeBuilder = new StringBuilder();
//        List<Processor> params = step.getParams();
//        JSONArray paramsArrays = new JSONArray();
//        for (Processor param : params) {
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("value", param.getValue());
//            paramsArrays.add(jsonObject);
//        }
//        List<ReturnField> paramsArray = step.getReturnFields();
//        JSONArray jsonArray = new JSONArray();
//        for (ReturnField param : paramsArray) {
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("name", param.getDatasourceField());
//            jsonArray.add(jsonObject);
//        }
//        codeBuilder.append("var response = $(response);\n")
//                .append("var jsonObject = {};\n")
//                .append("  var tSuccess = true;\n")
//                .append("var tErrorMessage = \"\";\n")
//                .append("var data=[];\n")
//                .append("var paramsArrays = ").append(paramsArrays.toJSONString()).append(";\n")
//                .append("var paramsArray = ").append(jsonArray.toJSONString()).append(";\n")
//                .append("var detectedData = $(detectedData);\n")
//                .append("if(response['std_data']['execution']['code'] == \"0\"){").append("\n")
//                .append("tErrorMessage = 'Success';").append("\n")
//                .append("var parameter = response.std_data.parameter;").append("\n")
//                .append("var dynamicPropertyName = Object.keys(parameter)[0];").append("\n")
//                .append("data = parameter[dynamicPropertyName];").append("\n")
//                .append("if (data && data.length > 0) {").append("\n")
//                .append("var maxLength = Math.max(detectedData.length, data.length);").append("\n")
//                .append("var detectedItem, newItem;").append("\n")
//                .append("for (var i = 0; i < maxLength; i++) {").append("\n")
//                .append("if (i < detectedData.length) {").append("\n")
//                .append("detectedItem = detectedData[i];").append("\n")
//                .append("} else {").append("\n")
//                .append("detectedItem = detectedData[detectedData.length-1];").append("\n")
//                .append("detectedData.push(detectedItem);").append("\n")
//                .append("}").append("\n")
//                .append("if (i < data.length) {").append("\n")
//                .append("newItem = data[i];").append("\n")
//                .append("} else {").append("\n")
//                .append("newItem = data[data.length-1];").append("\n")
//                .append("}").append("\n")
//                .append("for (var j = 0; j < paramsArrays.length; j++) {").append("\n")
//                .append("var param = paramsArrays[j].value;").append("\n")
//                .append("if (detectedItem.hasOwnProperty(param)) {").append("\n")
//                .append(" detectedItem[param] = detectedItem[param];\n")
//                .append(" } else if (newItem.hasOwnProperty(param)) {\n")
//                .append("  detectedItem[param] = newItem[param];\n")
//                .append(" }\n")
//                .append(" }\n")
//                .append(" for (var k = 0; k < paramsArray.length; k++) {\n")
//                .append(" var fieldName = paramsArray[k].name;\n")
//                .append(" if (detectedItem.hasOwnProperty(fieldName)) {\n")
//                .append("  detectedItem[fieldName] = detectedItem[fieldName];\n")
//                .append(" } else if (newItem.hasOwnProperty(fieldName)) {\n")
//                .append(" detectedItem[fieldName] = newItem[fieldName];\n")
//                .append("  }\n")
//                .append("  }\n")
//                .append("  }\n")
//                .append("  }\n")
//                .append("  } else {\n")
//                .append("  tSuccess = false;\n")
//                .append("  tErrorMessage = response.std_data.execution.description;\n")
//                .append("  }\n")
//                .append("return {").append("\n")
//                .append("\"success\" : tSuccess,\n")
//                .append("\"processVariable\": {\n")
//                .append("\"detectedData\":detectedData").append("\n")
//                .append("},").append("\n")
//                .append("\"errorMessage\" : tErrorMessage").append("\n")
//                .append("};").append("\n");
//
//        return codeBuilder.toString();
//    }

//    // ESP任务类型AfterResponseScript脚本构造
//    private String buildAfterResponseScript (Step step) {
//        StringBuilder codeBuilder = new StringBuilder();
//        List<Processor> params = step.getParams();
//        JSONArray paramsArrays = new JSONArray();
//        for (Processor param : params) {
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("value", param.getValue());
//            paramsArrays.add(jsonObject);
//        }
//        List<ReturnField> paramsArray = step.getReturnFields();
//        JSONArray jsonArray = new JSONArray();
//        for (ReturnField param : paramsArray) {
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("name", param.getDatasourceField());
//            jsonArray.add(jsonObject);
//        }
//        codeBuilder.append("var response = $(response);\n")
//                .append("var jsonObject = {};\n")
//                .append("  var tSuccess = true;\n")
//                .append("var tErrorMessage = \"\";\n")
//                .append("var data=[];\n")
//                .append("var newData=[];\n")
//                .append("var paramsArrays = ").append(paramsArrays.toJSONString()).append(";\n")
//                .append("var paramsArray = ").append(jsonArray.toJSONString()).append(";\n")
//                .append("var detectedData = $(detectedData);\n")
//                .append("if(response['std_data']['execution']['code'] == \"0\"){").append("\n")
//                .append("tErrorMessage = 'Success';").append("\n")
//                .append("var parameter = response.std_data.parameter;").append("\n")
//                .append("var dynamicPropertyName = Object.keys(parameter)[0];").append("\n")
//                .append(" data = parameter[dynamicPropertyName];").append("\n")
//                .append("if(data == null || data.length == 0){").append("\n")
//                .append("tSuccess = false;").append("\n")
//                .append("}else {").append("\n")
//                .append("detectedData.forEach(function(item) {").append("\n")
//                .append("data.forEach(function(dataItem) {").append("\n")
//                .append("var newItem = {};").append("\n")
//                .append("for (var prop in item) {\n" +
//                        "      if (item.hasOwnProperty(prop)) {\n" +
//                        "        newItem[prop] = item[prop];\n" +
//                        "      }\n" +
//                        "    }").append("\n")
//                .append("paramsArray.forEach(function(fieldItem) {").append("\n")
//                .append("newItem[fieldItem.name] = dataItem[fieldItem.name];").append("\n")
//                .append("});").append("\n")
//                .append("newData.push(newItem);").append("\n")
//
//                .append("});").append("\n")
//                .append("});").append("\n")
//                .append("detectedData = (newData === null || newData.length === 0) ? detectedData : newData;").append("\n")
//                .append("}").append("\n")
//                .append("}else{").append("\n")
//                .append("tSuccess = false;").append("\n")
//                .append("tErrorMessage = response['std_data']['execution']['description'];}\n")
//                .append("return {").append("\n")
//                .append("\"success\" : tSuccess,\n")
//                .append("\"processVariable\": {\n")
//                .append("\"detectedData\":detectedData").append("\n")
//                .append("},").append("\n")
//                .append("\"errorMessage\" : tErrorMessage").append("\n")
//                .append("};").append("\n");
//
//        return codeBuilder.toString();
//    }


    //    // ESP任务类型AfterResponseScript脚本构造
    private String buildAfterResponseScript (Step step) {
        StringBuilder codeBuilder = new StringBuilder();
        List<Processor> params = step.getParams();
        JSONArray paramsArrays = new JSONArray();
        for (Processor param : params) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("value", param.getValue());
            paramsArrays.add(jsonObject);
        }
        List<ReturnField> paramsArray = step.getReturnFields();
        JSONArray jsonArray = new JSONArray();
        for (ReturnField param : paramsArray) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", param.getDatasourceField());
            jsonArray.add(jsonObject);
        }
        codeBuilder.append("var response = $(response);\n")
                .append("var jsonObject = {};\n")
                .append("  var tSuccess = true;\n")
                .append("var tErrorMessage = \"\";\n")
                .append("var data=[];\n")
                .append("var newData=[];\n")
                .append("var paramsArrays = ").append(paramsArrays.toJSONString()).append(";\n")
                .append("var paramsArray = ").append(jsonArray.toJSONString()).append(";\n")
                .append("var detectedData = $(detectedData);\n")
                .append("if(response['std_data']['execution']['code'] == \"0\"){").append("\n")
                .append("tErrorMessage = 'Success';").append("\n")
                .append("var parameter = response.std_data.parameter;").append("\n")
                .append("var dynamicPropertyName = Object.keys(parameter)[0];").append("\n")
                .append(" data = parameter[dynamicPropertyName];").append("\n")
                .append("if(data == null || data.length == 0){").append("\n")
                .append("tSuccess = false;").append("\n")
                .append("}else {").append("\n")
                .append("detectedData.forEach(function(item, index) {").append("\n")
                .append("var newDataItem = {};").append("\n")
                .append("for (var prop in item) {").append("\n")
                .append("if (item.hasOwnProperty(prop)) {\n" +
                        "      newDataItem[prop] = item[prop];\n" +
                        "       }\n" +
                        "      }\n" +
                        "paramsArray.forEach(function(fieldItem) {").append("\n")
                .append("newDataItem[fieldItem.name] = (index < data.length) ? data[index][fieldItem.name] : data[data.length-1][fieldItem.name];").append("\n")
                .append("});").append("\n")
                .append("newData.push(newDataItem);").append("\n")
                .append("});").append("\n")

                .append("detectedData = (newData === null || newData.length === 0) ? detectedData : newData;").append("\n")
                .append("}").append("\n")
                .append("}else{").append("\n")
                .append("tSuccess = false;").append("\n")
                .append("tErrorMessage = response['std_data']['execution']['description'];}\n")
                .append("return {").append("\n")
                .append("\"success\" : tSuccess,\n")
                .append("\"processVariable\": {\n")
                .append("\"detectedData\":detectedData").append("\n")
                .append("},").append("\n")
                .append("\"errorMessage\" : tErrorMessage").append("\n")
                .append("};").append("\n");

        return codeBuilder.toString();
    }


    // Script类型脚本构造
    private String buildExecuteScript(Step step) {
        String script = step.getScript();
        String returnField = CollectionUtils.isNotEmpty(step.getReturnFields()) ? step.getReturnFields().get(0).getDatasourceField() : "";

        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var detectedData = $(detectedData);\n");
        codeBuilder.append(" detectedData.forEach(function(currentRow) {\n");
        // Execute script for each row
        if ("ByRow".equalsIgnoreCase(step.getExecuteMode())) {
            codeBuilder.append(script).append("\n");
        }else {
            // Execute script only once
            script = script.replace("currentRow","detectedData[0]");
            codeBuilder.append(script).append("\n");
        }
        codeBuilder.append("    currentRow.").append(returnField).append(" = data;\n");
        codeBuilder.append("});\n");
        codeBuilder.append("\n");
        codeBuilder.append(" return {\n");
        codeBuilder.append("  \"processVariable\": {\n");
        codeBuilder.append("    \"detectedData\": detectedData\n");
        codeBuilder.append("  }\n");
        codeBuilder.append(" };\n");
        return codeBuilder.toString();
    }

    // Constant类型脚本构造
    private String buildExecuteConstant(Step step) {
        String value = step.getValue();
        String returnField;
        if (CollectionUtils.isNotEmpty(step.getReturnFields())) {
            ReturnField field = step.getReturnFields().get(0);
            returnField = field.getDatasourceField();
            // 不是数字、布尔类型的需要用引号包裹
            if (!"number".equals(field.getValueType()) && !"numeric".equals(field.getValueType()) && !"boolean".equals(field.getValueType()) && ("string".equals(field.getValueType()) && !"\"\"".equals(value))) {
                value = "'" + value + "'";
            }
        } else {
            returnField = "";
        }
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var detectedData = $(detectedData);\n");

        codeBuilder.append(" detectedData.forEach(function(currentRow) {\n");
        codeBuilder.append("  var data = ").append(value).append(";\n");
        codeBuilder.append("    currentRow.").append(returnField).append(" = data;\n");
        codeBuilder.append("});\n");
        codeBuilder.append("\n");
        codeBuilder.append(" return {\n");
        codeBuilder.append("  \"processVariable\": {\n");
        codeBuilder.append("    \"detectedData\": detectedData\n");
        codeBuilder.append("  }\n");
        codeBuilder.append(" };\n");

        return codeBuilder.toString();
    }

    // 开始节点
    private Step buildStartStep(Sets sets,String startId) throws DWBusinessException {
        Step step = new Step();
        step.setId(startId);
        step.setType(SetsStepTypeEnum.Start.toString());
        step.setScript(getStartScript(sets));
        step.setDescription("开始节点");
        return step;
    }

    // 设置charge_id
    private Step buildDataSetStep(String id,String fieldName) {
        Step step = new Step();
        step.setId(id);
        step.setType(SetsStepTypeEnum.Start.toString());
        step.setScript(getDataSetScript(fieldName));
        step.setDescription("设置charge_id");
        return step;
    }

    // 数据筛选节点任务定义
    private Step buildFilterStep(String filterId,String condition) {
        Step step = new Step();
        step.setId(filterId);
        step.setType(SetsStepTypeEnum.Filter.toString());
        step.setScript(getFilterScript(condition));
        step.setDescription("数据筛选");
        return step;
    }

    // 判断节点任务定义
    private Step buildDecisionStep(String decisionId) {
        Step step = new Step();
        step.setId(TASK + decisionId);
        step.setType(SetsStepTypeEnum.Decision.toString());
        step.setDescription("判断是否发卡");
        return step;
    }

    // 开始节点
    private Step buildDataGroupStep(String dataGroupId,String personInChargeValue) {
        Step step = new Step();
        step.setId(dataGroupId);
        step.setType(SetsStepTypeEnum.Group.toString());
        step.setScript(getDataFroupScript(personInChargeValue));
        step.setDescription("数据分组或处理");
        return step;
    }

    // 循环开始
    private Step buildBatchStep(String id) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.Batch.toString());
        step.setDescription("Http循环开始");
        return step;
    }

    // 循环结束
    private Step buildBatchEndStep(String id) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.Batch_End.toString());
        step.setDescription("Http循环结束");
        return step;
    }

    private Step buildDataSaveApiStep(String id, String setsCode) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.DataSaveApi.toString());
        step.setServiceName(SetConstants.COMMON_DATA_MODEL_DATA_API_PREFIX + setsCode + ".create");
        step.setProductName(SetConstants.COMMON_DATA_PRODUCT);
        step.setDescription("调用数据存储api");
        step.setScript(getDataSaveScript(SetConstants.COMMON_DATA_MODEL_PREFIX + setsCode));
        // 将返回的数据推送到流程变量，返回的数据里有id
        step.setResponseScript(getDataSaveResponseScript(SetConstants.COMMON_DATA_MODEL_PREFIX + setsCode));
        return step;
    }

    /**
     * 42976 新增方法
     * 构建保存数据至应用的step
     *
     * @param applicationDataSaveTaskId
     * @param part
     * @param returnFieldAll
     * @param version
     * @return
     */
    private Step buildApplicationDataSaveApiStep(String applicationDataSaveTaskId, ApplicationDataSavePart part, List<ReturnField> returnFieldAll, String version) throws DWBusinessException {
        Step step = new Step();
        step.setId(TASK + applicationDataSaveTaskId);
        step.setType(SetsStepTypeEnum.DataSaveApi.toString());
        step.setServiceName(part.getServiceName());
        step.setProductName(part.getProductName());
        step.setDescription("调用应用api保存数据");
        step.setActionId(part.getActionId());
        String tenantId = AthenaUtils.getTenantId();
        List<ApiDataFieldMetadataDTO> actionParameters = kgService.getActionParameters(step.getActionId(),tenantId,version);
        if (CollectionUtils.isEmpty(actionParameters)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.dataNameIsEmpty",tenantId));
        }
        ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = actionParameters.get(0);
        if (apiDataFieldMetadataDTO != null && StringUtils.isNotEmpty(apiDataFieldMetadataDTO.getData_name())) {
            step.setScript(getDataSaveScript(apiDataFieldMetadataDTO.getData_name()));
        } else {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.dataNameIsEmpty", tenantId));
        }
//        List<Processor> params = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(returnFieldAll)) {
//            for (ReturnField returnField : returnFieldAll) {
//                Processor processor = new Processor();
//                processor.setName(returnField.getDatasourceField());
//                processor.setType(returnField.getType());
//                processor.setValueType(returnField.getValueType());
//                params.add(processor);
//            }
//        }
//        step.setParams(params);
        log.info("构建保存数据至应用的step:{}",JSON.toJSONString(step));
        return step;
    }

    /**
     * 字段类型当责者，业务数据为空时填充默认值
     * @param stepId id
     * @param fieldName 字段名
     * @return
     */
    private Step buildDefaultPersonInChargeStep(String stepId,String fieldName) {
        Step step = new Step();
        step.setId(stepId);
        step.setType(SetsStepTypeEnum.Start.toString());
        step.setScript(getDefaultPersonInChargeScript(fieldName));
        step.setDescription("字段类型当责者默认值");
        return step;
    }

    private String getDefaultPersonInChargeScript(String fieldName) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var detectedData = $(detectedData);\n")
                .append(" for (var i = 0; i < detectedData.length; i++) {\n")
                .append(" if (!detectedData[i].").append(fieldName).append("){\n")
                .append(" detectedData[i].").append(fieldName).append(" = '1';\n")
                .append(" }\n")
                .append("}\n")
                .append("return {").append("\n")
                .append("\"processVariable\": {").append("\n")
                .append("\"detectedData\":detectedData").append("\n")
                .append("}};").append("\n");

        return codeBuilder.toString();
    }

    private String getDataSaveScript(String code) {
        // 前面设置了自增主键（），不需要去设置主键的值了
        return "var dispatchData = $(detectedData);" + "\n" +
                "var jsonParam = {'"+code+"': dispatchData};\n" +
                "var request = {" + "\n" +
                "\"std_data\": {" + "\n" +
                " \"parameter\": jsonParam" + "\n" +
                "}};" + "\n" +
                "return request;" + "\n";
    }

    /**
     * 42976 新增方法
     * 数据保存应用api脚本
     * @return
     */
    private String getApplicationDataSaveScript() {
        return "var dispatchData = $(detectedData);" + "\n" +
                "var request = {" + "\n" +
                "\"std_data\": {" + "\n" +
                " \"parameter\": dispatchData" + "\n" +
                "}};" + "\n" +
                "return request;" + "\n";
    }

    private String getDataSaveResponseScript(String code) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var response = $(response);\n")
                .append("var tableData = $(detectedData);\n")
                .append("var tSuccess = true;\n")
                .append("var tErrorMessage = \"\";\n")
                .append("if(response['std_data']['execution']['code'] == \"0\"){").append("\n")
                .append("tErrorMessage = 'Success';").append("\n")
                .append("tableData = response.std_data.parameter.").append(code).append(";\n")
                .append("}else{").append("\n")
                .append("tSuccess = false;").append("\n")
                .append("tErrorMessage = response['std_data']['execution']['description'];}\n")
                .append("return {").append("\n")
                .append("\"success\" : tSuccess,\n")
                .append("\"processVariable\": {\n")
                .append("\"detectedData\":tableData").append("\n")
                .append("},").append("\n")
                .append("\"errorMessage\" : tErrorMessage").append("\n")
                .append("};").append("\n");
        return codeBuilder.toString();
    }

    public List<Step> buildEmailNoticeSteps(Sets currentSet, SmartAdjustProjectPart part) throws DWBusinessException {
        List<Step> steps = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(part.getEmailNotices())) {
            List<String> tenantIds = new ArrayList<>();
            List<AppPurchaseInfo> tenantIdDataList = cacService.getAllEffectiveTenantAndAppInfo(currentSet.getAppCode()).getList();
            if (!org.springframework.util.CollectionUtils.isEmpty(tenantIdDataList)) {
                tenantIds = tenantIdDataList.stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
            }
            for (EmailNotice emailNotice : part.getEmailNotices()) {
                for (String tenantId : tenantIds) {
                    Step step = buildEmailNoticeStep(currentSet, tenantId, emailNotice, part);
                    if(step != null) {
                        steps.add(step);
                    }
                }
            }
        }
        return steps;
    }

    private Step buildEmailNoticeStep(Sets currentSet, String tenantId, EmailNotice emailNotice, SmartAdjustProjectPart part) throws DWBusinessException {
        if(CollectionUtils.isEmpty(emailNotice.getReceivers())) {
            return null;
        }
        Step step = new Step();
        step.setId("email_" + UUID.randomUUID().toString().replaceAll("-","_"));
        step.setType(SetsStepTypeEnum.Http.toString());
        step.setDescription("调用邮件模板");
        step.setScript(getEmailNoticeScript(currentSet, tenantId, emailNotice, part));
        return step;
    }

    private String getEmailNoticeScript(Sets currentSet, String tenantId, EmailNotice emailNotice, SmartAdjustProjectPart part) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        String currentLocale = "zh_CN";
        String projectCode = SetConstants.PROJECT_PREFIX + currentSet.getCode();
        String manualTaskCode = currentSet.getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.manual;
        List<String> receivers = emailNotice.getReceivers();

        // 当前只支持字段类型
        String code = receivers.get(0);
        EmailNoticeTimingEnum timingEnum = EmailNoticeTimingEnum.getByCode(emailNotice.getTiming());
        String emailName = String.format("业务过程随心控%s邮件通知", timingEnum.getDesc());
        int type;
        switch (timingEnum) {
            case TASK_END:
                type = 2;
                break;
            case PROJECT_BEGIN:
                type = 3;
                break;
            case PROJECT_END:
                type = 4;
                break;
            case TASK_BEGIN:
            default:
                type = 1;
                break;
        }
        int state = Boolean.TRUE.equals(part.getEnableEmailNotice()) ? 1 : 0;
        String manualActivityId = EmailNoticeTimingEnum.PROJECT_END.equals(timingEnum) ? null : manualTaskCode;
        StringBuilder sb = new StringBuilder();
        sb.append("var detectedData = $(detectedData);").append("\n")
                .append("var receivers = [];").append("\n")
                .append("var lang = {'zh_CN':'").append(emailName).append("','zh_TW':'").append(emailName).append("','en_US':'").append(emailName).append("'};").append("\n")
                .append("var activities = [{'taskId': '").append(projectCode).append("', 'activityId':").append(manualActivityId == null ? "null" : "'" + manualActivityId + "'").append("}];\n")
                .append("for (var i=0;i<detectedData.length;i++) {").append("\n")
                .append("var item=detectedData[i];").append("if(item.").append(code).append("){").append("\n")
                .append("var exists = false;\n")
                .append("for (var j = 0;j < receivers.length;j++) {").append("\n")
                .append("if(item.").append(code).append(" == receivers[j]) {").append("\n")
                .append("exists = true;}}\n")
                .append("if(!exists) {").append("\n")
                .append("receivers.push(item.").append(code).append(");\n").append("}}};").append("\n")
                .append("var request = {").append("\n")
                .append("'receiveStaff' : receivers,").append("\n")
                .append("'activityList' : activities,").append("\n")
                .append("'tenantId':'").append(tenantId).append("',").append("\n")
                .append("'appCode':'").append(currentSet.getAppCode()).append("',").append("\n")
                .append("'emailName':lang,").append("\n")
                .append("'description':lang,").append("\n")
                .append("'type':'").append(type).append("',").append("\n")
                .append("'state':'").append(state).append("',").append("\n")
                .append("'updateBy':'").append(userId).append("',").append("\n")
                .append("'langName':'$(processLocale)'").append(",").append("\n")
                .append("'previewId':'").append(EmailEventIdEnum.getEmailEventId(timingEnum.getCode(), currentLocale)).append("'\n")
                .append("}").append("\n")
                .append("return request;");
        return sb.toString();
    }

    // Http节点任务定义
    private Step buildHttpStep(String setsCode,String id,String byGroup, Processor personInCharge) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.Http.toString());

        step.setScript(getHttpScript(setsCode,byGroup, personInCharge));
        step.setDescription("Http请求发起项目");
        return step;
    }

    private Step buildHttpEocStep(String setsCode,String id,String fieldName) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.Http.toString());
        step.setScript(getHttpEocScript(fieldName));
        step.setResponseScript(getHttpEocResponseScript(fieldName));
        step.setDescription("Http请求发起eoc请求进员工转换");
        return step;
    }

    private Step buildEndStep(String endTaskId) {
        Step step = new Step();
        step.setId(endTaskId);
        step.setType(SetsStepTypeEnum.End.toString());
        step.setScript("return {'msg': '结束'};");
        step.setDescription("结束");
        return step;
    }

    // 服务编排Links定义
    private List<ServiceComposerLink> convertConnectionsToLinks(List<ServiceComposerTask> tasks) {
        List<ServiceComposerLink> links = new ArrayList<>();
        for (int i = 0 ; i < tasks.size() ; i++) {
            String from = tasks.get(i).getId();
            if (i + 1 == tasks.size()) {
                break;
            }
            String to = tasks.get(i+1).getId();
            ServiceComposerLink link = new ServiceComposerLink();
            link.setId(LINK + UUID.randomUUID().toString().replaceAll("-","_"));
            link.setFrom(from);
            link.setTo(to);

            if (Objects.equals(ServiceComposerTaskTypeEnum.Decision.toString(),tasks.get(i).getType())) {
                link.setName("是");
                link.setType(ServiceComposerTaskTypeEnum.Decision.toString());
                link.setCaseExpression("$(detectedData).length > 0");

                // 不符合直接结束的link
                ServiceComposerLink endLink = new ServiceComposerLink();
                endLink.setId(LINK + UUID.randomUUID().toString().replaceAll("-","_"));
                endLink.setFrom(from);
                endLink.setTo(tasks.get(tasks.size() - 1).getId());
                endLink.setName("否");
                endLink.setType(ServiceComposerTaskTypeEnum.Decision.toString());
                links.add(endLink);
            }else {
                link.setType("Link");
            }
            links.add(link);
        }
        return links;
    }

    // 开始节点的脚本
    private String getStartScript(Sets sets) throws DWBusinessException {
        // 获取侦测类型
        boolean isArray = false;
        String dataName = "purchase_info";
        SystemPart sPart = sets.getS().getPart();
        String detectType = sPart.getDetectType();
        if (StringUtils.equalsIgnoreCase(MonitorRuleCategoryEnum.API.toString(), detectType)) {
            String tenantId = AthenaUtils.getTenantId();
            ApiDataFieldMetadataDTO actionResponse = kgService.getActionResponse(sPart.getActionId(), tenantId, sets.getVersion());
            if (actionResponse != null) {
                    isArray = actionResponse.getIs_array();
                    dataName = actionResponse.getData_name();
            }
        }

        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var scWorkflowModelContext = $(scWorkflowModelContext);\n")
                .append(" var detectedDataKey = Object.keys(scWorkflowModelContext.requestParams)[0];\n");
        if (StringUtils.equalsIgnoreCase(DetectType.SQL.toString(), detectType)) {
            codeBuilder.append(" var dataNew = [];\n");
        }

        if (isArray) {
            codeBuilder.append(" var detectedData = scWorkflowModelContext.requestParams[detectedDataKey][0].").append(dataName).append(";\n");
        }else {
            codeBuilder.append(" var detectedData = scWorkflowModelContext.requestParams[detectedDataKey];\n");
        }

        codeBuilder.append(" for (var i = 0; i < detectedData.length; i++) {\n");
        //如果是sql侦测 增加对提取的数据因数据库默认查询列均大写转化为小写
        if (StringUtils.equalsIgnoreCase(DetectType.SQL.toString(), detectType)) {
            codeBuilder.append(" var newDataItem ={};\n")
                    .append(" Object.keys(detectedData[i]).forEach( function(key){ \n" +
                            " if(key.toUpperCase()==key){ \n " +
                            "        newDataItem[key.toLocaleLowerCase()] = detectedData[i][key];\n" +
                            " } else{ \n" +
                            "        newDataItem[key] = detectedData[i][key];\n" +
                            " } "+
                            "    }); \n")
                    .append(" newDataItem.remark = '';\n")
                    .append(" newDataItem.adjust = true;\n")
                    .append(" newDataItem.sourceIds = '智能调参';\n")
                    .append(" newDataItem.charge_id = '1';\n")
                    .append(" newDataItem.performer_id = '1';\n")
                    .append( " dataNew.push(newDataItem);\n")
                    .append(" }\n")
                    .append("return {").append("\n")
                    .append("\"processVariable\": {").append("\n");
            codeBuilder.append("\"detectedData\":dataNew").append("\n");
        }else{
            codeBuilder.append(" detectedData[i].remark = '';\n")
                    .append(" detectedData[i].adjust = true;\n")
                    .append(" detectedData[i].sourceIds = '智能调参';\n")
                    .append(" detectedData[i].charge_id = '1';\n")
                    .append(" detectedData[i].performer_id = '1';\n")
                    .append(" }\n")
                    .append("return {").append("\n")
                    .append("\"processVariable\": {").append("\n");
            codeBuilder.append("\"detectedData\":detectedData").append("\n");
        }
        codeBuilder.append("}};").append("\n");
        return codeBuilder.toString();
    }


    // 设置charge_id的脚本
    private String getDataSetScript(String fieldName) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var detectedData = $(detectedData);\n")
                .append(" for (var i = 0; i < detectedData.length; i++) {\n")
                .append(" detectedData[i].charge_id = detectedData[i].").append(fieldName).append(";\n")
                .append(" }\n")
                .append("return {").append("\n")
                .append("\"processVariable\": {").append("\n")
                .append("\"detectedData\":detectedData").append("\n")
                .append("}};").append("\n");

        return codeBuilder.toString();
    }

    // 数据分组或其他处理的脚本
    private String getDataFroupScript(String value) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var detectedData = $(detectedData);").append("\n")
                .append(" var groupedData = {};\n")
                .append(" var output = [];\n")
                .append(" for (var i = 0; i < detectedData.length; i++) {\n")

                .append(" var customer_id = detectedData[i].").append(value).append("\n")
                .append(" if (!groupedData[customer_id]) {\n")
                .append(" groupedData[customer_id] = [];\n")
                .append(" }\n")
                .append(" groupedData[customer_id].push(detectedData[i]);\n")
                .append(" }\n")
                .append(" for (var key in groupedData) {\n")
                .append(" if (groupedData.hasOwnProperty(key)) {\n")
                .append(" var obj = {};\n")
                .append(" obj[\"data\"] = groupedData[key];\n")
                .append(" output.push(obj)\n")
                .append(" }\n")
                .append(" }\n")

                .append("return {").append("\n")
                .append("\"processVariable\": {").append("\n")
//                .append("\"detectedData\":detectedData,").append("\n")
                .append("\"detectedData\":output").append("\n")
                .append("}};").append("\n");

        return codeBuilder.toString();
    }

    // 数据筛选的脚本
    private String getFilterScript(String condition) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var detectedData = $(detectedData);").append("\n")
                .append("var filteredData = detectedData.filter(function(data) {").append("\n")
                .append("var result = ").append(condition).append(";").append("\n")
                .append(" return result;").append("\n")
                .append("});").append("\n")
                .append("detectedData = filteredData;").append("\n")
                .append("return {").append("\n")
                .append("\"processVariable\": {").append("\n")
                .append("\"detectedData\":detectedData").append("\n")
                .append("}};").append("\n");

        return codeBuilder.toString();
    }

    // 发起http请求的脚本
    private String getHttpScript(String setsCode,String isGroup, Processor personInCharge) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var dispatchData = [];").append("\n");
        if (Objects.equals(isGroup,"1")) { //分组
            codeBuilder.append("var d = $(data);").append("\n")
                    .append(" dispatchData = d.data;").append("\n");
        }else { // 不分组
            codeBuilder.append("dispatchData = $(detectedData);").append("\n");
        }
        codeBuilder.append("var requesterId = ");
        if ("field".equalsIgnoreCase(personInCharge.getType())) {
            // 字段类型当责者从dispatchData中取
            codeBuilder.append("dispatchData[0].charge_id;").append("\n");
        } else {
            // 非字段类型从personInCharge中取
            codeBuilder.append("'").append(personInCharge.getValue()).append("';\n");
        }
        codeBuilder.append("var variables = {};").append("\n")
                .append("variables.charge_id = requesterId;").append("\n")
                .append("var request = {").append("\n")
                .append("\"projectCode\":'").append(SetConstants.PROJECT_PREFIX +setsCode).append("',").append("\n")
                .append("\"dispatchData\": dispatchData").append(",").append("\n")
                .append("\"variables\": variables").append(",").append("\n");
        if ("field".equalsIgnoreCase(personInCharge.getType()) || "user".equalsIgnoreCase(personInCharge.getType())) {
            codeBuilder.append("\"requesterId\":requesterId,").append("\n");
        }
        codeBuilder.append("\"locale\":\"zh_CN\",").append("\n")
                .append("\"startDataStateCode\":'").append(setsCode + "_start").append("'\n")
                .append("};").append("\n")
                .append("return request;").append("\n");

        return codeBuilder.toString();
    }

    // 调用EOC请求的脚本
    private String getHttpEocScript(String fieldName) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var d = $(data);").append("\n")
                .append("var empId = d.").append(fieldName).append(";\n")
                .append("var request = {").append("\n")
                .append("\"empId\":empId").append("\n")
                .append("};").append("\n")
                .append("return request;").append("\n");

        return codeBuilder.toString();
    }

    // 调用EOC请求返回处理的脚本
    private String getHttpEocResponseScript(String fieldName) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var response = $(response);\n")
                .append("var detectedData = $(detectedData);").append("\n")
                .append("var d = $(data);").append("\n")
                .append("var empId = d.").append(fieldName).append(";\n")
                .append("if (response.code  === 200)").append("\n")
                .append("{").append("\n")
                .append("detectedData.forEach(function(item) {\n")
                .append("if (item.").append(fieldName).append("== empId)").append("\n")
                .append("{").append("\n")
                .append(" item.charge_id").append("= response.data;").append("\n")
                .append("}").append("\n")
                .append("});\n")
                .append("} else {").append("\n")
                .append("detectedData.forEach(function(item) {\n")
                .append("if (item.").append(fieldName).append("== empId) {").append("\n")
                .append(" item.charge_id").append("= empId;").append("\n")
                .append("}").append("\n")
                .append("});\n")
                .append("}").append("\n")
                .append("  return {\n" +
                        "    \"processVariable\": {\n" +
                        "      \"detectedData\": detectedData\n" +
                        "  }\n" +
                        "  };");

        return codeBuilder.toString();
    }

    // 调用接口发布服务编排模板
    private void publishTemplate(String dsl) {
        try {
            Map<String, Object> requestMap = new HashMap<>();
            requestMap.put("dsl", dsl);
            requestMap.put("tenantId",null);
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            headers.add("token", AthenaUtils.getHeaderToken());
            headers.add("routerKey",AthenaUtils.getTenantId());
            MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
            headers.setContentType(type);
            HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
            ResponseEntity<Object> result = restTemplate.exchange(scdispatcherUrl + PUBLISH_URL, HttpMethod.POST, requestEntity, Object.class);
            if (result.getStatusCodeValue() != 200) {
                log.error("publishTemplate failed");
            }
        } catch (Exception e) {
            log.error("publishTemplate failed,error:{}",e);
        }
    }

    public static void main(String[] args) throws DWBusinessException {
//        String httpTaskId = UUID.randomUUID().toString().replaceAll("-","_");
//        String endTaskId = UUID.randomUUID().toString().replaceAll("-","_");
//        String decisionId = UUID.randomUUID().toString().replaceAll("-","_");
//        String filterId = UUID.randomUUID().toString().replaceAll("-","_");
//        List<Step> steps = new ArrayList<>();
//        String json = "{ \"part\": { \"name\": \"业务数据理解\", \"type\": \"DataUnderstanding\", \"code\": \"partCode\", \"steps\": [ { \"id\": \"step1\", \"type\": \"API\", \"serviceName\": \"customer.credit.get\", \"description\": \"信用额度\", \"params\": [ { \"name\": \"supplier_detail.customer_code\", \"type\": \"Field\", \"value\": \"customerCode\" }, { \"name\": \"customer_type\", \"type\": \"Constant\", \"value\": \"Standard\" } ], \"returnFields\": [ { \"datasourceField\": \"customer_detail.customer_credit\", \"displayName\": \"信用额度\", \"editable\": true, \"hide\": false } ] }, { \"id\": \"step2\", \"description\": \"信用额度\", \"type\": \"Script\", \"script\": \"currentRow[\\\"customer_credit\\\"] * 1.5\", \"returnFields\": [ { \"datasourceField\": \"customer_detail.customer_credit\", \"displayName\": \"信用额度\", \"editable\": true, \"hide\": false } ], \"executeMode\": \"ByRow\" }, { \"id\": \"step3\", \"type\": \"Constant\", \"value\": \"3\", \"valueType\": \"String\", \"description\": \"信用额度\", \"returnFields\": [ { \"datasourceField\": \"customer_detail.customer_credit\", \"displayName\": \"信用额度\", \"editable\": true, \"hide\": false } ] } ], \"conns\": [ { \"from\": \"\", \"to\": \"step1\" }, { \"from\": \"step1\", \"to\": \"step2\" }, { \"from\": \"step1\", \"to\": \"step3\" }, { \"from\": \"step2\", \"to\": \"\" }, { \"from\": \"step3\", \"to\": \"\" } ] } }";
//        JSONObject jsonObject = JSON.parseObject(json);
//        DataUnderstandingPart part = jsonObject.getObject("part", DataUnderstandingPart.class);
//        DataUnderstandingPartParser understandingPartParser = new DataUnderstandingPartParser();
//        StringBuilder sb = new StringBuilder();
//        sb.append("var activities = [{'taskId': '").append("ProjectBySet_f30f08b9389846e4a4b8ef21b1270b20").append("', 'activityId':").append("'mmmm'").append("}];\n");
//        System.out.println(sb);
        String emailName = String.format("业务过程随心控%s邮件通知", "123");
        String projectCode = "projectCode";
        String code = "limit1";
        String tenantId = "tenantId";
        StringBuilder sb = new StringBuilder();
        sb.append("var detectedData = $(detectedData);").append("\n")
                .append("var receivers = [];").append("\n")
                .append("var lang = {'zh_CN':'").append(emailName).append("','zh_TW':'").append(emailName).append("','en_US':'").append(emailName).append("'};").append("\n")
                .append("var activities = [{'taskId': '").append(projectCode).append("', 'activityId':").append("null").append("}];\n")
                .append("for (var i=0;i<detectedData.length;i++) {").append("\n")
                .append("var item=detectedData[i];").append("if(item.").append(code).append(" && !receivers.some(e => item.").append(code).append(" == e)){").append("\n")
                .append("receivers.push(item.").append(code).append(")}};").append("\n")
                .append("var request = {").append("\n")
                .append("'receiveStaff' : receivers,").append("\n")
                .append("'activityList' : activities,").append("\n")
                .append("'tenantId':'").append(tenantId).append("',").append("\n")
                .append("'appCode':'").append("appcode").append("',").append("\n")
                .append("'emailName':lang,").append("\n")
                .append("'description':lang,").append("\n")
                .append("'type':'").append(1).append("',").append("\n")
                .append("'state':'").append(1).append("',").append("\n")
                .append("'updateBy':'").append("userId").append("',").append("\n")
                .append("'langName':'$(processLocale)'").append(",").append("\n")
                .append("'previewId':'").append("previewId").append("'\n")
                .append("}").append("\n")
                .append("return request;");
        System.out.println(sb);
        //        String jsons = "{\n" +
//                "    \"part\":{\n" +
//                "        \"name\":\"阈值判断\",\n" +
//                "        \"description\":\"客户信用额度超标判断\",\n" +
//                "        \"type\":\"ThresholdEvaluate\",\n" +
//                "        \"code\":\"partCode\",\n" +
//                "        \"thresholdCondition\":{\n" +
//                "            \"type\":\"OR_GROUP\",\n" +
//                "            \"items\":[\n" +
//                "                {\n" +
//                "                    \"type\":\"SINGLE\",\n" +
//                "                    \"leftField\":\"field1\",\n" +
//                "                    \"op\":\"GreaterThanEqual\",\n" +
//                "                    \"rightField\":\"field2\"\n" +
//                "                },\n" +
//                "                {\n" +
//                "                    \"type\":\"AND_GROUP\",\n" +
//                "                    \"items\":[\n" +
//                "                        {\n" +
//                "                            \"type\":\"SINGLE\",\n" +
//                "                            \"leftField\":\"field3\",\n" +
//                "                            \"op\":\"GreaterThanEqual\",\n" +
//                "                            \"rightField\":\"field4\"\n" +
//                "                        },\n" +
//                "                        {\n" +
//                "                            \"type\":\"SINGLE\",\n" +
//                "                            \"leftField\":\"field5\",\n" +
//                "                            \"op\":\"NotEqual\",\n" +
//                "                            \"rightField\":\"field6\"\n" +
//                "                        }\n" +
//                "                    ]\n" +
//                "                },\n" +
//                "                {\n" +
//                "                    \"type\":\"SINGLE\",\n" +
//                "                    \"leftField\":\"field7\",\n" +
//                "                    \"op\":\"Include\",\n" +
//                "                    \"rightField\":\"field8\"\n" +
//                "                }\n" +
//                "            ]\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//        JSONObject jsonObjects = JSON.parseObject(jsons);
//        ThresholdEvaluatePart parts = jsonObjects.getObject("part", ThresholdEvaluatePart.class);
//        if (StringUtils.isNotEmpty(parts.getThresholdCondition().getType())) {
//            String javascriptExpressions = parts.toJavaScriptExpression();
//            steps.add(understandingPartParser.buildFilterStep(filterId,javascriptExpressions)); // 加数据筛选节点
//        }
//        steps.add(understandingPartParser.buildDecisionStep(decisionId)); // 加判断节点
//        steps.add(understandingPartParser.buildHttpStep("setsCode",httpTaskId,"", null)); // 加Http节点
//        steps.add(understandingPartParser.buildEndStep(endTaskId)); // 加end节点
//        ServiceComposer serviceComposer = new ServiceComposer();
//        List<ServiceComposerTask> tasks = understandingPartParser.executePart(part,steps,"1.0");
//        List<ServiceComposerLink> links = understandingPartParser.convertConnectionsToLinks(tasks);
//        serviceComposer.setLinks(links);
//        serviceComposer.setTasks(tasks);
//        serviceComposer.setId(SetConstants.SERVICECOMPOSER_PREFIX + UUID.randomUUID());
//        serviceComposer.setName("参数调整套件的服务编排");
//        System.out.println(JSON.toJSONString(serviceComposer));
    }


}
