package com.digiwin.athena.knowledgegraph.set.partParsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.set.IOperateParser;
import com.digiwin.athena.knowledgegraph.set.SetConstants;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.set.part.Part;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @title: OperatePartParser
 * @author: linc
 * @date 2023/11/1 13:35
 * @version: 1.0
 */
@Service
@Slf4j
public class OperatePartParser implements IOperateParser {

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplate;

    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;

    @Override
    public boolean accept(SetParseContext context) {
        return StringUtils.equalsIgnoreCase("delete", context.getCurrentSet().getOperate());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        updateTenantMonitorRuleStatus(SetConstants.RULE_PREFIX + context.getCurrentSet().getCode());
    }

    // 更新租户的侦测数据并且通知sd停用
    private void updateTenantMonitorRuleStatus(String ruleId) {
        Query query = new Query();
        Criteria criteria = Criteria.where("monitorRuleId").is(ruleId);
        query.addCriteria(criteria);
        List<MonitorRuleTenantConfig> monitorRuleTenantConfigList = mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        try {
            if (!CollectionUtils.isEmpty(monitorRuleTenantConfigList)) {
                for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
                    monitorRuleConfigService.putDisable(monitorRuleTenantConfig.getTenantId(),monitorRuleTenantConfig.getMonitorRuleId(),monitorRuleTenantConfig.getEocMap());
                }
            }
        } catch (Exception e) {
            log.error("Sets updateTenantMonitorRuleStatus error: {}",e);
        }
    }
}
