package com.digiwin.athena.knowledgegraph.set.partParsers.monitorRule;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.set.SetConstants;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.SystemPart;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @title: SqlMonitorRulePartParser
 * @author: linc
 * @date 2023/10/14 14:59
 * @version: 1.0
 */
@Service
public class SqlMonitorRulePartParser implements IMonitorRulePartParser {
    @Autowired
    KgHelpService kgHelpService;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase("SQL", part.getDetectType());
    }

    @Override
    public void parse(MonitorRule monitorRule, Sets sets) throws DWBusinessException {
        saveMonitorRule(sets , monitorRule);
    }

    private void saveMonitorRule(Sets sets , MonitorRule monitorRule) {
        // 存neo4j
        SystemPart sPart = sets.getS().getPart();
        String jsonString = "CREATE (m:MonitorRule{actionType:'serviceComposer',code:$code,"
                + "autoRun:true,pluginId:$pluginId,"
                + "name:$name,"
                + "actionCommonId:$actionCommonId,"
                + "standardPollingRule:$standardPollingRule,"
                + "type:'SQL_SCRIPT',category:'SQL_SCRIPT',version:$version,athena_namespace:$athena_namespace})";

        Map<String, Object> props = new HashMap<>();
        props.put("code",monitorRule.getId());
        props.put("pluginId",sets.getCode());
        props.put("name",monitorRule.getName());
        props.put("actionCommonId", SetConstants.SERVICECOMPOSER_PREFIX + sets.getCode()); // 服务编排id
        props.put("standardPollingRule", JSON.toJSONString(sPart.getStandard_polling_rule()));
        props.put("version",monitorRule.getVersion());
        props.put("athena_namespace",sets.getAppCode());
        props.put("tenantId", "SYSTEM");
        kgHelpService.executeCyhper(jsonString,props);

        // 侦测存储到mongo
        MonitorRuleProductConfig monitorRuleProductConfig = new MonitorRuleProductConfig();
        monitorRuleProductConfig.setMonitorRuleId(monitorRule.getId());
        monitorRuleProductConfig.setProductName(monitorRule.getProductName());
        monitorRuleProductConfig.setVersion(monitorRule.getVersion());
        monitorRuleProductConfig.setPluginId(sets.getCode());
        monitorRuleProductConfig.setIsPollingIds(Boolean.FALSE);
        monitorRuleProductConfig.setScript(sPart.getSqlScript());
        monitorRuleProductConfig.setAthena_namespace(sets.getAppCode());
        monitorRuleProductConfig.setTenantId("SYSTEM");
        mongoTemplateSystem.save(monitorRuleProductConfig);
    }

}
