package com.digiwin.athena.knowledgegraph.support;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 签核套件应用相关
 */
public class SignOffAppHolder {
    /**
     * 用于存储签核套件应用标志的线程局部变量
     */
    private static final ThreadLocal<Boolean> signOffAppFlag = new ThreadLocal<>();
    
    /**
     * 签核套件应用代码列表
     */
    private static final List<String> signOffAppCodes = Arrays.asList("EAS", "DDSM");

    /**
     * 设置签核套件应用标志
     *
     * @param appCode 应用代码
     */
    public static void setSignOffAppFlag(String appCode) {
        if (StringUtils.isNotEmpty(appCode) && signOffAppCodes.contains(appCode)) {
            signOffAppFlag.set(true);
        }
    }
    
    /**
     * 获取签核套件应用标志
     *
     * @return 签核套件应用标志
     */
    public static Boolean getSignOffAppFlag() {
        return signOffAppFlag.get();
    }
    
    /**
     * 移除签核套件应用标志
     */
    public static void removeSignOffAppFlag() {
        signOffAppFlag.remove();
    }
}

