package com.digiwin.athena.knowledgegraph.support.custom;

import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismContext;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismOld;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismScene;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismService;
import com.digiwin.athena.knowledgegraph.support.MechanismCustomer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-11-06 10:13
 **/
@Service
public class MaterialStockCustomer implements MechanismCustomer {


    @Autowired
    MechanismService mechanismService;

    @Override
    public boolean accept(MechanismContext context) {
        return context!=null && "mechanism_materialStock".equalsIgnoreCase(context.getMechanismKey());
    }

    @Override
    public Object notifyChange(MechanismContext context) {
        return null;
    }

    @Override
    public Object notifyApproveSuccess(MechanismContext context) {
        return null;
    }

    @Override
    public Object filter(MechanismContext context) {
        return null;
    }

    /*
    接口定制部分.诚然这种硬编码实现方式不好.但实在找不到更优美的办法...
     */
    @Override
    public void innerDoMechanismMaterialConfig(MechanismContext context) {
        MechanismOld me = context.getMechanism();
        Map<String,Object> data = context.getAttach();

        List<Map<String,String>> material_type = new ArrayList<>();
        List<Map<String,Object>> material_position = new ArrayList<>();
        List<Map<String,String>> target_market = new ArrayList<>();
        List<Map<String,Object>> semiproducts_type = new ArrayList<>();
        List<Map<String,Object>> products_type = new ArrayList<>();
        List<Map<String,Object>> item_type_data = new ArrayList<>();
        Map<String,Object> products = new HashMap();
        Map<String,Object> material = new HashMap<>();
        Map<String,Object> semiproducts = new HashMap<>();

        me.getClassifications().forEach(cf->{
            if("classify_material_rate".equalsIgnoreCase(cf.getKey()) && null!=cf.getConditions()){//原物料数据
                cf.getConditions().forEach(cond->{
                    Map<String,String> tmp = new HashMap<>();
                    tmp.put("material_type_code",cond.getKey());
                    tmp.put("material_type_name",cond.getName());
                    material_type.add(tmp);
                    String[] keys = new String[]{"materialType_material",cond.getKey()};
                    MechanismScene scene = mechanismService.getScene(me,keys);
                    Map<String,Object> tmp2 = new HashMap<>();
                    tmp2.put("material_position_code",cond.getKey());
                    tmp2.put("material_position_name",cond.getName());
                    tmp2.put("frequency_interval",cond.getCondition());
                    if(null!=scene && null!= scene.getSuggests() && scene.getSuggests().size()>0){
                        tmp2.put("reasonable_purchase_interval_days",scene.getSuggests().get(0).getValue());
                    }
                    material_position.add(tmp2);

                });
            }

            if("classify_FamilyAndIndustry".equalsIgnoreCase(cf.getKey()) && null!=cf.getConditions()){//目標市場分類
                cf.getConditions().forEach(cond->{
                    Map<String,String> tmp = new HashMap<>();
                    tmp.put("target_market_code",cond.getKey());
                    tmp.put("target_market_name",cond.getName());
                    tmp.put("target_market_condition",cond.getCondition()==null?"":cond.getCondition().toString());
                    tmp.put("inv_type",cond.getType());
                    target_market.add(tmp);
                });
            }

            if("classify_halfProduct_kind".equalsIgnoreCase(cf.getKey()) && null!=cf.getConditions()){//半成品分類
                cf.getConditions().forEach(cond->{
                    Map<String,Object> tmp = new HashMap<>();
                    tmp.put("semi_products_type_code",cond.getKey());
                    tmp.put("semi_products_type_name",cond.getName());
                    tmp.put("semi_products_type_condition",cond.getCondition()==null?"":cond.getCondition().toString());
                    tmp.put("semi_products_leadtime",cond.getValue());
                    semiproducts_type.add(tmp);
                    Map<String,Object> tmp2 = new HashMap<>();
                    tmp2.put("key",cond.getKey());
                    tmp2.put("name",cond.getName());
                    semiproducts.put(cond.getName(),tmp2);
                });
            }
//
//            if("classify_product_Sale".equalsIgnoreCase(cf.getKey()) && null!=cf.getConditions()){//
//                cf.getConditions().forEach(cond->{
//                    Map<String,Object> tmp = new HashMap<>();
//                    tmp.put("products_type_code",cond.getKey());
//                    tmp.put("products_type_name",cond.getName());
//                    tmp.put("spec_service_level",cond.getCondition());
//                    products_type.add(tmp);
//                });
//            }
//            if("classify_product_Volatility".equalsIgnoreCase(cf.getKey())){//
//                cf.getConditions().forEach(cond->{
//                    Map<String,Object> tmp = new HashMap<>();
//                    tmp.put("products_type_code",cond.getKey());
//                    tmp.put("products_type_name",cond.getName());
//                    tmp.put("spec_service_level",cond.getCondition());
//                    products_type.add(tmp);
//                });
//            }

        });


        me.getScenes().forEach(scene->{
            if("materialStock_productScenes".equalsIgnoreCase(scene.getCategory())){//成品场景
                   Map<String,Object> tmp = new HashMap<>();
                    tmp.put("products_type_code",scene.getKey());
                    tmp.put("products_type_name",scene.getName());
                    tmp.put("service_level",scene.getCondition());
                    if(null!=scene.getProperties() && !scene.getProperties().isEmpty()){
                        tmp.putAll(scene.getProperties());
                    }
                    products_type.add(tmp);

                Map<String,Object> tmp2 = new HashMap<>();
                tmp2.put("key",scene.getKey());
                tmp2.put("name",scene.getName());
                if(null!=scene.getFormula()){
                    tmp2.put("formulaName",scene.getFormula().getFormulaName());
                }
                if(null!=scene.getSuggests() && scene.getSuggests().size()>0){
                    tmp2.put("suggestName",scene.getSuggests().get(0).getName());
                }
                products.put(scene.getName(),tmp2);
                //products.put(scene.getKey(),tmp2);
            }
            if("materialStock_materialScenes".equalsIgnoreCase(scene.getCategory())){//原材料场景

                Map<String,Object> tmp2 = new HashMap<>();
                tmp2.put("key",scene.getKey());
                tmp2.put("name",scene.getName());
                if(null!=scene.getFormula()){
                    tmp2.put("formulaName",scene.getFormula().getFormulaName());
                }
                if(null!=scene.getSuggests() && scene.getSuggests().size()>0){
                    tmp2.put("suggestName",scene.getSuggests().get(0).getName());
                }
                material.put(scene.getName(),tmp2);
                //material.put(scene.getKey(),tmp2);
            }

        });

        me.getDataAction().forEach(action->{

            if(action.getParams()!=null && action.getParams().size()>0){
                Map<String,Object> tmp = new HashMap<>();
                action.getParams().forEach(param->{
                    tmp.put(param.getKey(),param.getValue());
                });
                tmp.remove("time_distance");
                item_type_data.add(tmp);
            }

        });


        if(!material_type.isEmpty()){
            data.put("material_type",material_type);
        }
        if(!material_position.isEmpty()){
            data.put("material_position",material_position);
        }

        if(!target_market.isEmpty()){
            data.put("target_market",target_market);
        }

        if(!semiproducts_type.isEmpty()){
            data.put("semi_products_type",semiproducts_type);
        }

        if(!products_type.isEmpty()){
            data.put("products_type",products_type);
        }
        if(!item_type_data.isEmpty()){
            data.put("item_type_data",item_type_data);
        }
        data.put("products",products);
        data.put("material",material);
        data.put("semiproducts",semiproducts);


    }
}
