package com.digiwin.athena.knowledgegraph.support.custom;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismContext;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.*;
import com.digiwin.athena.knowledgegraph.repoSystem.AbsEntityDictRepository;
import com.digiwin.athena.knowledgegraph.repo.MechanismAchiveRecordRepository;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismService;
import com.digiwin.athena.knowledgegraph.support.MechanismCustomer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-11-03 20:52
 **/
@Service
public class SupplierChooseCustomer implements MechanismCustomer {

    private Log log = LogFactory.getLog(SupplierChooseCustomer.class);

    @Autowired
    private MechanismService mechanismService;

    @Autowired
    MechanismAchiveRecordRepository mechanismAchiveRecordRepository;

    @Autowired(required = false)
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateTenant;

    @Autowired
    AbsEntityDictRepository absEntityDictRepository;

    @Autowired
    SessionFactory sessionFactory;

    @Override
    public boolean accept(MechanismContext context) {
        return context!=null && "mechanism_SupplierChoose".equalsIgnoreCase(context.getMechanismKey());
    }

    @Override
    public Object notifyChange(MechanismContext context) throws DWBusinessException {

        if( null==context.getKey()){
            log.warn("config key  is null");
            return null;
        }
        if( null==context.getTaskId()){
            log.warn("config taskId  is null");
            return null;
        }
        MechanismOld me=mechanismService.getDetail(context.getTenant(),context.getMechanismKey());
        if(null!=me && null!=me.getScenes()){
            String key = context.getKey();
            String taskId =  context.getTaskId();
            for(MechanismScene sc : me.getScenes()){
                if(key.equals(sc.getKey())){
                    MechanismFormula2 formula2 = sc.getFormula();
                    if(null!=formula2){
                        MechanismAchiveRecord dict1 = new MechanismAchiveRecord();
                        dict1.setMechanismKey(context.getMechanismKey());
                        dict1.setKey(taskId);
                        dict1.setTenantId(context.getTenant());
                        dict1.setRecordStatus(0);
                        dict1.setKey(taskId);
                        dict1.setInstanceId(context.getInstanceId());
                        dict1.setValue(formula2);
                    //    mechanismAchiveRecordRepository.save(dict1);
                        mongoTemplateTenant.save(dict1);

                    }
                    break;
                }
            }

        }
    return null;

    }

    @Override
    public Object notifyApproveSuccess(MechanismContext context) throws DWBusinessException {
        MechanismAchiveRecord record = context.getRecord();

//        AbsEntityDict dict = absEntityDictRepository.findOneByCategoryAndKeyAndTenantAndStatus(com.digiwin.athena.knowledgegraph.domain2.mechanism.TaskMechanismConfig.class.getSimpleName(),context.getKey(),context.getTenant(),1);
//        if(dict!=null && dict.getAbstraction()!=null && null!=record && null!=record.getValue()){
//            com.digiwin.athena.knowledgegraph.domain2.mechanism.TaskMechanismConfig config = (com.digiwin.athena.knowledgegraph.domain2.mechanism.TaskMechanismConfig) dict.getAbstraction();
//            config.setFormula(JSON.parseObject(JSON.toJSONString(record.getValue()),MechanismFormula2.class));
//            absEntityDictRepository.save(dict);
//
//        }

        Session session =sessionFactory.openSession();
        MechanismOld me = mechanismService.getDetail(context.getTenant(),context.getMechanismKey());
        MechanismFormula2 newF = JSON.parseObject(JSON.toJSONString(record.getValue()),MechanismFormula2.class);
        for(TaskMechanismConfig config : me.getTaskConfigs()){
            if (context.getKey().equals(config.getKey())){
                config.setFormula(newF);
                session.save(me);
                break;
            }
        }

        return null;

    }

    @Override
    public Object filter(MechanismContext context) {
        Assert.notNull(context.getKey(),"taskId is null");
        if(null!=context.getAttach()){
            MechanismOld me = (MechanismOld) context.getAttach().get("mechanism");
            MechanismAchiveRecord record = (MechanismAchiveRecord) context.getAttach().get("record");
            Map<String,Object> result = new HashMap<>();
            if(null!=me && null!=me.getTaskConfigs()){
                for(com.digiwin.athena.knowledgegraph.domain2.mechanism.TaskMechanismConfig tc:me.getTaskConfigs()){
                    if (context.getKey().equalsIgnoreCase(tc.getKey())){
                        MechanismAchiveRecord record1 = new MechanismAchiveRecord();
                        record1.setInstanceId(context.getInstanceId());
                        record1.setTenantId(context.getTenant());
                        record1.setKey(context.getKey());
                        record1.setMechanismKey(context.getMechanismKey());
                        record1.setValue(tc.getFormula());
                        result.put("old",record1);
                        break;
                    }
                }

            }
            if(null!=record && null!=record.getValue()){
                result.put("new",record);
            }

            if(!result.isEmpty()){
                return result;
            }

        }

        return null;
    }

    @Override
    public void innerDoMechanismMaterialConfig(MechanismContext context) {
        MechanismOld me = context.getMechanism();
        Map<String,Object> data = context.getAttach();

    }


}
