package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import java.util.Collections;
import java.util.Map;

/**
 * @ClassName LinkFactory
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/7/22 19:52
 * @Version 1.0
 **/
public class LinkFactory {
    private static final String LINK_PREFIX = "Link";
    private static final String TYPE = "Link";
    private static final Map EMPTY_MAP = Collections.EMPTY_MAP;

    public static Link createLink(Node preNode, Node nextNode, int size) {
        final int index = size + 1;
        Link link = new Link();
        link.setId(LINK_PREFIX + index)
                .setText("")
                .setFromId(preNode.getId())
                .setToId(nextNode.getId())
                .setCondition("")
                .setConditionType("CONDITION")
                .setType(TYPE).setTextI18n(EMPTY_MAP)
                .setDescription(LINK_PREFIX + index)
                .setFakeFromId(preNode.getId())
                .setFakeToId(nextNode.getId()).setFakeId(LINK_PREFIX + index)
                .setPointPosition(EMPTY_MAP);
        return link;
    }
}
