package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.knowledgegraph.data.Neo4jConstants;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.GraphHelperTemplate;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.SpringUtil;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @ClassName NodeFactory
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/7/21 14:05
 * @Version 1.0
 **/
public class NodeFactory {
    private static final String START_NODE = "StartEvent";
    private static final String END_NODE = "EndEvent";
    private static final String USER_TASK = "UserTask";
    private static final String PARALLEL_GATEWAY = "ParallelGateway";
    private static final String SERVICE_TASK = "ServiceTask";

    private static final String EXTERNAL_REQUEST_HTTP_METHOD_POST = "POST";

    private static final String FIRST_GET_FIRST_WIN = "FIRST_GET_FIRST_WIN";

    private static final String EXTERNAL_SERVICE_REQUEST_TYPE = "standard";

    private static final Map EMPTY_MAP = Collections.EMPTY_MAP;
    public static Node createNode(Map nodeMap, String tenantId, List<ProcessVariable> requiredPVs, ProcessVariable createdPV) throws DWBusinessException {
        NodeType nodeType = (NodeType) nodeMap.get("type");
        int nodeIndex = (int) nodeMap.get("index");
        Node node = new Node();
        switch (nodeType) {
            case START:
                node.setId(START_NODE + nodeIndex)
                        .setIndex(nodeIndex)
                        .setName((String) nodeMap.get("name"))
                        .setType(START_NODE + nodeIndex)
                        .setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST)
                        .setExternalServiceUrl("")
                        .setMultiUserMode(FIRST_GET_FIRST_WIN)
                        .setGroupId("")
                        .setDescription("")
                        .setLimit(0)
                        .setVisible(true)
                        .setTextI18n(EMPTY_MAP)
                        .setExternalRequestParameters(EMPTY_MAP)
                        .setExternalResponseParameters(EMPTY_MAP)
                        .setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE)
                        .setExternalCustomRequest("")
                        .setBeforeRequestScript("")
                        .setAfterRequestScript("")
                        .setAsync(false)
                        .setExternalCustomHeader("")
                        .setServicePattern("")
                        .setEspServiceName("")
                        .setEspProductName("")
                        .setPerformerType(0)
                        .setProcessVariable("")
                        .setBasicOnProcessVariable("")
                        .setTop(0)
                        .setLeft(0)
                        .setWidth(50)
                        .setHeight(50)
                        .setBasicOnTask("")
                        .setNotice(false)
                        .setNoticeTemplate(EMPTY_MAP)
                        .setOrgService("")
                        .setSpecificRoleId("")
                        .setSpecificRoleId(START_NODE + nodeIndex);
                return node;
            case USER:
                node.setId(USER_TASK + nodeIndex)
                        .setIndex(nodeIndex)
                        .setName((String) nodeMap.get("name"))
                        .setType(USER_TASK + nodeIndex)
                        .setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST)
                        .setExternalServiceUrl("")
                        .setMultiUserMode(FIRST_GET_FIRST_WIN)
                        .setGroupId("")
                        .setDescription("")
                        .setLimit(0)
                        .setVisible(true)
                        .setTextI18n(EMPTY_MAP)
                        .setExternalRequestParameters(EMPTY_MAP)
                        .setExternalResponseParameters(EMPTY_MAP)
                        .setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE)
                        .setExternalCustomRequest("")
                        .setBeforeRequestScript("")
                        .setAfterRequestScript("")
                        .setAsync(false)
                        .setExternalCustomHeader("")
                        .setServicePattern("")
                        .setEspServiceName("")
                        .setEspProductName("")
                        .setPerformerType(0)
                        .setProcessVariable("")
                        .setBasicOnProcessVariable("")
                        .setTop(0)
                        .setLeft(0)
                        .setWidth(50)
                        .setHeight(50)
                        .setBasicOnTask("")
                        .setNotice(false)
                        .setNoticeTemplate(EMPTY_MAP)
                        .setOrgService("")
                        .setSpecificRoleId("")
                        .setSpecificRoleId(USER_TASK + nodeIndex);
                return node;
            case SERVICE:
                List<String> nodeLabels = (List<String>) nodeMap.get("eleLabels");
                node.setId(SERVICE_TASK + nodeIndex)
                        .setIndex(nodeIndex)
                        .setName((String) nodeMap.get("name"))
                        .setType(SERVICE_TASK + nodeIndex)
                        .setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST)
                        .setExternalServiceUrl("")
                        .setMultiUserMode(FIRST_GET_FIRST_WIN)
                        .setGroupId("")
                        .setDescription("")
                        .setLimit(0)
                        .setVisible(true)
                        .setTextI18n(EMPTY_MAP)
                        .setExternalRequestParameters(EMPTY_MAP)
                        .setExternalResponseParameters(EMPTY_MAP)
                        .setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE)
                        .setExternalCustomRequest("")
                        .setBeforeRequestScript("")
                        .setAfterRequestScript("")
                        .setAsync(false)
                        .setExternalCustomHeader("")
                        .setServicePattern("")
                        .setEspServiceName("")
                        .setEspProductName("")
                        .setPerformerType(3)
                        .setProcessVariable("")
                        .setBasicOnProcessVariable("")
                        .setTop(0)
                        .setLeft(0)
                        .setWidth(50)
                        .setHeight(50)
                        .setBasicOnTask("")
                        .setNotice(false)
                        .setNoticeTemplate(EMPTY_MAP)
                        .setOrgService("")
                        .setSpecificRoleId("")
                        .setSpecificRoleId(SERVICE_TASK + nodeIndex);
                if (nodeLabels.contains(Neo4jConstants.LABEL_ESP_ACTION)) {
                    //espAction
                    String productName;
                    try {
                        productName = SpringUtil.getBean(ProductNameResolver.class)
                                .getProductName((String) nodeMap.get("serviceName"), tenantId);
                    } catch (Exception e) {
                        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.searchProductError"));
                    }
                    node.setEspProductName(productName)
                            .setEspServiceName((String) nodeMap.get("serviceName"))
                            .setServicePattern("servicePool")
                            .setExternalCustomHeader("")
                            .setExternalServiceRequestType("scriptEngine");
                    //设置脚本
                    Map requestScriptSubstituteMap = new HashMap(3);
                    Map responseScriptSubstituteMap = new HashMap(3);
                    //根据内部依赖字段确定依赖的流程变量
                    Map<String,Map> innerRequireParas = (Map) nodeMap.get("requires");
                    if (!CollectionUtils.isEmpty(innerRequireParas)) {
                        //TODO 入参是一个实体
                        Map<String, List<String>> requireEntity = new HashMap<>();
                        for (String paraKey : innerRequireParas.keySet()) {
                            requireEntity = innerRequireParas.get(paraKey);
                        }
                        List<String> processVariableKey = new LinkedList<>();
                        if (!CollectionUtils.isEmpty(requireEntity)) {
                            for (String paraKey : requireEntity.keySet()) {
                                if (requireEntity.get(paraKey).size() > 1) {
                                    requireEntity.get(paraKey).forEach(item ->{
                                        processVariableKey.add(item.substring(0, item.lastIndexOf(GraphHelperTemplate.VAR_DELIMITER)));
                                    });
                                }
                            }
                        }
                        requestScriptSubstituteMap.put("processVariables", processVariableKey);
                    }
                    Map<String,Map> outerRequireParas = (Map) nodeMap.get("outerRequires");
                    if (!CollectionUtils.isEmpty(outerRequireParas)) {
                        //TODO 入参是一个实体
                        Map<String, List<String>> requireEntity = new HashMap<>();
                        for (String paraKey : outerRequireParas.keySet()) {
                            requireEntity = outerRequireParas.get(paraKey);
                        }
                        List<String> processVariableKey = new LinkedList<>();
                        if (!CollectionUtils.isEmpty(requireEntity)) {
                            for (String paraKey : requireEntity.keySet()) {
                                if (requireEntity.get(paraKey).size() > 1) {
                                    requireEntity.get(paraKey).forEach(item ->{
                                        processVariableKey.add(item.substring(0, item.lastIndexOf(GraphHelperTemplate.VAR_DELIMITER)));
                                    });
                                }
                            }
                        }
                        requestScriptSubstituteMap.put("outerProcessVariables", processVariableKey);
                    }

                    if (!CollectionUtils.isEmpty(requiredPVs)) {
                        //TODO 暂且认为入参只有一个
                        Assert.isTrue(requiredPVs.size() == 1, "暂且认为requiredPVs入参只有一个");
                        requestScriptSubstituteMap.put("param", requiredPVs.get(0).getName());
                    }
                    if (null != createdPV) {
                        responseScriptSubstituteMap.put("response", createdPV.getName());
                    }
                    node.setBeforeRequestScript(VelocityEngineHelper.replace(requestScriptSubstituteMap, "/vm/esprequest.vm"))
                            .setAfterRequestScript(VelocityEngineHelper.replace(responseScriptSubstituteMap, "/vm/espresponse.vm"));
                    }
                return node;
            case END:
                node.setId(END_NODE + nodeIndex)
                        .setIndex((Integer) nodeMap.get("index"))
                        .setName((String) nodeMap.get("name"))
                        .setType(END_NODE + nodeIndex)
                        .setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST)
                        .setExternalServiceUrl("")
                        .setMultiUserMode(FIRST_GET_FIRST_WIN)
                        .setGroupId("")
                        .setDescription("")
                        .setLimit(0)
                        .setVisible(true)
                        .setTextI18n(EMPTY_MAP)
                        .setExternalRequestParameters(EMPTY_MAP)
                        .setExternalResponseParameters(EMPTY_MAP)
                        .setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE)
                        .setExternalCustomRequest("")
                        .setBeforeRequestScript("")
                        .setAfterRequestScript("")
                        .setAsync(false)
                        .setExternalCustomHeader("")
                        .setServicePattern("")
                        .setEspServiceName("")
                        .setEspProductName("")
                        .setPerformerType(0)
                        .setProcessVariable("")
                        .setBasicOnProcessVariable("")
                        .setTop(0)
                        .setLeft(0)
                        .setWidth(50)
                        .setHeight(50)
                        .setBasicOnTask("")
                        .setNotice(false)
                        .setNoticeTemplate(EMPTY_MAP)
                        .setOrgService("")
                        .setSpecificRoleId("")
                        .setSpecificRoleId(END_NODE + nodeIndex);
                return node;
            case PARAGATEWAY:
                node.setId(PARALLEL_GATEWAY + nodeIndex)
                        .setIndex(nodeIndex)
                        .setName("Gateway")
                        .setType(PARALLEL_GATEWAY + nodeIndex)
                        .setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST)
                        .setExternalServiceUrl("")
                        .setMultiUserMode(FIRST_GET_FIRST_WIN)
                        .setGroupId("")
                        .setDescription("")
                        .setLimit(0)
                        .setVisible(true)
                        .setTextI18n(EMPTY_MAP)
                        .setExternalRequestParameters(EMPTY_MAP)
                        .setExternalResponseParameters(EMPTY_MAP)
                        .setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE)
                        .setExternalCustomRequest("")
                        .setBeforeRequestScript("")
                        .setAfterRequestScript("")
                        .setAsync(false)
                        .setExternalCustomHeader("")
                        .setServicePattern("")
                        .setEspServiceName("")
                        .setEspProductName("")
                        .setPerformerType(0)
                        .setProcessVariable("")
                        .setBasicOnProcessVariable("")
                        .setTop(0)
                        .setLeft(0)
                        .setWidth(50)
                        .setHeight(50)
                        .setBasicOnTask("")
                        .setNotice(false)
                        .setNoticeTemplate(EMPTY_MAP)
                        .setOrgService("")
                        .setSpecificRoleId("")
                        .setSpecificRoleId(PARALLEL_GATEWAY + nodeIndex);
                return node;
            default:
                throw new IllegalStateException(I18nUtils.getValue("knowledgegraph.unexpectedValue",nodeType));
        }
    }
}
