package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import org.springframework.util.Assert;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import static com.digiwin.athena.knowledgegraph.svcomposition.graph.GraphHelperTemplate.VAR_DELIMITER;

/**
 * @ClassName ProcessVariableFactory
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/8/20 9:28
 * @Version 1.0
 **/
public class ProcessVariableFactory {

    /**
     * @Author zhuangli
     * @Description TODO
     * @Date 9:39 2020/8/20
     * @Param
     * @return
     **/
    public static ProcessVariable createProcessVariableOfCreated(Map<String,Object> nodeMap) {
        Map<String, Object> createEntity = (Map<String, Object>) nodeMap.get("creates");
        String actionId = (String) nodeMap.get("actionId");
        if (null == createEntity) {
            return null;
        } else {
            ProcessVariable processVariable = castToProcessVariable(createEntity, actionId);
            return processVariable;
        }
    }

    /**
     * @Author zhuangli
     * @Description 将节点输出转化为流程变量统一格式,每个action最多输出一个实体
     * @Date 14:55 2020/8/7
     * @Param
     * @return
     **/
    private static ProcessVariable castToProcessVariable(Map<String, Object> createEntity, String actionId) {
        Assert.isTrue(createEntity.size() == 1, "action can create only one Entity");
        ProcessVariable processVariable = new ProcessVariable();
        //只会循环一次
        for (String key : createEntity.keySet()) {
            processVariable.setId(actionId + VAR_DELIMITER + key);
            processVariable.setName(actionId + VAR_DELIMITER + key);
            processVariable.setType("STRING");
            processVariable.setValue("");
            processVariable.setDescription("");
        }
        return processVariable;
    }

    /**
     * @Author zhuangli
     * @Description TODO
     * @Date 9:52 2020/8/20
     * @Param [nodeMap] 入参确定是包含需要外部输入节点
     * @return
     **/
    public static List<ProcessVariable> createProcessVariableOfRequired(Map nodeMap) {
        Map<String, Object> requireEntity = (Map) nodeMap.get("requires");
        if (null == requireEntity) {
            return null;
        }
        String actionId = (String) nodeMap.get("actionId");
        List<ProcessVariable> processVariables = new LinkedList<>();
        ProcessVariable processVariable = new ProcessVariable();
        for (String key : requireEntity.keySet()) {
            processVariable.setId(actionId + VAR_DELIMITER + "requires" + VAR_DELIMITER + key);
            processVariable.setName(actionId + VAR_DELIMITER + "requires" + VAR_DELIMITER + key);
            processVariable.setType("STRING");
            processVariable.setValue("");
            processVariable.setDescription("");
            processVariables.add(processVariable);
        }
        return processVariables;
    }
}
