package com.digiwin.athena.knowledgegraph.svcomposition.graph;

import com.digiwin.athena.knowledgegraph.data.Neo4jConstants;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName OldGraphHelper
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/8/28 10:27
 * @Version 1.0
 **/
public class OldGraphHelper extends GraphHelperTemplate{

    /**
     * @Author zhuangli
     * @Description 生成边
     * @Date 14:44 2020/8/18
     * @Param
     * @return
     **/
    @Override
    public void generateEdges(Map<String, Map> actionMap, Set<String> actionIds, List<Edge> edgeList, HashMap item, String queryActionId) {
        String querySource = "match (n)-[:Requires]->(de)-[:Contains]->(df)-[:MapsTo]->()<-[:Contains]-()" +
                "<-[:Creates]-(source) where n.actionId = '" + queryActionId + "' return distinct source";
        List<Map<String, Object>> querySourceResult = Neo4jManager.getNeo4jManager().ExecuteQuery(querySource);
        if (querySourceResult.size() > 0) {
            List<Map> sources = querySourceResult.stream().map(source->
                    (Map)source.get("source")).collect(Collectors.toList());
            sources.forEach(sourceItem->{
                if (actionIds.contains(sourceItem.get("actionId"))) {
                    edgeList.add(new Edge((int) actionMap.get(sourceItem.get("actionId")).get("index"),
                            (int) item.get("index")));
                }
            });
        }
    }

    /**
     * @Author zhuangli
     * @Description 查询依赖字段,依赖份两种类型,内部依赖和外部依赖,外部依赖作为流程变量发起流程时传入
     *  内部依赖由前置节点产生从流程变量获取
     * @Date 14:44 2020/8/18
     * @Param
     * @return
     * requires = {
     * 		student = {
     * 			studentId = [physicalExamination.physicalExResult.studentId, finalTest.finalTest.studentId, studentInfo.student.studentId],
     * 			name = [studentInfo.student.name],
     * 			healthyLv = [physicalExamination.physicalExResult.healthyLv],
     * 			mathScore = [finalTest.finalTest.math]
     *      }
     * }
     **/
    @Override
    public void queryRequireFields(HashMap item, String queryActionId, Set<String> actionIds) {
        StringSet actIdsStringSet = new StringSet(actionIds);
        //查询内部依赖字段
        String queryRequiresField = "match (n)-[:Requires]->(de)\n" +
                "where n.actionId = '" + queryActionId + "' \n" +
                "optional match (de:DataEntity)-[:Contains*0..1]->(df)-[:MapsTo]->(scdf)<-[:Contains]-(scde)<-[:Creates]-(source) \n" +
                "where source.actionId in " + actIdsStringSet +
                "return distinct labels(de) as deType,de.name as deName,df.name as dfName,source.actionId+'" + VAR_DELIMITER + "'+scde.name+'" + VAR_DELIMITER + "'+scdf.name as sourceField";
        List<Map<String, Object>> queryRequiresFieldResult = Neo4jManager.getNeo4jManager().ExecuteQuery(queryRequiresField);
        if (queryRequiresFieldResult.size() > 0) {
            Map<String, List<Map>> entityMap = queryRequiresFieldResult.stream().collect(Collectors.groupingBy(
                    queryResultItem -> (String) queryResultItem.get("deName")));
            Set<String> keySets = entityMap.keySet();
            //[sourceActionId_sourceEntityName_sourceFieldName]
            Map<String, Object> convertedInnerRequireEntities = new HashMap<>();
            Map<String, Object> convertedOuterRequireEntities = new HashMap<>();
            for (String key : keySets) {
                Map<String, List<String>> convertedInnerRequireEntity = new HashMap<>();
                Map<String, List<String>> convertedOuterRequireEntity = new HashMap<>();
                List<Map> entityValues = entityMap.get(key);
                entityValues.forEach(entityValue -> {
                    List<String> deTypes = (List<String>) entityValue.get("deType");
                    if (Neo4jConstants.NULL.equals(entityValue.get("sourceField"))) {
                        if (deTypes.contains("DataEntity")) {
                            String entityKey = (String) entityValue.get("dfName");
                            convertedOuterRequireEntity.put(entityKey, null);
                        }
                    } else {
                        if (deTypes.contains("DataEntity")) {
                            String entityKey = (String) entityValue.get("dfName");
                            if (convertedInnerRequireEntity.get(entityKey) == null) {
                                List<String> sourceFieldList = new ArrayList<>();
                                sourceFieldList.add((String) entityValue.get("sourceField"));
                                convertedInnerRequireEntity.put(entityKey, sourceFieldList);
                            } else {
                                convertedInnerRequireEntity.get(entityKey).add((String) entityValue.get("sourceField"));
                            }
                        }
                    }

                });
                convertedInnerRequireEntities.put(key, convertedInnerRequireEntity);
                convertedOuterRequireEntities.put(key, convertedOuterRequireEntity);
            }
            item.put("requires", convertedInnerRequireEntities);
            item.put("requiresStr", convertedInnerRequireEntities.toString());
            item.put("outerRequires", convertedOuterRequireEntities);
            item.put("outerRequiresStr", convertedOuterRequireEntities.toString());
        }
    }

    /**
     * @Author zhuangli
     * @Description 查询创建字段
     * @Date 14:43 2020/8/18
     * @Param
     * @return
     * creates = {
     * 		physicalExResult = {
     * 			studentId = null,
     * 			healthyLv = null,
     * 			weight = null
     *      }
     * }
     **/
    @Override
    public void queryCreatesFields(HashMap item, String queryActionId) {
        String queryCreatesField = "match (n)-[:Creates]->(de)-[:Contains]->(df) \n" +
                "where n.actionId = '" + queryActionId + "' \n" +
                "return distinct de.name as deName,df.name as dfName";
        List<Map<String, Object>> queryCreatesFieldResult = Neo4jManager.getNeo4jManager().ExecuteQuery(queryCreatesField);
        if (queryCreatesFieldResult.size() > 0) {
            Map<String, List<Map>> entityMap = queryCreatesFieldResult.stream().collect(Collectors.groupingBy(
                    queryResultItem -> (String) queryResultItem.get("deName")));
            Set<String> keySets = entityMap.keySet();
            Map<String, Object> convertedCreatesEntities = new HashMap<>();
            for (String key : keySets) {
                Map<String, Object> convertedCreatesEntity = new HashMap<>();
                List<Map> entityValues = entityMap.get(key);
                entityValues.forEach(entityValue -> {
                    String entityKey = (String) entityValue.get("dfName");
                    convertedCreatesEntity.put(entityKey, null);
                });
                convertedCreatesEntities.put(key, convertedCreatesEntity);
            }
            item.put("creates", convertedCreatesEntities);
            item.put("createsStr", convertedCreatesEntities.toString());
        }
    }

}
