package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.DataSubscriptionScheduleParam;
import com.digiwin.athena.knowledgegraph.service.impl.DataSubscriptionService;
import com.digiwin.athena.knowledgegraph.synonym.controller.ISubscriptionService;
import com.digiwin.athena.knowledgegraph.synonym.dao.SubscriptionDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.DeleteDto;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.EntryInfo;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.GetSubscriptionByPageRequest;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.SubscriberInfo;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.Subscription;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;

import com.digiwin.athena.knowledgegraph.synonym.utils.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;


/**
 * @author gudahua
 * @title:
 * @projectName kg
 * @description:
 * @Date
 */
@Service
@Slf4j
public class SubscriptionServiceImpl implements ISubscriptionService {
    @Resource
    private SubscriptionDao subscriptionDao;
    @Autowired
    private DataSubscriptionService dataSubscriptionService;


    @Override
    public ResultBean<Object> createEntry(Subscription subscription) {
        try {
            subscription.setCreateDate(DateUtil.getStringDate(new Date()));
            subscriptionDao.insertOne(subscription);
            return ResultBean.success("");
        } catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> updateEntry(Subscription subscription) {
        try {
            subscription.setEditDate(DateUtil.getStringDate(new Date()));
            subscriptionDao.saveOne(subscription);
            return ResultBean.success("");
        } catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getEntryDetail(String code) {
        try {
            return ResultBean.success(subscriptionDao.fineOne(new Query(Criteria.where("code").is(code))));
        } catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getEntryPage(GetSubscriptionByPageRequest request) {
        Integer pageNum = request.getPage();
        Integer pageSize = request.getPageSize();
        String question = request.getQuestion();
        String tenantId = request.getTenantId();

        try {
            return ResultBean.success(subscriptionDao.getEntryPage(pageNum, pageSize, question, tenantId));
        } catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getSubscriptionPage(GetSubscriptionByPageRequest request) {
        try {
            return ResultBean.success(subscriptionDao.getSubscriptionPage(request));
        } catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> deleteSubscription(DeleteDto deleteDto) {
        try {
            List<Subscription> dtoList = deleteDto.getCodes();
            if (!CollectionUtils.isEmpty(dtoList)) {
                /*for (Subscription subscription : dtoList) {
                    Object result = dataSubscriptionService.postRemoveDataSubscriptionConfig(deleteDto.getTenantId(), subscription.getSubscriber(), subscription.getQuestion().getSceneCode(), subscription.getQuestion().getMetricIdList(), subscription.getQuestion().getQuestion());
                    if(StringUtils.equals(String.valueOf(result),"success")){
                        subscriptionDao.deleteSubscription(deleteDto.getTenantId(), subscription.getCode());
                    }
                }*/
                List<String> ruleIds = dtoList.stream().map(Subscription :: getCode).collect(Collectors.toList());
                Object result = dataSubscriptionService.postRemoveDataSubscriptionConfig(deleteDto.getTenantId(),ruleIds);
                if(StringUtils.equals(String.valueOf(result),"success")){
                    subscriptionDao.deleteSubscription(deleteDto.getTenantId(),ruleIds);
                }
            }
            return ResultBean.success("");
        } catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> deleteEntry(DeleteDto deleteDto) {
        try {
            subscriptionDao.deleteEntry(deleteDto);
            return ResultBean.success("");
        } catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> createSubscription(Subscription subscription) {
        try {
            String tenantId = subscription.getTenantId();
            EntryInfo entryInfo = subscription.getQuestion();
            String question = entryInfo.getQuestion();
            String sceneCode = entryInfo.getSceneCode();
            List<String> metricIdList = entryInfo.getMetricIdList();
            List<String> datasetIdList = entryInfo.getDatasetIdList();
            List<SubscriberInfo> subscribers = subscription.getSubscribers();
            if (!CollectionUtils.isEmpty(subscribers)) {
                for (SubscriberInfo subscriber : subscribers) {
                    List<DataSubscriptionRule> dataSubscriptionRules = dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, subscriber.getUserId(), question, sceneCode, metricIdList,datasetIdList,"asada");
                    if(CollectionUtils.isEmpty(dataSubscriptionRules)){
                        createSystemSubscription(tenantId,subscriber,subscription);
                        continue;
                    }

                    List<DataSubscriptionRule> system = dataSubscriptionRules.stream().filter(e -> e.getScheduleParam().getUndeletable()).collect(Collectors.toList());
                    if(CollectionUtils.isEmpty(system)){
                        createSystemSubscription(tenantId,subscriber,subscription);
                        continue;
                    }

                    DataSubscriptionRule dataSubscriptionRule = system.get(0);
                    //存在时根据ruleId查寻agiledata_subscription中有没有，没有的话创建一份数据
                    Subscription subs = subscriptionDao.fineOne(new Query(Criteria.where("tenantId").is(tenantId).and("code").is(dataSubscriptionRule.getRuleId())));
                    if (Objects.isNull(subs)) {
                        Subscription copy = new Subscription();
                        BeanUtils.copyProperties(subscription,copy);
                        copy.setObjectId(null);
                        copy.setCode(dataSubscriptionRule.getRuleId());
                        copy.setSubscriber(subscriber.getUserId());
                        copy.setSubscriberName(subscriber.getUserName());
                        copy.setSubscribers(null);
                        copy.setCreateDate(DateUtil.getStringDate(new Date()));
                        copy.setEditDate(null);
                        copy.setEditBy(null);
                        subscriptionDao.insertOne(copy);
                    }
                }
            }
        } catch (Exception e) {
            return ResultBean.fail(1, e.getMessage());
        }
        return ResultBean.success("");
    }

    private void createSystemSubscription(String tenantId, SubscriberInfo subscriber, Subscription subscription) {
        try {
            //不存在时创建订阅
            DataSubscriptionRule config = DataSubscriptionRule.builder()
                    .tenantId(tenantId)
                    .caller("agileSubscribe")
                    .enableStatus("Y").build();
            DataSubscriptionScheduleParam scheduleParam = convertScheduleParam(subscription.getQuestion(),subscriber.getUserId(),subscriber.getUserName());
            config.setScheduleParam(scheduleParam);
            config.setTriggers(subscription.getFrequency());
            Object result = dataSubscriptionService.postAddDataSubscriptionConfig(config);
            if(!StringUtils.equals(String.valueOf(result),"success")){
                log.error("系统订阅创建失败,tenantId:{},question:{},userId:{}",tenantId,subscription.getQuestion().getQuestion(),subscriber.getUserId());
            }
            List<DataSubscriptionRule> rules = dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, subscriber.getUserId(), subscription.getQuestion().getQuestion(), subscription.getQuestion().getSceneCode(), subscription.getQuestion().getMetricIdList(),subscription.getQuestion().getDatasetIdList(),"asada");
            if(!CollectionUtils.isEmpty(rules)){
                List<DataSubscriptionRule> system = rules.stream().filter(e -> e.getScheduleParam().getUndeletable()).collect(Collectors.toList());
                if(!CollectionUtils.isEmpty(system)){
                    String ruleId = system.get(0).getRuleId();
                    Subscription copy = new Subscription();
                    BeanUtils.copyProperties(subscription,copy);
                    copy.setObjectId(null);
                    copy.setCode(ruleId);
                    copy.setSubscriber(subscriber.getUserId());
                    copy.setSubscriberName(subscriber.getUserName());
                    copy.setSubscribers(null);
                    copy.setCreateDate(DateUtil.getStringDate(new Date()));
                    copy.setEditDate(null);
                    copy.setEditBy(null);
                    subscriptionDao.insertOne(copy);
                }
            }
        } catch (Exception ex) {
            log.error("系统订阅创建失败:{}",ex.getMessage());
        }
    }
    private DataSubscriptionScheduleParam convertScheduleParam(EntryInfo question, String userId, String userName) {
        DataSubscriptionScheduleParam scheduleParam = new DataSubscriptionScheduleParam();
        scheduleParam.setUserId(userId);
        scheduleParam.setAsaCode("asada");
        scheduleParam.setUserName(userName);
        scheduleParam.setQuestion(question.getQuestion());
        scheduleParam.setSceneCode(question.getSceneCode());
        scheduleParam.setMetricIdList(question.getMetricIdList());
        scheduleParam.setUndeletable(true);
        return scheduleParam;
    }

    @Override
    public ResultBean<Object> editSubscription(Subscription subscription) {
        try {
            DataSubscriptionRule dataSubscriptionRule = (DataSubscriptionRule) dataSubscriptionService.getSingleDataSubscriptionConfig(subscription.getCode());
            if(Objects.isNull(dataSubscriptionRule) || !dataSubscriptionRule.getScheduleParam().getUndeletable()){
                throw  new BusinessException("该系统订阅不存在");
            }
            dataSubscriptionRule.setTriggers(subscription.getFrequency());
            Object result = dataSubscriptionService.postAddDataSubscriptionConfig(dataSubscriptionRule);
            if(StringUtils.equals(String.valueOf(result),"success")){
                subscription.setEditDate(DateUtil.getStringDate(new Date()));
                subscriptionDao.saveOne(subscription);
            }
        } catch (Exception e) {
            return ResultBean.fail(1, e.getMessage());
        }

        return ResultBean.success("");
    }

    @Override
    public List<Subscription> findByQuestion(String tenantId, String question) {
        try {
            return subscriptionDao.findByQuestion(tenantId,question);
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }
}
