package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.AppThresholdConfig;

import com.digiwin.athena.knowledgegraph.synonym.domain.EntityType;
import com.digiwin.athena.knowledgegraph.synonym.domain.Synonym;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Author: wangao
 * @CreateTime: 2024-07-24  14:36
 * @Description: TODO
 * @Version: 1.0
 */
@Repository
public class AppThresholdConfigDao {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;
    public List<AppThresholdConfig> findList(String appCode,String tenantId) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("tenantId").is(tenantId));
        if (StringUtils.isNotBlank(appCode)) {
            criteria.and("appCode").is(appCode);
        }
        query.addCriteria(criteria);
        return this.mongoTemplate.find(query, AppThresholdConfig.class);
    }
    public void deleteList(String tid, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        if (StringUtils.isEmpty(tid)){
            throw new BusinessException("租户id不能为空");
        }

        Query query = new Query(Criteria.where("id").in(ids).andOperator(Criteria.where("tenantId").is(tid)));
        this.mongoTemplate.remove(query, AppThresholdConfig.class);
    }
    public void save(AppThresholdConfig appThresholdConfig) {
        this.mongoTemplate.save(appThresholdConfig);
    }
    public void insertAll(List<AppThresholdConfig> appThresholdConfigs){
        mongoTemplate.insertAll(appThresholdConfigs);
    }

    public void dataMigration(){
        long count = systemMongoTemplate.count(new Query(), AppThresholdConfig.class);
        if (count > 0){
            List<AppThresholdConfig> appThresholdConfigs = systemMongoTemplate.find(new Query(), AppThresholdConfig.class);
            mongoTemplate.insertAll(appThresholdConfigs);
        }
    }
}
