package com.digiwin.athena.knowledgegraph.synonym.dao;


import com.digiwin.athena.knowledgegraph.synonym.domain.ErrorSynonym;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Date;

/**
 * @Author: wangao
 * @CreateTime: 2024-03-27  10:55
 * @Description: TODO
 * @Version: 1.0
 */
@Repository
public class ErrorSynonymDao {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void insert(ErrorSynonym errorSynonym){
        errorSynonym.setDate(new Date());
        mongoTemplate.insert(errorSynonym);
    }

    public ErrorSynonym getOne(String fileName){
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("id").is(fileName));
        query.addCriteria(criteria);
        return mongoTemplate.findOne(query,ErrorSynonym.class);
    }
}
