package com.digiwin.athena.knowledgegraph.synonym.dao;

import lombok.AccessLevel;
import lombok.Builder;
import lombok.Data;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;


/**
 * @Author: wangao
 * @CreateTime: 2024-04-22  14:48
 * @Description: TODO
 * @Version: 1.0
 */
@Data
@Builder
@Accessors(chain = true)
@Document(collection = "systemEntityType")
public class SystemEntityType {
    @Id
    private String objectId;

    private String entityTypeName;

    private String lang;
    /**
     * 目标跟维度俩字段是不可删除的，这里为true，其他情况都是false
     */
    @Setter(AccessLevel.NONE)
    @Builder.Default
    private Boolean deleteFlag = true;

}
