package com.digiwin.athena.knowledgegraph.synonym.domain;

import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zjz
 * @title:
 * @projectName athena_designer
 * @description:
 * @Date
 */
@Data
@Accessors(chain = true)
@Document(collection = "agiledata_business_type")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BusinessType {
    @Id
    private String objectId;

    private String appCode;

    private String tenantId;

    private String code;

    private String name;

    private String showType;

    private String source;

    private String description;

    private Integer decimal;

    private String decimalRule;//舍入方式 up：向上取整 down：向下取整 round：四舍五入 absUp：绝对值增大舍入 absDown：绝对值减少舍入
    //0计数单位(万/亿/兆)
    //1计数单位(千/百万/十亿/万亿)
    //2计数单位(K/M/B/T)
    private String dataUnit;
    private JSONObject lang;

    private String editBy;

    private Long editDate;

    private Date editTime;

}
