package com.digiwin.athena.knowledgegraph.synonym.domain;

import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @Author: wangao
 * @CreateTime: 2024-08-27  15:08
 * @Description:
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@Document(collection = "agiledata_business_variables_value")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BusinessVariablesValue {
    @Id
    private String id;
    private String appCode;
    private String tenantId;
    private String data_name;
    /**
     * enum EFieldTypes {
     *   String = 'string',
     *   Date = 'date',
     *   Numeric = 'numeric',
     *   Boolean = 'boolean',
     * }
     */
    private String data_type;
    //说明
    private String name;
    private String source;
    // 状态 0-停用 1-启用
    private String status;
    //描述
    private String description;
    //0 其他（非包含 不包含） 1 包含 不包含
    private Integer operationTag;

    private JSONObject lang;

    private String updateDate;

    private String updateBy;

    private Object value;
    private String code;

    private String compileVersion;
}
