package com.digiwin.athena.knowledgegraph.synonym.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;

/**
 * @Author: wangao
 * @CreateTime: 2024-03-25  15:33
 * @Description: TODO
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@Document(collection = "synonym")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Synonym {
    @Id
    private String objectId;

    private String tenantId;
    /**
     * 专有名词
     */
    private String properNoun;
    /**
     * 实体类型
     */
    private String entityTypeName;
    /**
     * 简体
     */
    private String zh_CN_Str;
    /**
     * 繁体
     */
    private String zh_TW_Str;
    /**
     * 简体
     */
    private List<String> zh_CN;
    /**
     * 繁体
     */
    private List<String> zh_TW;
    private String description;

    private Object createBy;

    private Date createDate;
    private Object editBy;

    private Date editDate;

    private Integer delFlag;
}
