package com.digiwin.athena.knowledgegraph.synonym.exception;

import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName BusinessException
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/12 14:49
 * @Version 1.0
 **/
public class BusinessException extends RuntimeException {
    Integer code;
    private Integer status;
    private String statusDescription;
    private String errorCode;
    private Object errorMessage;
    private String errorType;
    private String description;

    private Map<String, Object> errorInstructors;

    public Map<String, Object> getInstructors() {
        if (this.errorInstructors == null) {
            this.errorInstructors = new HashMap();
        }

        return this.errorInstructors;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static BusinessException create(Integer code, String errorCode, Object errorMessage, String description,
                                           String statusDescription, Throwable e) {
        BusinessException businessException = new BusinessException(description, e);
        businessException.setCode(code);
        businessException.setErrorCode(errorCode);
        businessException.setErrorMessage(errorMessage);
        businessException.setDescription(description);
        businessException.setStatusDescription(statusDescription);
        return businessException;
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     */
    public BusinessException() {
        super();
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public BusinessException(String message) {
        super(message);
    }


    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param code    error code;
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public BusinessException(Integer code, String message) {
        super(message);
        this.code = code;
    }

    public BusinessException(String errorCode, String message) {
        super(message);
        this.code = 500;
        this.errorCode = errorCode;
        this.errorMessage = message;
    }

    public BusinessException(Integer code, String errorCode, String message) {
        super(message);
        this.code = code;
        this.errorCode = errorCode;
        this.errorMessage = message;
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime com.digiwin.middleware.core.exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }

    public BusinessException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        this.errorMessage = message;
    }


    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime com.digiwin.middleware.core.exception's detail message.
     *
     * @param code    error code
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public BusinessException(Integer code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified cause and a
     * detail message of <tt>(cause==null ? null : cause.toString())</tt>
     * (which typically contains the class and detail message of
     * <tt>cause</tt>).  This constructor is useful for runtime exceptions
     * that are little more than wrappers for other throwables.
     *
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @since 1.4
     */
    public BusinessException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail
     * message, cause, suppression enabled or disabled, and writable
     * stack trace enabled or disabled.
     *
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @since 1.7
     */
    protected BusinessException(String message, Throwable cause,
                                boolean enableSuppression,
                                boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public static BusinessException create(String message) {
        return create(500, "500", (Object) null, message, "", (Throwable) null);
    }

    public static BusinessException create(Throwable cause) {
        return create(500, "500".toString(), (Object) null, cause.getMessage(), "", cause);
    }

    public static BusinessException create(Integer code, String message) {
        return create(code, code.toString(), (Object) null, message, "", (Throwable) null);
    }

    public static BusinessException create(String message, Throwable cause) {
        return create(500, "500".toString(), (Object) null, message, "", cause);
    }

    public static BusinessException create(Integer code, String message, Throwable cause) {
        return create(500, "500".toString(), (Object) null, message, "", cause);
    }


    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
