package com.digiwin.athena.knowledgegraph.task;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.task.model.AuditRuleTenantConfigDO;
import com.mongodb.client.MongoCollection;
import org.bson.Document;

import static com.mongodb.client.model.Filters.and;
import static com.mongodb.client.model.Filters.eq;

public class AuditRuleTenantConfigManager {
    private static final String PRODUCT_CONFIG_COLLECTION_NAME = "auditRuleTenantConfig";

    private static final String PRODUCT_CONFIG_INDEX_NAME = "idx_AuditRuleTenantConfig";
    private static final String TENANT_ID_FIELD = "tenantId";
    private static final String RULE_ID_FIELD = "ruleId";
    private static final String RULE_FIELD = "rule";

    public AuditRuleTenantConfigDO readTenantConfig(String tenantId, String ruleId) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, RULE_ID_FIELD, RULE_FIELD);
        //获取的配置必须是启用状态
        Document doc = col.find(and(eq(TENANT_ID_FIELD, tenantId), eq(RULE_ID_FIELD, ruleId))).first();
        if (doc != null) {
            AuditRuleTenantConfigDO auditRuleTenantConfigDO = JSON.parseObject(doc.toJson(), AuditRuleTenantConfigDO.class);
            return auditRuleTenantConfigDO;
        } else {
            return null;
        }
    }

}