package com.digiwin.athena.knowledgegraph.task;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.product.model.ProductTypeEnum;
import com.digiwin.athena.knowledgegraph.task.model.DecisionRuleTenantConfigDO;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import org.bson.Document;

import static com.mongodb.client.model.Filters.and;
import static com.mongodb.client.model.Filters.eq;

public class DecisionRuleTenantConfigManager {
    private static final String PRODUCT_CONFIG_COLLECTION_NAME = "decisionRuleTenantConfig";

    private static final String PRODUCT_CONFIG_INDEX_NAME = "idx_DecisionRuleTenantConfig";
    private static final String TENANT_ID_FIELD = "tenantId";
    private static final String RULE_ID_FIELD = "ruleId";
    private static final String DECISION_RULE_FIELD = "decisionRule";

    public DecisionRuleTenantConfigDO readTenantConfig(String tenantId, String ruleId) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, RULE_ID_FIELD, DECISION_RULE_FIELD);
        //获取的配置必须是启用状态
        Document doc = col.find(and(eq(TENANT_ID_FIELD, tenantId), eq(RULE_ID_FIELD, ruleId))).first();
        if (doc != null) {
            DecisionRuleTenantConfigDO decisionRuleConfigDO = JSON.parseObject(doc.toJson(), DecisionRuleTenantConfigDO.class);
            return decisionRuleConfigDO;
        } else {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.decisionRuleNotFound",tenantId,ruleId));
        }
    }

}