package com.digiwin.athena.knowledgegraph.utils;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import io.seata.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Objects;

@Slf4j
@Service
public class DataSubscriptionUtils {

    @Autowired
    @Qualifier("sdRestTemplate")
    RestTemplate restTemplate;

    @Value("${xxlJobUrl}")
    private String xxlJobUrl;

    @Value("${scdispatcherUrl}/restful/standard/AgileDataEngine/schedule")
    private String scdispatcherUrl;

    @Value("${xxlJobFlag}")
    private String xxlJobFlag;

    @Autowired
    private IamService iamService;

    public static final String FAIL_MSG = "fail";

    public static final String SUCCESS_MSG = "success";

    public String postDataSubscription(Object data, String url, HttpMethod method) {
        try {
            HttpHeaders headers = new HttpHeaders();
            String tenantId = AthenaUtils.getTenantId();
            String token = AthenaUtils.getHeaderToken();
            String routerKey = Objects.nonNull(KgFilter.getLoginInfo()) ?
                    (StringUtils.isNotEmpty(KgFilter.getLoginInfo().getRouterKey()) ? KgFilter.getLoginInfo().getRouterKey() : tenantId) : tenantId;
            if (StringUtils.isBlank(token)) {
                token = this.iamService.getTenantToken(tenantId);
            }
            headers.add("token", token);
            headers.add("routerKey", routerKey);
            HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity(data, headers);

            // 兼容xxl-job调用
            if (!(url.startsWith("http://") || url.startsWith("https://"))) {
                if (xxlJobFlag.equals("true")) {
                    url = xxlJobUrl + url;
                }else {
                    url = scdispatcherUrl;
                }
            }

            ResponseEntity<HashMap> res = restTemplate.exchange(url, method, httpEntity, HashMap.class);
            if (!"200".equals(res.getStatusCode().toString())) {
                return FAIL_MSG;
            }
        } catch (Exception e) {
            log.error("postDataSubscription method error : {},data:{},type:{}",e, JSON.toJSON(data),"sdRestTemplate");
            return FAIL_MSG;
        }
        return SUCCESS_MSG;
    }
}
