package com.digiwin.athena.knowledgegraph.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class DateUtils {


  public static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
  public static String formatTime(TemporalAccessor temporal) {
    return TIME_FORMAT.format(temporal);
  }

  /**
   * 将字符串转换为时间
   *
   * @param dateStr   时间字符串
   * @param formatter DateTimeFormatter
   * @return 时间
   */
  public static LocalDateTime parseDateTime(String dateStr, DateTimeFormatter formatter) {
    return LocalDateTime.parse(dateStr, formatter);
  }
  public static LocalDateTime parseDateTime(String dateStr, String pattern) {
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
    return parseDateTime(dateStr, formatter);
  }

}
