package com.digiwin.athena.knowledgegraph.utils;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.knowledgegraph.domain.esp.EspBody;
import com.digiwin.athena.knowledgegraph.domain.esp.EspResponse;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

@Slf4j
public class ESPInvokeUtil {

    private static final Set<String> SUCCESS_CODES = new HashSet<>();

    static {
        SUCCESS_CODES.add("0");
        SUCCESS_CODES.add("000");
    }

    private ESPInvokeUtil() {}

    public static EspResponse invokeRestSync(String serviceName, String productName, String token, String tenantId, String jsonMsg, Map<String, Object> headerParamMap, Map<String,Object> eocMap){
        // 建立RequestModel物件並設定內容
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("AgileInteraction");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage("zh_CN");
        requestModel.setTenantId(tenantId);
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(serviceName);
        requestModel.setEocMap(eocMap);
        String body = null;
        if(StringUtils.isNotEmpty(jsonMsg)){
            body = "{\"std_data\":{\"parameter\":" + jsonMsg + "}}";
        }else{
            body = "{\"std_data\":{\"parameter\":" + JSONObject.toJSONString(new JSONObject()) + "}}";
        }
        requestModel.setBodyJsonString(body);
        // 从上下文中取到应用 code，透传
        // 有些应用在解析 digi-datakey 的时候，如果里面的值有 null 会报错
        LoginInfo loginInfo = KgFilter.getLoginInfo();
        if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty(loginInfo.getApplication())) {
            Map<String, String> datakeyMap = new HashMap<>();
            datakeyMap.put("appCode", loginInfo.getApplication());
            requestModel.setDatakeyMap(datakeyMap);
        }
        //header
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("token", token);
        headerMap.put("routerKey", tenantId);

        if(headerParamMap != null){
            Set<Map.Entry<String, Object>> entries = headerParamMap.entrySet();
            for(Map.Entry<String, Object> entry : entries){
                headerMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        requestModel.setHeaderMap(headerMap);

        ResponseModel responseModel;
        try {
            DWServiceChainUtils.beforeInvokeOutterAPI(headerMap::put);
            responseModel = Invoker.invokeRestSync(requestModel);
            String response = responseModel.getBodyJsonString();
//            String response = "{\"std_data\":{\"execution\":{\"sql_code\":\"\",\"code\":\"0\",\"description\":\"\"},\"parameter\":{\"inquiry_is_download\":true,\"purchase_is_download\":true,\"drawing_default_format\":\"1\",\"online_drawing_format\":\"1\",\"advance_notice_days\":\"2\",\"only_download_once\":true}}}";
            log.info("invoke Result:{}", response);
            EspBody espBody = JSONObject.parseObject(response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if (SUCCESS_CODES.contains(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData(espBody);
                return espResponse;
            } else {
                espResponse.setMsg(espBody.getStd_data().getExecution().getDescription());
                espResponse.setStatus(EspResponse.Status.FAILED);
                return espResponse;
            }
        } catch (Exception e) {
            log.error("call esp error:{}", e.getMessage());
            EspResponse espResponse = new EspResponse();
            espResponse.setMsg(e.getMessage());
            espResponse.setStatus(EspResponse.Status.FAILED);
            if(e instanceof InvocationException){
                espResponse.setErrorCode(((InvocationException) e).getErrorCode());
                espResponse.setChainInfo(((InvocationException) e).getChainInfo());
            }
            return espResponse;
        }
    }
}
