package com.digiwin.athena.knowledgegraph.utils;

import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Slf4j
@Service
public class OperationRecordUtil {
    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

     public void recordInfo(OperationRecord operationRecord) {
        try {
            LocalDateTime currentDateTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String currentTime = currentDateTime.format(formatter);
            operationRecord.setTime(currentTime);
            mongoTemplate.insert(operationRecord);
        } catch (Exception e) {
            log.warn("OperationRecordUtil.recordSensitiveOperation warn,{}", e.toString());
        }
    }

    public void cleanOperationRecord() {
        LocalDateTime currentDateTime = LocalDateTime.now().minusDays(30);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String currentTime = currentDateTime.format(formatter);
        mongoTemplate.remove(Query.query(Criteria.where("time").lt(currentTime).and("type").is(OperationRecordType.CLEAN_REDIS.toString())), OperationRecord.class);
    }
}