package com.digiwin.athena.knowledgegraph.utils;

import cn.hutool.core.util.RandomUtil;
import com.digiwin.athena.domain.core.app.Application;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TestUtil {

    public static Object fillObject(Class<?> clazz) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        // 对象实列
        Object o = clazz.newInstance();
        // 对象所有成员变量
        Field[] fields = clazz.getDeclaredFields();
        // 成员变量赋值
        for (Field field : fields){
            // 允许反射修改
            field.setAccessible(true);
            // 随机值变量 （通过数据类型名）
            String typeName = field.getType().getName();
            // 基本类型、基本类型包装类和String类型
            Object value = getValue(typeName);
            if (value != null){
                field.set(o,value);
                // List类型
            } else if (typeName.contains("List")) {
                List<Object> list = new ArrayList<>();
                // 泛型类型名
                String genericTypeName = field.getGenericType().getTypeName();
                Object value2 = getValue(genericTypeName);
                // 泛型类型是基本类型、基本类型包装类和String类型
                if (value2 != null){
                    for (int i = 0; i < 10; i++){
                        list.add(getValue(genericTypeName));
                    }
                    // 其他类型
                }else {
                    String generatorTypeRoute = genericTypeName.substring(genericTypeName.indexOf("<") + 1,
                            genericTypeName.indexOf(">"));
                    for (int i = 0; i < 10; i++){
                        list.add(fillObject(Class.forName(generatorTypeRoute)));
                    }
                }
                field.set(o,list);
                // 其他类型（对象,非集合）
            } else {
                field.set(o,fillObject(Class.forName(typeName)));
            }
        }
        return o;
    }

    /**
     * 根据数据类型（基本类型、基本类型包装类和String）随机生成值
     */
    private static Object getValue(String type){
        if (type.contains("String")){
            return GenerateData.getString(10);
        } else if (type.contains("int") || type.contains("Integer")){
            return GenerateData.getInt(0,100);
        }else if (type.contains("long") || type.contains("Long") ){
            return GenerateData.getInt(0,100);
        }else if (type.contains("float") || type.contains("Float")){
            return GenerateData.getDouble(0,100);
        }else if (type.contains("double") || type.contains("Double")){
            return GenerateData.getDouble(0,100);
        }else {
            return null;
        }
    }

    private static class GenerateData{
        /**
         * 生成UUID
         */
        public static String getUUID(){
            return UUID.randomUUID().toString();
        }

        /**
         * 生成字符串
         */
        public static String getString(int length){
            return RandomUtil.randomString(length);
        }

        /**
         * 随机获取一个整数
         */
        public static int getInt(int min,int max){
            return RandomUtil.randomInt(min,max);
        }

        /**
         * 随机获取一个浮点数
         */
        public static double getDouble(int min,int max){
            return RandomUtil.randomDouble(min,max);
        }

        /**
         * 获取String list
         */
        public static List<String> getList(int size,int length){
            List<String> result = new ArrayList<>(size);
            int i = 0;
            while (i < size){
                result.add(getString(length));
                i++;
            }
            return result;
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Application application = (Application) TestUtil.fillObject(Application.class);
        System.out.println(application);
    }

}
