package com.digiwin.athena.knowledgegraph.vo;

import com.digiwin.athena.kg.domain.OpenWindowDefinition;
import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class ParadigmConditionVO {
    /**
     * 范式code
     */
    private String paradigmCode;
    /**
     * 字段开窗设置
     */
    private List<FieldOpenWindowSetting> fieldOpenWindowMap;
    /**
     * 字段信息
     */
    private Object fields;
    /**
     * 字段映射信息
     */
    private Object fieldMapsTo;
    /**
     * 动态条件对应开窗信息(通过fieldOpenWindowMap查询)
     */
    private Map<String, OpenWindowDefinition> fieldOpenWindowDefinitions;
    /**
     * 已保存的组户级条件
     */
    private Object conditions;
    /**
     * 租户id
     */
    private String tenantId;

}
