package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.activity.DynamicActivity;
import com.digiwin.athena.kg.activity.DynamicActivityComposition;
import com.digiwin.athena.kg.activity.DynamicTask;
import com.digiwin.athena.knowledgegraph.domain.qr.DynamicTaskAndActivities;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DynamicTaskRepository extends Neo4jRepository<DynamicTask, Long> {

    @Query(value = "MATCH (t:DynamicTask)-[:Contains]->(c:DynamicActivityComposition) " +
        "WHERE t.code = $0 RETURN c")
    List<DynamicActivityComposition> getDynamicActivityCompositionByTask(String taskCode);

    @Query(value = "MATCH (t:DynamicTask)-[:Contains]->(c:DynamicActivityComposition)-[:Contains]->(a:DynamicActivity) " +
            "WHERE t.code=$0 and c.code = $1 RETURN a")
    List<DynamicActivity> getDynamicActivityByComposition(String taskCode, String compositionCode);

    @Query(value = "MATCH (t:DynamicTask)-[:Contains]->(c:DynamicActivityComposition) " +
            "WHERE t.code=$0 and c.code = $1 RETURN c")
    DynamicActivityComposition getDynamicActivityCompositionByCode(String taskCode, String compositionCode);

    @Query(value = "MATCH (t:DynamicTask{version:$2})-[:Contains]->(a:DynamicActivity) " +
            "WHERE t.code = $0 and a.code = $1 RETURN a")
    DynamicActivity getDynamicActivityByCode(String taskCode, String activityCode, String tenantVersion);

//    @Query("MATCH (te:TenantEntity{tenantId:$0})-[:TASK]->(task:DynamicTask{version:$3})-[:Contains]->(composition:DynamicActivityComposition)-[:Contains]->(activity:DynamicActivity) " +
//            "where task.code = $1 and composition.code in $2 " +
//            "return task,COLLECT(activity) as activities")
    @Query("MATCH (task:DynamicTask{version:$3})-[:Contains]->(composition:DynamicActivityComposition)-[:Contains]->(activity:DynamicActivity) " +
        "where task.code = $1 and (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) and composition.code in $2 " +
        "return task,COLLECT(activity) as activities")
    DynamicTaskAndActivities findTaskAndActivities(String tenantId, String taskId, List<String> compositionCodes, String tenantVersion);
}