package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.knowledgegraph.domain.Task;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.qr.TaskAndActivities;
import com.digiwin.athena.knowledgegraph.domain.qr.TaskAndActivity;
import com.digiwin.athena.knowledgegraph.domain.qr.TaskAndTarget;
import com.digiwin.athena.knowledgegraph.domain.task.TaskInputData;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Repository
public interface TaskRepository extends Neo4jRepository<Task, Long> {


    Task findOneByCodeAndVersion(String code, String version, @Depth int depth);

//    @Query("match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{code:$1,version:$2}) return task")
    @Query("match(task:Task{code:$1,version:$2}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null or $0 in task.inclusionTenant) return task")
    Task findTask(String tenantId, String code, String tenantVersion);

    @Query("match (task:Task) where code = $0 return task")
    Task findTaskNoTenantId(String code);

//    @Query("match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{code:$1,version:$2}) optional match(task)-[:Achieves]->(target:TaskTarget) optional match(task)<-[:ResponsibleFor]-(personInCharge:PersonInCharge) return task,target,personInCharge")
    @Query("match(task:Task{code:$1,version:$2}) optional match(task)-[:Achieves]->(target:TaskTarget) optional match(task)<-[:ResponsibleFor]-(personInCharge:PersonInCharge) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task,target,personInCharge")
    TaskAndTarget findTaskAndTarget(String tenantId, String code, String tenantVersion);

//    @Query("match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{code:$1,version:$2})-[:Contains]->(activity:Activity) return task,COLLECT(activity) as activities")
    @Query("match(task:Task{code:$1,version:$2})-[:Contains]->(activity:Activity) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task,COLLECT(activity) as activities")
    TaskAndActivities findTaskAndActivities(String tenantId, String code, String tenantVersion);

//    @Query("match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{code:$1,version:$3})-[:Contains]->(activity:Activity{code:$2}) return task,activity")
    @Query("match(task:Task{code:$1,version:$3})-[:Contains]->(activity:Activity{code:$2}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task,activity")
    TaskAndActivity findTaskAndActivity(String tenantId, String code, String activityCode, String tenantVersion);

    @Query("match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{manualAble:$1,version:$2})-[:preset]->(a:LifeActivity)<-[:ACTIVITY]-(te:TenantEntity{tenantId:$0}) return task")
//    @Query("match(task:Task{manualAble:$1,version:$2})-[:preset]->(a:LifeActivity) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task")
    List<Task> findByManualAble(String tenantId, Boolean manualAble, String tenantVersion);

//    @Query(value = "MATCH (t:Task {code:$0})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) RETURN t.code as taskId, COLLECT(field) as fields, entity as inputData")
//    Optional<TaskInputData> getTaskInputData(String code);

   // @Query(value = "MATCH (te:TenantEntity{tenantId:$0})-[:TASK]->(t:Task {code:$1,version:$2})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) RETURN t.code as taskId, COLLECT(field) as fields, entity as inputData")
  //  @Query("match(task:Task{code:$1,version:$3})-[:Contains]->(activity:Activity{code:$2}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task,activity")
    @Query(value = "MATCH (t:Task {code:$1,version:$2})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) where (t.tenantId in ['SYSTEM',$0] or t.tenantId is null) RETURN t.code as taskId, COLLECT(field) as fields, entity as inputData")
    Optional<TaskInputData> getTaskInputData(String tenantId, String code, String tenantVersion);


//    @Query("match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{version:$1}) return task")
//    List<Task> allTask(String tenantId, String tenantVersion);


    @Query("match(task:Task{version:$1}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) and task.code in $2 return task")
    List<Task> allTask(String tenantId, String tenantVersion,List<String> codes);

//    @Query("match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{code:$1,version:$2}) optional match(task)-[:Achieves]->(target:TaskTarget) optional match(task)<-[:ResponsibleFor]-(personInCharge:PersonInCharge) optional match(task)-[:Contains]->(activity:Activity) optional match(task)-[:preset]->(lifeActivity:LifeActivity)   return task,target,personInCharge,COLLECT(activity) as activities,COLLECT(lifeActivity) as presetActivities")
    @Query("match(task:Task{code:$1,version:$2}) optional match(task)-[:Achieves]->(target:TaskTarget) optional match(task)<-[:ResponsibleFor]-(personInCharge:PersonInCharge) optional match(task)-[:Contains]->(activity:Activity) optional match(task)-[:preset]->(lifeActivity:LifeActivity)  where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null)   return task,target,personInCharge,COLLECT(activity) as activities,COLLECT(lifeActivity) as presetActivities")
    TaskAndTarget findTaskDetail(String tenantId, String code, String tenantVersion);


    @Query("match(t:Task{version:$1})-[:Contains]->(a:Activity) where t.code in $0 and a.executeType='MANUAL' return a")
    List<Activity> findManualActivities(List<String> taskCodes, String tenantVersion);

   // @Query("match (te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task) where task.code in $1 and task.version = $2 return task")
    @Query("match (task:Task) where task.code in $1 and task.version = $2  and (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task")
    List<Task> getTasksByCode(String tenantId, List<String> bizCodes, String tenantVersion);

//    @Query("match (te:TenantEntity{tenantId:$1})-[:TASK]->(n:Task{version:$2})-[:preset]->(a:LifeActivity)<-[:ACTIVITY]-(te:TenantEntity{tenantId:$1}) where n.manualAble = true and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) return n")
    @Query("match (n:Task{version:$2})-[:preset]->(a:LifeActivity) where n.manualAble = true  and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null) and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) return n")
    List<Task> getManualProjectsByName(String condition, String tenantId, String tenantVersion);

    @Query("match (t:Task) return distinct t.code as code, t.name as name , t.nameSpace as nameSpace")
    List<Map> getAllTask();

    @Query("match(task:Task{version:$1})-[:Contains]->(activity:Activity{executeType:'MANUAL'}) where task.code in $2 and (task.tenantId in ['SYSTEM',$0] or task.tenantId is null)  return distinct activity.code as code,activity.name as name,{name:{zh_TW:activity.`lang.name.zh_TW`,en_US:activity.`lang.name.en_US`,zh_CN:activity.`lang.name.zh_CN`}} as lang")
    List<Map<String,Object>> getTaskByProjectCodes(String tenantId, String tenantVersion,List<String> projectCodes);

    @Query("match (task:Task{version:$1}) where task.code in $2 and (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return distinct task.code as code,task.name as name,{name:{zh_TW:task.`lang.name.zh_TW`,en_US:task.`lang.name.en_US`,zh_CN:task.`lang.name.zh_CN`}} as lang")
    List<Map<String,Object>> getProjectByProjectCodes(String tenantId, String tenantVersion,List<String> projectCodes);
}
