/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.action.execution;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.metadata.KmActionClient;
import com.digiwin.athena.knowledgegraph.action.dao.ActionMetadataDAO;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionQueryService {
    private static final Logger log = LoggerFactory.getLogger(ActionQueryService.class);
    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private ActionMetadataDAO actionMetadataDAO;
    @Autowired
    private KmActionClient actionClient;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    private DataPickService dataPickService;

    public List<ActionExecutionDTO> queryActionExeutionList(List<String> actionIds, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = this.dataPickService.excludeWithSameCode(this.actionRepository.getActionAndLabels(actionIds, tenantId, tenantVersion), actionLabel -> actionLabel.getAction().entityBizCode(), actionLabel -> actionLabel.getAction().getSourceLevel());
        ArrayList<ActionExecutionDTO> result = new ArrayList<ActionExecutionDTO>();
        if (actionAndLabels.size() == 0) {
            throw new DWException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionIds, tenantId));
        }
        actionAndLabels.forEach(e -> {
            ActionLabel actionLabel = (ActionLabel)actionAndLabels.get(0);
            Map actionMatched = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)actionLabel.getAction()), Map.class);
            actionMatched.put("tenantId", tenantId);
            List actionLabels = actionLabel.getActionLabels();
            try {
                result.add(this.actionClient.doHandlerExecution(actionLabels, actionMatched));
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        });
        return result;
    }

    public ActionExecutionDTO queryActionExeution(String actionId, String tenantId) throws Exception {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<ActionLabel> actionAndLabels = this.dataPickService.filterByIndividual(this.actionRepository.getActionAndLabels(actionId, tenantId, tenantVersion), tenantId, actionLabel -> actionLabel.getAction().getNameSpace());
        if (actionAndLabels.size() == 0) {
            throw new DWException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionId, tenantId));
        }
        ActionLabel actionLabel2 = actionAndLabels.get(0);
        Map actionMatched = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)actionLabel2.getAction()), Map.class);
        actionMatched.put("tenantId", tenantId);
        List actionLabels = actionLabel2.getActionLabels();
        return this.actionClient.doHandlerExecution(actionLabels, actionMatched);
    }

    public ActionDefinitionDTO queryActionMetadataInfo(String actionId, String tenantId) throws Exception {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<ActionLabel> actionAndLabels = this.dataPickService.filterByIndividual(this.actionRepository.getActionAndLabels(actionId, tenantId, tenantVersion), tenantId, actionLabel -> actionLabel.getAction().getNameSpace());
        if (actionAndLabels.size() == 0) {
            throw new DWException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionId, tenantId));
        }
        ActionLabel actionLabel2 = actionAndLabels.get(0);
        Map actionMatched = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)actionLabel2.getAction()), Map.class);
        actionMatched.put("tenantId", tenantId);
        List actionLabels = actionLabel2.getActionLabels();
        return this.actionClient.doHandlerMetadata(actionLabels, actionMatched);
    }
}

