/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.cache;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import com.digiwin.athena.knowledgegraph.service.ICacheService;
import com.digiwin.athena.knowledgegraph.service.TagSystemService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.OperationRecordUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CacheService
implements ICacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheService.class);
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    @Qualifier(value="dataFootprintTemplate")
    RestTemplate restTemplate;
    @Value(value="${dataFootprintUrl}")
    private String dataFootprintUrl;
    @Autowired
    OperationRecordUtil recordUtil;
    @Autowired
    private TagSystemService tagSystemService;
    public static Map<String, String> compatibleKey = new HashMap<String, String>();

    @Override
    public Object deleteKeys(List<String> keys) throws Exception {
        Long delete = this.redisTemplate.delete(keys);
        this.recordUtil.recordInfo(OperationRecord.builder().type(OperationRecordType.CLEAN_REDIS.toString()).supplementaryContent(keys).build());
        return DWServiceResultBuilder.build((Object)(I18nUtils.getValue("knowledgegraph.deleteNums", new Object[0]) + delete));
    }

    @Override
    public Object deleteWithPattern(String keyPattern) throws Exception {
        log.info("deleteWithPattern keyPattern,{}", (Object)keyPattern);
        keyPattern = this.compatiblePattern(keyPattern);
        int count = 2000;
        Long delete = this.blurScanDelete(keyPattern, count);
        log.info("deleteWithPattern delete size,{}", (Object)delete);
        this.deleteDataFootprintCache();
        if (keyPattern.startsWith("tag")) {
            this.tagSystemService.initTagData();
        }
        return DWServiceResultBuilder.build((Object)(I18nUtils.getValue("knowledgegraph.deleteNums", new Object[0]) + delete));
    }

    @Override
    public Object deleteWithPattern(List<String> keyPattern) throws Exception {
        int count = 2000;
        Long delete = 0L;
        for (String pattern : keyPattern) {
            delete = delete + this.blurScanDelete(pattern, count);
            if (!pattern.startsWith("tag")) continue;
            this.tagSystemService.initTagData();
        }
        this.deleteDataFootprintCache();
        return DWServiceResultBuilder.build((Object)(I18nUtils.getValue("knowledgegraph.deleteNums", new Object[0]) + delete));
    }

    @Override
    public Object getData(String key) throws Exception {
        int count = 2000;
        return DWServiceResultBuilder.build(this.blurScan(key, count));
    }

    @Override
    public Object getSetData(String key, String value) throws Exception {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        return DWServiceResultBuilder.build((Object)I18nUtils.getValue("knowledgegraph.setDatasuccess", new Object[0]));
    }

    private void deleteDataFootprintCache() throws DWBusinessException {
        try {
            HashMap<String, String> requestMap = new HashMap<String, String>();
            requestMap.put("pattern", "datafootprint:v2");
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            headers.add("token", AthenaUtils.getHeaderToken());
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
            ResponseEntity result = this.restTemplate.exchange(this.dataFootprintUrl + "/restful/service/DataFootprint/manual/deleteCache", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            if (result.getStatusCodeValue() != 200) {
                log.error("deleteDataFootprintCache failed");
            }
        }
        catch (Exception e) {
            log.error("deleteDataFootprintCache failed,{}", (Object)e.toString());
        }
    }

    public Set<String> blurScan(String matchKey, int count) {
        return (Set)this.redisTemplate.execute(connection -> {
            HashSet<String> keys = new HashSet<String>();
            try (Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().count((long)count).match(matchKey).build());){
                while (cursor.hasNext()) {
                    keys.add(new String((byte[])cursor.next()));
                }
            }
            catch (Exception e) {
                log.error("blurScan failed,{}", (Object)e.toString());
            }
            return keys;
        });
    }

    public Long blurScanDelete(String matchKey, int count) {
        return (Long)this.redisTemplate.execute(connection -> {
            long keyCount = 0L;
            try (Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().count((long)count).match(matchKey).build());){
                long cursorId = cursor.getCursorId();
                HashSet<String> keys = new HashSet<String>();
                while (cursor.hasNext()) {
                    keys.add(new String((byte[])cursor.next()));
                    if (cursorId != cursor.getCursorId()) {
                        keyCount += (long)keys.size();
                        this.deleteByKeys(keys);
                        keys = new HashSet();
                    }
                    cursorId = cursor.getCursorId();
                }
                if (cursor.getCursorId() == 0L || CollectionUtils.isNotEmpty(keys)) {
                    keyCount += (long)keys.size();
                    this.deleteByKeys(keys);
                }
            }
            catch (Exception e) {
                log.error("blurScanDelete failed,{}", (Object)e.toString());
            }
            return keyCount;
        });
    }

    private void deleteByKeys(Set<String> keys) {
        this.redisTemplate.delete(keys);
        this.recordUtil.recordInfo(OperationRecord.builder().type(OperationRecordType.CLEAN_REDIS.toString()).supplementaryContent(keys).build());
    }

    private String compatiblePattern(String keyPattern) {
        keyPattern = keyPattern.replace("km:", "");
        for (Map.Entry<String, String> entry : compatibleKey.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!keyPattern.contains(key) || keyPattern.contains(value)) continue;
            keyPattern = keyPattern.replace(key, value);
        }
        return keyPattern;
    }

    static {
        compatibleKey.put("kg", "knowledgegraph");
        compatibleKey.put("tag", "tagsystem");
        compatibleKey.put("presetLibrary", "presetlibrary");
    }
}

