/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.clients;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CACUtils {
    @Value(value="${cacUrl}")
    private String cacUrl;
    @Autowired
    @Qualifier(value="cacRestTemplate")
    RestTemplate restTemplate;
    @Value(value="${iamApToken}")
    private String iamApToken;
    private static final String CAC_TENANT_GOODS = "/api/cac/v4/authorizations/tenants/%s/goods/%s";
    private static final String CAC_TENANT_USER = "/api/cac/v4/authorizations/current/user/apps";
    private static final String CAC_TENANT_USER_GOODS = "/api/cac/v4/counting/currenttenant/goods/%s";

    public Boolean getAppAuth(String tenantId, String appId) throws DWBusinessException, ParseException {
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders(headers);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(String.format(this.cacUrl + CAC_TENANT_GOODS, tenantId, appId), HttpMethod.GET, entity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() == 200) {
            if (!((Map)result.getBody()).isEmpty()) {
                Map re = (Map)result.getBody();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date effectiveTime = sdf.parse((String)re.get("effectiveTime"));
                Date expiredTime = sdf.parse((String)re.get("expiredTime"));
                Date currentTime = new Date();
                if (effectiveTime.before(currentTime) && currentTime.before(expiredTime)) {
                    return true;
                }
                return false;
            }
            return false;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getAuthError", new Object[0]));
    }

    public Map<String, String> getAppAuthDate(String tenantId, String appId) throws DWBusinessException, ParseException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders(headers);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(String.format(this.cacUrl + CAC_TENANT_GOODS, tenantId, appId), HttpMethod.GET, entity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() == 200) {
            if (null != result.getBody() && !((Map)result.getBody()).isEmpty()) {
                Map re = (Map)result.getBody();
                String effectiveTime = re.get("effectiveTime").toString();
                String expiredTime = re.get("expiredTime").toString();
                String[] efTime = effectiveTime.split(" ");
                String[] exTime = expiredTime.split(" ");
                resultMap.put("effectiveTime", efTime[0]);
                resultMap.put("expiredTime", exTime[0]);
                return resultMap;
            }
            resultMap.put("effectiveTime", "");
            resultMap.put("expiredTime", "");
            return resultMap;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getAuthError", new Object[0]));
    }

    public List<String> getAppAuth() throws DWBusinessException {
        return this.getAppAuth(null);
    }

    public List<String> getAppAuth(String userId) throws DWBusinessException {
        ResponseEntity response;
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders(headers);
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", this.iamApToken);
        String url = this.cacUrl + CAC_TENANT_USER;
        if (StringUtils.isNotEmpty((String)userId)) {
            url = url + "?userId=" + userId;
        }
        if ((response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0])).getStatusCode() == HttpStatus.OK) {
            Map body = (Map)response.getBody();
            List dataList = (List)body.get("data");
            if (dataList != null) {
                return dataList.stream().filter(e -> this.isEffective((Map<String, Object>)e)).map(data -> data.get("id").toString()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getAuthError", new Object[0]));
    }

    private boolean isEffective(Map<String, Object> map) {
        Object expiredTimeObj = map.get("expiredTime");
        if (expiredTimeObj != null) {
            String expiredTime = String.valueOf(expiredTimeObj);
            DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2);
            return LocalDateTime.now().isBefore(expiredLocalDateTime);
        }
        return false;
    }
}

