/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.clients;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.authority.AppAuthorizationsResponse;
import com.digiwin.athena.knowledgegraph.utils.KgHttpUtil;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CacService {
    private static final Logger log = LoggerFactory.getLogger(CacService.class);
    @Autowired
    @Qualifier(value="cacRestTemplate")
    RestTemplate restTemplate;
    @Value(value="${cacUrl}")
    private String cacUrl;
    @Value(value="${iamApToken}")
    private String iamApToken;
    private final String AUTHORIZATIONS_TENANTS = "/api/cac/v4/authorizations/tenants/";
    private final String APP_TENANT_INFO = "/api/cac/v4/authorizations/category/app/exclude/policy";

    public Object authorizationsTenants(String tenantId) {
        String requestUrl = this.cacUrl + "/api/cac/v4/authorizations/tenants/" + tenantId;
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders(headers);
        headers.set("digi-middleware-auth-user", DWServiceContext.getContext().getToken());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, Object.class, new Object[0]);
        Object forObject = exchange.getBody();
        return forObject;
    }

    public List<String> getAuthorizationsApplication(String tenantId) {
        HashSet<String> appLists = new HashSet<String>();
        Object obj = this.authorizationsTenants(tenantId);
        if (obj == null) {
            return new ArrayList<String>();
        }
        JSONArray jsonArray = JSON.parseArray((String)JSONObject.toJSONString((Object)obj));
        for (int i = 0; i < jsonArray.size(); ++i) {
            DateTimeFormatter dtf2;
            String code = jsonArray.getJSONObject(i).getString("code");
            String expiredTime = jsonArray.getJSONObject(i).getString("expiredTime");
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            if (expiredLocalDateTime.isBefore(LocalDateTime.now())) {
                log.info("app:{} \u5df2\u7ecf\u8fc7\u671f\u4e86\uff0c expiredTime\uff1a{}", (Object)code, (Object)expiredTime);
                continue;
            }
            appLists.add(code);
        }
        return new ArrayList<String>(appLists);
    }

    public String effectiveTenantAndAppInfo(String appCode, int pageNum, int pageSize) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("tenantId", "");
        paramsMap.put("goodsCode", appCode);
        paramsMap.put("beginTime", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        paramsMap.put("endTime", "9999-12-31");
        HashMap<String, Serializable> requestMap = new HashMap<String, Serializable>();
        requestMap.put("pageNum", Integer.valueOf(pageNum));
        requestMap.put("pageSize", Integer.valueOf(pageSize));
        requestMap.put("params", paramsMap);
        String requestUrl = this.cacUrl + "/api/cac/v4/authorizations/category/app/exclude/policy";
        log.info("requestUrl:{}, requestParam:{}", (Object)requestUrl, requestMap);
        Map<String, String> header = Utils.requiredMapHeaders();
        header.put("digi-middleware-auth-app", this.iamApToken);
        String forObject = KgHttpUtil.sendGet(requestUrl, JSON.toJSONString(requestMap), header);
        return forObject;
    }

    public AppAuthorizationsResponse getAllEffectiveTenantAndAppInfo(String appCode) {
        AppAuthorizationsResponse againResponse;
        String o = this.effectiveTenantAndAppInfo(appCode, 1, 50);
        AppAuthorizationsResponse firstResponse = (AppAuthorizationsResponse)JSON.parseObject((String)o, AppAuthorizationsResponse.class);
        int queryTimes = 1;
        for (int left = firstResponse.getTotal() - firstResponse.getList().size(); left > 0; left -= againResponse.getList().size()) {
            String o1 = this.effectiveTenantAndAppInfo(appCode, ++queryTimes, 50);
            againResponse = (AppAuthorizationsResponse)JSON.parseObject((String)o1, AppAuthorizationsResponse.class);
            firstResponse.getList().addAll(againResponse.getList());
        }
        return firstResponse;
    }

    public String getExpiredTenantAndAppInfo(String appCode, int beginMinusDays, int endMinusDays, int pageNum, int pageSize) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("tenantId", "");
        paramsMap.put("goodsCode", appCode);
        paramsMap.put("beginTime", LocalDate.now().minusDays(beginMinusDays).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        paramsMap.put("endTime", LocalDate.now().minusDays(endMinusDays).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        HashMap<String, Serializable> requestMap = new HashMap<String, Serializable>();
        requestMap.put("pageNum", Integer.valueOf(pageNum));
        requestMap.put("pageSize", Integer.valueOf(pageSize));
        requestMap.put("params", paramsMap);
        String requestUrl = this.cacUrl + "/api/cac/v4/authorizations/category/app/exclude/policy";
        log.info("requestUrl:{}, requestParam:{}", (Object)requestUrl, requestMap);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.iamApToken);
        String forObject = KgHttpUtil.sendGet(requestUrl, JSON.toJSONString(requestMap), header);
        return forObject;
    }

    public AppAuthorizationsResponse getAllExpiredTenantAndAppInfo(String appCode, int beginMinusDays, int endMinusDays) {
        AppAuthorizationsResponse againResponse;
        String o = this.getExpiredTenantAndAppInfo(appCode, beginMinusDays, endMinusDays, 1, 50);
        AppAuthorizationsResponse firstResponse = (AppAuthorizationsResponse)JSON.parseObject((String)o, AppAuthorizationsResponse.class);
        int queryTimes = 1;
        for (int left = firstResponse.getTotal() - firstResponse.getList().size(); left > 0; left -= againResponse.getList().size()) {
            String o1 = this.getExpiredTenantAndAppInfo(appCode, beginMinusDays, endMinusDays, ++queryTimes, 50);
            againResponse = (AppAuthorizationsResponse)JSON.parseObject((String)o1, AppAuthorizationsResponse.class);
            firstResponse.getList().addAll(againResponse.getList());
        }
        return firstResponse;
    }
}

