/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.clients;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWFile;
import com.digiwin.athena.knowledgegraph.po.FileInfo;
import com.digiwin.athena.knowledgegraph.po.MidWareResponse;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class DMCUtils {
    private static final Logger log = LoggerFactory.getLogger(DMCUtils.class);
    @Value(value="${dmcUrl}")
    private String dmcUrl;
    @Value(value="${iamApToken}")
    private String appToken;
    @Value(value="${dmcUserName}")
    private String dmcUserName;
    @Value(value="${dmcPwdhash}")
    private String dmcPwdhash;
    @Value(value="${dmcDirId}")
    private String dmcDirId;
    @Value(value="${dmcBucket}")
    private String dmcBucket;
    @Autowired
    @Qualifier(value="dmcRestTemplate")
    private RestTemplate dmcRestTemplate;

    public String getDmcToken() throws DWBusinessException {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("username", this.dmcUserName);
        reqMap.put("pwdhash", this.dmcPwdhash);
        String url = this.dmcUrl + "/api/dmc/v1/auth/login";
        HttpEntity httpEntity = new HttpEntity(reqMap, (MultiValueMap)header);
        ResponseEntity resMap = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        String token = (String)((Map)resMap.getBody()).get("userToken");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)token)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getDmcTokenError", new Object[0]));
        }
        log.info("dmcToken:{}", (Object)token);
        return token;
    }

    public String upload(DWFile dwFile, FileInfo fileInfo) throws Exception {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.MULTIPART_FORM_DATA);
        header.add("digi-middleware-auth-user", this.getDmcToken());
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType((String)this.getMediaType(dwFile.getFileByteArray())));
        fileHeader.setContentDispositionFormData("file", dwFile.getFileName());
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        try {
            HttpEntity fileEntity = new HttpEntity((Object)new ByteArrayResource(dwFile.getFileByteArray()), (MultiValueMap)fileHeader);
            fileInfo.setTenantId("default");
            fileInfo.setDirectoryId(this.dmcDirId);
            HttpEntity fileInfoEntity = new HttpEntity((Object)fileInfo, (MultiValueMap)fileInfoHeader);
            multiValueMap.add((Object)"file", (Object)fileEntity);
            multiValueMap.add((Object)"fileInfo", (Object)fileInfoEntity);
            String url = this.dmcUrl + "/api/dmc/v2/file/Athena/upload";
            HttpEntity httpEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)header);
            ResponseEntity postForEntity = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, MidWareResponse.class, new Object[0]);
            MidWareResponse midWareResponse = (MidWareResponse)postForEntity.getBody();
            if (midWareResponse.getSuccess().booleanValue()) {
                return (String)((Map)midWareResponse.getData()).get("id");
            }
            log.error("\u8c03\u7528\u4e0a\u4f20api\u5931\u8d25");
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.invokeApiError", new Object[0]));
        }
        catch (Exception e) {
            log.error("fileUploadError:{}", (Throwable)e);
            throw new DWBusinessException("", (Throwable)e);
        }
    }

    public void downLoadTemplate(String fileId, HttpServletResponse response) throws DWBusinessException {
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.wordNotBuild", new Object[0]));
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=template.xlsx");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        byte[] inputBytes = this.getErrorTableInputBytes(fileId);
        try (ServletOutputStream out = response.getOutputStream();){
            out.write(inputBytes, 0, inputBytes.length);
            out.flush();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
    }

    private byte[] readInputStream(InputStream fis) throws IOException {
        int len;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = fis.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        return outStream.toByteArray();
    }

    private byte[] getErrorTableInputBytes(String fileId) throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", this.getDmcToken());
        headers.add("digi-middleware-auth-app", this.appToken);
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        list.add(MediaType.parseMediaType((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
        headers.setAccept(list);
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.getDmcBucket() + "/download/" + fileId;
        ResponseEntity restRes = this.dmcRestTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return (byte[])restRes.getBody();
    }

    public String getMediaType(byte[] fileByte) {
        String mimeType = null;
        try {
            MagicMatch magicMatch = Magic.getMagicMatch((byte[])fileByte);
            mimeType = magicMatch.getMimeType();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("mediaType:{}", (Object)mimeType);
        return mimeType;
    }

    public String getDmcUrl() {
        return this.dmcUrl;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getDmcUserName() {
        return this.dmcUserName;
    }

    public String getDmcPwdhash() {
        return this.dmcPwdhash;
    }

    public String getDmcDirId() {
        return this.dmcDirId;
    }

    public String getDmcBucket() {
        return this.dmcBucket;
    }

    public RestTemplate getDmcRestTemplate() {
        return this.dmcRestTemplate;
    }

    public void setDmcUrl(String dmcUrl) {
        this.dmcUrl = dmcUrl;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public void setDmcUserName(String dmcUserName) {
        this.dmcUserName = dmcUserName;
    }

    public void setDmcPwdhash(String dmcPwdhash) {
        this.dmcPwdhash = dmcPwdhash;
    }

    public void setDmcDirId(String dmcDirId) {
        this.dmcDirId = dmcDirId;
    }

    public void setDmcBucket(String dmcBucket) {
        this.dmcBucket = dmcBucket;
    }

    public void setDmcRestTemplate(RestTemplate dmcRestTemplate) {
        this.dmcRestTemplate = dmcRestTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DMCUtils)) {
            return false;
        }
        DMCUtils other = (DMCUtils)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dmcUrl = this.getDmcUrl();
        String other$dmcUrl = other.getDmcUrl();
        if (this$dmcUrl == null ? other$dmcUrl != null : !this$dmcUrl.equals(other$dmcUrl)) {
            return false;
        }
        String this$appToken = this.getAppToken();
        String other$appToken = other.getAppToken();
        if (this$appToken == null ? other$appToken != null : !this$appToken.equals(other$appToken)) {
            return false;
        }
        String this$dmcUserName = this.getDmcUserName();
        String other$dmcUserName = other.getDmcUserName();
        if (this$dmcUserName == null ? other$dmcUserName != null : !this$dmcUserName.equals(other$dmcUserName)) {
            return false;
        }
        String this$dmcPwdhash = this.getDmcPwdhash();
        String other$dmcPwdhash = other.getDmcPwdhash();
        if (this$dmcPwdhash == null ? other$dmcPwdhash != null : !this$dmcPwdhash.equals(other$dmcPwdhash)) {
            return false;
        }
        String this$dmcDirId = this.getDmcDirId();
        String other$dmcDirId = other.getDmcDirId();
        if (this$dmcDirId == null ? other$dmcDirId != null : !this$dmcDirId.equals(other$dmcDirId)) {
            return false;
        }
        String this$dmcBucket = this.getDmcBucket();
        String other$dmcBucket = other.getDmcBucket();
        if (this$dmcBucket == null ? other$dmcBucket != null : !this$dmcBucket.equals(other$dmcBucket)) {
            return false;
        }
        RestTemplate this$dmcRestTemplate = this.getDmcRestTemplate();
        RestTemplate other$dmcRestTemplate = other.getDmcRestTemplate();
        return !(this$dmcRestTemplate == null ? other$dmcRestTemplate != null : !this$dmcRestTemplate.equals(other$dmcRestTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DMCUtils;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dmcUrl = this.getDmcUrl();
        result = result * 59 + ($dmcUrl == null ? 43 : $dmcUrl.hashCode());
        String $appToken = this.getAppToken();
        result = result * 59 + ($appToken == null ? 43 : $appToken.hashCode());
        String $dmcUserName = this.getDmcUserName();
        result = result * 59 + ($dmcUserName == null ? 43 : $dmcUserName.hashCode());
        String $dmcPwdhash = this.getDmcPwdhash();
        result = result * 59 + ($dmcPwdhash == null ? 43 : $dmcPwdhash.hashCode());
        String $dmcDirId = this.getDmcDirId();
        result = result * 59 + ($dmcDirId == null ? 43 : $dmcDirId.hashCode());
        String $dmcBucket = this.getDmcBucket();
        result = result * 59 + ($dmcBucket == null ? 43 : $dmcBucket.hashCode());
        RestTemplate $dmcRestTemplate = this.getDmcRestTemplate();
        result = result * 59 + ($dmcRestTemplate == null ? 43 : $dmcRestTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "DMCUtils(dmcUrl=" + this.getDmcUrl() + ", appToken=" + this.getAppToken() + ", dmcUserName=" + this.getDmcUserName() + ", dmcPwdhash=" + this.getDmcPwdhash() + ", dmcDirId=" + this.getDmcDirId() + ", dmcBucket=" + this.getDmcBucket() + ", dmcRestTemplate=" + this.getDmcRestTemplate() + ")";
    }
}

