/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.clients;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.action.execution.ESPConfiguration;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.knowledgegraph.domain.esp.EspBody;
import com.digiwin.athena.knowledgegraph.domain.esp.EspResponse;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.ESPInvokeUtil;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.http.client.DWHttpClient;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ESPUtils {
    private static final Logger log = LoggerFactory.getLogger(ESPUtils.class);
    private final String OPERATION_LIST = "/restful/standard/mdc/TenantProductOperationList/Get";
    private final String OPERATION_LIST_V2 = "/restful/standard/mdc/TenantProductOperationListV2/Get";
    private final String INTG_INFO = "/restful/standard/mdc/IntgInfo/Get";
    private static final String GET_PRODUCT = "/restful/standard/mdc/TenantProductList/Get";
    @Autowired
    private ProductNameResolver productNameResolver;
    @Autowired
    private DWHttpClient dwHttpClient;
    @Autowired
    @Qualifier(value="routeRestTemplate")
    RestTemplate restTemplate;
    @Autowired
    private IamService iamService;
    @Value(value="${iamApToken}")
    private String iamApToken;

    public Map getTenantProductOperationList(String tenantId, String productName, boolean isTenantV2) throws DWBusinessException, ParseException, IOException {
        String token = StringUtils.isEmpty((CharSequence)AthenaUtils.getHeaderToken()) ? KgFilter.getLoginInfo().getToken() : AthenaUtils.getHeaderToken();
        String url = ESPConfiguration.getMdcUrl() + (isTenantV2 ? "/restful/standard/mdc/TenantProductOperationListV2/Get" : "/restful/standard/mdc/TenantProductOperationList/Get");
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String routerKey = request.getHeader("routerKey");
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerkey", routerKey);
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenant_id", tenantId);
        requestMap.put("prod_name", productName);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() == 200) {
            return (Map)result.getBody();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getProductError", tenantId, productName));
    }

    public Map<String, Object> execute(String token, String tenantId, String api, Object requestObj) throws Exception {
        String productName = this.productNameResolver.getProductName(api, tenantId);
        if (StringUtils.isEmpty((CharSequence)productName)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.invokeEspApiError", tenantId, api));
        }
        String dataJson = JSON.toJSONString((Object)requestObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        EspResponse response = ESPInvokeUtil.invokeRestSync(api, productName, token, tenantId, dataJson, null, null);
        if (response.isOK()) {
            EspBody espBody = (EspBody)response.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            return parameter;
        }
        DWBusinessException dwBusinessException = new DWBusinessException(response.getErrorCode(), I18nUtils.getValue(I18nUtils.getValue("knowledgegraph.invokeEspApiErrorMsg", tenantId, api, response.getMsg()), new Object[0]));
        dwBusinessException.getInstructors().put("chainInfo", response.getChainInfo());
        throw dwBusinessException;
    }

    public Map<String, Object> executeV2(String token, String tenantId, String api, String jsonBody, Map<String, Object> eocMap, Map<String, Object> headerMap) throws Exception {
        String productName = this.productNameResolver.getProductName(api, tenantId);
        if (StringUtils.isEmpty((CharSequence)productName)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.invokeEspApiError", tenantId, api));
        }
        EspResponse response = ESPInvokeUtil.invokeRestSync(api, productName, token, tenantId, jsonBody, headerMap, eocMap);
        if (response.isOK()) {
            EspBody espBody = (EspBody)response.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            return parameter;
        }
        DWBusinessException dwBusinessException = new DWBusinessException(response.getErrorCode(), I18nUtils.getValue(I18nUtils.getValue("knowledgegraph.invokeEspApiErrorMsg", tenantId, api, response.getMsg()), new Object[0]));
        dwBusinessException.getInstructors().put("chainInfo", response.getChainInfo());
        throw dwBusinessException;
    }

    public Map<String, Object> query(String token, String tenantId, String queryApi) throws Exception {
        String productName = this.productNameResolver.getProductName(queryApi, tenantId);
        if (StringUtils.isEmpty((CharSequence)productName)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.invokeEspApiError", tenantId, queryApi));
        }
        EspResponse response = ESPInvokeUtil.invokeRestSync(queryApi, productName, token, tenantId, null, null, null);
        if (response.isOK()) {
            EspBody espBody = (EspBody)response.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            return parameter;
        }
        DWBusinessException dwBusinessException = new DWBusinessException(response.getErrorCode(), I18nUtils.getValue("knowledgegraph.invokeEspApiErrorMsg", tenantId, queryApi, response.getMsg()));
        dwBusinessException.getInstructors().put("chainInfo", response.getChainInfo());
        throw dwBusinessException;
    }

    public Map<String, Object> getOMOperationInfo(String tenantId, String prodName, String uid) throws DWBusinessException {
        String url = ESPConfiguration.getMdcUrl() + "/restful/standard/mdc/IntgInfo/Get";
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", StringUtils.isEmpty((CharSequence)AthenaUtils.getHeaderToken()) ? KgFilter.getLoginInfo().getToken() : AthenaUtils.getHeaderToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenant_id", tenantId);
        requestMap.put("prod_name", prodName);
        requestMap.put("uid", uid);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() == 200) {
            return (Map)result.getBody();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getProductError2", tenantId));
    }

    public Object getTenantProduct(String tenantId, String apiName) {
        HttpPost httpPost = new HttpPost(ESPConfiguration.getMdcUrl() + GET_PRODUCT);
        httpPost.setHeader("Content-Type", MediaType.APPLICATION_JSON.toString());
        JSONObject requestBody = new JSONObject();
        requestBody.put("tenant_id", (Object)tenantId);
        requestBody.put("api_name", (Object)apiName);
        StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.create((String)"application/json", (Charset)Charsets.UTF_8));
        httpPost.setEntity((HttpEntity)requestEntity);
        try {
            HttpEntity entity;
            httpPost.setHeader("token", StringUtils.isEmpty((CharSequence)AthenaUtils.getHeaderToken()) ? KgFilter.getLoginInfo().getToken() : AthenaUtils.getHeaderToken());
            HttpResponse response = this.dwHttpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value() && (entity = response.getEntity()) != null) {
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject result = JSON.parseObject((String)responseString);
                return result;
            }
        }
        catch (Exception e) {
            log.error("ESPUtils.getTenantProduct method error:{}", (Throwable)e);
        }
        return null;
    }

    public Object callEspService(Object registerModel, String token, String tenantId, String productName, String serviceName) throws DWBusinessException {
        token = this.iamService.getIntegrationToken(tenantId, token);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", this.iamApToken);
        headers.add("token", token);
        headers.add("Content-Type", "application/json");
        headers.add("digi-type", "sync");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);
        HashMap<String, String> headMapDigi_Host = new HashMap<String, String>();
        headMapDigi_Host.put("prod", productName);
        headMapDigi_Host.put("ver", "1.0");
        headMapDigi_Host.put("lang", "zh_CN");
        headMapDigi_Host.put("timestamp", formatTime);
        headMapDigi_Host.put("ip", "");
        headMapDigi_Host.put("eoc_acct", "athena");
        headMapDigi_Host.put("acct", "athena");
        headers.add("digi-host", JSON.toJSONString(headMapDigi_Host));
        HashMap<String, String> headMapDigi_Service = new HashMap<String, String>();
        headMapDigi_Service.put("prod", productName);
        headMapDigi_Service.put("uid", productName);
        headMapDigi_Service.put("tenant_id", tenantId);
        headMapDigi_Service.put("name", serviceName);
        headers.add("digi-service", JSON.toJSONString(headMapDigi_Service));
        HashMap requestMap = new HashMap();
        HashMap parameter = new HashMap();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("model", registerModel);
        parameter.put("parameter", model);
        requestMap.put("std_data", parameter);
        String fileMD5 = DigestUtils.md5Hex((String)(JSON.toJSONString(headMapDigi_Host) + JSON.toJSONString(headMapDigi_Service)));
        headers.add("digi-key", fileMD5);
        log.info("headers headers is ={}", (Object)JSON.toJSONString((Object)headers));
        log.info("requestMap is ={}", (Object)JSON.toJSONString(requestMap));
        String url = ESPConfiguration.getEspUrl() + "/CROSS/RESTful";
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        return resEntity.getBody();
    }
}

