/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.clients;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EocService {
    private static final Logger log = LoggerFactory.getLogger(EocService.class);
    @Autowired
    @Qualifier(value="eocRestTemplate")
    RestTemplate restTemplate;
    @Value(value="${eocUrl}")
    private String eocUrl;
    @Value(value="${iamApToken}")
    private String iamApToken;
    private static final String EOC_DUTY = "/api/eoc/v2/duty/list?pageSize=99999";
    private static final String EOC_STAFF = "/api/eoc/v2/emp?pageSize=99999";
    private static final String EOC_DEPT_STAFF = "/api/eoc/v2/dept/cascade?pageSize=99999";
    private static final String EOC_DUTY_STAFF = "/api/eoc/v2/duty/dept/emps";
    private static final String CORP_ALL = "/api/eoc/v2/corp/all";
    private static final String EOC_STAFF_USER = "/api/eoc/v2/emp/infos";

    public Object checkByUser(String token, List<String> dutyIds, List<String> appIds) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("dutyIds", dutyIds);
        requestMap.put("appIds", appIds);
        requestMap.put("version", "v2");
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        log.info("checkByUser url:{}, requestMap:{}", (Object)(this.eocUrl + "/api/eoc/v2/emp/dept/byuser/check"), requestMap);
        ResponseEntity resEntity = this.restTemplate.exchange(this.eocUrl + "/api/eoc/v2/emp/dept/byuser/check", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        log.info("checkByUser url:{}, dutyIds:{}, result:{}", new Object[]{this.eocUrl + "/api/eoc/v2/emp/dept/byuser/check", dutyIds, body});
        return body;
    }

    public Object checkByUsers(String token, List<Map> requestParam) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        HttpEntity requestEntity = new HttpEntity(requestParam, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.eocUrl + "/api/eoc/v2/emp/dept/byusers/check", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        log.info("checkByUsers url:{}, requestParam:{}, result:{}", new Object[]{this.eocUrl + "/api/eoc/v2/emp/dept/byusers/check", requestParam, body});
        return body;
    }

    public List<Map> getEocStaff() throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", this.iamApToken);
        ResponseEntity response = this.restTemplate.exchange(this.eocUrl + EOC_STAFF, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            Map body = (Map)response.getBody();
            Map dataMap = (Map)body.get("data");
            if (!CollectionUtils.isEmpty((Map)dataMap)) {
                return (List)dataMap.get("list");
            }
            return Collections.emptyList();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocStaffError", new Object[0]));
    }

    public List<String> getEocDuty() throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", this.iamApToken);
        ResponseEntity response = this.restTemplate.exchange(this.eocUrl + EOC_DUTY, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            List dataList;
            Map body = (Map)response.getBody();
            Map dataMap = (Map)body.get("data");
            if (!CollectionUtils.isEmpty((Map)dataMap) && !CollectionUtils.isEmpty((Collection)(dataList = (List)dataMap.get("list")))) {
                return dataList.stream().map(data -> data.get("id").toString()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocDutyError", new Object[0]));
    }

    public List<Map> getEocDeptAndStaff() throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", this.iamApToken);
        ResponseEntity response = this.restTemplate.exchange(this.eocUrl + EOC_DEPT_STAFF, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            Map body = (Map)response.getBody();
            Map dataMap = (Map)body.get("data");
            if (!CollectionUtils.isEmpty((Map)dataMap)) {
                return (List)dataMap.get("list");
            }
            return Collections.emptyList();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocDeptAndStaff", new Object[0]));
    }

    public List<String> getEocDutyAndStaff(String dutyId) throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestParam = new HashMap<String, String>();
        requestParam.put("dutyId", dutyId);
        ResponseEntity response = this.restTemplate.exchange(this.eocUrl + EOC_DUTY_STAFF, HttpMethod.POST, new HttpEntity(requestParam, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            Map body = (Map)response.getBody();
            List dataList = (List)body.get("data");
            if (!CollectionUtils.isEmpty((Collection)dataList)) {
                return dataList.stream().map(data -> data.get("empId").toString()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocDutyAndStaff", new Object[0]));
    }

    public List<String> getUserIdsByStaffs(List<String> eocIds, String token) throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, List<String>> requestParam = new HashMap<String, List<String>>();
        requestParam.put("empIds", eocIds);
        ResponseEntity response = this.restTemplate.exchange(this.eocUrl + EOC_STAFF_USER, HttpMethod.POST, new HttpEntity(requestParam, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            Map body = (Map)response.getBody();
            List dataList = (List)body.get("data");
            if (!CollectionUtils.isEmpty((Collection)dataList)) {
                return dataList.stream().map(data -> data.get("userId").toString()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocDutyAndStaff", new Object[0]));
    }

    public Set<String> appHasUser(String appId, String tenantId, String token) throws DWBusinessException {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("appId", appId);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.eocUrl + "/api/eoc/v2/emp/app/has/user", HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() == 200) {
            Map userData = (Map)result.getBody();
            if (!CollectionUtils.isEmpty((Map)userData)) {
                List userDataMap = (List)userData.get("data");
                return userDataMap.stream().map(item -> item.get("empUserId").toString()).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getProductError", ""));
    }

    public Map getOperationUnitWithToken(String token) throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        ResponseEntity response = this.restTemplate.exchange(this.eocUrl + CORP_ALL, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            Map body = (Map)response.getBody();
            Map dataMap = (Map)body.get("data");
            if (dataMap != null) {
                return dataMap;
            }
            return new HashMap();
        }
        throw new DWBusinessException("getOperationUnit error");
    }
}

