/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.component.applies;

import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyContext;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=100)
public class DefaultComponentApplyService
implements ComponentApplyService {
    @Autowired
    DataMapService dataMapService;

    @Override
    public boolean accept(ComponentBO componentBO) {
        return ComponentTypeEnum.MechanismDefault.equals((Object)componentBO.getType());
    }

    @Override
    public void apply(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", componentBO.getType().name());
        param.put("pluginId", componentBO.getCode());
        this.dataMapService.bindMechanismComponent(param);
    }

    @Override
    public void unApply(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", componentBO.getType().name());
        param.put("pluginId", componentBO.getCode());
        this.dataMapService.unBindMechanismComponent(param);
    }
}

