/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableRabbit
public class AthenaRabbitMQConfig {
    private static final Logger log = LoggerFactory.getLogger(AthenaRabbitMQConfig.class);
    @Value(value="${spring.rabbitmq.addresses}")
    private String addresses;

    public AthenaRabbitMQConfig() {
        System.out.println("========AthenaRabbitMQConfig init========");
    }

    @Bean(value={"connectionFactory"})
    @Primary
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        RabbitProperties properties = new RabbitProperties();
        properties.setAddresses(this.addresses);
        connectionFactory.setHost(properties.determineHost());
        connectionFactory.setPort(properties.determinePort());
        connectionFactory.setUsername(properties.determineUsername());
        connectionFactory.setPassword(properties.determinePassword());
        connectionFactory.setVirtualHost(properties.determineVirtualHost());
        return connectionFactory;
    }

    @Bean(name={"amqpAdmin"})
    @Primary
    public RabbitAdmin amqpAdmin() {
        return new RabbitAdmin(this.connectionFactory());
    }

    @Bean(name={"rabbitTemplate"})
    @Primary
    public RabbitTemplate rabbitTemplate(@Qualifier(value="connectionFactory") ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        return rabbitTemplate;
    }

    @Bean(name={"rabbitListenerContainerFactory"})
    @Primary
    public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(@Qualifier(value="connectionFactory") ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        return factory;
    }
}

