/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class MdcRabbitMQConfig {
    private static final Logger log = LoggerFactory.getLogger(MdcRabbitMQConfig.class);
    public static final String mdcConnectionFactory = "mdcConnectionFactory";
    public static final String mdcRabbitTemplate = "mdcRabbitTemplate";
    @Value(value="${spring.rabbitmq.mdc.addresses}")
    private String addresses;

    public MdcRabbitMQConfig() {
        System.out.println("========MdcRabbitMQConfig init========");
    }

    @Bean(value={"mdcConnectionFactory"})
    public ConnectionFactory mdcConnectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        RabbitProperties properties = new RabbitProperties();
        properties.setAddresses(this.addresses);
        connectionFactory.setHost(properties.determineHost());
        connectionFactory.setPort(properties.determinePort());
        connectionFactory.setUsername(properties.determineUsername());
        connectionFactory.setPassword(properties.determinePassword());
        connectionFactory.setVirtualHost(properties.determineVirtualHost());
        return connectionFactory;
    }

    @Bean(name={"mdcRabbitTemplate"})
    public RabbitTemplate mdcRabbitTemplate(@Qualifier(value="mdcConnectionFactory") ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        return rabbitTemplate;
    }

    @Bean(name={"mdcMessageListenerContainer"})
    public SimpleRabbitListenerContainerFactory mdcMessageListenerContainer(@Qualifier(value="mdcConnectionFactory") ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        return factory;
    }

    @Bean(name={"mdcAmqpAdmin"})
    @Primary
    public RabbitAdmin mdcAmqpAdmin() {
        return new RabbitAdmin(this.mdcConnectionFactory());
    }
}

