/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.configuration;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ModuleConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ModuleConfiguration.class);
    public static final String APP_EXPIRE_EXCHANGE = "appExpireChange";
    @Value(value="${rabbitMQEnabled}")
    private String rabbitMQEnabled;
    @Value(value="${rabbitMQExchangeName}")
    private String rabbitMQExchangeName;
    @Value(value="${rabbitMQExchangeType}")
    private String rabbitMQExchangeType;
    @Value(value="${rabbitMQPersistent}")
    private String rabbitMQPersistent;
    @Value(value="${scheduleRuleConfigQueueName}")
    private String scheduleRuleConfigQueueName;
    @Value(value="${scheduleRuleConfigRoutingKey}")
    private String scheduleRuleConfigRoutingKey;
    @Value(value="${monitorRuleConfigQueueName}")
    private String monitorRuleConfigQueueName;
    @Value(value="${monitorRuleConfigRoutingKey}")
    private String monitorRuleConfigRoutingKey;
    @Value(value="${deadLetterExchangeName}")
    private String deadLetterExchangeName;
    @Value(value="${deadLetterScheduleRuleConfigQueueName}")
    private String deadLetterScheduleRuleConfigQueueName;
    @Value(value="${deadLetterScheduleRuleConfigRoutingKey}")
    private String deadLetterScheduleRuleConfigRoutingKey;
    @Value(value="${deadLetterMonitorRuleConfigQueueName}")
    private String deadLetterMonitorRuleConfigQueueName;
    @Value(value="${deadLetterMonitorRuleConfigRoutingKey}")
    private String deadLetterMonitorRuleConfigRoutingKey;
    @Value(value="${scheduleRuleConfigQueueTTL}")
    private long scheduleRuleConfigQueueTTL;
    @Value(value="${monitorRuleConfigQueueTTL}")
    private long monitorRuleConfigQueueTTL;
    @Value(value="${monitorCrossLevelQueueName}")
    private String monitorCrossLevelQueueName;
    @Value(value="${monitorCrossLevelRoutingKey}")
    private String monitorCrossLevelRoutingKey;
    @Value(value="${monitorRuleConfigCDCRoutingKey}")
    private String monitorRuleConfigCDCRoutingKey;
    @Value(value="${monitorRuleConfigCDCQueueName}")
    private String monitorRuleConfigCDCQueueName;
    @Value(value="${monitorCrossLevelCDCRoutingKey}")
    private String monitorCrossLevelCDCRoutingKey;
    @Value(value="${monitorCrossLevelCDCQueueName}")
    private String monitorCrossLevelCDCQueueName;

    public ModuleConfiguration() {
        System.out.println("knowledgeGraph init..........");
    }

    @Bean
    public Queue monitorRuleConfigQueueName() {
        HashMap<String, Object> args = new HashMap<String, Object>(3);
        args.put("x-dead-letter-exchange", this.deadLetterExchangeName);
        args.put("x-dead-letter-routing-key", this.deadLetterMonitorRuleConfigRoutingKey);
        args.put("x-message-ttl", this.monitorRuleConfigQueueTTL);
        if ("false".equalsIgnoreCase(this.rabbitMQPersistent)) {
            return QueueBuilder.nonDurable((String)this.monitorRuleConfigQueueName).withArguments(args).build();
        }
        return QueueBuilder.durable((String)this.monitorRuleConfigQueueName).withArguments(args).build();
    }

    @Bean
    public Queue monitorRuleConfigCDCQueueName() {
        return new Queue(this.monitorRuleConfigCDCQueueName);
    }

    @Bean(value={"deadLetterMonitorRuleQueue"})
    public Queue deadLetterMonitorRuleQueue() {
        return new Queue(this.deadLetterMonitorRuleConfigQueueName);
    }

    @Bean(value={"monitorCrossLevelQueue"})
    public Queue monitorCrossLevelQueue() {
        log.info("monitorCrossLevelQueue name:" + this.monitorCrossLevelQueueName);
        return new Queue(this.monitorCrossLevelQueueName);
    }

    @Bean(value={"monitorCrossLevelCDCQueue"})
    public Queue monitorCrossLevelCDCQueue() {
        log.info("monitorCrossLevelCDCQueue name:" + this.monitorCrossLevelCDCQueueName);
        return new Queue(this.monitorCrossLevelCDCQueueName);
    }

    @Bean
    Exchange rabbitMQExchange() {
        boolean persistent = true;
        if ("false".equalsIgnoreCase(this.rabbitMQPersistent)) {
            persistent = false;
        }
        if ("topic".equals(this.rabbitMQExchangeType)) {
            return new TopicExchange(this.rabbitMQExchangeName, persistent, false);
        }
        if ("fanout".equals(this.rabbitMQExchangeType)) {
            return new FanoutExchange(this.rabbitMQExchangeName, persistent, false);
        }
        return new DirectExchange(this.rabbitMQExchangeName, persistent, false);
    }

    @Bean(value={"deadLetterExchange"})
    public DirectExchange deadLetterExchange() {
        return new DirectExchange(this.deadLetterExchangeName);
    }

    @Bean
    Binding binding02() {
        log.info("binding02 begin ,monitorRuleConfigRoutingKey:" + this.monitorRuleConfigRoutingKey);
        return BindingBuilder.bind((Queue)this.monitorRuleConfigQueueName()).to(this.rabbitMQExchange()).with(this.monitorRuleConfigRoutingKey).noargs();
    }

    @Bean
    Binding crossLevelQueue() {
        log.info("crossLevelQueue begin ,monitorCrossLevelRoutingKey:" + this.monitorCrossLevelRoutingKey);
        return BindingBuilder.bind((Queue)this.monitorCrossLevelQueue()).to(this.rabbitMQExchange()).with(this.monitorCrossLevelRoutingKey).noargs();
    }

    @Bean
    Binding bindingCdc() {
        log.info("bindingCdc begin ,monitorRuleConfigCDCRoutingKey:" + this.monitorRuleConfigCDCRoutingKey);
        return BindingBuilder.bind((Queue)this.monitorRuleConfigCDCQueueName()).to(this.rabbitMQExchange()).with(this.monitorRuleConfigCDCRoutingKey).noargs();
    }

    @Bean
    Binding crossLevelCDCQueue() {
        log.info("crossLevelCDCQueue begin ,monitorCrossLevelCDCRoutingKey:" + this.monitorCrossLevelCDCRoutingKey);
        return BindingBuilder.bind((Queue)this.monitorCrossLevelCDCQueue()).to(this.rabbitMQExchange()).with(this.monitorCrossLevelCDCRoutingKey).noargs();
    }

    @Bean
    public Binding deadLetterBindingMonitorQueue() {
        return BindingBuilder.bind((Queue)this.deadLetterMonitorRuleQueue()).to(this.deadLetterExchange()).with(this.deadLetterMonitorRuleConfigRoutingKey);
    }

    @Bean
    public FanoutExchange appExpireChangeFanoutExchange() {
        return new FanoutExchange(APP_EXPIRE_EXCHANGE, true, false);
    }
}

