/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.util.Pair;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class Neo4jManager
implements InitializingBean {
    private static Log log = LogFactory.getLog(Neo4jManager.class);
    private static Neo4jManager neo4jManager = null;
    @Autowired
    private Driver driver;

    public static Neo4jManager getNeo4jManager() {
        return neo4jManager;
    }

    public void ExecuteNoQuery(String statement) {
        try (Session session = this.driver.session();){
            session.run(statement);
        }
    }

    public void ExecuteNoQuery(List<String> statements) {
        try (Session session = this.driver.session();){
            for (String statement : statements) {
                session.run(statement);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> ExecuteQuery(String statement) {
        try (Session session = this.driver.session();){
            StatementResult result = session.run(statement);
            ArrayList<Map<String, Object>> mapObjects = new ArrayList<Map<String, Object>>();
            while (result.hasNext()) {
                Record record = result.next();
                List fields = record.fields();
                HashMap<Object, Object> recordAsMap = new HashMap<Object, Object>();
                for (Pair field : fields) {
                    recordAsMap.put(field.key(), Neo4jManager.ParseNode(field.value()));
                }
                mapObjects.add(recordAsMap);
            }
            ArrayList<Map<String, Object>> arrayList = mapObjects;
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> ExecuteQuery(String statement, Map<String, Object> params) {
        try (Session session = this.driver.session();){
            StatementResult result = session.run(statement, params);
            ArrayList<Map<String, Object>> mapObjects = new ArrayList<Map<String, Object>>();
            while (result.hasNext()) {
                Record record = result.next();
                List fields = record.fields();
                HashMap<Object, Object> recordAsMap = new HashMap<Object, Object>();
                for (Pair field : fields) {
                    recordAsMap.put(field.key(), Neo4jManager.ParseNode(field.value()));
                }
                mapObjects.add(recordAsMap);
            }
            ArrayList<Map<String, Object>> arrayList = mapObjects;
            return arrayList;
        }
    }

    private static Object ParseNode(Object value) {
        if (value instanceof NodeValue) {
            return ((Value)value).asMap();
        }
        if (value instanceof StringValue) {
            return ((Value)value).asString();
        }
        if (value instanceof BooleanValue) {
            return ((Value)value).asBoolean();
        }
        if (value instanceof IntegerValue) {
            return ((Value)value).asInt();
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((Value)value).asFloat());
        }
        if (value instanceof ListValue) {
            ArrayList<Object> parsedValue = new ArrayList<Object>();
            List valueAsList = ((Value)value).asList();
            for (Object element : valueAsList) {
                parsedValue.add(Neo4jManager.ParseNode(element));
            }
            return parsedValue;
        }
        return value;
    }

    public void afterPropertiesSet() throws Exception {
        neo4jManager = this;
    }
}

